/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.phpModel.parser;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import org.eclipse.php.core.phpModel.parser.CodeDataFilter;
import org.eclipse.php.core.phpModel.parser.ComparableName;
import org.eclipse.php.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileDataUtilities;
import org.eclipse.php.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.core.phpModel.phpElementData.PHPModifier;
import org.eclipse.php.core.phpModel.phpElementData.PHPVariableData;

public class ModelSupport {
    public static final CodeDataFilter STATIC_VARIABLES_FILTER = new StaticVariablesFilter(true);
    public static final CodeDataFilter NOT_STATIC_VARIABLES_FILTER = new StaticVariablesFilter(false);
    public static final CodeDataFilter STATIC_FUNCTIONS_FILTER = new StaticFunctionsFilter(true);
    public static final CodeDataFilter INTERNAL_CODEDATA_FILTER = new InternalPhpCodeData();
    public static final CodeDataFilter PIRVATE_ACCESS_LEVEL_FILTER = new AccessLevelFilter(){

        public boolean verify(int n) {
            return true;
        }
    };
    public static final CodeDataFilter PROTECTED_ACCESS_LEVEL_FILTER = new AccessLevelFilter(){

        public boolean verify(int n) {
            return !PHPModifier.isPrivate(n);
        }
    };
    public static final CodeDataFilter PUBLIC_ACCESS_LEVEL_FILTER = new AccessLevelFilter(){

        public boolean verify(int n) {
            return !PHPModifier.isPrivate(n) && !PHPModifier.isProtected(n);
        }
    };
    private static final int SMALL_ARRAY_SIZE = 12;
    public static final PHPCodeContext EMPTY_CONTEXT = new PHPCodeContextImp("", "", "");

    private ModelSupport() {
    }

    public static CodeData[] getCodeDataStartingWith(CodeData[] codeDataArray, String string) {
        return ModelSupport.getCodeDataStartingWith(codeDataArray, string, false, false);
    }

    public static CodeData[] getFileDataStartingWith(CodeData[] codeDataArray, String string) {
        return ModelSupport.getCodeDataStartingWith(codeDataArray, string, true, false);
    }

    public static CodeData[] getCodeDataStartingWithCS(CodeData[] codeDataArray, String string) {
        return ModelSupport.getCodeDataStartingWith(codeDataArray, string, false, true);
    }

    public static CodeData[] getFileDataStartingWithCS(CodeData[] codeDataArray, String string) {
        return ModelSupport.getCodeDataStartingWith(codeDataArray, string, true, true);
    }

    private static CodeData[] getCodeDataStartingWith(CodeData[] codeDataArray, String string, boolean bl, boolean bl2) {
        CodeData[] codeDataArray2;
        if (codeDataArray == null) {
            codeDataArray = PHPCodeDataFactory.EMPTY_CODE_DATA_ARRAY;
        }
        if (string == null || string.equals("") || codeDataArray.length == 0) {
            return codeDataArray;
        }
        int n = ModelSupport.getFirstMatch(codeDataArray, string, false, bl, bl2);
        if (n < 0) {
            return PHPCodeDataFactory.EMPTY_CODE_DATA_ARRAY;
        }
        int n2 = codeDataArray.length - 1;
        int n3 = string.length();
        int n4 = n;
        while (n4 < codeDataArray.length) {
            codeDataArray2 = bl ? ((ComparableName)((Object)codeDataArray[n4])).getComparableName() : codeDataArray[n4].getName();
            Object object = codeDataArray2 = codeDataArray2.length() > n3 ? codeDataArray2.substring(0, n3) : codeDataArray2;
            if (bl2) {
                if (codeDataArray2.compareTo(string) > 0) {
                    n2 = n4 - 1;
                    break;
                }
            } else if (codeDataArray2.compareToIgnoreCase(string) > 0) {
                n2 = n4 - 1;
                break;
            }
            ++n4;
        }
        n4 = n2 < n ? 0 : n2 - n + 1;
        codeDataArray2 = new CodeData[n4];
        System.arraycopy(codeDataArray, n, codeDataArray2, 0, codeDataArray2.length);
        return codeDataArray2;
    }

    public static int getFirstMatch(CodeData[] codeDataArray, String string, boolean bl) {
        return ModelSupport.getFirstMatch(codeDataArray, string, bl, false, false);
    }

    private static int getFirstMatch(CodeData[] codeDataArray, String string, boolean bl, boolean bl2) {
        return ModelSupport.getFirstMatch(codeDataArray, string, bl, bl2, false);
    }

    public static int getFirstMatchCS(CodeData[] codeDataArray, String string, boolean bl) {
        return ModelSupport.getFirstMatch(codeDataArray, string, bl, false, true);
    }

    private static int getFirstMatchCS(CodeData[] codeDataArray, String string, boolean bl, boolean bl2) {
        return ModelSupport.getFirstMatch(codeDataArray, string, bl, bl2, true);
    }

    private static int getFirstMatch(CodeData[] codeDataArray, String string, boolean bl, boolean bl2, boolean bl3) {
        String string2;
        int n = string.length();
        if (n == 0) {
            if (bl) {
                return -1;
            }
            return 0;
        }
        if (codeDataArray == null || codeDataArray.length == 0) {
            return -1;
        }
        if (codeDataArray.length < 12) {
            int n2 = 0;
            while (n2 < codeDataArray.length) {
                String string3;
                String string4 = string3 = bl2 ? ((ComparableName)((Object)codeDataArray[n2])).getComparableName() : codeDataArray[n2].getName();
                if (!bl && string3.length() > n) {
                    string3 = string3.substring(0, n);
                }
                if (bl3 ? string.equals(string3) : string.equalsIgnoreCase(string3)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }
        int n3 = 0;
        int n4 = codeDataArray.length - 1;
        while (n3 <= n4) {
            int n5;
            String string5;
            int n6 = n3 + n4 >> 1;
            String string6 = string5 = bl2 ? ((ComparableName)((Object)codeDataArray[n6])).getComparableName() : codeDataArray[n6].getName();
            if (!bl && string5.length() > n) {
                string5 = string5.substring(0, n);
            }
            int n7 = n5 = bl3 ? string5.compareTo(string) : string5.compareToIgnoreCase(string);
            if (n5 == 0) {
                n3 = n6;
                break;
            }
            if (n5 < 0) {
                n3 = n6 + 1;
                continue;
            }
            n4 = n6 - 1;
        }
        if (n3 < 0 || n3 >= codeDataArray.length) {
            return -1;
        }
        String string7 = string2 = bl2 ? ((ComparableName)((Object)codeDataArray[n3])).getComparableName() : codeDataArray[n3].getName();
        if (!bl && string2.length() > n) {
            string2 = string2.substring(0, n);
        }
        if (bl3 ? !string2.equals(string) : !string2.equalsIgnoreCase(string)) {
            return -1;
        }
        --n3;
        while (n3 >= 0) {
            String string8 = string2 = bl2 ? ((ComparableName)((Object)codeDataArray[n3])).getComparableName() : codeDataArray[n3].getName();
            if (!bl && string2.length() > n) {
                string2 = string2.substring(0, n);
            }
            if (bl3 ? !string2.equals(string) : !string2.equalsIgnoreCase(string)) break;
            --n3;
        }
        return n3 + 1;
    }

    private static int getFirstMatch(File[] fileArray, String string) {
        return ModelSupport.getFirstMatch(fileArray, string, false);
    }

    private static int getFirstMatchCS(File[] fileArray, String string) {
        return ModelSupport.getFirstMatch(fileArray, string, true);
    }

    private static int getFirstMatch(File[] fileArray, String string, boolean bl) {
        int n = string.length();
        if (n == 0) {
            return 0;
        }
        if (fileArray == null || fileArray.length == 0) {
            return -1;
        }
        if (fileArray.length < 12) {
            int n2 = 0;
            while (n2 < fileArray.length) {
                String string2 = fileArray[n2].getName();
                if (string2.length() > n) {
                    string2 = string2.substring(0, n);
                }
                if (bl ? string.equals(string2) : string.equalsIgnoreCase(string2)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }
        int n3 = 0;
        int n4 = fileArray.length - 1;
        while (n3 <= n4) {
            int n5;
            int n6 = n3 + n4 >> 1;
            String string3 = fileArray[n6].getName();
            if (string3.length() > n) {
                string3 = string3.substring(0, n);
            }
            int n7 = n5 = bl ? string3.compareTo(string) : string3.compareToIgnoreCase(string);
            if (n5 == 0) {
                n3 = n6;
                break;
            }
            if (n5 < 0) {
                n3 = n6 + 1;
                continue;
            }
            n4 = n6 - 1;
        }
        if (n3 < 0 || n3 >= fileArray.length) {
            return -1;
        }
        String string4 = fileArray[n3].getName();
        if (string4.length() > n) {
            string4 = string4.substring(0, n);
        }
        if (bl ? !string4.equals(string) : !string4.equalsIgnoreCase(string)) {
            return -1;
        }
        --n3;
        while (n3 >= 0) {
            string4 = fileArray[n3].getName();
            if (string4.length() > n) {
                string4 = string4.substring(0, n);
            }
            if (bl ? !string4.equals(string) : !string4.equalsIgnoreCase(string)) break;
            --n3;
        }
        return n3 + 1;
    }

    public static CodeData[] removeRepeatedNames(CodeData[] codeDataArray) {
        if (codeDataArray.length < 2) {
            return codeDataArray;
        }
        int n = 0;
        String string = codeDataArray[0].getName();
        int n2 = 1;
        while (n2 < codeDataArray.length) {
            String string2 = codeDataArray[n2].getName();
            if (string.equals(string2)) {
                codeDataArray[n2] = null;
                ++n;
            } else {
                string = string2;
            }
            ++n2;
        }
        CodeData[] codeDataArray2 = new CodeData[codeDataArray.length - n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < codeDataArray.length) {
            if (codeDataArray[n4] != null) {
                codeDataArray2[n3] = codeDataArray[n4];
                ++n3;
            }
            ++n4;
        }
        return codeDataArray2;
    }

    public static CodeData[] mergeAndRemoveDuplicated(CodeData[] codeDataArray, CodeData[] codeDataArray2) {
        if (codeDataArray == null || codeDataArray.length == 0) {
            return codeDataArray2;
        }
        if (codeDataArray2 == null || codeDataArray2.length == 0) {
            return codeDataArray;
        }
        ArrayList<CodeData> arrayList = new ArrayList<CodeData>(codeDataArray.length + codeDataArray2.length);
        int n = 0;
        int n2 = 0;
        while (n != codeDataArray.length || n2 != codeDataArray2.length) {
            if (n == codeDataArray.length) {
                arrayList.add(codeDataArray2[n2++]);
                continue;
            }
            if (n2 == codeDataArray2.length) {
                arrayList.add(codeDataArray[n++]);
                continue;
            }
            int n3 = codeDataArray[n].compareTo(codeDataArray2[n2]);
            if (n3 == 0) {
                arrayList.add(codeDataArray[n++]);
                ++n2;
                continue;
            }
            if (n3 < 0) {
                arrayList.add(codeDataArray[n++]);
                continue;
            }
            arrayList.add(codeDataArray2[n2++]);
        }
        CodeData[] codeDataArray3 = new CodeData[arrayList.size()];
        arrayList.toArray(codeDataArray3);
        return codeDataArray3;
    }

    public static CodeData[] merge(CodeData[] codeDataArray, CodeData[] codeDataArray2) {
        if (codeDataArray == null || codeDataArray.length == 0) {
            return codeDataArray2;
        }
        if (codeDataArray2 == null || codeDataArray2.length == 0) {
            return codeDataArray;
        }
        int n = codeDataArray.length + codeDataArray2.length;
        CodeData[] codeDataArray3 = new CodeData[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (n2 == codeDataArray.length) {
                System.arraycopy(codeDataArray2, n3, codeDataArray3, n4, n - n4);
                break;
            }
            if (n3 == codeDataArray2.length) {
                System.arraycopy(codeDataArray, n2, codeDataArray3, n4, n - n4);
                break;
            }
            codeDataArray3[n4] = codeDataArray[n2].compareTo(codeDataArray2[n3]) < 0 ? codeDataArray[n2++] : codeDataArray2[n3++];
            ++n4;
        }
        return codeDataArray3;
    }

    public static PHPCodeContext createContext(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string.equals("") && string2.equals("")) {
            return EMPTY_CONTEXT;
        }
        return new PHPCodeContextImp("", string, string2);
    }

    public static PHPCodeContext createContext(PHPFileData pHPFileData, int n) {
        return ModelSupport.createContext(PHPFileDataUtilities.getCodeData(pHPFileData, n));
    }

    public static PHPCodeContext createContext(String string, String string2, String string3) {
        return new PHPCodeContextImp(string, string2, string3);
    }

    public static PHPCodeContext createContext(CodeData codeData) {
        String string;
        if (codeData == null) {
            return EMPTY_CONTEXT;
        }
        String string2 = codeData.getUserData().getFileName();
        String string3 = "";
        if (codeData instanceof PHPFunctionData) {
            PHPFunctionData pHPFunctionData = (PHPFunctionData)codeData;
            string = pHPFunctionData.getName();
            PHPCodeData pHPCodeData = pHPFunctionData.getContainer();
            if (pHPCodeData != null && pHPCodeData instanceof PHPClassData) {
                string3 = pHPCodeData.getName();
            }
        } else {
            string = codeData.getName();
        }
        return new PHPCodeContextImp(string2, string3, string);
    }

    public static CodeData[] getFilteredCodeData(CodeData[] codeDataArray, CodeDataFilter codeDataFilter) {
        if (codeDataArray == null || codeDataArray.length == 0) {
            return codeDataArray;
        }
        ArrayList<CodeData> arrayList = new ArrayList<CodeData>();
        int n = 0;
        while (n < codeDataArray.length) {
            if (codeDataFilter.accept(codeDataArray[n])) {
                arrayList.add(codeDataArray[n]);
            }
            ++n;
        }
        CodeData[] codeDataArray2 = new CodeData[arrayList.size()];
        arrayList.toArray(codeDataArray2);
        return codeDataArray2;
    }

    public static CodeData[] removeFilteredCodeData(CodeData[] codeDataArray, CodeDataFilter codeDataFilter) {
        if (codeDataArray == null || codeDataArray.length == 0) {
            return codeDataArray;
        }
        ArrayList<CodeData> arrayList = new ArrayList<CodeData>();
        int n = 0;
        while (n < codeDataArray.length) {
            if (!codeDataFilter.accept(codeDataArray[n])) {
                arrayList.add(codeDataArray[n]);
            }
            ++n;
        }
        CodeData[] codeDataArray2 = new CodeData[arrayList.size()];
        arrayList.toArray(codeDataArray2);
        return codeDataArray2;
    }

    public static File[] getFileSStartingWith(File[] fileArray, String string, boolean bl) {
        File[] fileArray2;
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        if (string == null || string.equals("") || fileArray.length == 0) {
            return fileArray;
        }
        int n = ModelSupport.getFirstMatch(fileArray, string, bl);
        if (n < 0) {
            return new File[0];
        }
        int n2 = fileArray.length - 1;
        int n3 = string.length();
        int n4 = n;
        while (n4 < fileArray.length) {
            fileArray2 = fileArray[n4].getName();
            Object object = fileArray2 = fileArray2.length() > n3 ? fileArray2.substring(0, n3) : fileArray2;
            if (bl) {
                if (fileArray2.compareTo(string) > 0) {
                    n2 = n4 - 1;
                    break;
                }
            } else if (fileArray2.compareToIgnoreCase(string) > 0) {
                n2 = n4 - 1;
                break;
            }
            ++n4;
        }
        n4 = n2 < n ? 0 : n2 - n + 1;
        fileArray2 = new File[n4];
        System.arraycopy(fileArray, n, fileArray2, 0, fileArray2.length);
        return fileArray2;
    }

    private static class PHPCodeContextImp
    implements PHPCodeContext,
    Serializable {
        private final String className;
        private final String functionName;
        private int hash;

        PHPCodeContextImp(String string, String string2, String string3) {
            this.className = string2;
            this.functionName = string3;
        }

        public final String getContainerClassName() {
            return this.className;
        }

        public final String getContainerFunctionName() {
            return this.functionName;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof PHPCodeContextImp)) {
                return false;
            }
            PHPCodeContextImp pHPCodeContextImp = (PHPCodeContextImp)object;
            return this.className.equals(pHPCodeContextImp.className) && this.functionName.equals(pHPCodeContextImp.functionName);
        }

        public int hashCode() {
            int n = this.hash;
            if (n == 0) {
                n = this.functionName.hashCode();
                n = 31 * n + this.className.hashCode();
                this.hash = n = 31 * n + this.functionName.hashCode();
            }
            return n;
        }
    }

    private static class StaticVariablesFilter
    implements CodeDataFilter {
        boolean acceptStatic;

        StaticVariablesFilter(boolean bl) {
            this.acceptStatic = bl;
        }

        public boolean accept(CodeData codeData) {
            if (codeData instanceof PHPVariableData && PHPModifier.isStatic(((PHPClassVarData)codeData).getModifiers())) {
                return this.acceptStatic;
            }
            return !this.acceptStatic;
        }
    }

    private static class StaticFunctionsFilter
    implements CodeDataFilter {
        boolean acceptStatic;

        StaticFunctionsFilter(boolean bl) {
            this.acceptStatic = bl;
        }

        public boolean accept(CodeData codeData) {
            if (codeData instanceof PHPFunctionData && PHPModifier.isStatic(((PHPFunctionData)codeData).getModifiers())) {
                return this.acceptStatic;
            }
            return !this.acceptStatic;
        }
    }

    private static abstract class AccessLevelFilter
    implements CodeDataFilter {
        private AccessLevelFilter() {
        }

        public boolean accept(CodeData codeData) {
            if (codeData instanceof PHPClassVarData) {
                return this.verify(((PHPClassVarData)codeData).getModifiers());
            }
            if (codeData instanceof PHPFunctionData) {
                return this.verify(((PHPFunctionData)codeData).getModifiers());
            }
            return true;
        }

        public abstract boolean verify(int var1);
    }

    private static final class InternalPhpCodeData
    implements CodeDataFilter {
        private InternalPhpCodeData() {
        }

        public boolean accept(CodeData codeData) {
            if (codeData == null || !(codeData instanceof PHPCodeData)) {
                return false;
            }
            PHPCodeData pHPCodeData = (PHPCodeData)codeData;
            PHPDocBlock pHPDocBlock = pHPCodeData.getDocBlock();
            return pHPDocBlock != null && pHPDocBlock.hasTagOf(21);
        }
    }
}

