/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.project.options;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.resources.XMLWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.php.core.IncludePathContainerInitializer;
import org.eclipse.php.core.PHPCorePlugin;
import org.eclipse.php.core.project.IIncludePathContainer;
import org.eclipse.php.core.project.IIncludePathEntry;
import org.eclipse.php.core.project.PHPNature;
import org.eclipse.php.core.project.options.IPhpProjectOptionChangeListener;
import org.eclipse.php.core.project.options.includepath.IncludePathEntry;
import org.eclipse.php.core.project.options.includepath.IncludePathVariableManager;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PHPProjectOptions {
    public static final String BUILDER_ID = "org.eclipse.php.core.PhpIncrementalProjectBuilder";
    static final IIncludePathEntry[] EMPTY_INCLUDEPATH;
    public static final String FILE_NAME = ".projectOptions";
    private static final String TAG_OPTION = "projectOption";
    private static final String TAG_OPTIONS = "phpProjectOptions";
    public static final String USER_LIBRARY_CONTAINER_ID = "org.eclipse.php.USER_LIBRARY";
    IIncludePathEntry[] includePathEntries = new IIncludePathEntry[0];
    private Map options = new HashMap();
    private final Map optionsChangeListenersMap = new HashMap();
    private IProject project;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.php.core.project.options.PHPProjectOptions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        EMPTY_INCLUDEPATH = new IIncludePathEntry[0];
    }

    public static PHPProjectOptions forProject(IProject iProject) {
        if (!iProject.isAccessible()) {
            return null;
        }
        PHPNature pHPNature = null;
        try {
            pHPNature = (PHPNature)iProject.getNature("org.eclipse.php.core.PHPNature");
        }
        catch (CoreException coreException) {
            PHPCorePlugin.log(coreException);
        }
        if (pHPNature != null) {
            return pHPNature.getOptions();
        }
        return null;
    }

    public static IIncludePathContainer getIncludePathContainer(IPath iPath, IProject iProject) {
        return null;
    }

    public static IncludePathContainerInitializer getIncludePathContainerInitializer(String string) {
        return null;
    }

    public static IPath getIncludePathVariable(String string) {
        return IncludePathVariableManager.instance().getIncludePathVariable(string);
    }

    public static String[] getIncludePathVariableNames() {
        return IncludePathVariableManager.instance().getIncludePathVariableNames();
    }

    public static IPath getResolvedVariablePath(IPath iPath) {
        return IncludePathVariableManager.instance().getIncludePathVariable(iPath.toString());
    }

    public static void setIncludePathVariables(String[] stringArray, IPath[] iPathArray, SubProgressMonitor subProgressMonitor) {
        IncludePathVariableManager.instance().setIncludePathVariables(stringArray, iPathArray, subProgressMonitor);
    }

    public PHPProjectOptions(IProject iProject) {
        this.project = iProject;
        this.loadOptions();
    }

    public void addOptionChangeListener(String string, IPhpProjectOptionChangeListener iPhpProjectOptionChangeListener) {
        ArrayList<IPhpProjectOptionChangeListener> arrayList = null;
        Object v = this.optionsChangeListenersMap.get(string);
        if (v == null) {
            arrayList = new ArrayList<IPhpProjectOptionChangeListener>();
            this.optionsChangeListenersMap.put(string, arrayList);
        } else {
            arrayList = (ArrayList<IPhpProjectOptionChangeListener>)v;
        }
        arrayList.add(iPhpProjectOptionChangeListener);
    }

    public Object getOption(String string) {
        return this.options.get(string);
    }

    public IProject getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadOptions() {
        ArrayList<Object> arrayList;
        block16: {
            IFile iFile = this.project.getFile(FILE_NAME);
            if (!iFile.exists()) {
                return;
            }
            arrayList = new ArrayList<Object>();
            this.includePathEntries = EMPTY_INCLUDEPATH;
            try {
                Object object;
                Object object2;
                int n;
                Element element;
                Object object3;
                InputStreamReader inputStreamReader = new InputStreamReader(iFile.getContents());
                try {
                    try {
                        object3 = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        element = ((DocumentBuilder)object3).parse(new InputSource(inputStreamReader)).getDocumentElement();
                    }
                    catch (SAXException sAXException) {
                        throw new IOException("Bad project options file format");
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        throw new IOException("Bad project options file format");
                    }
                }
                catch (Throwable throwable) {
                    Object var6_12 = null;
                    ((Reader)inputStreamReader).close();
                    throw throwable;
                }
                {
                    Object var6_13 = null;
                }
                ((Reader)inputStreamReader).close();
                this.options = new HashMap();
                if (!element.getNodeName().equalsIgnoreCase(TAG_OPTIONS)) {
                    throw new IOException("Bad project options file format");
                }
                object3 = element.getElementsByTagName(TAG_OPTION);
                int n2 = object3.getLength();
                int n3 = 0;
                while (true) {
                    if (n3 >= n2) {
                        object3 = element.getElementsByTagName("includepath");
                        if (object3.getLength() > 0) {
                            Element element2 = (Element)object3.item(0);
                            object3 = element2.getElementsByTagName("includepathentry");
                            n2 = object3.getLength();
                            n = 0;
                            break;
                        }
                        break block16;
                    }
                    Element element3 = (Element)object3.item(n3);
                    object2 = element3.getAttribute("name");
                    object = element3.getFirstChild().getNodeValue().trim();
                    this.options.put(object2, object);
                    ++n3;
                }
                while (n < n2) {
                    object2 = object3.item(n);
                    if (object2.getNodeType() == 1) {
                        object = IncludePathEntry.elementDecode((Element)object2, this);
                        arrayList.add(object);
                    }
                    ++n;
                }
            }
            catch (IOException iOException) {
                PHPCorePlugin.log(iOException);
            }
            catch (CoreException coreException) {
                PHPCorePlugin.log(coreException);
            }
        }
        int n = arrayList.size();
        this.includePathEntries = new IIncludePathEntry[n];
        arrayList.toArray(this.includePathEntries);
    }

    public void modifyIncludePathEntry(IIncludePathEntry iIncludePathEntry, IProject iProject, IPath iPath, IProgressMonitor iProgressMonitor) throws CoreException {
        throw new RuntimeException("implement me");
    }

    public void notifyOptionChangeListeners(String string, Object object, Object object2) {
        Object v = this.optionsChangeListenersMap.get(string);
        if (v == null) {
            return;
        }
        List list = (List)v;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IPhpProjectOptionChangeListener iPhpProjectOptionChangeListener = (IPhpProjectOptionChangeListener)iterator.next();
            iPhpProjectOptionChangeListener.notifyOptionChanged(object, object2);
        }
    }

    public IIncludePathEntry[] readRawIncludePath() {
        return this.includePathEntries;
    }

    public Object removeOption(String string) {
        Object v = this.options.remove(string);
        if (v == null) {
            return v;
        }
        this.runSave();
        return v;
    }

    public void removeOptionChangeListener(String string, IPhpProjectOptionChangeListener iPhpProjectOptionChangeListener) {
        Object v = this.optionsChangeListenersMap.get(string);
        if (v == null) {
            return;
        }
        List list = (List)v;
        list.remove(iPhpProjectOptionChangeListener);
    }

    public Object removeOptionNotify(String string) {
        Object object = this.removeOption(string);
        this.notifyOptionChangeListeners(string, object, null);
        return object;
    }

    public void removeResourceFromIncludePath(IResource iResource) {
        if (this.includePathEntries.length > 0) {
            IIncludePathEntry[] iIncludePathEntryArray = new IIncludePathEntry[this.includePathEntries.length - 1];
            int n = 0;
            int n2 = 0;
            while (n < this.includePathEntries.length) {
                if (this.includePathEntries[n].getResource() != iResource) {
                    iIncludePathEntryArray[n2++] = this.includePathEntries[n];
                }
                ++n;
            }
            try {
                this.setRawIncludePath(iIncludePathEntryArray, null);
            }
            catch (Exception exception) {
                PHPCorePlugin.log(exception);
            }
        }
    }

    public void runSave() {
        WorkspaceJob workspaceJob = new WorkspaceJob("Project save"){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    PHPProjectOptions.this.saveChanges(iProgressMonitor);
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        };
        workspaceJob.setRule((ISchedulingRule)this.getProject());
        workspaceJob.setUser(false);
        workspaceJob.schedule();
    }

    public void saveChanges(IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            String string;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XMLWriter xMLWriter = new XMLWriter((OutputStream)byteArrayOutputStream);
            xMLWriter.startTag(TAG_OPTIONS, null);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Iterator iterator = this.options.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                Object v = this.options.get(string);
                hashMap.put("name", string);
                xMLWriter.startTag(TAG_OPTION, hashMap);
                xMLWriter.write(v.toString());
                xMLWriter.endTag(TAG_OPTION);
            }
            xMLWriter.startTag("includepath", null);
            int n = 0;
            while (n < this.includePathEntries.length) {
                ((IncludePathEntry)this.includePathEntries[n]).elementEncode(xMLWriter, this.project.getFullPath(), true);
                ++n;
            }
            xMLWriter.endTag("includepath");
            xMLWriter.endTag(TAG_OPTIONS);
            xMLWriter.flush();
            xMLWriter.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            string = this.project.getFile(FILE_NAME);
            if (string.exists()) {
                string.setContents((InputStream)byteArrayInputStream, 1, iProgressMonitor);
            } else {
                string.create((InputStream)byteArrayInputStream, 1, iProgressMonitor);
            }
        }
        catch (IOException iOException) {
            PHPCorePlugin.log(iOException);
        }
    }

    public void setOption(String string, Object object) {
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError();
        }
        Object v = this.options.get(string);
        if (v != null ? object != null && object.equals(v) : object == null) {
            return;
        }
        this.options.put(string, object);
        this.runSave();
        this.notifyOptionChangeListeners(string, v, object);
    }

    public void setRawIncludePath(IIncludePathEntry[] iIncludePathEntryArray, SubProgressMonitor subProgressMonitor) throws CoreException {
        IIncludePathEntry[] iIncludePathEntryArray2 = this.includePathEntries;
        this.includePathEntries = iIncludePathEntryArray;
        IncludePathEntry.updateProjectReferences(this.includePathEntries, iIncludePathEntryArray2, this.project, subProgressMonitor);
        this.saveChanges((IProgressMonitor)subProgressMonitor);
        this.notifyOptionChangeListeners("org.eclipse.php.core.includePath", iIncludePathEntryArray2, iIncludePathEntryArray);
    }
}

