/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ini4j.AbstractBeanInvocationHandler;
import org.ini4j.Convert;
import org.ini4j.IniHandler;
import org.ini4j.IniParser;
import org.ini4j.InvalidIniFormatException;

public class Ini
extends LinkedHashMap {
    public static int FORCE_QUOTES = 4;
    public static int IGNORE_ESCAPE = 1;
    private static final String OPERATOR = " = ";
    private static final long serialVersionUID = -2366249958968147183L;
    public static int STRIP_QUOTES = 2;
    private static final char SUBST_CHAR = '$';
    private static final String SUBST_BEGIN = "${";
    private static final int SUBST_BEGIN_LEN = "${".length();
    private static final String SUBST_END = "}";
    private static final int SUBST_END_LEN = "}".length();
    private static final String SUBST_ENVIRONMENT = "@env";
    private static final char SUBST_ESCAPE = '\\';
    private static final String SUBST_PROPERTY = "@prop";
    private static final char SUBST_SEPARATOR = '/';
    private Map _beans;

    public Ini() {
    }

    public Ini(InputStream inputStream, int n) throws IOException, InvalidIniFormatException {
        this();
        this.load(inputStream, n);
    }

    public Ini(Reader reader, int n) throws IOException, InvalidIniFormatException {
        this();
        this.load(reader, n);
    }

    public Ini(URL uRL, int n) throws IOException, InvalidIniFormatException {
        this();
        this.load(uRL, n);
    }

    public Section add(String string) {
        Section section = new Section(string);
        this.put(string, section);
        return section;
    }

    public void load(InputStream inputStream, int n) throws IOException, InvalidIniFormatException {
        this.load(new InputStreamReader(inputStream), n);
    }

    public void load(Reader reader, int n) throws IOException, InvalidIniFormatException {
        Builder builder = new Builder();
        IniParser.newInstance().parse(reader, (IniHandler)builder, n);
    }

    public void load(URL uRL, int n) throws IOException, InvalidIniFormatException {
        Builder builder = new Builder();
        IniParser.newInstance().parse(uRL, (IniHandler)builder, n);
    }

    public void loadFromXML(InputStream inputStream) throws IOException, InvalidIniFormatException {
        this.loadFromXML(new InputStreamReader(inputStream));
    }

    public void loadFromXML(Reader reader) throws IOException, InvalidIniFormatException {
        Builder builder = new Builder();
        IniParser.newInstance().parseXML(reader, (IniHandler)builder);
    }

    public void loadFromXML(URL uRL) throws IOException, InvalidIniFormatException {
        Builder builder = new Builder();
        IniParser.newInstance().parseXML(uRL, (IniHandler)builder);
    }

    public Section remove(Section section) {
        return (Section)this.remove(section.getName());
    }

    protected void resolve(StringBuffer stringBuffer, Section section) {
        int n = -1;
        int n2 = -1;
        int n3 = stringBuffer.indexOf(SUBST_BEGIN);
        while (n3 >= 0) {
            if (n3 + 2 > stringBuffer.length()) break;
            if (n3 == 0 || stringBuffer.charAt(n3 - 1) != '\\') {
                n = n3;
                n2 = stringBuffer.indexOf(SUBST_END, n3);
                if (n2 < 0) break;
                if (n >= 0 && n2 > 0) {
                    String string = stringBuffer.substring(n + SUBST_BEGIN_LEN, n2);
                    String string2 = null;
                    int n4 = string.indexOf(47);
                    String string3 = null;
                    if (n4 > 0) {
                        string2 = string.substring(0, n4);
                        string = string.substring(n4 + 1);
                    }
                    if (string != null) {
                        if (string2 == null) {
                            string3 = section.fetch(string);
                        } else if (SUBST_ENVIRONMENT.equals(string2)) {
                            string3 = System.getenv(string);
                        } else if (SUBST_PROPERTY.equals(string2)) {
                            string3 = System.getProperty(string);
                        } else {
                            section = (Section)this.get(string2);
                            if (section != null) {
                                string3 = section.fetch(string);
                            }
                        }
                    }
                    if (string3 != null) {
                        stringBuffer.replace(n, n2 + SUBST_END_LEN, string3);
                    }
                }
            }
            n3 = stringBuffer.indexOf(SUBST_BEGIN, n3 + 1);
        }
    }

    public void store(OutputStream outputStream, int n) {
        this.store(new OutputStreamWriter(outputStream), n);
    }

    public void store(Writer writer, int n) {
        PrintWriter printWriter = new PrintWriter(writer);
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Section section = (Section)iterator.next();
            String string = section.getName();
            if (!string.equals("_")) {
                printWriter.print('[');
                if ((n & IGNORE_ESCAPE) == 0) {
                    string = Convert.escape(string);
                }
                printWriter.print(string);
                printWriter.println(']');
            }
            Iterator iterator2 = section.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                String string2 = (String)entry.getKey();
                String string3 = (String)entry.getValue();
                if ((n & IGNORE_ESCAPE) == 0) {
                    string2 = Convert.escape(string2);
                    string3 = Convert.escape(string3);
                }
                if ((n & FORCE_QUOTES) > 0) {
                    string3 = "\"" + string3 + "\"";
                }
                printWriter.print(string2);
                printWriter.print(OPERATOR);
                printWriter.print(string3);
                printWriter.println();
            }
            printWriter.println();
        }
        printWriter.flush();
    }

    public void storeToXML(OutputStream outputStream) {
        this.storeToXML(new OutputStreamWriter(outputStream));
    }

    public void storeToXML(Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println("<ini version='1.0'>");
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Section section = (Section)iterator.next();
            printWriter.print(" <section key='");
            printWriter.print(section.getName());
            printWriter.println("'>");
            Iterator iterator2 = section.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                printWriter.print("  <option key='");
                printWriter.print((String)entry.getKey());
                printWriter.print("' value='");
                printWriter.print((String)entry.getValue());
                printWriter.println("'/>");
            }
            printWriter.println(" </section>");
        }
        printWriter.println("</ini>");
        printWriter.flush();
    }

    public Object to(Class clazz) {
        Object object;
        if (this._beans == null) {
            this._beans = new HashMap();
            object = null;
        } else {
            object = this._beans.get(clazz);
        }
        if (object == null) {
            object = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new BeanInvocationHandler());
            this._beans.put(clazz, object);
        }
        return object;
    }

    class BeanInvocationHandler
    extends AbstractBeanInvocationHandler {
        private final Map _sectionBeans = new HashMap();

        BeanInvocationHandler() {
        }

        protected Object getPropertySpi(String string, Class clazz) {
            Section section;
            Object object = this._sectionBeans.get(string);
            if (object == null && (section = (Section)Ini.this.get(string)) != null) {
                object = section.to(clazz);
                this._sectionBeans.put(string, object);
            }
            return object;
        }

        protected boolean hasPropertySpi(String string) {
            return false;
        }

        protected void setPropertySpi(String string, Object object, Class clazz) {
            throw new UnsupportedOperationException("read only bean");
        }
    }

    class Builder
    implements IniHandler {
        private Section currentSection;

        Builder() {
        }

        public void endIni() {
        }

        public void endSection() {
            this.currentSection = null;
        }

        public void handleOption(String string, String string2) {
            this.currentSection.put(string, string2);
        }

        public void startIni() {
        }

        public void startSection(String string) {
            Section section = (Section)Ini.this.get(string);
            this.currentSection = section != null ? section : Ini.this.add(string);
        }
    }

    public class Section
    extends LinkedHashMap {
        private static final long serialVersionUID = -7065562990685327173L;
        private Map _beans;
        private String _name;

        public Section(String string) {
            this._name = string;
        }

        public String fetch(Object object) {
            String string = (String)this.get(object);
            if (string != null && string.indexOf(36) >= 0) {
                StringBuffer stringBuffer = new StringBuffer(string);
                Ini.this.resolve(stringBuffer, this);
                string = stringBuffer.toString();
            }
            return string;
        }

        public String getName() {
            return this._name;
        }

        public synchronized Object to(Class clazz) {
            Object object;
            if (this._beans == null) {
                this._beans = new HashMap();
                object = null;
            } else {
                object = this._beans.get(clazz);
            }
            if (object == null) {
                object = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new BeanInvocationHandler());
                this._beans.put(clazz, object);
            }
            return object;
        }

        class BeanInvocationHandler
        extends AbstractBeanInvocationHandler {
            BeanInvocationHandler() {
            }

            protected Object getPropertySpi(String string, Class clazz) {
                return Section.this.fetch(string);
            }

            protected boolean hasPropertySpi(String string) {
                return Section.this.containsKey(string);
            }

            protected void setPropertySpi(String string, Object object, Class clazz) {
                Section.this.put(string, object.toString());
            }
        }
    }
}

