/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.debugger;

import org.eclipse.php.debug.core.debugger.Breakpoint;
import org.eclipse.php.debug.core.debugger.PHPstack;

public interface Debugger {
    public boolean start(StartResponseHandler var1);

    public boolean start();

    public boolean addBreakpoint(Breakpoint var1, BreakpointAddedResponseHandler var2);

    public void addBreakpoint(Breakpoint var1);

    public boolean removeBreakpoint(int var1, BreakpointRemovedResponseHandler var2);

    public boolean removeBreakpoint(int var1);

    public boolean removeBreakpoint(Breakpoint var1, BreakpointRemovedResponseHandler var2);

    public boolean removeBreakpoint(Breakpoint var1);

    public boolean removeAllBreakpoints(AllBreakpointRemovedResponseHandler var1);

    public boolean removeAllBreakpoints();

    public boolean stepInto(StepIntoResponseHandler var1);

    public boolean stepInto();

    public boolean stepOver(StepOverResponseHandler var1);

    public boolean stepOver();

    public boolean stepOut(StepOutResponseHandler var1);

    public boolean stepOut();

    public boolean go(GoResponseHandler var1);

    public boolean go();

    public boolean pause(PauseResponseHandler var1);

    public boolean pause();

    public boolean eval(String var1, EvalResponseHandler var2);

    public String eval(String var1);

    public boolean assignValue(String var1, String var2, int var3, String[] var4, AssignValueResponseHandler var5);

    public boolean assignValue(String var1, String var2, int var3, String[] var4);

    public boolean getVariableValue(String var1, int var2, String[] var3, VariableValueResponseHandler var4);

    public String getVariableValue(String var1, int var2, String[] var3);

    public boolean getCallStack(GetCallStackResponseHandler var1);

    public PHPstack getCallStack();

    public boolean getStackVariableValue(int var1, String var2, int var3, String[] var4, GetStackVariableValueResponseHandler var5);

    public String getStackVariableValue(int var1, String var2, int var3, String[] var4);

    public void finish();

    public boolean isActive();

    public static interface StartResponseHandler {
        public void started(boolean var1);
    }

    public static interface BreakpointAddedResponseHandler {
        public void breakpointAdded(String var1, int var2, int var3, boolean var4);
    }

    public static interface BreakpointRemovedResponseHandler {
        public void breakpointRemoved(int var1, boolean var2);
    }

    public static interface AllBreakpointRemovedResponseHandler {
        public void allBreakpointRemoved(boolean var1);
    }

    public static interface EvalResponseHandler {
        public void evaled(String var1, String var2, boolean var3);
    }

    public static interface StepIntoResponseHandler {
        public void stepInto(boolean var1);
    }

    public static interface StepOverResponseHandler {
        public void stepOver(boolean var1);
    }

    public static interface StepOutResponseHandler {
        public void stepOut(boolean var1);
    }

    public static interface GoResponseHandler {
        public void go(boolean var1);
    }

    public static interface PauseResponseHandler {
        public void pause(boolean var1);
    }

    public static interface AssignValueResponseHandler {
        public void valueAssigned(String var1, String var2, int var3, String[] var4, boolean var5);
    }

    public static interface VariableValueResponseHandler {
        public void variableValue(String var1, int var2, String[] var3, String var4, boolean var5);
    }

    public static interface GetCallStackResponseHandler {
        public void callStack(PHPstack var1, boolean var2);
    }

    public static interface GetStackVariableValueResponseHandler {
        public void stackVariableValue(int var1, String var2, int var3, String[] var4, String var5, boolean var6);
    }

    public static interface DebugResponseHandler
    extends BreakpointAddedResponseHandler,
    BreakpointRemovedResponseHandler,
    AllBreakpointRemovedResponseHandler,
    StartResponseHandler,
    EvalResponseHandler,
    StepIntoResponseHandler,
    StepOverResponseHandler,
    StepOutResponseHandler,
    GoResponseHandler,
    PauseResponseHandler,
    AssignValueResponseHandler,
    VariableValueResponseHandler,
    GetCallStackResponseHandler,
    GetStackVariableValueResponseHandler {
    }

    public static class DefaultDebugResponseHandler
    implements DebugResponseHandler {
        public void breakpointAdded(String string, int n, int n2, boolean bl) {
        }

        public void breakpointRemoved(int n, boolean bl) {
        }

        public void allBreakpointRemoved(boolean bl) {
        }

        public void started(boolean bl) {
        }

        public void evaled(String string, String string2, boolean bl) {
        }

        public void stepInto(boolean bl) {
        }

        public void stepOver(boolean bl) {
        }

        public void stepOut(boolean bl) {
        }

        public void go(boolean bl) {
        }

        public void pause(boolean bl) {
        }

        public void valueAssigned(String string, String string2, int n, String[] stringArray, boolean bl) {
        }

        public void variableValue(String string, int n, String[] stringArray, String string2, boolean bl) {
        }

        public void callStack(PHPstack pHPstack, boolean bl) {
        }

        public void stackVariableValue(int n, String string, int n2, String[] stringArray, String string2, boolean bl) {
        }
    }
}

