/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.wizards.fields;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.ui.util.SWTUtil;
import org.eclipse.php.ui.wizards.fields.DialogField;
import org.eclipse.php.ui.wizards.fields.ITreeListAdapter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class TreeListDialogField
extends DialogField {
    protected TreeViewer fTree;
    protected ILabelProvider fLabelProvider;
    protected TreeViewerAdapter fTreeViewerAdapter;
    protected List fElements;
    protected ViewerSorter fViewerSorter;
    protected String[] fButtonLabels;
    private Button[] fButtonControls;
    private boolean[] fButtonsEnabled;
    private int fRemoveButtonIndex;
    private int fUpButtonIndex;
    private int fDownButtonIndex;
    private Label fLastSeparator;
    private Tree fTreeControl;
    private Composite fButtonsControl;
    private ISelection fSelectionWhenEnabled;
    private ITreeListAdapter fTreeAdapter;
    private Object fParentElement;
    private int fTreeExpandLevel;

    public TreeListDialogField(ITreeListAdapter iTreeListAdapter, String[] stringArray, ILabelProvider iLabelProvider) {
        this.fTreeAdapter = iTreeListAdapter;
        this.fLabelProvider = iLabelProvider;
        this.fTreeViewerAdapter = new TreeViewerAdapter();
        this.fParentElement = this;
        this.fElements = new ArrayList(10);
        this.fButtonLabels = stringArray;
        if (this.fButtonLabels != null) {
            int n = this.fButtonLabels.length;
            this.fButtonsEnabled = new boolean[n];
            int n2 = 0;
            while (n2 < n) {
                this.fButtonsEnabled[n2] = true;
                ++n2;
            }
        }
        this.fTree = null;
        this.fTreeControl = null;
        this.fButtonsControl = null;
        this.fRemoveButtonIndex = -1;
        this.fUpButtonIndex = -1;
        this.fDownButtonIndex = -1;
        this.fTreeExpandLevel = 0;
    }

    public void setRemoveButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fRemoveButtonIndex = n;
    }

    public void setUpButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fUpButtonIndex = n;
    }

    public void setDownButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fDownButtonIndex = n;
    }

    public void setViewerSorter(ViewerSorter viewerSorter) {
        this.fViewerSorter = viewerSorter;
    }

    public void setTreeExpansionLevel(int n) {
        this.fTreeExpandLevel = n;
        if (this.isOkToUse((Control)this.fTreeControl) && this.fTreeExpandLevel > 0) {
            this.fTree.expandToLevel(n);
        }
    }

    private void buttonPressed(int n) {
        if (!this.managedButtonPressed(n) && this.fTreeAdapter != null) {
            this.fTreeAdapter.customButtonPressed(this, n);
        }
    }

    protected boolean managedButtonPressed(int n) {
        if (n == this.fRemoveButtonIndex) {
            this.remove();
        } else if (n == this.fUpButtonIndex) {
            this.up();
        } else if (n == this.fDownButtonIndex) {
            this.down();
        } else {
            return false;
        }
        return true;
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        this.assertEnoughColumns(n);
        Label label = this.getLabelControl(composite);
        GridData gridData = TreeListDialogField.gridDataForLabel(1);
        gridData.verticalAlignment = 1;
        label.setLayoutData((Object)gridData);
        Control control = this.getTreeControl(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = n - 2;
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(6);
        control.setLayoutData((Object)gridData);
        Composite composite2 = this.getButtonBox(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite2.setLayoutData((Object)gridData);
        return new Control[]{label, control, composite2};
    }

    public int getNumberOfControls() {
        return 3;
    }

    public void setButtonsMinWidth(int n) {
        if (this.fLastSeparator != null) {
            ((GridData)this.fLastSeparator.getLayoutData()).widthHint = n;
        }
    }

    public Control getTreeControl(Composite composite) {
        if (this.fTreeControl == null) {
            this.assertCompositeNotNull(composite);
            this.fTree = this.createTreeViewer(composite);
            this.fTreeControl = (Tree)this.fTree.getControl();
            this.fTreeControl.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    TreeListDialogField.this.handleKeyPressed(keyEvent);
                }
            });
            this.fTree.setContentProvider((IContentProvider)this.fTreeViewerAdapter);
            this.fTree.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
            this.fTree.addSelectionChangedListener((ISelectionChangedListener)this.fTreeViewerAdapter);
            this.fTree.addDoubleClickListener((IDoubleClickListener)this.fTreeViewerAdapter);
            this.fTree.setInput(this.fParentElement);
            this.fTree.expandToLevel(this.fTreeExpandLevel);
            if (this.fViewerSorter != null) {
                this.fTree.setSorter(this.fViewerSorter);
            }
            this.fTreeControl.setEnabled(this.isEnabled());
            if (this.fSelectionWhenEnabled != null) {
                this.postSetSelection(this.fSelectionWhenEnabled);
            }
        }
        return this.fTreeControl;
    }

    public TreeViewer getTreeViewer() {
        return this.fTree;
    }

    protected int getTreeStyle() {
        int n = 2818;
        return n;
    }

    protected TreeViewer createTreeViewer(Composite composite) {
        Tree tree = new Tree(composite, this.getTreeStyle());
        tree.setFont(composite.getFont());
        return new TreeViewer(tree);
    }

    protected Button createButton(Composite composite, String string, SelectionListener selectionListener) {
        Button button = new Button(composite, 8);
        button.setFont(composite.getFont());
        button.setText(string);
        button.addSelectionListener(selectionListener);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 1;
        gridData.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gridData);
        return button;
    }

    private Label createSeparator(Composite composite) {
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setVisible(false);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.heightHint = 4;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public Composite getButtonBox(Composite composite) {
        if (this.fButtonsControl == null) {
            this.assertCompositeNotNull(composite);
            SelectionListener selectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    TreeListDialogField.this.doButtonSelected(selectionEvent);
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TreeListDialogField.this.doButtonSelected(selectionEvent);
                }
            };
            Composite composite2 = new Composite(composite, 0);
            composite2.setFont(composite.getFont());
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            composite2.setLayout((Layout)gridLayout);
            if (this.fButtonLabels != null) {
                this.fButtonControls = new Button[this.fButtonLabels.length];
                int n = 0;
                while (n < this.fButtonLabels.length) {
                    String string = this.fButtonLabels[n];
                    if (string != null) {
                        this.fButtonControls[n] = this.createButton(composite2, string, selectionListener);
                        this.fButtonControls[n].setEnabled(this.isEnabled() && this.fButtonsEnabled[n]);
                    } else {
                        this.fButtonControls[n] = null;
                        this.createSeparator(composite2);
                    }
                    ++n;
                }
            }
            this.fLastSeparator = this.createSeparator(composite2);
            this.updateButtonState();
            this.fButtonsControl = composite2;
        }
        return this.fButtonsControl;
    }

    private void doButtonSelected(SelectionEvent selectionEvent) {
        if (this.fButtonControls != null) {
            int n = 0;
            while (n < this.fButtonControls.length) {
                if (selectionEvent.widget == this.fButtonControls[n]) {
                    this.buttonPressed(n);
                    return;
                }
                ++n;
            }
        }
    }

    protected void handleKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.fRemoveButtonIndex != -1 && this.isButtonEnabled(this.fTree.getSelection(), this.fRemoveButtonIndex)) {
            this.managedButtonPressed(this.fRemoveButtonIndex);
            return;
        }
        this.fTreeAdapter.keyPressed(this, keyEvent);
    }

    public void dialogFieldChanged() {
        super.dialogFieldChanged();
        this.updateButtonState();
    }

    protected void updateButtonState() {
        if (this.fButtonControls != null) {
            ISelection iSelection = this.fTree.getSelection();
            int n = 0;
            while (n < this.fButtonControls.length) {
                Button button = this.fButtonControls[n];
                if (this.isOkToUse((Control)button)) {
                    button.setEnabled(this.isButtonEnabled(iSelection, n));
                }
                ++n;
            }
        }
    }

    protected boolean containsAttributes(List list) {
        int n = 0;
        while (n < list.size()) {
            if (!this.fElements.contains(list.get(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean getManagedButtonState(ISelection iSelection, int n) {
        List list = this.getSelectedElements();
        boolean bl = this.containsAttributes(list);
        if (n == this.fRemoveButtonIndex) {
            return !list.isEmpty() && !bl;
        }
        if (n == this.fUpButtonIndex) {
            return !iSelection.isEmpty() && !bl && this.canMoveUp(list);
        }
        if (n == this.fDownButtonIndex) {
            return !iSelection.isEmpty() && !bl && this.canMoveDown(list);
        }
        return true;
    }

    protected void updateEnableState() {
        super.updateEnableState();
        boolean bl = this.isEnabled();
        if (this.isOkToUse((Control)this.fTreeControl)) {
            if (!bl) {
                this.fSelectionWhenEnabled = this.fTree.getSelection();
                this.selectElements(null);
            } else {
                this.selectElements(this.fSelectionWhenEnabled);
                this.fSelectionWhenEnabled = null;
            }
            this.fTreeControl.setEnabled(bl);
        }
        this.updateButtonState();
    }

    public void enableButton(int n, boolean bl) {
        if (this.fButtonsEnabled != null && n < this.fButtonsEnabled.length) {
            this.fButtonsEnabled[n] = bl;
            this.updateButtonState();
        }
    }

    private boolean isButtonEnabled(ISelection iSelection, int n) {
        boolean bl = this.getManagedButtonState(iSelection, n);
        return this.isEnabled() && bl && this.fButtonsEnabled[n];
    }

    public void setElements(List list) {
        this.fElements = new ArrayList(list);
        this.refresh();
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.expandToLevel(this.fTreeExpandLevel);
        }
        this.dialogFieldChanged();
    }

    public List getElements() {
        return new ArrayList(this.fElements);
    }

    public Object getElement(int n) {
        return this.fElements.get(n);
    }

    public int getIndexOfElement(Object object) {
        return this.fElements.indexOf(object);
    }

    public void replaceElement(Object object, Object object2) throws IllegalArgumentException {
        int n = this.fElements.indexOf(object);
        if (n != -1) {
            this.fElements.set(n, object2);
            if (this.isOkToUse((Control)this.fTreeControl)) {
                List list = this.getSelectedElements();
                if (list.remove(object)) {
                    list.add(object2);
                }
                boolean bl = this.fTree.getExpandedState(object);
                this.fTree.remove(object);
                this.fTree.add(this.fParentElement, object2);
                if (bl) {
                    this.fTree.expandToLevel(object2, this.fTreeExpandLevel);
                }
                this.selectElements((ISelection)new StructuredSelection(list));
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public void addElement(Object object) {
        if (this.fElements.contains(object)) {
            return;
        }
        this.fElements.add(object);
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.add(this.fParentElement, object);
            this.fTree.expandToLevel(object, this.fTreeExpandLevel);
        }
        this.dialogFieldChanged();
    }

    public void addElements(List list) {
        int n = list.size();
        if (n > 0) {
            ArrayList arrayList = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                Object e = list.get(n2);
                if (!this.fElements.contains(e)) {
                    arrayList.add(e);
                }
                ++n2;
            }
            this.fElements.addAll(arrayList);
            if (this.isOkToUse((Control)this.fTreeControl)) {
                this.fTree.add(this.fParentElement, arrayList.toArray());
                n2 = 0;
                while (n2 < arrayList.size()) {
                    this.fTree.expandToLevel(arrayList.get(n2), this.fTreeExpandLevel);
                    ++n2;
                }
            }
            this.dialogFieldChanged();
        }
    }

    public void insertElementAt(Object object, int n) {
        if (this.fElements.contains(object)) {
            return;
        }
        this.fElements.add(n, object);
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.add(this.fParentElement, object);
            if (this.fTreeExpandLevel != -1) {
                this.fTree.expandToLevel(object, this.fTreeExpandLevel);
            }
        }
        this.dialogFieldChanged();
    }

    public void removeAllElements() {
        if (this.fElements.size() > 0) {
            this.fElements.clear();
            this.refresh();
            this.dialogFieldChanged();
        }
    }

    public void removeElement(Object object) throws IllegalArgumentException {
        if (this.fElements.remove(object)) {
            if (this.isOkToUse((Control)this.fTreeControl)) {
                this.fTree.remove(object);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public void removeElements(List list) {
        if (list.size() > 0) {
            this.fElements.removeAll(list);
            if (this.isOkToUse((Control)this.fTreeControl)) {
                this.fTree.remove(list.toArray());
            }
            this.dialogFieldChanged();
        }
    }

    public int getSize() {
        return this.fElements.size();
    }

    public void selectElements(ISelection iSelection) {
        this.fSelectionWhenEnabled = iSelection;
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.setSelection(iSelection, true);
        }
    }

    public void selectFirstElement() {
        Object object = null;
        if (this.fViewerSorter != null) {
            Object[] objectArray = this.fElements.toArray();
            this.fViewerSorter.sort((Viewer)this.fTree, objectArray);
            if (objectArray.length > 0) {
                object = objectArray[0];
            }
        } else if (this.fElements.size() > 0) {
            object = this.fElements.get(0);
        }
        if (object != null) {
            this.selectElements((ISelection)new StructuredSelection(object));
        }
    }

    public void postSetSelection(final ISelection iSelection) {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            Display display = this.fTreeControl.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (TreeListDialogField.this.isOkToUse((Control)TreeListDialogField.this.fTreeControl)) {
                        TreeListDialogField.this.selectElements(iSelection);
                    }
                }
            });
        }
    }

    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.refresh();
        }
    }

    public void refresh(Object object) {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.refresh(object);
        }
    }

    public void update(Object object) {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.update(object, null);
        }
    }

    private List moveUp(List list, List list2) {
        int n = list.size();
        ArrayList arrayList = new ArrayList(n);
        Object e = null;
        int n2 = 0;
        while (n2 < n) {
            Object e2 = list.get(n2);
            if (list2.contains(e2)) {
                arrayList.add(e2);
            } else {
                if (e != null) {
                    arrayList.add(e);
                }
                e = e2;
            }
            ++n2;
        }
        if (e != null) {
            arrayList.add(e);
        }
        return arrayList;
    }

    private void moveUp(List list) {
        if (list.size() > 0) {
            this.setElements(this.moveUp(this.fElements, list));
            this.fTree.reveal(list.get(0));
        }
    }

    private void moveDown(List list) {
        if (list.size() > 0) {
            this.setElements(this.reverse(this.moveUp(this.reverse(this.fElements), list)));
            this.fTree.reveal(list.get(list.size() - 1));
        }
    }

    private List reverse(List list) {
        ArrayList arrayList = new ArrayList(list.size());
        int n = list.size() - 1;
        while (n >= 0) {
            arrayList.add(list.get(n));
            --n;
        }
        return arrayList;
    }

    private void remove() {
        this.removeElements(this.getSelectedElements());
    }

    private void up() {
        this.moveUp(this.getSelectedElements());
    }

    private void down() {
        this.moveDown(this.getSelectedElements());
    }

    private boolean canMoveUp(List list) {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            int n = list.size();
            int n2 = this.fElements.size();
            int n3 = 0;
            while (n3 < n2 && n > 0) {
                if (!list.contains(this.fElements.get(n3))) {
                    return true;
                }
                --n;
                ++n3;
            }
        }
        return false;
    }

    private boolean canMoveDown(List list) {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            int n = list.size();
            int n2 = this.fElements.size() - 1;
            while (n2 >= 0 && n > 0) {
                if (!list.contains(this.fElements.get(n2))) {
                    return true;
                }
                --n;
                --n2;
            }
        }
        return false;
    }

    public List getSelectedElements() {
        ISelection iSelection;
        ArrayList arrayList = new ArrayList();
        if (this.isOkToUse((Control)this.fTreeControl) && (iSelection = this.fTree.getSelection()) instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    public void expandElement(Object object, int n) {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.expandToLevel(object, n);
        }
    }

    protected void doListSelected(SelectionChangedEvent selectionChangedEvent) {
        this.updateButtonState();
        if (this.fTreeAdapter != null) {
            this.fTreeAdapter.selectionChanged(this);
        }
    }

    protected void doDoubleClick(DoubleClickEvent doubleClickEvent) {
        if (this.fTreeAdapter != null) {
            this.fTreeAdapter.doubleClicked(this);
        }
    }

    private class TreeViewerAdapter
    implements ITreeContentProvider,
    ISelectionChangedListener,
    IDoubleClickListener {
        private final Object[] NO_ELEMENTS = new Object[0];

        private TreeViewerAdapter() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public boolean isDeleted(Object object) {
            return false;
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return TreeListDialogField.this.fElements.toArray();
        }

        public Object[] getChildren(Object object) {
            if (TreeListDialogField.this.fTreeAdapter != null) {
                return TreeListDialogField.this.fTreeAdapter.getChildren(TreeListDialogField.this, object);
            }
            return this.NO_ELEMENTS;
        }

        public Object getParent(Object object) {
            if (!TreeListDialogField.this.fElements.contains(object) && TreeListDialogField.this.fTreeAdapter != null) {
                return TreeListDialogField.this.fTreeAdapter.getParent(TreeListDialogField.this, object);
            }
            return TreeListDialogField.this.fParentElement;
        }

        public boolean hasChildren(Object object) {
            if (TreeListDialogField.this.fTreeAdapter != null) {
                return TreeListDialogField.this.fTreeAdapter.hasChildren(TreeListDialogField.this, object);
            }
            return false;
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            TreeListDialogField.this.doListSelected(selectionChangedEvent);
        }

        public void doubleClick(DoubleClickEvent doubleClickEvent) {
            TreeListDialogField.this.doDoubleClick(doubleClickEvent);
        }
    }
}

