/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.php.Logger;
import org.eclipse.php.core.documentModel.PHPEditorModel;
import org.eclipse.php.core.documentModel.parser.PhpLexer;
import org.eclipse.php.core.phpModel.parser.CodeDataFilter;
import org.eclipse.php.core.phpModel.parser.ModelSupport;
import org.eclipse.php.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileDataUtilities;
import org.eclipse.php.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.core.phpModel.phpElementData.PHPModifier;
import org.eclipse.php.core.phpModel.phpElementData.UserData;
import org.eclipse.php.ui.editor.contentassist.PHPTextSequenceUtilities;
import org.eclipse.php.ui.editor.util.TextSequence;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;

public class CodeDataResolver {
    protected static final char[] phpDelimiters = new char[]{'?', ':', ';', '|', '^', '&', '<', '>', '+', '-', '.', '*', '/', '%', '!', '~', '[', ']', '(', ')', '{', '}', '@', '\n', '\t', ' ', ',', '$', '\'', '\"'};
    private static final String CLASS_FUNCTIONS_TRIGGER = "::";
    private static final String OBJECT_FUNCTIONS_TRIGGER = "->";
    private static final Pattern extendsPattern = Pattern.compile("\\Wextends\\W", 2);
    private static final Pattern implementsPattern = Pattern.compile("\\Wimplements", 2);
    private static final Pattern catchPattern = Pattern.compile("catch\\s[^{]*", 2);
    private static final boolean CONSTANT_CASE_SENSITIVE = false;
    private static final CodeDataResolver instance = new CodeDataResolver();
    private CodeData[] extendedImplementCodeData;
    private static CodeData[] implementCodeData;
    private static CodeData[] extendsCodeData;

    private CodeDataResolver() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CodeData getCodeData(ITextViewer iTextViewer, int n) throws BadLocationException {
        IStructuredModel iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(iTextViewer.getDocument());
        if (!(iStructuredModel instanceof PHPEditorModel)) {
            if (iStructuredModel == null) return null;
            iStructuredModel.releaseFromRead();
            return null;
        }
        PHPEditorModel pHPEditorModel = (PHPEditorModel)iStructuredModel;
        try {
            CodeData codeData;
            try {
                codeData = instance.getCodeData(iTextViewer, pHPEditorModel, n);
                Object var5_5 = null;
            }
            catch (BadLocationException badLocationException) {
                Logger.logException(badLocationException);
            }
            iStructuredModel.releaseFromRead();
            return codeData;
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            iStructuredModel.releaseFromRead();
            throw throwable;
        }
        iStructuredModel.releaseFromRead();
        return null;
    }

    private CodeData getCodeData(ITextViewer iTextViewer, PHPEditorModel pHPEditorModel, int n) throws BadLocationException {
        boolean bl;
        PHPFileData pHPFileData = pHPEditorModel.getFileData();
        if (pHPFileData == null) {
            return null;
        }
        String string = pHPFileData.getName();
        PHPProjectModel pHPProjectModel = pHPEditorModel.getProjectModel();
        IStructuredDocumentRegion iStructuredDocumentRegion = ContentAssistUtils.getStructuredDocumentRegion((StructuredTextViewer)((StructuredTextViewer)iTextViewer), (int)n);
        ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        if (iTextRegion == null) {
            return null;
        }
        int n2 = iStructuredDocumentRegion.getStartOffset(iTextRegion);
        if (n2 == n) {
            iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n - 1);
            if (iTextRegion == null) {
                return null;
            }
            n2 = iStructuredDocumentRegion.getStartOffset(iTextRegion);
        }
        TextSequence textSequence = PHPTextSequenceUtilities.getStatment(n, iStructuredDocumentRegion, true);
        String string2 = iTextRegion.getType();
        CodeData codeData = this.getIfInArrayOptionQuotes(pHPProjectModel, string, string2, n, textSequence);
        if (codeData != null) {
            return codeData;
        }
        if (this.isPHPSingleQuote(iStructuredDocumentRegion, iTextRegion) || PhpLexer.isPHPCommentState((String)string2)) {
            return null;
        }
        codeData = this.getIfInFunctionDeclaretion(pHPProjectModel, string, textSequence, n);
        if (codeData != null) {
            return codeData;
        }
        codeData = this.getIfInClassDeclaretion(pHPProjectModel, string, textSequence, n);
        if (codeData != null) {
            return codeData;
        }
        codeData = this.getIfInCatchStatment(pHPProjectModel, textSequence, n);
        if (codeData != null) {
            return codeData;
        }
        int n3 = textSequence.length();
        int n4 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n3);
        int n5 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n4, true);
        String string3 = textSequence.subSequence(n5, n4).toString();
        boolean bl2 = bl = n3 != n4;
        if (bl && (codeData = this.getIfNewOrInstanceofStatment(pHPProjectModel, string3, "", n, string2)) != null) {
            return codeData;
        }
        int n6 = iStructuredDocumentRegion.getParentDocument().getLineOfOffset(n);
        codeData = this.getIfClassFunctionCompletion(pHPProjectModel, string, textSequence, n, n6, string3, n5, bl);
        if (codeData != null) {
            return codeData;
        }
        n4 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n5);
        n5 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n4, true);
        String string4 = textSequence.subSequence(n5, n4).toString();
        if (!bl && (codeData = this.getIfNewOrInstanceofStatment(pHPProjectModel, string4, string3, n, string2)) != null) {
            return codeData;
        }
        codeData = this.getIfInArrayOption(pHPProjectModel, string, bl, string4, string3, n5, n, textSequence);
        if (codeData != null) {
            return codeData;
        }
        String string5 = string3;
        if (string5.startsWith("$")) {
            IStructuredDocument iStructuredDocument;
            if (PhpLexer.isPHPQuotesState((String)string2)) {
                iStructuredDocument = iStructuredDocumentRegion.getParentDocument();
                try {
                    char c = iStructuredDocument.get(n - 2, 1).charAt(0);
                    if (c == '\\') {
                        return null;
                    }
                }
                catch (BadLocationException badLocationException) {
                    Logger.logException(badLocationException);
                }
            }
            iStructuredDocument = this.getContext(pHPProjectModel, string, n - string5.length());
            string5 = string5.substring(1);
            CodeData[] codeDataArray = pHPProjectModel.getVariables(string, (PHPCodeContext)iStructuredDocument, string5, true);
            return this.filterExact(codeDataArray, string5);
        }
        if (PhpLexer.isPHPQuotesState((String)string2) || string2.equals("PHP_HEREDOC_TAG") && iStructuredDocumentRegion.getStartOffset(iTextRegion) + iTextRegion.getLength() <= n) {
            return null;
        }
        CodeData[] codeDataArray = pHPProjectModel.getFunction(string5);
        PHPConstantData pHPConstantData = pHPProjectModel.getConstantData(string5, false);
        PHPClassData pHPClassData = pHPProjectModel.getClass(string, string5);
        CodeData[] codeDataArray2 = pHPProjectModel.getKeywordData(string5);
        CodeData[] codeDataArray3 = null;
        codeDataArray3 = ModelSupport.merge((CodeData[])codeDataArray2, (CodeData[])codeDataArray3);
        if (pHPClassData != null) {
            codeDataArray3 = ModelSupport.merge((CodeData[])new CodeData[]{pHPClassData}, (CodeData[])codeDataArray3);
        }
        if (pHPConstantData != null) {
            codeDataArray3 = ModelSupport.merge((CodeData[])new CodeData[]{pHPConstantData}, (CodeData[])codeDataArray3);
        }
        codeDataArray3 = ModelSupport.merge((CodeData[])codeDataArray, (CodeData[])codeDataArray3);
        return this.filterExact(codeDataArray3, string5);
    }

    private boolean isPHPSingleQuote(IStructuredDocumentRegion iStructuredDocumentRegion, ITextRegion iTextRegion) {
        if (PhpLexer.isPHPQuotesState((String)iTextRegion.getType())) {
            char c = iStructuredDocumentRegion.getText(iTextRegion).charAt(0);
            return c == '\'';
        }
        return false;
    }

    private CodeData getIfInArrayOptionQuotes(PHPProjectModel pHPProjectModel, String string, String string2, int n, TextSequence textSequence) {
        if (!PhpLexer.isPHPQuotesState((String)string2)) {
            return null;
        }
        int n2 = textSequence.length();
        int n3 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n2);
        int n4 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n3, false);
        if (n3 != n2 && n4 != n3) {
            return null;
        }
        String string3 = textSequence.subSequence(n4, n3).toString();
        n3 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n4);
        char c = textSequence.charAt(n3 - 1);
        if (c != '\"' && c != '\'') {
            return null;
        }
        --n3;
        if ((n3 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n3)) == 0 || textSequence.charAt(n3 - 1) != '[') {
            return null;
        }
        --n3;
        n4 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n3 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n3), true);
        String string4 = textSequence.subSequence(n4, n3).toString();
        if (string4.startsWith("$")) {
            string4 = string4.substring(1);
        }
        return this.filterExact(pHPProjectModel.getArrayVariables(string, string4, string3, true), string3);
    }

    private CodeData getIfClassFunctionCompletion(PHPProjectModel pHPProjectModel, String string, TextSequence textSequence, int n, int n2, String string2, int n3, boolean bl) {
        String string3;
        if ((n3 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n3)) <= 2) {
            return null;
        }
        boolean bl2 = false;
        String string4 = textSequence.subSequence(n3 - 2, n3).toString();
        if (!string4.equals(OBJECT_FUNCTIONS_TRIGGER)) {
            if (string4.equals(CLASS_FUNCTIONS_TRIGGER)) {
                bl2 = true;
            } else {
                return null;
            }
        }
        if ((string3 = this.getClassName(pHPProjectModel, string, textSequence, n3, n, n2)) == null) {
            string3 = "";
        }
        if (bl && string2.length() > 0) {
            return this.filterExact(this.getIfClassFunctionCall(pHPProjectModel, string, string3, string2), string2);
        }
        boolean bl3 = !bl2 && !textSequence.toString().trim().equals("$this->");
        return this.filterExact(this.getClassCall(pHPProjectModel, string, n, string3, string2, bl3), string2);
    }

    private String getClassName(PHPProjectModel pHPProjectModel, String string, TextSequence textSequence, int n, int n2, int n3) {
        int n4;
        int n5;
        n = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n);
        boolean bl = false;
        String string2 = textSequence.subSequence(n - 2, n).toString();
        if (!string2.equals(OBJECT_FUNCTIONS_TRIGGER)) {
            if (string2.equals(CLASS_FUNCTIONS_TRIGGER)) {
                bl = true;
            } else {
                return null;
            }
        }
        if ((n5 = PHPTextSequenceUtilities.getPrivousTriggerIndex(textSequence, n4 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n - 2))) == -1) {
            return this.innerGetClassName(pHPProjectModel, string, textSequence, n4, bl, n2, n3);
        }
        int n6 = PHPTextSequenceUtilities.readForwardSpaces(textSequence, n5 + 2);
        String string3 = textSequence.subSequence(n6, n4).toString();
        String string4 = this.getClassName(pHPProjectModel, string, textSequence, n6, n2, n3);
        int n7 = string3.indexOf(40);
        if (n7 == -1) {
            return this.getVarType(pHPProjectModel, string, string4, string3, n2, n3);
        }
        String string5 = string3.substring(0, n7).trim();
        return this.getFunctionReturnType(pHPProjectModel, string, string4, string5);
    }

    private String innerGetClassName(PHPProjectModel pHPProjectModel, String string, TextSequence textSequence, int n, boolean bl, int n2, int n3) {
        int n4 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n, true);
        String string2 = textSequence.subSequence(n4, n).toString();
        if (bl) {
            PHPClassData pHPClassData;
            if (string2.equals("self")) {
                PHPClassData pHPClassData2 = this.getContainerClassData(pHPProjectModel, string, n2 - 6);
                if (pHPClassData2 != null) {
                    return pHPClassData2.getName();
                }
            } else if (string2.equals("parent") && (pHPClassData = this.getContainerClassData(pHPProjectModel, string, n2 - 8)) != null) {
                return pHPProjectModel.getSuperClassName(string, pHPClassData.getName());
            }
            return string2;
        }
        if (string2.length() > 0 && string2.charAt(0) == '$') {
            int n5 = n2 - textSequence.length();
            return PHPFileDataUtilities.getVariableType((String)string, (String)string2, (int)n5, (int)n3, (PHPUserModel)pHPProjectModel.getPHPUserModel(), (boolean)true);
        }
        if (textSequence.charAt(n - 1) == ')') {
            int n6 = this.getFunctionNameEndOffset(textSequence, n - 1);
            int n7 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n6, false);
            String string3 = textSequence.subSequence(n7, n6).toString();
            PHPClassData pHPClassData = this.getContainerClassData(pHPProjectModel, string, n2);
            if (pHPClassData != null) {
                return this.getFunctionReturnType(pHPProjectModel, string, pHPClassData.getName(), string3);
            }
            PHPFileData pHPFileData = pHPProjectModel.getFileData(string);
            PHPFunctionData[] pHPFunctionDataArray = pHPFileData.getFunctions();
            int n8 = 0;
            while (n8 < pHPFunctionDataArray.length) {
                PHPFunctionData pHPFunctionData = pHPFunctionDataArray[n8];
                if (pHPFunctionData.getName().equals(string3)) {
                    return pHPFunctionData.getReturnType();
                }
                ++n8;
            }
        }
        return null;
    }

    private CodeData[] getIfClassFunctionCall(PHPProjectModel pHPProjectModel, String string, String string2, String string3) {
        CodeData codeData = pHPProjectModel.getClassFunctionData(string, string2, string3);
        if (codeData != null) {
            return new CodeData[]{codeData};
        }
        return null;
    }

    private String getVarType(PHPProjectModel pHPProjectModel, String string, String string2, String string3, int n, int n2) {
        String string4 = PHPFileDataUtilities.getVariableType((String)string, (String)("this;*" + string3), (int)n, (int)n2, (PHPUserModel)pHPProjectModel.getPHPUserModel(), (boolean)true);
        if (string4 != null) {
            return string4;
        }
        CodeData codeData = pHPProjectModel.getClassVariablesData(string, string2, string3);
        if (codeData != null) {
            if (codeData instanceof PHPClassVarData) {
                return ((PHPClassVarData)codeData).getClassType();
            }
            return null;
        }
        PHPClassData pHPClassData = pHPProjectModel.getClass(string, string2);
        if (pHPClassData == null) {
            return null;
        }
        PHPClassData.PHPSuperClassNameData pHPSuperClassNameData = pHPClassData.getSuperClassData();
        if (pHPSuperClassNameData == null) {
            return null;
        }
        return this.getVarType(pHPProjectModel, string, pHPSuperClassNameData.getName(), string3, n, n2);
    }

    private String getFunctionReturnType(PHPProjectModel pHPProjectModel, String string, String string2, String string3) {
        CodeData[] codeDataArray;
        CodeData codeData = pHPProjectModel.getClassFunctionData(string, string2, string3);
        if (codeData != null) {
            if (codeData instanceof PHPFunctionData) {
                return ((PHPFunctionData)codeData).getReturnType();
            }
            return null;
        }
        PHPClassData pHPClassData = pHPProjectModel.getClass(string, string2);
        if (pHPClassData == null) {
            return null;
        }
        String string4 = null;
        PHPClassData.PHPSuperClassNameData pHPSuperClassNameData = pHPClassData.getSuperClassData();
        if (pHPSuperClassNameData != null) {
            string4 = this.getFunctionReturnType(pHPProjectModel, string, pHPSuperClassNameData.getName(), string3);
        }
        if (string4 == null) {
            codeDataArray = pHPProjectModel.getFileData(string);
            PHPFunctionData[] pHPFunctionDataArray = codeDataArray.getFunctions();
            int n = 0;
            while (n < pHPFunctionDataArray.length) {
                PHPFunctionData pHPFunctionData = pHPFunctionDataArray[n];
                if (pHPFunctionData.getName().equals(string3) && pHPFunctionData instanceof PHPFunctionData) {
                    string4 = pHPFunctionData.getReturnType();
                }
                ++n;
            }
        }
        if (string4 == null) {
            codeDataArray = pHPProjectModel.getFunctions();
            int n = 0;
            while (n < codeDataArray.length) {
                CodeData codeData2 = codeDataArray[n];
                if (codeData2.getName().equals(string3) && codeData2 instanceof PHPFunctionData) {
                    string4 = ((PHPFunctionData)codeData2).getReturnType();
                }
                ++n;
            }
        }
        return string4;
    }

    private CodeData[] getClassCall(PHPProjectModel pHPProjectModel, String string, int n, String string2, String string3, boolean bl) {
        CodeData codeData = pHPProjectModel.getClassFunctionData(string, string2, string3);
        CodeData codeData2 = pHPProjectModel.getClassVariablesData(string, string2, string3);
        CodeData codeData3 = pHPProjectModel.getClassConstsData(string, string2, string3);
        CodeData[] codeDataArray = null;
        if (codeData != null) {
            codeDataArray = ModelSupport.merge((CodeData[])new CodeData[]{codeData}, (CodeData[])codeDataArray);
        }
        if (codeData2 != null) {
            codeDataArray = ModelSupport.merge((CodeData[])new CodeData[]{codeData2}, (CodeData[])codeDataArray);
        }
        if (codeData3 != null) {
            codeDataArray = ModelSupport.merge((CodeData[])new CodeData[]{codeData3}, (CodeData[])codeDataArray);
        }
        codeDataArray = ModelSupport.getFilteredCodeData((CodeData[])codeDataArray, (CodeDataFilter)this.getAccessLevelFilter(pHPProjectModel, string, string2, n, bl));
        return codeDataArray;
    }

    private PHPClassData getContainerClassData(PHPProjectModel pHPProjectModel, String string, int n) {
        PHPFileData pHPFileData = pHPProjectModel.getFileData(string);
        return PHPFileDataUtilities.getContainerClassDada((PHPFileData)pHPFileData, (int)n);
    }

    private int getFunctionNameEndOffset(TextSequence textSequence, int n) {
        if (textSequence.charAt(n) != ')') {
            return 0;
        }
        int n2 = n;
        int n3 = 1;
        while (n3 != 0 && n2 >= 0) {
            if (textSequence.charAt(--n2) == ')') {
                ++n3;
                continue;
            }
            if (textSequence.charAt(n2) != '(') continue;
            --n3;
        }
        return n2;
    }

    private CodeDataFilter getAccessLevelFilter(PHPProjectModel pHPProjectModel, String string, String string2, int n, boolean bl) {
        PHPCodeContext pHPCodeContext = this.getContext(pHPProjectModel, string, n);
        String string3 = pHPCodeContext.getContainerClassName();
        if (string3.equals(string2)) {
            return ModelSupport.PIRVATE_ACCESS_LEVEL_FILTER;
        }
        if (string3.equals("") || bl) {
            return ModelSupport.PUBLIC_ACCESS_LEVEL_FILTER;
        }
        PHPClassData pHPClassData = pHPProjectModel.getClass(string, string3);
        String string4 = pHPClassData.getSuperClassData().getName();
        while (string4 != null) {
            if (string4.equals(string2)) {
                return ModelSupport.PROTECTED_ACCESS_LEVEL_FILTER;
            }
            pHPClassData = pHPProjectModel.getClass(string, string4);
            if (pHPClassData == null) break;
            string4 = pHPClassData.getSuperClassData().getName();
        }
        return ModelSupport.PUBLIC_ACCESS_LEVEL_FILTER;
    }

    private PHPCodeContext getContext(PHPProjectModel pHPProjectModel, String string, int n) {
        PHPFileData pHPFileData = pHPProjectModel.getFileData(string);
        return ModelSupport.createContext((PHPFileData)pHPFileData, (int)n);
    }

    private CodeData getIfInFunctionDeclaretion(PHPProjectModel pHPProjectModel, String string, TextSequence textSequence, int n) {
        int n2 = PHPTextSequenceUtilities.isInFunctionDeclaretion(textSequence);
        if (n2 == -1) {
            return null;
        }
        int n3 = textSequence.length() - 1;
        while (n3 >= n2) {
            if (textSequence.charAt(n3) == '(') {
                return null;
            }
            --n3;
        }
        n3 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, textSequence.length());
        int n4 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n3, false);
        String string2 = textSequence.subSequence(n4, n3).toString();
        PHPClassData pHPClassData = this.getContainerClassData(pHPProjectModel, string, textSequence.getOriginalOffset(n2));
        if (pHPClassData == null) {
            PHPFileData pHPFileData = pHPProjectModel.getFileData(string);
            return this.filterExact((CodeData[])pHPFileData.getFunctions(), string2);
        }
        CodeData codeData = pHPProjectModel.getClassFunctionData(string, pHPClassData.getName(), string2);
        if (codeData != null) {
            return codeData;
        }
        String string3 = pHPProjectModel.getPHPLanguageModel().getPHPVersion();
        boolean bl = string3.equals("php5");
        if (!bl) {
            return PHPCodeDataFactory.createPHPFuctionData((String)pHPClassData.getName(), (int)1, null, (UserData)pHPClassData.getUserData(), (PHPFunctionData.PHPFunctionParameter[])PHPCodeDataFactory.EMPTY_FUNCTION_PARAMETER_DATA_ARRAY, null);
        }
        CodeData[] codeDataArray = new CodeData[]{PHPCodeDataFactory.createPHPFuctionData((String)"__construct", (int)1, null, (UserData)pHPClassData.getUserData(), (PHPFunctionData.PHPFunctionParameter[])PHPCodeDataFactory.EMPTY_FUNCTION_PARAMETER_DATA_ARRAY, null), PHPCodeDataFactory.createPHPFuctionData((String)"__destruct", (int)1, null, (UserData)pHPClassData.getUserData(), (PHPFunctionData.PHPFunctionParameter[])PHPCodeDataFactory.EMPTY_FUNCTION_PARAMETER_DATA_ARRAY, null), PHPCodeDataFactory.createPHPFuctionData((String)pHPClassData.getName(), (int)1, null, (UserData)pHPClassData.getUserData(), (PHPFunctionData.PHPFunctionParameter[])PHPCodeDataFactory.EMPTY_FUNCTION_PARAMETER_DATA_ARRAY, null)};
        int n5 = 0;
        while (n5 < codeDataArray.length) {
            ((PHPFunctionData)codeDataArray[n5]).setContainer((PHPCodeData)pHPClassData);
            ((PHPCodeDataFactory.PHPFunctionDataImp)codeDataArray[n5]).setReturnType(pHPClassData.getName());
            ++n5;
        }
        return this.filterExact(codeDataArray, string2);
    }

    private CodeData getIfInClassDeclaretion(PHPProjectModel pHPProjectModel, String string, TextSequence textSequence, int n) {
        int n2 = PHPTextSequenceUtilities.isInClassDeclaretion(textSequence);
        if (n2 == -1) {
            return null;
        }
        boolean bl = true;
        if (n2 >= 6) {
            String string2 = textSequence.subSequence(n2 - 6, n2 - 1).toString();
            bl = string2.equals("class");
        }
        textSequence = textSequence.subTextSequence(n2, textSequence.length());
        int n3 = 0;
        while (n3 < textSequence.length()) {
            if (!Character.isLetterOrDigit(textSequence.charAt(n3))) break;
            ++n3;
        }
        if (n3 == textSequence.length()) {
            return pHPProjectModel.getClass(string, textSequence.toString());
        }
        textSequence = textSequence.subTextSequence(n3, textSequence.length());
        int n4 = textSequence.length();
        int n5 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n4, false);
        String string3 = textSequence.subSequence(n5, n4).toString();
        Matcher matcher = extendsPattern.matcher(textSequence);
        Matcher matcher2 = implementsPattern.matcher(textSequence);
        boolean bl2 = matcher.find();
        boolean bl3 = matcher2.find();
        if (!bl2 && !bl3) {
            if (bl) {
                return this.filterExact(this.getExtendsImplementsCodeData(pHPProjectModel, string3, n), string3);
            }
            return this.filterExact(CodeDataResolver.getExtendsCodeData(pHPProjectModel, string3, n), string3);
        }
        n4 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n5);
        String string4 = textSequence.subSequence(n5 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n4, true), n4).toString();
        if (string4.equalsIgnoreCase("extends")) {
            return this.filterExact(this.getBaseClassList(pHPProjectModel, string3, n, bl), string3);
        }
        if (string4.equalsIgnoreCase("implements")) {
            return this.filterExact(this.getInterfaceList(pHPProjectModel, string3, n), string3);
        }
        if (bl2 && bl3) {
            if (matcher.start() < matcher2.start()) {
                return this.filterExact(this.getInterfaceList(pHPProjectModel, string3, n), string3);
            }
            return this.filterExact(this.getBaseClassList(pHPProjectModel, string3, n, bl), string3);
        }
        if (bl3) {
            return this.filterExact(this.getInterfaceList(pHPProjectModel, string3, n), string3);
        }
        if (bl) {
            return this.filterExact(this.getImplementsCodeData(pHPProjectModel, string3, n), string3);
        }
        return null;
    }

    private CodeData[] getInterfaceList(PHPProjectModel pHPProjectModel, String string, int n) {
        CodeData[] codeDataArray = pHPProjectModel.getClasses(string);
        ArrayList<CodeData> arrayList = new ArrayList<CodeData>(codeDataArray.length / 10);
        int n2 = 0;
        while (n2 < codeDataArray.length) {
            if (PHPModifier.isInterface((int)((PHPClassData)codeDataArray[n2]).getModifiers())) {
                arrayList.add(codeDataArray[n2]);
            }
            ++n2;
        }
        CodeData[] codeDataArray2 = new CodeData[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        int n3 = 0;
        while (n3 < codeDataArray2.length) {
            codeDataArray2[n3] = (CodeData)iterator.next();
            ++n3;
        }
        return codeDataArray2;
    }

    private CodeData[] getExtendsImplementsCodeData(PHPProjectModel pHPProjectModel, String string, int n) {
        if (this.extendedImplementCodeData == null) {
            CodeData codeData = null;
            CodeData codeData2 = null;
            CodeData[] codeDataArray = pHPProjectModel.getKeywordData();
            int n2 = 0;
            while (n2 < codeDataArray.length) {
                if (codeDataArray[n2].getName().equals("extends")) {
                    codeData = codeDataArray[n2];
                }
                if (codeDataArray[n2].getName().equals("implements")) {
                    codeData2 = codeDataArray[n2];
                }
                ++n2;
            }
            String string2 = pHPProjectModel.getPHPLanguageModel().getPHPVersion();
            boolean bl = string2.equals("php5");
            this.extendedImplementCodeData = bl ? new CodeData[]{codeData, codeData2} : new CodeData[]{codeData};
        }
        return this.extendedImplementCodeData;
    }

    private CodeData[] getImplementsCodeData(PHPProjectModel pHPProjectModel, String string, int n) {
        String string2 = pHPProjectModel.getPHPLanguageModel().getPHPVersion();
        boolean bl = string2.equals("php5");
        if (!bl) {
            return null;
        }
        if (implementCodeData == null) {
            CodeData codeData = null;
            CodeData[] codeDataArray = pHPProjectModel.getKeywordData();
            int n2 = 0;
            while (n2 < codeDataArray.length) {
                if (codeDataArray[n2].getName().equals("implements")) {
                    codeData = codeDataArray[n2];
                    break;
                }
                ++n2;
            }
            implementCodeData = new CodeData[]{codeData};
        }
        return implementCodeData;
    }

    private static CodeData[] getExtendsCodeData(PHPProjectModel pHPProjectModel, String string, int n) {
        if (extendsCodeData == null) {
            CodeData codeData = null;
            CodeData[] codeDataArray = pHPProjectModel.getKeywordData();
            int n2 = 0;
            while (n2 < codeDataArray.length) {
                if (codeDataArray[n2].getName().equals("extends")) {
                    codeData = codeDataArray[n2];
                    break;
                }
                ++n2;
            }
            extendsCodeData = new CodeData[]{codeData};
        }
        return extendsCodeData;
    }

    private CodeData[] getBaseClassList(PHPProjectModel pHPProjectModel, String string, int n, boolean bl) {
        if (!bl) {
            this.getInterfaceList(pHPProjectModel, string, n);
        }
        CodeData[] codeDataArray = this.getOnlyClasses(pHPProjectModel);
        return codeDataArray;
    }

    private CodeData[] getOnlyClasses(PHPProjectModel pHPProjectModel) {
        CodeData[] codeDataArray = pHPProjectModel.getClasses("");
        int n = 0;
        int n2 = 0;
        while (n2 < codeDataArray.length) {
            if (PHPModifier.isInterface((int)((PHPClassData)codeDataArray[n2]).getModifiers())) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return codeDataArray;
        }
        CodeData[] codeDataArray2 = new CodeData[codeDataArray.length - n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < codeDataArray.length) {
            if (!PHPModifier.isInterface((int)((PHPClassData)codeDataArray[n4]).getModifiers())) {
                codeDataArray2[n3] = codeDataArray[n4];
                ++n3;
            }
            ++n4;
        }
        return codeDataArray2;
    }

    private CodeData getIfInCatchStatment(PHPProjectModel pHPProjectModel, TextSequence textSequence, int n) {
        Matcher matcher = catchPattern.matcher(textSequence);
        int n2 = textSequence.length();
        while (matcher.find()) {
            if (textSequence.length() != matcher.end()) continue;
            n2 = matcher.start() + 1;
            break;
        }
        if (n2 == textSequence.length()) {
            return null;
        }
        int n3 = n2 + 5;
        textSequence = textSequence.subTextSequence(n3, textSequence.length());
        int n4 = 0;
        while (n4 < textSequence.length()) {
            if (textSequence.charAt(n4) == '(') break;
            ++n4;
        }
        if (n4 == textSequence.length()) {
            return null;
        }
        n4 = PHPTextSequenceUtilities.readForwardSpaces(textSequence, n4 + 1);
        int n5 = PHPTextSequenceUtilities.readIdentifiarEndIndex(textSequence, n4, false);
        String string = textSequence.subSequence(n4, n5).toString();
        if (n5 == textSequence.length()) {
            return this.filterExact(this.getClassList(pHPProjectModel, string, n, false), string);
        }
        return null;
    }

    private CodeData[] getClassList(PHPProjectModel pHPProjectModel, String string, int n, boolean bl) {
        CodeData[] codeDataArray = bl ? this.getOnlyClasses(pHPProjectModel) : pHPProjectModel.getClasses(string);
        return codeDataArray;
    }

    private CodeData getIfNewOrInstanceofStatment(PHPProjectModel pHPProjectModel, String string, String string2, int n, String string3) {
        if (PhpLexer.isPHPQuotesState((String)string3)) {
            return null;
        }
        if (string.equalsIgnoreCase("instanceof")) {
            return this.filterExact(this.getClassList(pHPProjectModel, string2, n, false), string2);
        }
        if (string.equalsIgnoreCase("new")) {
            return this.filterExact(this.getClassList(pHPProjectModel, string2, n, true), string2);
        }
        return null;
    }

    private CodeData getIfInArrayOption(PHPProjectModel pHPProjectModel, String string, boolean bl, String string2, String string3, int n, int n2, TextSequence textSequence) {
        boolean bl2 = false;
        if (n > 0 && !string3.startsWith("$")) {
            if (bl) {
                if (string3.length() == 0 && string2.length() == 0 && textSequence.charAt(n - 1) == '[') {
                    bl2 = true;
                }
            } else if (string2.length() == 0 && textSequence.charAt(n - 1) == '[') {
                bl2 = true;
            }
        }
        if (!bl2) {
            return null;
        }
        int n3 = n - 1;
        n = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n3 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n3), true);
        String string4 = textSequence.subSequence(n, n3).toString();
        if (string4.startsWith("$")) {
            string4 = string4.substring(1);
        }
        CodeData[] codeDataArray = pHPProjectModel.getArrayVariables(string, string4, string3, true);
        CodeData[] codeDataArray2 = pHPProjectModel.getFunction(string3);
        CodeData[] codeDataArray3 = ModelSupport.merge((CodeData[])codeDataArray2, (CodeData[])codeDataArray);
        PHPConstantData pHPConstantData = pHPProjectModel.getConstantData(string3, false);
        if (pHPConstantData != null) {
            codeDataArray3 = ModelSupport.merge((CodeData[])new CodeData[]{pHPConstantData}, (CodeData[])codeDataArray3);
        }
        return this.filterExact(codeDataArray3, string3);
    }

    private CodeData filterExact(CodeData[] codeDataArray, String string) {
        int n = ModelSupport.getFirstMatch((CodeData[])codeDataArray, (String)string, (boolean)true);
        if (n != -1) {
            return codeDataArray[n];
        }
        return null;
    }
}

