/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.preferences.ui;

import java.io.File;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.PHPUIMessages;
import org.eclipse.php.core.Logger;
import org.eclipse.php.core.util.FileUtils;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.php.ui.preferences.ui.LocaleConfigurationBlock;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class LocalePreferencePage
extends PropertyAndPreferencePage {
    public static final String PREF_ID = "org.eclipse.php.ui.preferences.LocalePreferencePage";
    public static final String DATA_SELECT_OPTION_KEY = "select_option_key";
    public static final String DATA_SELECT_OPTION_QUALIFIER = "select_option_qualifier";
    private LocaleConfigurationBlock fConfigurationBlock;

    public LocalePreferencePage() {
        this.setPreferenceStore(PHPUiPlugin.getDefault().getPreferenceStore());
        this.setTitle(PHPUIMessages.getString("LanguageSetting_preferences_title"));
    }

    public void createControl(Composite composite) {
        IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer = (IWorkbenchPreferenceContainer)this.getContainer();
        this.fConfigurationBlock = new LocaleConfigurationBlock(this.getNewStatusChangedListener(), this.getProject(), iWorkbenchPreferenceContainer);
        super.createControl(composite);
    }

    protected Control createPreferenceContent(Composite composite) {
        return this.fConfigurationBlock.createContents(composite);
    }

    protected boolean hasProjectSpecificOptions(IProject iProject) {
        return false;
    }

    protected String getPreferencePageID() {
        return PREF_ID;
    }

    protected String getPropertyPageID() {
        return null;
    }

    public void dispose() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.dispose();
        }
        super.dispose();
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.performDefaults();
        }
    }

    public boolean performOk() {
        String string;
        if (this.fConfigurationBlock != null && !this.fConfigurationBlock.performOk()) {
            return false;
        }
        if (this.fConfigurationBlock.hasChanges && this.addLocaleToConfigFile(string = this.fConfigurationBlock.getLocaleComboValue())) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)PHPUIMessages.getString("LanguageSetting_restartwindow_title"), (String)PHPUIMessages.getString("LanguageSetting_restartwindow_message"));
        }
        return super.performOk();
    }

    public void performApply() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.performApply();
        }
    }

    public void applyData(Object object) {
        super.applyData(object);
        if (object instanceof Map && this.fConfigurationBlock != null) {
            Map map = (Map)object;
            Object v = map.get(DATA_SELECT_OPTION_KEY);
            Object v2 = map.get(DATA_SELECT_OPTION_QUALIFIER);
            if (v instanceof String && v2 instanceof String) {
                this.fConfigurationBlock.selectOption((String)v, (String)v2);
            }
        }
    }

    public void setElement(IAdaptable iAdaptable) {
        super.setElement(iAdaptable);
        this.setDescription(null);
    }

    public String findConfigFile() {
        Object object;
        String string = Platform.getInstallLocation().getURL().getFile();
        File file = new File(string);
        String string2 = null;
        if (file.isDirectory()) {
            object = file.list();
            int n = 0;
            while (n < ((String[])object).length) {
                if (object[n].indexOf(".ini") != -1) {
                    string2 = object[n];
                    break;
                }
                ++n;
            }
        }
        object = null;
        if (string2 != null) {
            object = String.valueOf(string) + string2;
        }
        return object;
    }

    public boolean addLocaleToConfigFile(String string) {
        String string2 = this.findConfigFile();
        if (string2 == null) {
            Logger.log((int)4, (String)PHPUIMessages.getString("LanguageSetting_config_file_error"));
            return false;
        }
        File file = new File(string2);
        try {
            String string3 = FileUtils.getContents((File)file);
            if (string3.indexOf("-nl") != -1) {
                string3 = string3.replaceAll("-nl[\n\r]*.*##[\n\r]*", "");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("-nl");
            stringBuffer.append(System.getProperty("line.separator"));
            stringBuffer.append(string);
            stringBuffer.append("##");
            stringBuffer.append(System.getProperty("line.separator"));
            stringBuffer.append(string3);
            FileUtils.setContents((File)file, (String)stringBuffer.toString());
        }
        catch (Exception exception) {
            Logger.logException((String)PHPUIMessages.getString("LanguageSetting_change_locale_error"), (Throwable)exception);
            return false;
        }
        return true;
    }
}

