/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.phpIni;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.core.project.IIncludePathEntry;
import org.eclipse.php.core.project.options.PHPProjectOptions;
import org.ini4j.Ini;

public class IniModifier {
    static final String PARAM_INCLUDE_PATH = "include_path";
    static final String PATH_SEPARATOR = System.getProperty("os.name").toLowerCase().startsWith("windows") ? ";" : ":";
    static final String PHP_SECTION_NAME = "PHP";

    private static String getParameter(Ini ini, String string, String string2) {
        Ini.Section section = (Ini.Section)ini.get(string);
        if (section != null) {
            return (String)section.get(string2);
        }
        return null;
    }

    private static void setParameter(Ini ini, String string, String string2, String string3) {
        ((Ini.Section)ini.get(string)).put(string2, string3);
    }

    public static File addIncludePath(File file, IPath[] iPathArray) {
        File file2;
        block8: {
            if (iPathArray.length < 0) {
                return file;
            }
            file2 = IniModifier.createTempFile();
            if (file2 != null) break block8;
            return null;
        }
        try {
            StringBuffer stringBuffer;
            Ini ini = new Ini();
            ini.load(new FileInputStream(file), Ini.IGNORE_ESCAPE);
            String string = PHP_SECTION_NAME;
            String string2 = IniModifier.getParameter(ini, PHP_SECTION_NAME, PARAM_INCLUDE_PATH);
            if (string2 == null) {
                string = "_";
                string2 = IniModifier.getParameter(ini, "_", PARAM_INCLUDE_PATH);
            }
            if (string2 != null) {
                stringBuffer = new StringBuffer(string2.replaceAll("\"", ""));
                stringBuffer.append(PATH_SEPARATOR);
            } else {
                stringBuffer = new StringBuffer();
            }
            int n = 0;
            while (n < iPathArray.length) {
                stringBuffer.append(iPathArray[n].toOSString()).append(PATH_SEPARATOR);
                ++n;
            }
            stringBuffer.insert(0, "\"");
            stringBuffer.append("\"");
            IniModifier.setParameter(ini, string, PARAM_INCLUDE_PATH, stringBuffer.toString());
            ini.store(new FileOutputStream(file2), Ini.IGNORE_ESCAPE);
            return file2;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static File addIncludePath(File file, IProject iProject) {
        return IniModifier.addIncludePath(file, IniModifier.projectGetIncludePaths(iProject));
    }

    static File createTempFile() {
        try {
            File file = File.createTempFile("php.", ".ini");
            file.deleteOnExit();
            return file;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static File findPHPIni(String string) {
        IPath iPath = new Path(string).removeLastSegments(1).append("php.ini");
        File file = new File(iPath.toOSString());
        if (!file.canRead()) {
            return null;
        }
        return file;
    }

    static IPath[] projectGetIncludePaths(IProject iProject) {
        PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject(iProject);
        IIncludePathEntry[] iIncludePathEntryArray = pHPProjectOptions.readRawIncludePath();
        ArrayList<IPath> arrayList = new ArrayList<IPath>(iIncludePathEntryArray.length);
        int n = 0;
        while (n < iIncludePathEntryArray.length) {
            Object object;
            IPath iPath = iIncludePathEntryArray[n].getPath();
            if (iIncludePathEntryArray[n].getEntryKind() == 1) {
                if (iIncludePathEntryArray[n].getContentKind() != 2) {
                    arrayList.add(iPath);
                }
            } else if (iIncludePathEntryArray[n].getEntryKind() == 2) {
                object = iIncludePathEntryArray[n].getResource();
                if (object instanceof IProject) {
                    arrayList.add(object.getLocation());
                }
            } else if (iIncludePathEntryArray[n].getEntryKind() == 4) {
                object = iPath.toString();
                int n2 = ((String)object).indexOf(47);
                String string = "";
                if (n2 != -1) {
                    if (n2 + 1 < ((String)object).length()) {
                        string = ((String)object).substring(n2 + 1);
                    }
                    object = ((String)object).substring(0, n2);
                }
                IPath iPath2 = PHPProjectOptions.getIncludePathVariable((String)object);
                if ((string = (iPath2 = iPath2.append(string)).getFileExtension()) == null || !string.equalsIgnoreCase("zip")) {
                    arrayList.add(iPath2);
                }
            }
            ++n;
        }
        return arrayList.toArray(new IPath[arrayList.size()]);
    }
}

