/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.launching;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.core.phpIni.IniModifier;
import org.eclipse.php.debug.core.Logger;
import org.eclipse.php.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.eclipse.php.debug.core.debugger.PHPExecutableDebuggerInitializer;
import org.eclipse.php.debug.core.debugger.PHPSessionLaunchMapper;
import org.eclipse.php.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.debug.core.model.DebugSessionIdGenerator;
import org.eclipse.php.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.ui.dialogs.saveFiles.SaveFilesHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PHPExecutableLaunchDelegate
extends LaunchConfigurationDelegate {
    protected Map envVariables = null;

    public void debugPHPExecutable(ILaunch iLaunch, String string, String string2) throws DebugException {
        try {
            PHPExecutableDebuggerInitializer pHPExecutableDebuggerInitializer = new PHPExecutableDebuggerInitializer(iLaunch);
            pHPExecutableDebuggerInitializer.initializeDebug(new File(string).getAbsolutePath(), new File(string2).getAbsolutePath(), this.envVariables);
        }
        catch (IOException iOException) {
            Logger.logException("PHPDebugTarget: Debugger didn't find file to debug.", iOException);
            String string3 = PHPDebugCoreMessages.DebuggerFileNotFound_1;
            throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, string3, (Throwable)iOException));
        }
    }

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        File file;
        Object object;
        PHPLaunchUtilities.showDebugView();
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        String string2 = iLaunchConfiguration.getAttribute("ATTR_LOCATION", null);
        String string3 = iLaunchConfiguration.getAttribute("ATTR_WORKING_DIRECTORY", null);
        String string4 = iLaunchConfiguration.getAttribute("ATTR_FILE", null);
        boolean bl = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", true);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        if (string4 == null || string4.equals("")) {
            return;
        }
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(string4);
        IProject iProject = null;
        String string5 = null;
        if (string3 == null) {
            object = iWorkspaceRoot.findMember((IPath)path);
            if (object == null || !object.isAccessible()) {
                this.displayErrorMessage(NLS.bind((String)PHPDebugCoreMessages.Debugger_ResourceNotFound, (Object)path));
                return;
            }
            iProject = object.getProject();
            if (iProject == null) {
                this.displayErrorMessage(NLS.bind((String)PHPDebugCoreMessages.Debugger_InvalidDebugResource, (Object)path));
            }
            string5 = object.getLocation().toString();
        } else {
            try {
                object = new Path(string3);
                iProject = iWorkspaceRoot.getProject(object.lastSegment());
                string5 = path.makeAbsolute().toString();
            }
            catch (Exception exception) {}
        }
        if (iProject == null || !iProject.isAccessible()) {
            this.displayErrorMessage(NLS.bind((String)PHPDebugCoreMessages.Debugger_InvalidDebugResource, (Object)path));
        }
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 10);
        object = IniModifier.findPHPIni((String)string2);
        if (object != null && (file = IniModifier.addIncludePath((File)object, (IProject)iProject)) != null) {
            iLaunch.setAttribute("PHPIniLocation", file.getAbsolutePath());
        }
        if (string.equals("debug") || bl) {
            boolean bl2 = false;
            bl2 = iLaunchConfiguration.getAttribute("overrideFirstLineBreakpoint", false) ? iLaunchConfiguration.getAttribute("firstLineBreakpoint", false) : PHPProjectPreferences.getStopAtFirstLine(iProject);
            int n = PHPProjectPreferences.getDebugPort(iProject);
            String string6 = iProject.getFullPath().toString();
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)iLaunchConfiguration : iLaunchConfiguration.getWorkingCopy();
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.PHP_Project", string6);
            iLaunchConfigurationWorkingCopy.setAttribute("debugTransferEncoding", PHPProjectPreferences.getTransferEncoding(iProject));
            iLaunchConfigurationWorkingCopy.doSave();
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            int n2 = DebugSessionIdGenerator.generateSessionID();
            PHPSessionLaunchMapper.put(n2, iLaunch);
            iLaunch.setAttribute("port", Integer.toString(n));
            iLaunch.setAttribute("firstLineBreakpoint", Boolean.toString(bl2));
            iLaunch.setAttribute("debugSessionID", Integer.toString(n2));
            this.debugPHPExecutable(iLaunch, string2, string5);
        } else {
            file = new Path(string2);
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            IPath iPath = iProject.getRawLocation();
            if (iPath == null) {
                iPath = iProject.getLocation();
            }
            String string7 = iPath.toOSString();
            Path path2 = new Path(string7);
            path2.toFile();
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            Path path3 = new Path(string4);
            if (string4.startsWith("/")) {
                path3 = path3.removeFirstSegments(1);
            }
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            String[] stringArray = DebugPlugin.getDefault().getLaunchManager().getEnvironment(iLaunchConfiguration);
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            File file2 = new File(file.removeLastSegments(1).toString());
            String string8 = file2.getAbsolutePath();
            String string9 = iLaunch.getAttribute("PHPIniLocation");
            if (string9 != null && !string9.equals("")) {
                string8 = string9;
            }
            IResource iResource = iWorkspaceRoot.findMember((IPath)path);
            String string10 = null;
            string10 = iResource != null ? iResource.getLocation().toOSString() : path.toOSString();
            String[] stringArray2 = new String[]{file.toOSString(), "-c", string8, string10};
            Process process = DebugPlugin.exec((String[])stringArray2, (File)file2, (String[])stringArray);
            IProcess iProcess = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string11 = file.lastSegment();
            String string12 = file.getFileExtension();
            if (string12 != null) {
                string11 = string11.substring(0, string11.length() - (string12.length() + 1));
            }
            string11 = string11.toLowerCase();
            hashMap.put(IProcess.ATTR_PROCESS_TYPE, string11);
            if (process != null) {
                subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 80);
                subProgressMonitor.beginTask(MessageFormat.format("start launch", iLaunchConfiguration.getName()), -1);
                iProcess = DebugPlugin.newProcess((ILaunch)iLaunch, (Process)process, (String)file.toOSString(), hashMap);
                if (iProcess == null) {
                    process.destroy();
                    throw new CoreException((IStatus)new Status(4, PHPDebugPlugin.getID(), 0, null, null));
                }
                subProgressMonitor.done();
            }
            iProcess.setAttribute(IProcess.ATTR_CMDLINE, string4);
            if (!CommonTab.isLaunchInBackground((ILaunchConfiguration)iLaunchConfiguration)) {
                while (!iProcess.isTerminated()) {
                    try {
                        if (iProgressMonitor.isCanceled()) {
                            iProcess.terminate();
                            break;
                        }
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 10);
                RefreshTab.refreshResources((ILaunchConfiguration)iLaunchConfiguration, (IProgressMonitor)subProgressMonitor);
            }
        }
    }

    protected boolean saveFiles(IProject iProject, IProgressMonitor iProgressMonitor) {
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        boolean bl = preferences.getBoolean(PHPDebugCorePreferenceNames.AUTO_SAVE_DIRTY);
        SaveFilesHandler.SaveFilesResult saveFilesResult = SaveFilesHandler.handle((IProject)iProject, (boolean)bl, (boolean)true, (IProgressMonitor)iProgressMonitor);
        if (!saveFilesResult.isAccepted()) {
            return false;
        }
        if (saveFilesResult.isAutoSave() && !bl) {
            preferences.setValue(PHPDebugCorePreferenceNames.AUTO_SAVE_DIRTY, true);
            PHPDebugPlugin.getDefault().savePluginPreferences();
        }
        return true;
    }

    private void displayErrorMessage(final String string) {
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)display.getActiveShell(), (String)PHPDebugCoreMessages.Debugger_LaunchError_title, (String)string);
            }
        });
    }
}

