/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.JDTQuickMenuAction;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.ui.actions.FindExceptionOccurrencesAction;
import org.eclipse.jdt.ui.actions.FindImplementOccurrencesAction;
import org.eclipse.jdt.ui.actions.FindOccurrencesInFileAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;

public class OccurrencesSearchMenuAction
implements IWorkbenchWindowPulldownDelegate2 {
    private static Action NO_ACTION_AVAILABLE = new Action(SearchMessages.group_occurrences_quickMenu_noEntriesAvailable){

        public boolean isEnabled() {
            return false;
        }
    };
    private Menu fMenu;

    public Menu getMenu(Menu parent) {
        this.setMenu(new Menu(parent));
        this.fillMenu(this.fMenu);
        this.installMenuListener();
        return this.fMenu;
    }

    public Menu getMenu(Control parent) {
        this.setMenu(new Menu(parent));
        this.fillMenu(this.fMenu);
        this.installMenuListener();
        return this.fMenu;
    }

    public void dispose() {
        this.setMenu(null);
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        IEditorPart activeEditor = JavaPlugin.getActivePage().getActiveEditor();
        if (!(activeEditor instanceof JavaEditor)) {
            return;
        }
        JavaEditor editor = (JavaEditor)activeEditor;
        new JDTQuickMenuAction(editor, "org.eclipse.jdt.ui.edit.text.java.search.occurrences.in.file.quickMenu"){

            protected void fillMenu(IMenuManager menu) {
                OccurrencesSearchMenuAction.this.fillQuickMenu(menu);
            }
        }.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void fillQuickMenu(IMenuManager manager) {
        IAction[] actions = this.getActions(JavaPlugin.getActiveWorkbenchWindow());
        if (actions != null) {
            boolean hasAction = false;
            int i = 0;
            while (i < actions.length) {
                IAction action = actions[i];
                if (action.isEnabled()) {
                    hasAction = true;
                    manager.add(action);
                }
                ++i;
            }
            if (!hasAction) {
                manager.add((IAction)NO_ACTION_AVAILABLE);
            }
        } else {
            manager.add((IAction)NO_ACTION_AVAILABLE);
        }
    }

    private void fillMenu(Menu menu) {
        IAction[] actions = this.getActions(JavaPlugin.getActiveWorkbenchWindow());
        if (actions != null) {
            boolean hasAction = false;
            int i = 0;
            while (i < actions.length) {
                IAction action = actions[i];
                if (action.isEnabled()) {
                    hasAction = true;
                    ActionContributionItem item = new ActionContributionItem(action);
                    item.fill(menu, -1);
                }
                ++i;
            }
            if (!hasAction) {
                ActionContributionItem item = new ActionContributionItem((IAction)NO_ACTION_AVAILABLE);
                item.fill(menu, -1);
            }
        } else {
            ActionContributionItem item = new ActionContributionItem((IAction)NO_ACTION_AVAILABLE);
            item.fill(menu, -1);
        }
    }

    private IAction[] getActions(IWorkbenchWindow window) {
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null) {
            return null;
        }
        IWorkbenchPart activePart = activePage.getActivePart();
        if (activePart == null) {
            return null;
        }
        if (activePart instanceof JavaEditor) {
            return this.getActions((JavaEditor)activePart);
        }
        return this.getActions(activePart.getSite());
    }

    private IAction[] getActions(IWorkbenchPartSite site) {
        FindOccurrencesInFileAction findIdentifier = new FindOccurrencesInFileAction((IWorkbenchSite)site);
        FindExceptionOccurrencesAction findExceptions = new FindExceptionOccurrencesAction((IWorkbenchSite)site);
        FindImplementOccurrencesAction findImplement = new FindImplementOccurrencesAction((IWorkbenchSite)site);
        ISelectionProvider selectionProvider = site.getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        this.init(findIdentifier, selection);
        this.init(findExceptions, selection);
        this.init(findImplement, selection);
        return new IAction[]{findIdentifier, findExceptions, findImplement};
    }

    private IAction[] getActions(JavaEditor editor) {
        FindOccurrencesInFileAction findIdentifier = new FindOccurrencesInFileAction(editor);
        FindExceptionOccurrencesAction findExceptions = new FindExceptionOccurrencesAction(editor);
        FindImplementOccurrencesAction findImplement = new FindImplementOccurrencesAction(editor);
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        this.init(findIdentifier, selection);
        this.init(findExceptions, selection);
        this.init(findImplement, selection);
        editor.setAction("SearchOccurrencesInFile", (IAction)findIdentifier);
        editor.setAction("SearchExceptionOccurrences", (IAction)findExceptions);
        editor.setAction("SearchImplementOccurrences", (IAction)findImplement);
        return new IAction[]{findIdentifier, findExceptions, findImplement};
    }

    private void init(FindImplementOccurrencesAction findImplement, ISelection selection) {
        findImplement.update(selection);
        findImplement.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.implement.occurrences");
    }

    private void init(FindExceptionOccurrencesAction findExceptions, ISelection selection) {
        findExceptions.update(selection);
        findExceptions.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.exception.occurrences");
    }

    private void init(FindOccurrencesInFileAction findIdentifier, ISelection selection) {
        findIdentifier.update(selection);
        findIdentifier.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.occurrences.in.file");
        findIdentifier.setText(SearchMessages.Search_FindOccurrencesInFile_shortLabel);
    }

    private void setMenu(Menu menu) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = menu;
    }

    private void installMenuListener() {
        this.fMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                OccurrencesSearchMenuAction.this.fillMenu(m);
            }
        });
    }
}

