/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ModuleType;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.ModuleDelegate;

public class Module
implements IModule {
    protected String id;
    protected String name;
    protected ModuleFactory factory;
    protected String type;
    protected String version;
    protected IProject project;
    protected ModuleDelegate delegate;

    public Module(ModuleFactory factory, String id, String name, String type, String version, IProject project) {
        this.factory = factory;
        this.project = project;
        this.type = type;
        this.version = version;
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return String.valueOf(this.factory.getId()) + ":" + this.id;
    }

    public String getInternalId() {
        return this.id;
    }

    public IModuleType getModuleType() {
        return new ModuleType(this.type, this.version);
    }

    public IProject getProject() {
        return this.project;
    }

    public String getName() {
        return this.name;
    }

    public ModuleFactory getModuleFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModuleDelegate getDelegate(IProgressMonitor monitor) {
        if (this.delegate != null) {
            return this.delegate;
        }
        Module module = this;
        synchronized (module) {
            if (this.delegate == null) {
                try {
                    long time = System.currentTimeMillis();
                    this.delegate = this.factory.getDelegate(monitor).getModuleDelegate(this);
                    this.delegate.initialize(this);
                    Trace.trace(Trace.PERFORMANCE, "Module.getDelegate(): <" + (System.currentTimeMillis() - time) + " " + this.factory.getId());
                }
                catch (Throwable t) {
                    Trace.trace(Trace.SEVERE, "Could not create delegate " + this.toString(), t);
                }
            }
        }
        return this.delegate;
    }

    public IModule[] getChildModules(IProgressMonitor monitor) {
        try {
            return this.getDelegate(monitor).getChildModules();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate getChildModules() " + this.toString(), e);
            return null;
        }
    }

    public IStatus validate(IProgressMonitor monitor) {
        try {
            return this.getDelegate(monitor).validate();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate validate() " + this.toString(), e);
            return null;
        }
    }

    public Object getAdapter(Class adapter) {
        if (this.delegate != null && adapter.isInstance(this.delegate)) {
            return this.delegate;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public Object loadAdapter(Class adapter, IProgressMonitor monitor) {
        this.getDelegate(monitor);
        if (adapter.isInstance(this.delegate)) {
            return this.delegate;
        }
        return Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IModule)) {
            return false;
        }
        IModule m = (IModule)obj;
        return this.getId().equals(m.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "Module[" + this.name + "," + this.getId() + "]";
    }
}

