/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui;

import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.ui.util.PHPElementImageProvider;
import org.eclipse.php.ui.util.PHPElementLabels;
import org.eclipse.php.ui.util.StorageLabelProvider;
import org.eclipse.swt.graphics.Image;

public class PHPElementLabelProvider
extends LabelProvider {
    public static final int SHOW_RETURN_TYPE = 1;
    public static final int SHOW_PARAMETERS = 2;
    public static final int SHOW_OVERLAY_ICONS = 16;
    public static final int SHOW_TYPE = 32;
    public static final int SHOW_ROOT = 64;
    public static final int SHOW_SMALL_ICONS = 256;
    public static final int SHOW_VARIABLE = 512;
    public static final int SHOW_QUALIFIED = 1024;
    public static final int SHOW_POST_QUALIFIED = 2048;
    public static final int SHOW_BASICS = 0;
    public static final int SHOW_DEFAULT = new Integer(18);
    private PHPElementImageProvider fImageLabelProvider = new PHPElementImageProvider();
    private StorageLabelProvider fStorageLabelProvider = new StorageLabelProvider();
    private int fFlags;
    private int fImageFlags;
    private long fTextFlags;

    public PHPElementLabelProvider() {
        this(SHOW_DEFAULT);
    }

    public PHPElementLabelProvider(int n) {
        this.fFlags = n;
        this.updateImageProviderFlags();
        this.updateTextProviderFlags();
    }

    private boolean getFlag(int n) {
        return (this.fFlags & n) != 0;
    }

    public void turnOn(int n) {
        this.fFlags |= n;
        this.updateImageProviderFlags();
        this.updateTextProviderFlags();
    }

    public void turnOff(int n) {
        this.fFlags &= ~n;
        this.updateImageProviderFlags();
        this.updateTextProviderFlags();
    }

    private void updateImageProviderFlags() {
        this.fImageFlags = 0;
        if (this.getFlag(16)) {
            this.fImageFlags |= 1;
        }
        if (this.getFlag(256)) {
            this.fImageFlags |= 2;
        }
    }

    private void updateTextProviderFlags() {
        this.fTextFlags = 0x200000L;
        if (this.getFlag(1)) {
            this.fTextFlags |= 8L;
        }
        if (this.getFlag(2)) {
            this.fTextFlags |= 1L;
        }
        if (this.getFlag(64)) {
            this.fTextFlags |= 0x18829040L;
        }
        if (this.getFlag(2048)) {
            this.fTextFlags |= 0x10028000L;
        } else if (this.getFlag(1024)) {
            this.fTextFlags |= 0x8012000L;
        }
        if (this.getFlag(32)) {
            this.fTextFlags |= 0x200L;
        }
        if (this.getFlag(512)) {
            this.fTextFlags |= 0x1000000L;
        }
        if (this.getFlag(1024)) {
            this.fTextFlags |= 0x9012C20L;
        }
        if (this.getFlag(2048)) {
            this.fTextFlags |= 0x12029140L;
        }
    }

    public Image getImage(Object object) {
        Image image = this.fImageLabelProvider.getImageLabel(object, this.fImageFlags);
        if (image != null) {
            return image;
        }
        if (object instanceof IStorage) {
            return this.fStorageLabelProvider.getImage(object);
        }
        return image;
    }

    public String getText(Object object) {
        String string = PHPElementLabels.getTextLabel(object, this.fTextFlags);
        if (string.length() > 0) {
            return string;
        }
        if (object instanceof IStorage) {
            return this.fStorageLabelProvider.getText(object);
        }
        return string;
    }

    public void dispose() {
        this.fStorageLabelProvider.dispose();
        this.fImageLabelProvider.dispose();
    }
}

