/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.preferences.includepath;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.php.core.project.IIncludePathEntry;
import org.eclipse.php.core.project.options.PHPProjectOptions;
import org.eclipse.php.core.project.options.includepath.IncludePathEntry;
import org.eclipse.php.ui.preferences.includepath.IPListElementAttribute;
import org.eclipse.php.ui.preferences.includepath.ZipFileFilter;

public class IPListElement {
    private IProject fProject;
    private int fEntryKind;
    private int fContentKind;
    private IPath fPath;
    private IResource fResource;
    private boolean fIsExported;
    private boolean fIsMissing;
    private Object fParentContainer;
    private IIncludePathEntry fCachedEntry;
    private ArrayList fChildren;

    public IPListElement(IProject iProject, int n, int n2, IPath iPath, IResource iResource) {
        this(null, iProject, n, n2, iPath, iResource);
    }

    public IPListElement(Object object, IProject iProject, int n, int n2, IPath iPath, IResource iResource) {
        this.fProject = iProject;
        this.fEntryKind = n;
        this.fContentKind = n2;
        this.fPath = iPath;
        this.fChildren = new ArrayList();
        this.fResource = iResource;
        this.fIsExported = false;
        this.fIsMissing = false;
        this.fCachedEntry = null;
        this.fParentContainer = object;
        switch (n) {
            case 3: {
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                throw new RuntimeException("implement me");
            }
        }
    }

    public IIncludePathEntry getIncludePathEntry() {
        if (this.fCachedEntry == null) {
            this.fCachedEntry = this.newIncludePathEntry();
        }
        return this.fCachedEntry;
    }

    private IIncludePathEntry newIncludePathEntry() {
        switch (this.fEntryKind) {
            case 3: {
                return IncludePathEntry.newSourceEntry((IPath)this.fPath, (IResource)this.fResource);
            }
            case 1: {
                return new IncludePathEntry(this.fContentKind, 1, this.fPath, this.fResource, this.isExported());
            }
            case 2: {
                return IncludePathEntry.newProjectEntry((IPath)this.fPath, (IResource)this.fResource, (boolean)this.isExported());
            }
            case 5: {
                return IncludePathEntry.newContainerEntry((IPath)this.fPath, (IResource)this.fResource, (boolean)this.isExported());
            }
            case 4: {
                return IncludePathEntry.newVariableEntry((IPath)this.fPath, (IResource)this.fResource, (boolean)this.isExported());
            }
        }
        return null;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public int getEntryKind() {
        return this.fEntryKind;
    }

    public int getContentKind() {
        return this.fContentKind;
    }

    public IResource getResource() {
        return this.fResource;
    }

    public IPListElementAttribute setAttribute(String string, Object object) {
        IPListElementAttribute iPListElementAttribute = this.findAttributeElement(string);
        if (iPListElementAttribute == null) {
            return null;
        }
        iPListElementAttribute.setValue(object);
        this.attributeChanged(string);
        return iPListElementAttribute;
    }

    public IPListElementAttribute findAttributeElement(String string) {
        int n = 0;
        while (n < this.fChildren.size()) {
            IPListElementAttribute iPListElementAttribute;
            Object e = this.fChildren.get(n);
            if (e instanceof IPListElementAttribute && string.equals((iPListElementAttribute = (IPListElementAttribute)e).getKey())) {
                return iPListElementAttribute;
            }
            ++n;
        }
        return null;
    }

    public Object getAttribute(String string) {
        IPListElementAttribute iPListElementAttribute = this.findAttributeElement(string);
        if (iPListElementAttribute != null) {
            return iPListElementAttribute.getValue();
        }
        return null;
    }

    private void createAttributeElement(String string, Object object, boolean bl) {
        this.fChildren.add(new IPListElementAttribute(this, string, object, bl));
    }

    private static boolean isFiltered(Object object, String[] stringArray) {
        if (object instanceof IPListElementAttribute) {
            String string = ((IPListElementAttribute)object).getKey();
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private Object[] getFilteredChildren(String[] stringArray) {
        int n = this.fChildren.size();
        ArrayList arrayList = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            Object e = this.fChildren.get(n2);
            if (!IPListElement.isFiltered(e, stringArray)) {
                arrayList.add(e);
            }
            ++n2;
        }
        return arrayList.toArray();
    }

    public Object[] getChildren(boolean bl) {
        if (bl && this.fEntryKind == 3) {
            return this.getFilteredChildren(new String[0]);
        }
        if (this.fEntryKind == 2) {
            return this.getFilteredChildren(new String[0]);
        }
        return this.fChildren.toArray();
    }

    public Object getParentContainer() {
        return this.fParentContainer;
    }

    private void attributeChanged(String string) {
        this.fCachedEntry = null;
    }

    private boolean canUpdateContainer() {
        throw new RuntimeException("implement me");
    }

    public boolean isInNonModifiableContainer() {
        if (this.fParentContainer instanceof IPListElement) {
            return !((IPListElement)this.fParentContainer).canUpdateContainer();
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            IPListElement iPListElement = (IPListElement)object;
            return this.getIncludePathEntry().equals(iPListElement.getIncludePathEntry());
        }
        return false;
    }

    public int hashCode() {
        return this.fPath.hashCode() + this.fEntryKind + this.fContentKind;
    }

    public String toString() {
        return this.getIncludePathEntry().toString();
    }

    public boolean isMissing() {
        return this.fIsMissing;
    }

    public void setIsMissing(boolean bl) {
        this.fIsMissing = bl;
    }

    public boolean isExported() {
        return this.fIsExported;
    }

    public void setExported(boolean bl) {
        if (bl != this.fIsExported) {
            this.fIsExported = bl;
            this.attributeChanged(null);
        }
    }

    public IProject getProject() {
        return this.fProject;
    }

    public static IPListElement createFromExisting(IIncludePathEntry iIncludePathEntry, IProject iProject) {
        return IPListElement.createFromExisting(null, iIncludePathEntry, iProject);
    }

    public static IPListElement createFromExisting(Object object, IIncludePathEntry iIncludePathEntry, IProject iProject) {
        Object object2;
        IPath iPath = iIncludePathEntry.getPath();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource iResource = null;
        boolean bl = false;
        switch (iIncludePathEntry.getEntryKind()) {
            case 5: {
                iResource = null;
                bl = iProject != null && PHPProjectOptions.getIncludePathContainer((IPath)iPath, (IProject)iProject) == null;
                break;
            }
            case 4: {
                object2 = PHPProjectOptions.getResolvedVariablePath((IPath)iPath);
                iResource = null;
                bl = iWorkspaceRoot.findMember((IPath)object2) == null && !object2.toFile().isFile();
                break;
            }
            case 1: {
                iResource = iWorkspaceRoot.findMember(iPath);
                if (iResource != null) break;
                if (!ZipFileFilter.isZipPath(iPath) && iWorkspaceRoot.getWorkspace().validatePath(iPath.toString(), 2).isOK() && iWorkspaceRoot.getProject(iPath.segment(0)).exists()) {
                    iResource = iWorkspaceRoot.getFolder(iPath);
                }
                bl = !iPath.toFile().exists();
                break;
            }
            case 3: {
                iPath = iPath.removeTrailingSeparator();
                iResource = iWorkspaceRoot.findMember(iPath);
                if (iResource != null) break;
                if (iWorkspaceRoot.getWorkspace().validatePath(iPath.toString(), 2).isOK()) {
                    iResource = iWorkspaceRoot.getFolder(iPath);
                }
                bl = true;
                break;
            }
            case 2: {
                iResource = iWorkspaceRoot.findMember(iPath);
                bl = iResource == null;
            }
        }
        object2 = new IPListElement(object, iProject, iIncludePathEntry.getEntryKind(), iIncludePathEntry.getContentKind(), iPath, iResource);
        ((IPListElement)object2).setExported(iIncludePathEntry.isExported());
        if (iProject != null && iProject.exists()) {
            ((IPListElement)object2).setIsMissing(bl);
        }
        return object2;
    }

    public static StringBuffer appendEncodePath(IPath iPath, StringBuffer stringBuffer) {
        if (iPath != null) {
            String string = iPath.toString();
            stringBuffer.append('[').append(string.length()).append(']').append(string);
        } else {
            stringBuffer.append('[').append(']');
        }
        return stringBuffer;
    }

    public static StringBuffer appendEncodedString(String string, StringBuffer stringBuffer) {
        if (string != null) {
            stringBuffer.append('[').append(string.length()).append(']').append(string);
        } else {
            stringBuffer.append('[').append(']');
        }
        return stringBuffer;
    }

    public static StringBuffer appendEncodedFilter(IPath[] iPathArray, StringBuffer stringBuffer) {
        if (iPathArray != null) {
            stringBuffer.append('[').append(iPathArray.length).append(']');
            int n = 0;
            while (n < iPathArray.length) {
                IPListElement.appendEncodePath(iPathArray[n], stringBuffer).append(';');
                ++n;
            }
        } else {
            stringBuffer.append('[').append(']');
        }
        return stringBuffer;
    }

    public StringBuffer appendEncodedSettings(StringBuffer stringBuffer) {
        stringBuffer.append(this.fEntryKind).append(';');
        stringBuffer.append(this.fContentKind).append(';');
        IPListElement.appendEncodePath(this.fPath, stringBuffer).append(';');
        stringBuffer.append((Object)this.fIsExported).append(';');
        int n = 0;
        while (n < this.fChildren.size()) {
            Object e = this.fChildren.get(n);
            if (e instanceof IPListElementAttribute) {
                IPListElementAttribute iPListElementAttribute = (IPListElementAttribute)e;
                if (iPListElementAttribute.isBuiltIn()) {
                    iPListElementAttribute.getKey();
                } else {
                    IPListElement.appendEncodedString((String)iPListElementAttribute.getValue(), stringBuffer);
                }
            }
            ++n;
        }
        return stringBuffer;
    }
}

