/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.preferences.ui;

import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.core.phpModel.phpElementData.PHPModifier;
import org.eclipse.php.ui.preferences.PreferenceConstants;

public class MembersOrderPreferenceCache
implements IPropertyChangeListener {
    public static final int INCLUDEFILES_INDEX = 0;
    public static final int CONSTANTS_INDEX = 1;
    public static final int STATIC_VARS_INDEX = 2;
    public static final int CONSTRUCTORS_INDEX = 3;
    public static final int STATIC_FUNCTIONS_INDEX = 4;
    public static final int FUNCTIONS_INDEX = 5;
    public static final int CLASS_INDEX = 6;
    public static final int VARS_INDEX = 7;
    public static final int N_CATEGORIES = 8;
    private static final int PUBLIC_INDEX = 0;
    private static final int DEFAULT_INDEX = 1;
    private static final int PROTECTED_INDEX = 2;
    private static final int PRIVATE_INDEX = 3;
    private static final int N_VISIBILITIES = 4;
    private int[] fCategoryOffsets = null;
    private boolean fSortByVisibility = PreferenceConstants.getPreferenceStore().getBoolean("enableVisibilityOrder");
    private int[] fVisibilityOffsets = null;

    public static boolean isMemberOrderProperty(String string) {
        return "outlinesortoption".equals(string) || "org.eclipse.php.ui.visibility.order".equals(string) || "enableVisibilityOrder".equals(string);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if ("outlinesortoption".equals(string)) {
            this.fCategoryOffsets = null;
        } else if ("org.eclipse.php.ui.visibility.order".equals(string)) {
            this.fVisibilityOffsets = null;
        } else if ("enableVisibilityOrder".equals(string)) {
            this.fSortByVisibility = PreferenceConstants.getPreferenceStore().getBoolean("enableVisibilityOrder");
        }
    }

    public int getCategoryIndex(int n) {
        if (this.fCategoryOffsets == null) {
            this.fCategoryOffsets = this.getCategoryOffsets();
        }
        return this.fCategoryOffsets[n];
    }

    private int[] getCategoryOffsets() {
        String string;
        int[] nArray = new int[8];
        IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
        boolean bl = this.fillCategoryOffsetsFromPreferenceString(iPreferenceStore.getString(string = "outlinesortoption"), nArray);
        if (!bl) {
            iPreferenceStore.setToDefault(string);
            this.fillCategoryOffsetsFromPreferenceString(iPreferenceStore.getDefaultString(string), nArray);
        }
        return nArray;
    }

    private boolean fillCategoryOffsetsFromPreferenceString(String string, int[] nArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if ("T".equals(string2)) {
                nArray[6] = n++;
                continue;
            }
            if ("F".equals(string2)) {
                nArray[5] = n++;
                continue;
            }
            if ("V".equals(string2)) {
                nArray[7] = n++;
                continue;
            }
            if ("SV".equals(string2)) {
                nArray[2] = n++;
                continue;
            }
            if ("SF".equals(string2)) {
                nArray[4] = n++;
                continue;
            }
            if (!"C".equals(string2)) continue;
            nArray[3] = n++;
        }
        return n == 8;
    }

    public boolean isSortByVisibility() {
        return this.fSortByVisibility;
    }

    public int getVisibilityIndex(int n) {
        if (this.fVisibilityOffsets == null) {
            this.fVisibilityOffsets = this.getVisibilityOffsets();
        }
        int n2 = 1;
        if (PHPModifier.isPublic((int)n)) {
            n2 = 0;
        } else if (PHPModifier.isProtected((int)n)) {
            n2 = 2;
        } else if (PHPModifier.isPrivate((int)n)) {
            n2 = 3;
        }
        return this.fVisibilityOffsets[n2];
    }

    private int[] getVisibilityOffsets() {
        String string;
        int[] nArray = new int[4];
        IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
        boolean bl = this.fillVisibilityOffsetsFromPreferenceString(iPreferenceStore.getString(string = "org.eclipse.php.ui.visibility.order"), nArray);
        if (!bl) {
            iPreferenceStore.setToDefault(string);
            this.fillVisibilityOffsetsFromPreferenceString(iPreferenceStore.getDefaultString(string), nArray);
        }
        return nArray;
    }

    private boolean fillVisibilityOffsetsFromPreferenceString(String string, int[] nArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if ("B".equals(string2)) {
                nArray[0] = n++;
                continue;
            }
            if ("V".equals(string2)) {
                nArray[3] = n++;
                continue;
            }
            if ("R".equals(string2)) {
                nArray[2] = n++;
                continue;
            }
            if (!"D".equals(string2)) continue;
            nArray[1] = n++;
        }
        return n == 4;
    }
}

