/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.util;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.custom.BusyIndicator;

public class BusyIndicatorRunnableContext
implements IRunnableContext {
    public void run(boolean bl, boolean bl2, IRunnableWithProgress iRunnableWithProgress) throws InvocationTargetException, InterruptedException {
        BusyRunnable busyRunnable = new BusyRunnable(bl, iRunnableWithProgress);
        BusyIndicator.showWhile(null, (Runnable)busyRunnable);
        Throwable throwable = busyRunnable.fThrowable;
        if (throwable instanceof InvocationTargetException) {
            throw (InvocationTargetException)throwable;
        }
        if (throwable instanceof InterruptedException) {
            throw (InterruptedException)throwable;
        }
    }

    private static class BusyRunnable
    implements Runnable {
        public Throwable fThrowable;
        private boolean fFork;
        private IRunnableWithProgress fRunnable;

        public BusyRunnable(boolean bl, IRunnableWithProgress iRunnableWithProgress) {
            this.fFork = bl;
            this.fRunnable = iRunnableWithProgress;
        }

        public void run() {
            try {
                this.internalRun(this.fFork, this.fRunnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.fThrowable = invocationTargetException;
            }
            catch (InterruptedException interruptedException) {
                this.fThrowable = interruptedException;
            }
        }

        private void internalRun(boolean bl, IRunnableWithProgress iRunnableWithProgress) throws InvocationTargetException, InterruptedException {
            Thread thread = Thread.currentThread();
            if (thread instanceof ThreadContext || ModalContext.isModalContextThread((Thread)thread)) {
                bl = false;
            }
            if (bl) {
                ThreadContext threadContext = new ThreadContext(iRunnableWithProgress);
                threadContext.start();
                threadContext.sync();
                Throwable throwable = threadContext.fThrowable;
                if (throwable != null) {
                    if (throwable instanceof InvocationTargetException) {
                        throw (InvocationTargetException)throwable;
                    }
                    if (throwable instanceof InterruptedException) {
                        throw (InterruptedException)throwable;
                    }
                    if (throwable instanceof OperationCanceledException) {
                        throw new InterruptedException();
                    }
                    throw new InvocationTargetException(throwable);
                }
            } else {
                try {
                    iRunnableWithProgress.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (OperationCanceledException operationCanceledException) {
                    throw new InterruptedException();
                }
            }
        }

        private static class ThreadContext
        extends Thread {
            IRunnableWithProgress fRunnable;
            Throwable fThrowable;

            public ThreadContext(IRunnableWithProgress iRunnableWithProgress) {
                this(iRunnableWithProgress, "BusyCursorRunnableContext-Thread");
            }

            protected ThreadContext(IRunnableWithProgress iRunnableWithProgress, String string) {
                super(string);
                this.fRunnable = iRunnableWithProgress;
            }

            public void run() {
                try {
                    this.fRunnable.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.fThrowable = invocationTargetException;
                }
                catch (InterruptedException interruptedException) {
                    this.fThrowable = interruptedException;
                }
                catch (ThreadDeath threadDeath) {
                    this.fThrowable = threadDeath;
                    throw threadDeath;
                }
                catch (RuntimeException runtimeException) {
                    this.fThrowable = runtimeException;
                }
                catch (Error error) {
                    this.fThrowable = error;
                }
            }

            void sync() {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

