/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;

class ExcludingDecoratingLabelProvider
extends DecoratingLabelProvider {
    private String fExcludedDecoratorId;

    public ExcludingDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator, String excludedDecoratorId) {
        super(provider, decorator);
        this.fExcludedDecoratorId = excludedDecoratorId;
    }

    public Image getImage(Object element) {
        IDecoratorManager decoratorMgr = PlatformUI.getWorkbench().getDecoratorManager();
        boolean isDecoratorEnabled = decoratorMgr.getEnabled(this.fExcludedDecoratorId);
        if (isDecoratorEnabled) {
            try {
                decoratorMgr.setEnabled(this.fExcludedDecoratorId, false);
            }
            catch (CoreException coreException) {}
        }
        Image image = super.getImage(element);
        if (isDecoratorEnabled) {
            try {
                decoratorMgr.setEnabled(this.fExcludedDecoratorId, true);
            }
            catch (CoreException coreException) {}
        }
        return image;
    }

    public String getText(Object element) {
        IDecoratorManager decoratorMgr = PlatformUI.getWorkbench().getDecoratorManager();
        boolean isDecoratorEnabled = decoratorMgr.getEnabled(this.fExcludedDecoratorId);
        if (isDecoratorEnabled) {
            try {
                decoratorMgr.setEnabled(this.fExcludedDecoratorId, false);
            }
            catch (CoreException coreException) {}
        }
        String text = super.getText(element);
        if (isDecoratorEnabled) {
            try {
                decoratorMgr.setEnabled(this.fExcludedDecoratorId, true);
            }
            catch (CoreException coreException) {}
        }
        return text;
    }
}

