/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.CodeStyleFix;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.dialogs.IDialogSettings;

public class CodeStyleCleanUp
extends AbstractCleanUp {
    public static final int QUALIFY_FIELD_ACCESS = 1;
    public static final int CHANGE_NON_STATIC_ACCESS_TO_STATIC = 2;
    public static final int QUALIFY_STATIC_FIELD_ACCESS = 4;
    public static final int CHANGE_INDIRECT_STATIC_ACCESS_TO_DIRECT = 8;
    public static final int QUALIFY_METHOD_ACCESS = 16;
    public static final int QUALIFY_STATIC_METHOD_ACCESS = 32;
    public static final int REMOVE_THIS_FIELD_QUALIFIER = 64;
    public static final int REMOVE_THIS_METHOD_QUALIFIER = 128;
    private static final int DEFAULT_FLAG = 10;
    private static final String SECTION_NAME = "CleanUp_CodeStyle";

    public CodeStyleCleanUp(int flag) {
        super(flag);
    }

    public CodeStyleCleanUp(IDialogSettings settings) {
        super(CodeStyleCleanUp.getSection(settings, SECTION_NAME), 10);
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return CodeStyleFix.createCleanUp(compilationUnit, this.isFlag(1), this.isFlag(2), this.isFlag(4), this.isFlag(8), this.isFlag(16), this.isFlag(32), this.isFlag(64), this.isFlag(128));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return CodeStyleFix.createCleanUp(compilationUnit, problems, this.isFlag(1), this.isFlag(2), this.isFlag(8));
    }

    public Map getRequiredOptions() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        if (this.isFlag(2)) {
            options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "warning");
        }
        if (this.isFlag(8)) {
            options.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", "warning");
        }
        return options;
    }

    public void saveSettings(IDialogSettings settings) {
        super.saveSettings(CodeStyleCleanUp.getSection(settings, SECTION_NAME));
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isFlag(1)) {
            result.add(MultiFixMessages.CodeStyleMultiFix_AddThisQualifier_description);
        }
        if (this.isFlag(4)) {
            result.add(MultiFixMessages.CodeStyleMultiFix_QualifyAccessToStaticField);
        }
        if (this.isFlag(2)) {
            result.add(MultiFixMessages.CodeStyleMultiFix_ChangeNonStaticAccess_description);
        }
        if (this.isFlag(8)) {
            result.add(MultiFixMessages.CodeStyleMultiFix_ChangeIndirectAccessToStaticToDirect);
        }
        if (this.isFlag(16)) {
            result.add(MultiFixMessages.CodeStyleCleanUp_QualifyNonStaticMethod_description);
        }
        if (this.isFlag(32)) {
            result.add(MultiFixMessages.CodeStyleCleanUp_QualifyStaticMethod_description);
        }
        if (this.isFlag(64)) {
            result.add(MultiFixMessages.CodeStyleCleanUp_removeFieldThis_description);
        }
        if (this.isFlag(128)) {
            result.add(MultiFixMessages.CodeStyleCleanUp_removeMethodThis_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        buf.append("private int value;\n");
        buf.append("public int get() {\n");
        if (this.isFlag(1)) {
            buf.append("    return this.value + this.value;\n");
        } else if (this.isFlag(64)) {
            buf.append("    return value + value;\n");
        } else {
            buf.append("    return this.value + value;\n");
        }
        buf.append("}\n");
        buf.append("\n");
        buf.append("public int getZero() {\n");
        if (this.isFlag(16)) {
            buf.append("    return this.get() - this.get();\n");
        } else if (this.isFlag(128)) {
            buf.append("    return get() - get();\n");
        } else {
            buf.append("    return this.get() - get();\n");
        }
        buf.append("}\n");
        buf.append("\n");
        buf.append("class E {\n");
        buf.append("    public static int NUMBER;\n");
        buf.append("    public static void set(int i) {\n");
        if (this.isFlag(4)) {
            buf.append("        E.NUMBER= i;\n");
        } else {
            buf.append("        NUMBER= i;\n");
        }
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    public void reset() {\n");
        if (this.isFlag(32)) {
            buf.append("        E.set(0);\n");
        } else {
            buf.append("        set(0);\n");
        }
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("\n");
        buf.append("class ESub extends E {\n");
        buf.append("    public void reset() {\n");
        if (this.isFlag(8)) {
            buf.append("        E.NUMBER= 0;\n");
        } else {
            buf.append("        ESub.NUMBER= 0;\n");
        }
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("\n");
        buf.append("public void dec() {\n");
        if (this.isFlag(2)) {
            buf.append("    E.NUMBER--;\n");
        } else {
            buf.append("    (new E()).NUMBER--;\n");
        }
        buf.append("}\n");
        return buf.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        CodeStyleFix[] fixes;
        CodeStyleFix fix;
        if (this.isFlag(1) && (fix = CodeStyleFix.createAddFieldQualifierFix(compilationUnit, problem)) != null) {
            return true;
        }
        if (this.isFlag(8) && (fix = CodeStyleFix.createIndirectAccessToStaticFix(compilationUnit, problem)) != null) {
            return true;
        }
        return this.isFlag(2) && (fixes = CodeStyleFix.createNonStaticAccessFixes(compilationUnit, problem)) != null && fixes.length > 0;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        int id;
        int i;
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isFlag(1)) {
            result += this.getNumberOfProblems(problems, 570425423);
        }
        if (this.isFlag(8)) {
            i = 0;
            while (i < problems.length) {
                id = problems[i].getID();
                if (id == 570425422 || id == 603979895) {
                    ++result;
                }
                ++i;
            }
        }
        if (this.isFlag(2)) {
            i = 0;
            while (i < problems.length) {
                id = problems[i].getID();
                if (id == 570425420 || id == 603979893) {
                    ++result;
                }
                ++i;
            }
        }
        return result;
    }

    public int getDefaultFlag() {
        return 10;
    }
}

