/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.debugger.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.php.debug.core.communication.CommunicationUtilities;
import org.eclipse.php.debug.core.debugger.messages.DebugMessageRequestImpl;
import org.eclipse.php.debug.core.debugger.messages.IDebugRequestMessage;

public class AssignValueRequest
extends DebugMessageRequestImpl
implements IDebugRequestMessage {
    private String var;
    private String value;
    private int depth;
    private String[] path;

    public void setVar(String string) {
        this.var = string;
    }

    public String getVar() {
        return this.var;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setPath(String[] stringArray) {
        if (stringArray == null) {
            this.path = new String[0];
            return;
        }
        this.path = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.path, 0, stringArray.length);
    }

    public String[] getPath() {
        return this.path;
    }

    public void deserialize(DataInputStream dataInputStream) throws IOException {
        this.setID(dataInputStream.readInt());
        this.setVar(CommunicationUtilities.readEncodedString(dataInputStream, this.getTransferEncoding()));
        this.setValue(CommunicationUtilities.readEncodedString(dataInputStream, this.getTransferEncoding()));
        this.setDepth(dataInputStream.readInt());
        int n = dataInputStream.readInt();
        if (n > 0) {
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = CommunicationUtilities.readString(dataInputStream);
                ++n2;
            }
            this.setPath(stringArray);
        }
    }

    public int getType() {
        return 33;
    }

    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.getType());
        dataOutputStream.writeInt(this.getID());
        CommunicationUtilities.writeEncodedString(dataOutputStream, this.getVar(), this.getTransferEncoding());
        CommunicationUtilities.writeEncodedString(dataOutputStream, this.getValue(), this.getTransferEncoding());
        dataOutputStream.writeInt(this.getDepth());
        String[] stringArray = this.getPath();
        dataOutputStream.writeInt(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            CommunicationUtilities.writeString(dataOutputStream, stringArray[n]);
            ++n;
        }
    }
}

