/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PatternConstructor {
    private PatternConstructor() {
    }

    public static Pattern createPattern(String pattern, boolean isCaseSensitive, boolean isRegex) throws PatternSyntaxException {
        return PatternConstructor.createPattern(pattern, isRegex, true, isCaseSensitive, false);
    }

    public static Pattern createPattern(String pattern, boolean isRegex, boolean isStringMatcher, boolean isCaseSensitive, boolean isWholeWord) throws PatternSyntaxException {
        if (isRegex) {
            if (isWholeWord) {
                StringBuffer buffer = new StringBuffer(pattern.length() + 10);
                buffer.append("\\b(?:").append(pattern).append(")\\b");
                pattern = buffer.toString();
            }
        } else {
            int len = pattern.length();
            StringBuffer buffer = new StringBuffer(len + 10);
            if (isWholeWord && len > 0 && PatternConstructor.isWordChar(pattern.charAt(0))) {
                buffer.append("\\b");
            }
            PatternConstructor.appendAsRegEx(isStringMatcher, pattern, buffer);
            if (isWholeWord && len > 0 && PatternConstructor.isWordChar(pattern.charAt(len - 1))) {
                buffer.append("\\b");
            }
            pattern = buffer.toString();
        }
        int regexOptions = 8;
        if (!isCaseSensitive) {
            regexOptions |= 0x42;
        }
        return Pattern.compile(pattern, regexOptions);
    }

    private static boolean isWordChar(char c) {
        return Character.isLetterOrDigit(c);
    }

    public static Pattern createPattern(String[] patterns, boolean isCaseSensitive) throws PatternSyntaxException {
        StringBuffer pattern = new StringBuffer();
        int i = 0;
        while (i < patterns.length) {
            if (i > 0) {
                pattern.append('|');
            }
            PatternConstructor.appendAsRegEx(true, patterns[i], pattern);
            ++i;
        }
        return PatternConstructor.createPattern(pattern.toString(), true, true, isCaseSensitive, false);
    }

    public static StringBuffer appendAsRegEx(boolean isStringMatcher, String pattern, StringBuffer buffer) {
        boolean isEscaped = false;
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            switch (c) {
                case '\\': {
                    if (isStringMatcher && !isEscaped) {
                        isEscaped = true;
                        break;
                    }
                    buffer.append("\\\\");
                    isEscaped = false;
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    if (isEscaped) {
                        buffer.append("\\\\");
                        isEscaped = false;
                    }
                    buffer.append('\\');
                    buffer.append(c);
                    break;
                }
                case '?': {
                    if (isStringMatcher && !isEscaped) {
                        buffer.append('.');
                        break;
                    }
                    buffer.append('\\');
                    buffer.append(c);
                    isEscaped = false;
                    break;
                }
                case '*': {
                    if (isStringMatcher && !isEscaped) {
                        buffer.append(".*");
                        break;
                    }
                    buffer.append('\\');
                    buffer.append(c);
                    isEscaped = false;
                    break;
                }
                default: {
                    if (isEscaped) {
                        buffer.append("\\\\");
                        isEscaped = false;
                    }
                    buffer.append(c);
                }
            }
            ++i;
        }
        if (isEscaped) {
            buffer.append("\\\\");
            isEscaped = false;
        }
        return buffer;
    }
}

