/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.outline;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.core.documentModel.PHPEditorModel;
import org.eclipse.php.core.documentModel.dom.PHPElementImpl;
import org.eclipse.php.core.phpModel.parser.ModelListener;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.core.phpModel.phpElementData.UserData;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.StandardPHPElementContentProvider;
import org.eclipse.php.ui.treecontent.PHPTreeNode;
import org.eclipse.php.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeContentProvider;

public class PHPOutlineContentProvider
extends JFaceNodeContentProvider
implements ModelListener {
    private static final Image CLASSES_GROUP_IMAGE = PHPPluginImages.DESC_OBJ_PHP_CLASSES_GROUP.createImage();
    private static final Image CONSTANTS_GROUP_IMAGE = PHPPluginImages.DESC_OBJ_PHP_CONSTANTS_GROUP.createImage();
    private static final Image FUNCTIONS_GROUP_IMAGE = PHPPluginImages.DESC_OBJ_PHP_FUNCTIONS_GROUP.createImage();
    public static final int GROUP_CLASSES = 1;
    public static final int GROUP_CONSTANTS = 2;
    public static final int GROUP_FUNCTIONS = 3;
    public static final int GROUP_INCLUDES = 4;
    private static final Image INCLUDES_GROUP_IMAGE = PHPPluginImages.DESC_OBJS_INCLUDE.createImage();
    public static final int MODE_HTML = 2;
    public static final int MODE_MIXED = 3;
    public static final int MODE_PHP = 1;
    private ISelectionListener fSelectionListener = null;
    PHPEditorModel editorModel;
    GroupNode[] groupNodes;
    int mode;
    StandardPHPElementContentProvider phpContentProvider = new StandardPHPElementContentProvider(true);
    boolean showGroups;
    TreeViewer viewer;
    GroupNode includes = null;
    static /* synthetic */ Class class$0;

    public PHPOutlineContentProvider() {
        PHPWorkspaceModelManager.getInstance().addModelListener((ModelListener)this);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        super.inputChanged(viewer, object, object2);
        if (object == null && object2 != null) {
            PHPWorkspaceModelManager.getInstance().addModelListener((ModelListener)this);
            this.postRefresh(object2, true);
        } else if (object != null && object2 == null) {
            PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
            this.postRefresh(true);
        }
    }

    public void dispose() {
        PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
        PHPUiPlugin.getActiveWorkbenchWindow().getSelectionService().removePostSelectionListener(this.getSelectionServiceListener());
        super.dispose();
    }

    public void dataCleared() {
    }

    public void fileDataAdded(PHPFileData pHPFileData) {
        if (this.editorModel != null && this.editorModel.getFileData() != null && this.editorModel.getFileData().getComparableName().equals(pHPFileData.getComparableName())) {
            this.postRefresh(true);
        }
    }

    public void fileDataChanged(PHPFileData pHPFileData) {
        if (this.editorModel != null && this.editorModel.getFileData() != null && this.editorModel.getFileData().getComparableName().equals(pHPFileData.getComparableName())) {
            if (this.groupNodes == null) {
                this.postRefresh(this.editorModel, true);
            } else {
                int n = 0;
                while (n < this.groupNodes.length) {
                    this.groupNodes[n].reset(pHPFileData);
                    this.postRefresh(this.groupNodes[n], true);
                    ++n;
                }
            }
        }
    }

    public void fileDataRemoved(PHPFileData pHPFileData) {
    }

    private void postRefresh(final Object object, final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (PHPOutlineContentProvider.this.viewer == null) {
                    return;
                }
                Control control = PHPOutlineContentProvider.this.viewer.getControl();
                if (control == null || control.isDisposed()) {
                    return;
                }
                if (object == null) {
                    PHPOutlineContentProvider.this.viewer.refresh(bl);
                } else {
                    PHPOutlineContentProvider.this.viewer.refresh(object, bl);
                }
                PHPOutlineContentProvider.this.viewer.expandAll();
            }
        };
        Control control = this.viewer.getControl();
        if (control != null && !control.isDisposed()) {
            this.viewer.getControl().getDisplay().asyncExec(runnable);
        }
    }

    private void postRefresh(boolean bl) {
        this.postRefresh(null, bl);
    }

    public PHPOutlineContentProvider(TreeViewer treeViewer) {
        this.viewer = treeViewer;
        this.mode = PHPUiPlugin.getDefault().getPreferenceStore().getInt("ChangeOutlineModeAction.selectedMode");
        if (this.mode == 0) {
            this.mode = 1;
            PHPUiPlugin.getDefault().getPreferenceStore().setValue("ChangeOutlineModeAction.selectedMode", this.mode);
        }
        this.showGroups = PHPUiPlugin.getDefault().getPreferenceStore().getBoolean("ShowGroupsAction.show");
        PHPUiPlugin.getActiveWorkbenchWindow().getSelectionService().addPostSelectionListener(this.getSelectionServiceListener());
    }

    public Object[] getChildren(Object object) {
        if (object instanceof PHPElementImpl && this.mode == 3) {
            ArrayList arrayList = this.getPHPChildren((PHPElementImpl)object);
            return arrayList.toArray();
        }
        if (object instanceof PHPCodeData) {
            return this.phpContentProvider.getChildren(object);
        }
        if (object instanceof PHPEditorModel && this.mode == 1) {
            Object[] objectArray;
            this.editorModel = (PHPEditorModel)object;
            PHPEditorModel pHPEditorModel = (PHPEditorModel)object;
            PHPFileData pHPFileData = pHPEditorModel.getFileData();
            if (pHPFileData != null && (objectArray = this.getGroupNodes(pHPFileData)) != null) {
                return objectArray;
            }
            objectArray = this.phpContentProvider.getChildren(pHPFileData);
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
            objectArray2[0] = this.getIncludeFilesNode(pHPFileData);
            return objectArray2;
        }
        if (object instanceof GroupNode) {
            return ((GroupNode)object).getChildren();
        }
        if (object instanceof PHPTreeNode) {
            return ((PHPTreeNode)object).getChildren();
        }
        return super.getChildren(object);
    }

    public Object[] getElements(Object object) {
        if (object instanceof PHPElementImpl && this.mode == 3) {
            ArrayList arrayList = this.getPHPChildren((PHPElementImpl)object);
            return arrayList.toArray();
        }
        if (object instanceof PHPCodeData) {
            return this.phpContentProvider.getElements(object);
        }
        if (object instanceof PHPEditorModel && this.mode == 1) {
            this.editorModel = (PHPEditorModel)object;
            IDOMDocument iDOMDocument = this.editorModel.getDocument();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iDOMDocument.getAdapterFor((Object)clazz);
            PHPFileData pHPFileData = this.editorModel.getFileData();
            Object[] objectArray = this.getGroupNodes(pHPFileData);
            if (objectArray != null) {
                return objectArray;
            }
            Object[] objectArray2 = this.phpContentProvider.getElements(pHPFileData);
            GroupNode groupNode = this.getIncludeFilesNode(pHPFileData);
            if (!groupNode.hasChildren()) {
                return objectArray2;
            }
            Object[] objectArray3 = new Object[objectArray2.length + 1];
            System.arraycopy(objectArray2, 0, objectArray3, 1, objectArray2.length);
            objectArray3[0] = groupNode;
            return objectArray3;
        }
        if (object instanceof GroupNode) {
            return ((GroupNode)object).getChildren();
        }
        return super.getElements(object);
    }

    GroupNode getIncludeFilesNode(PHPFileData pHPFileData) {
        if (this.includes == null) {
            this.includes = new GroupNode(4, "include files", pHPFileData);
        } else {
            this.includes.setFileData(pHPFileData);
        }
        return this.includes;
    }

    GroupNode[] getGroupNodes(PHPFileData pHPFileData) {
        if (this.showGroups) {
            if (this.groupNodes != null) {
                return this.groupNodes;
            }
            this.groupNodes = new GroupNode[]{new GroupNode(1, "classes", pHPFileData), new GroupNode(3, "functions", pHPFileData), new GroupNode(2, "constants", pHPFileData), this.getIncludeFilesNode(pHPFileData)};
        } else {
            this.groupNodes = null;
        }
        return this.groupNodes;
    }

    public int getMode() {
        return this.mode;
    }

    public Object getParent(Object object) {
        if (object instanceof PHPCodeData) {
            PHPCodeData pHPCodeData = (PHPCodeData)object;
            PHPCodeData pHPCodeData2 = pHPCodeData.getContainer();
            if (pHPCodeData2 instanceof PHPFileData && this.showGroups) {
                int n = 0;
                while (n < this.groupNodes.length) {
                    Object[] objectArray = this.groupNodes[n].getChildren();
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        if (objectArray[n2] == object) {
                            return this.groupNodes[n];
                        }
                        ++n2;
                    }
                    ++n;
                }
            } else {
                return pHPCodeData2;
            }
        }
        return super.getParent(object);
    }

    private ArrayList getPHPChildren(PHPElementImpl pHPElementImpl) {
        String string = pHPElementImpl.getModel().getBaseLocation();
        int n = pHPElementImpl.getStartOffset();
        int n2 = pHPElementImpl.getEndOffset();
        PHPFileData pHPFileData = PHPWorkspaceModelManager.getInstance().getModelForFile(string);
        ArrayList arrayList = this.getPHPChildren(pHPFileData, n, n2);
        return arrayList;
    }

    private ArrayList getPHPChildren(PHPFileData pHPFileData, int n, int n2) {
        PHPFunctionData[] pHPFunctionDataArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (pHPFileData == null) {
            return arrayList;
        }
        PHPClassData[] pHPClassDataArray = pHPFileData.getClasses();
        if (pHPClassDataArray != null) {
            int n3 = 0;
            while (n3 < pHPClassDataArray.length) {
                if (this.isInside(n, n2, (PHPCodeData)pHPClassDataArray[n3])) {
                    arrayList.add(pHPClassDataArray[n3]);
                }
                ++n3;
            }
        }
        if ((pHPFunctionDataArray = pHPFileData.getFunctions()) != null) {
            int n4 = 0;
            while (n4 < pHPFunctionDataArray.length) {
                if (this.isInside(n, n2, (PHPCodeData)pHPFunctionDataArray[n4])) {
                    arrayList.add(pHPFunctionDataArray[n4]);
                }
                ++n4;
            }
        }
        return arrayList;
    }

    private ISelectionListener getSelectionServiceListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new PostSelectionServiceListener();
        }
        return this.fSelectionListener;
    }

    public boolean getShowGroups() {
        return this.showGroups;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof PHPElementImpl) {
            ArrayList arrayList = this.getPHPChildren((PHPElementImpl)object);
            return arrayList.size() > 0;
        }
        if (object instanceof PHPCodeData) {
            return this.phpContentProvider.hasChildren(object);
        }
        if (object instanceof GroupNode) {
            return ((GroupNode)object).hasChildren();
        }
        if (object instanceof PHPTreeNode) {
            return ((PHPTreeNode)object).hasChildren();
        }
        return super.hasChildren(object);
    }

    boolean isInside(int n, int n2, PHPCodeData pHPCodeData) {
        UserData userData = pHPCodeData.getUserData();
        if (userData == null) {
            return false;
        }
        return n <= userData.getStartPosition() && n2 >= userData.getEndPosition();
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public void setShowGroups(boolean bl) {
        this.showGroups = bl;
        this.postRefresh(true);
    }

    static class GroupNode {
        Object[] children;
        PHPFileData fileData;
        String text;
        int type;

        public void setFileData(PHPFileData pHPFileData) {
            this.fileData = pHPFileData;
            this.loadChildren();
        }

        GroupNode(int n, String string, PHPFileData pHPFileData) {
            this.type = n;
            this.text = string;
            this.fileData = pHPFileData;
        }

        public Object[] getChildren() {
            if (this.children == null) {
                this.loadChildren();
            }
            return this.children;
        }

        public void reset(PHPFileData pHPFileData) {
            this.fileData = pHPFileData;
            this.children = null;
        }

        public Image getImage() {
            switch (this.type) {
                case 1: {
                    return CLASSES_GROUP_IMAGE;
                }
                case 3: {
                    return FUNCTIONS_GROUP_IMAGE;
                }
                case 2: {
                    return CONSTANTS_GROUP_IMAGE;
                }
                case 4: {
                    return INCLUDES_GROUP_IMAGE;
                }
            }
            return null;
        }

        public String getText() {
            return this.text;
        }

        public boolean hasChildren() {
            if (this.children == null) {
                this.loadChildren();
            }
            return this.children.length > 0;
        }

        void loadChildren() {
            if (this.fileData != null) {
                switch (this.type) {
                    case 1: {
                        this.children = this.fileData.getClasses();
                        break;
                    }
                    case 3: {
                        this.children = this.fileData.getFunctions();
                        break;
                    }
                    case 2: {
                        this.children = this.fileData.getConstants();
                        break;
                    }
                    case 4: {
                        this.children = this.fileData.getIncludeFiles();
                    }
                }
            }
            if (this.children == null) {
                this.children = new Object[0];
            }
        }
    }

    private class PostSelectionServiceListener
    implements ISelectionListener {
        private PostSelectionServiceListener() {
        }

        public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        }
    }
}

