/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.util;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.php.core.phpModel.PHPModelUtil;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.UserData;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.util.IProblemChangedListener;
import org.eclipse.php.ui.util.ImageDescriptorRegistry;
import org.eclipse.php.ui.util.ImageImageDescriptor;
import org.eclipse.php.ui.util.PHPElementImageDescriptor;
import org.eclipse.php.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class ProblemsLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private static final int ERRORTICK_WARNING = 32;
    private static final int ERRORTICK_ERROR = 64;
    private ImageDescriptorRegistry fRegistry;
    private boolean fUseNewRegistry = false;
    private IProblemChangedListener fProblemChangedListener;
    private ListenerList fListeners;

    public ProblemsLabelDecorator() {
        this(null);
        this.fUseNewRegistry = true;
    }

    public ProblemsLabelDecorator(ImageDescriptorRegistry imageDescriptorRegistry) {
        this.fRegistry = imageDescriptorRegistry;
        this.fProblemChangedListener = null;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.fUseNewRegistry ? new ImageDescriptorRegistry() : PHPUiPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String decorateText(String string, Object object) {
        return string;
    }

    public Image decorateImage(Image image, Object object) {
        int n = this.computeAdornmentFlags(object);
        if (n != 0) {
            ImageImageDescriptor imageImageDescriptor = new ImageImageDescriptor(image);
            Rectangle rectangle = image.getBounds();
            return this.getRegistry().get((ImageDescriptor)new PHPElementImageDescriptor(imageImageDescriptor, n, new Point(rectangle.width, rectangle.height)));
        }
        return image;
    }

    protected int computeAdornmentFlags(Object object) {
        try {
            if (object instanceof PHPProjectModel) {
                object = PHPWorkspaceModelManager.getInstance().getProjectForModel((PHPProjectModel)object);
            }
            if (object instanceof PHPCodeData) {
                IResource iResource = PHPModelUtil.getResource((Object)object);
                return this.getErrorTicksFromMarkers(iResource, 1, (PHPCodeData)object);
            }
            if (object instanceof IResource) {
                return this.getErrorTicksFromMarkers((IResource)object, 2, null);
            }
        }
        catch (CoreException coreException) {
            if (coreException.getStatus().getCode() == 376) {
                return 0;
            }
            PHPUiPlugin.log(coreException);
        }
        return 0;
    }

    private int getErrorTicksFromMarkers(IResource iResource, int n, PHPCodeData pHPCodeData) throws CoreException {
        if (iResource == null || !iResource.isAccessible()) {
            return 0;
        }
        int n2 = 0;
        IMarker[] iMarkerArray = iResource.findMarkers("org.eclipse.core.resources.problemmarker", true, n);
        if (iMarkerArray != null) {
            int n3 = 0;
            while (n3 < iMarkerArray.length && n2 != 64) {
                IMarker iMarker = iMarkerArray[n3];
                if (pHPCodeData == null || this.isMarkerInRange(iMarker, pHPCodeData)) {
                    int n4 = iMarker.getAttribute("severity", -1);
                    if (n4 == 1) {
                        n2 = 32;
                    } else if (n4 == 2) {
                        n2 = 64;
                    }
                }
                ++n3;
            }
        }
        return n2;
    }

    private boolean isMarkerInRange(IMarker iMarker, PHPCodeData pHPCodeData) throws CoreException {
        if (iMarker.isSubtypeOf("org.eclipse.core.resources.textmarker")) {
            int n = iMarker.getAttribute("charStart", -1);
            return this.isInside(n, pHPCodeData);
        }
        return false;
    }

    private int getErrorTicksFromWorkingCopy(PHPFileData pHPFileData, PHPCodeData pHPCodeData) throws CoreException {
        int n = 0;
        new FileEditorInput((IFile)PHPModelUtil.getResource((Object)pHPFileData));
        IAnnotationModel iAnnotationModel = null;
        if (iAnnotationModel != null) {
            Iterator iterator = iAnnotationModel.getAnnotationIterator();
            while (n != 64 && iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                IMarker iMarker = this.isAnnotationInRange(iAnnotationModel, annotation, pHPCodeData);
                if (iMarker == null) continue;
                int n2 = iMarker.getAttribute("severity", -1);
                if (n2 == 1) {
                    n = 32;
                    continue;
                }
                if (n2 != 2) continue;
                n = 64;
            }
        }
        return n;
    }

    private IMarker isAnnotationInRange(IAnnotationModel iAnnotationModel, Annotation annotation, PHPCodeData pHPCodeData) throws CoreException {
        Position position;
        IMarker iMarker;
        if (annotation instanceof MarkerAnnotation && (iMarker = ((MarkerAnnotation)annotation).getMarker()).exists() && iMarker.isSubtypeOf("org.eclipse.core.resources.problemmarker") && (position = iAnnotationModel.getPosition(annotation)) != null && (pHPCodeData == null || this.isInside(position.getOffset(), pHPCodeData))) {
            return iMarker;
        }
        return null;
    }

    protected boolean isInside(int n, PHPCodeData pHPCodeData) throws CoreException {
        UserData userData = pHPCodeData.getUserData();
        if (userData != null) {
            int n2 = userData.getStartPosition();
            return n2 <= n && userData.getStopPosition() > n;
        }
        return false;
    }

    public void dispose() {
        if (this.fProblemChangedListener != null) {
            PHPUiPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
            this.fProblemChangedListener = null;
        }
        if (this.fRegistry != null && this.fUseNewRegistry) {
            this.fRegistry.dispose();
        }
    }

    public boolean isLabelProperty(Object object, String string) {
        return true;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)iLabelProviderListener);
        if (this.fProblemChangedListener == null) {
            this.fProblemChangedListener = new IProblemChangedListener(){

                public void problemsChanged(IResource[] iResourceArray, boolean bl) {
                    ProblemsLabelDecorator.this.fireProblemsChanged(iResourceArray, bl);
                }
            };
            PHPUiPlugin.getDefault().getProblemMarkerManager().addListener(this.fProblemChangedListener);
        }
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)iLabelProviderListener);
            if (this.fListeners.isEmpty() && this.fProblemChangedListener != null) {
                PHPUiPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
                this.fProblemChangedListener = null;
            }
        }
    }

    private void fireProblemsChanged(IResource[] iResourceArray, boolean bl) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            ProblemsLabelChangedEvent problemsLabelChangedEvent = new ProblemsLabelChangedEvent((IBaseLabelProvider)this, iResourceArray, bl);
            Object[] objectArray = this.fListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                ((ILabelProviderListener)objectArray[n]).labelProviderChanged((LabelProviderChangedEvent)problemsLabelChangedEvent);
                ++n;
            }
        }
    }

    public void decorate(Object object, IDecoration iDecoration) {
        int n = this.computeAdornmentFlags(object);
        if (n == 64) {
            iDecoration.addOverlay(PHPPluginImages.DESC_OVR_ERROR);
        } else if (n == 32) {
            iDecoration.addOverlay(PHPPluginImages.DESC_OVR_WARNING);
        }
    }

    public static class ProblemsLabelChangedEvent
    extends LabelProviderChangedEvent {
        private boolean fMarkerChange;

        public ProblemsLabelChangedEvent(IBaseLabelProvider iBaseLabelProvider, IResource[] iResourceArray, boolean bl) {
            super(iBaseLabelProvider, (Object[])iResourceArray);
            this.fMarkerChange = bl;
        }

        public boolean isMarkerChange() {
            return this.fMarkerChange;
        }
    }
}

