/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceSaveableComparison;
import org.eclipse.team.ui.mapping.ISynchronizationCompareInput;
import org.eclipse.team.ui.mapping.SaveableComparison;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.Saveable;

public class ModelCompareEditorInput
extends CompareEditorInput
implements ISaveablesSource,
IPropertyListener {
    private final ModelSynchronizeParticipant participant;
    private final ICompareInput input;
    private final Saveable model;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ModelCompareEditorInput(ModelSynchronizeParticipant participant, ICompareInput input) {
        super(new CompareConfiguration());
        Assert.isNotNull((Object)participant);
        Assert.isNotNull((Object)input);
        this.participant = participant;
        this.input = input;
        this.model = this.asSaveable(input);
        this.setDirty(this.model.isDirty());
    }

    private Saveable asSaveable(ICompareInput input) {
        ISynchronizationCompareInput mci;
        SaveableComparison compareModel;
        if (input instanceof ISynchronizationCompareInput && (compareModel = (mci = (ISynchronizationCompareInput)input).getSaveable()) != null) {
            return compareModel;
        }
        return new ResourceSaveableComparison(input, this.participant, this);
    }

    public Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.model instanceof SaveableComparison) {
            final SaveableComparison scm = (SaveableComparison)this.model;
            scm.addPropertyListener(this);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    scm.removePropertyListener(ModelCompareEditorInput.this);
                }
            });
        }
        return control;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.setTitle(this.getTitle());
        monitor.beginTask(TeamUIMessages.SyncInfoCompareInput_3, 100);
        monitor.setTaskName(TeamUIMessages.SyncInfoCompareInput_3);
        try {
            try {
                ISynchronizationCompareInput adapter = this.asModelCompareInput(this.input);
                if (adapter != null) {
                    adapter.prepareInput(this.getCompareConfiguration(), Policy.subMonitorFor(monitor, 100));
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        monitor.done();
        return this.input;
    }

    private ISynchronizationCompareInput asModelCompareInput(ICompareInput input) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.ui.mapping.ISynchronizationCompareInput");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ISynchronizationCompareInput)Utils.getAdapter(input, clazz);
    }

    public boolean matches(Object object, ISynchronizeParticipant participant) {
        if (participant == this.participant && this.input instanceof ISynchronizationCompareInput) {
            ISynchronizationCompareInput mci = (ISynchronizationCompareInput)this.input;
            return mci.isCompareInputFor(object);
        }
        return false;
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 257) {
            this.setDirty(this.model.isDirty());
        }
    }

    public Object getAdapter(Class adapter) {
        IResource resource;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter) && (resource = Utils.getResource(this.input)) instanceof IFile) {
            return resource;
        }
        return super.getAdapter(adapter);
    }

    public Image getTitleImage() {
        ImageRegistry reg = TeamUIPlugin.getPlugin().getImageRegistry();
        Image image = reg.get("eview16/synch_synch.gif");
        if (image == null) {
            image = this.getImageDescriptor().createImage();
            reg.put("eview16/synch_synch.gif", image);
        }
        return image;
    }

    public String getTitle() {
        return NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_title, (Object[])new String[]{this.input.getName()});
    }

    public ImageDescriptor getImageDescriptor() {
        return TeamUIPlugin.getImageDescriptor("eview16/synch_synch.gif");
    }

    public String getToolTipText() {
        ISynchronizationCompareInput adapter = this.asModelCompareInput(this.input);
        String fullPath = adapter != null ? adapter.getFullPath() : this.getName();
        return NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_tooltip, (Object[])new String[]{Utils.shortenText(100, this.participant.getName()), fullPath});
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        boolean isNewViewer;
        Viewer newViewer = super.findContentViewer(oldViewer, input, parent);
        boolean bl = isNewViewer = newViewer != oldViewer;
        if (isNewViewer && newViewer instanceof IPropertyChangeNotifier && this.model instanceof IPropertyChangeListener) {
            final IPropertyChangeNotifier dsp = (IPropertyChangeNotifier)newViewer;
            final IPropertyChangeListener pcl = (IPropertyChangeListener)this.model;
            dsp.addPropertyChangeListener(pcl);
            Control c = newViewer.getControl();
            c.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    dsp.removePropertyChangeListener(pcl);
                }
            });
        }
        return newViewer;
    }

    public Saveable[] getActiveSaveables() {
        return new Saveable[]{this.model};
    }

    public Saveable[] getSaveables() {
        return this.getActiveSaveables();
    }
}

