/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.phpModel.parser.management;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.php.core.phpModel.parser.IParserClientFactory;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.parser.management.ProjectParsingManager;
import org.eclipse.php.core.util.project.observer.IProjectClosedObserver;
import org.eclipse.php.core.util.project.observer.ProjectRemovedObserversAttacher;

public class GlobalParsingManager {
    private static GlobalParsingManager instance;
    private Map project2ParsingManagerMap = new HashMap();

    private GlobalParsingManager() {
    }

    public static GlobalParsingManager getInstance() {
        if (instance == null) {
            instance = new GlobalParsingManager();
        }
        return instance;
    }

    public boolean addParserClient(IParserClientFactory iParserClientFactory, IProject iProject) {
        ProjectParsingManager projectParsingManager = this.getProjectParsingManager(iProject);
        if (projectParsingManager == null) {
            return false;
        }
        projectParsingManager.addParserClient(iParserClientFactory);
        return true;
    }

    public void removeParserClient(IParserClientFactory iParserClientFactory, IProject iProject) {
        ProjectParsingManager projectParsingManager = this.getProjectParsingManager(iProject);
        if (projectParsingManager == null) {
            return;
        }
        projectParsingManager.removeParserClient(iParserClientFactory);
    }

    private ProjectParsingManager getProjectParsingManager(IProject iProject) {
        Object v = this.project2ParsingManagerMap.get(iProject);
        if (v == null) {
            if (!iProject.isAccessible()) {
                return null;
            }
            ProjectParsingManager projectParsingManager = new ProjectParsingManager(iProject);
            this.project2ParsingManagerMap.put(iProject, projectParsingManager);
            this.register2RemoveManagerWhenProjectCloses(iProject);
            PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
            pHPProjectModel.addProjectModelListener(projectParsingManager);
            return projectParsingManager;
        }
        return (ProjectParsingManager)v;
    }

    private void register2RemoveManagerWhenProjectCloses(final IProject iProject) {
        ProjectRemovedObserversAttacher.getInstance().addProjectClosedObserver(iProject, new IProjectClosedObserver(){

            public void closed() {
                ProjectParsingManager projectParsingManager = (ProjectParsingManager)GlobalParsingManager.this.project2ParsingManagerMap.remove(iProject);
                if (projectParsingManager == null) {
                    return;
                }
                projectParsingManager.dispose();
            }
        });
    }
}

