/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.hovers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.php.core.Logger;
import org.eclipse.php.debug.core.debugger.DefaultExpressionsManager;
import org.eclipse.php.debug.core.debugger.Expression;
import org.eclipse.php.debug.core.model.PHPDebugTarget;
import org.eclipse.php.debug.core.model.PHPStackFrame;
import org.eclipse.php.ui.editor.hover.AbstractPHPTextHover;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class PHPDebugTextHover
extends AbstractPHPTextHover {
    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        String string;
        PHPDebugTarget pHPDebugTarget = this.getDebugTarget();
        if (pHPDebugTarget == null || iTextViewer == null || iTextViewer.getDocument() == null) {
            return null;
        }
        int n = iRegion.getOffset();
        IStructuredDocumentRegion iStructuredDocumentRegion = ((IStructuredDocument)iTextViewer.getDocument()).getRegionAtCharacterOffset(n);
        ITextRegion iTextRegion = null;
        if (iStructuredDocumentRegion != null) {
            iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        }
        if (iTextRegion != null && (string = iTextRegion.getType()).equalsIgnoreCase("PHP_VARIABLE")) {
            String string2 = null;
            try {
                string2 = iTextViewer.getDocument().get(iRegion.getOffset(), iRegion.getLength());
                string2 = "<B>" + string2 + " = </B>" + this.getValue(pHPDebugTarget, string2);
            }
            catch (BadLocationException badLocationException) {
                Logger.logException((String)"Error retrieving the value\n", (Throwable)badLocationException);
            }
            return string2;
        }
        return null;
    }

    protected String getValue(PHPDebugTarget pHPDebugTarget, String string) {
        DefaultExpressionsManager defaultExpressionsManager = pHPDebugTarget.getExpressionManager();
        Expression expression = defaultExpressionsManager.buildExpression(string);
        String string2 = pHPDebugTarget.getExpressionManager().getExpressionValue(expression, 1);
        defaultExpressionsManager.update(expression, 1);
        string2 = expression.getValue().getValueAsString();
        if (string2 != null && string2.length() == 0) {
            string2 = "Empty";
            return string2;
        }
        if (string2 != null) {
            this.tab.matcher(string2).replaceAll("    ");
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PHPDebugTarget getDebugTarget() {
        FileEditorInput fileEditorInput;
        PHPStackFrame pHPStackFrame;
        block4: {
            String string;
            IAdaptable iAdaptable = DebugUITools.getDebugContext();
            if (!(iAdaptable instanceof PHPStackFrame)) return null;
            pHPStackFrame = (PHPStackFrame)iAdaptable;
            IEditorInput iEditorInput = this.getEditorPart().getEditorInput();
            if (!(iEditorInput instanceof FileEditorInput)) return (PHPDebugTarget)pHPStackFrame.getDebugTarget();
            fileEditorInput = (FileEditorInput)this.getEditorPart().getEditorInput();
            String string2 = pHPStackFrame.getLaunch().getLaunchConfiguration().getAttribute("org.eclipse.php.debug.core.PHP_Project", null);
            if (string2.equals(string = String.valueOf('/') + fileEditorInput.getFile().getProject().getName())) break block4;
            return null;
        }
        try {
            String string = pHPStackFrame.getSourceName();
            String string3 = fileEditorInput.getFile().getProjectRelativePath().toString();
            if (string != null) {
                if (string.endsWith(String.valueOf('/') + string3)) return (PHPDebugTarget)pHPStackFrame.getDebugTarget();
            }
            if (!string.equals(string3)) return null;
            return (PHPDebugTarget)pHPStackFrame.getDebugTarget();
        }
        catch (CoreException coreException) {
            Logger.logException((String)"Error retrieving the PHPDebugTarget.\n", (Throwable)coreException);
        }
        return null;
    }
}

