/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.launching;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.core.phpModel.PHPModelUtil;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.util.FileUtils;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.eclipse.php.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.server.core.Server;
import org.eclipse.php.server.core.manager.ServersManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class PHPServerLaunchShortcut
implements ILaunchShortcut {
    static /* synthetic */ Class class$0;

    public void launch(ISelection iSelection, String string) {
        if (iSelection instanceof IStructuredSelection) {
            PHPServerLaunchShortcut.searchAndLaunch(((IStructuredSelection)iSelection).toArray(), string, this.getPHPServerLaunchConfigType());
        }
    }

    public void launch(IEditorPart iEditorPart, String string) {
        IFile iFile;
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iFile = (IFile)iEditorInput.getAdapter((Class)clazz)) != null) {
            PHPServerLaunchShortcut.searchAndLaunch(new Object[]{iFile}, string, this.getPHPServerLaunchConfigType());
        }
    }

    private ILaunchConfigurationType getPHPServerLaunchConfigType() {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        return iLaunchManager.getLaunchConfigurationType("org.eclipse.php.server.core.launchConfigurationType");
    }

    public static void searchAndLaunch(Object[] objectArray, String string, ILaunchConfigurationType iLaunchConfigurationType) {
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                IStatus iStatus;
                try {
                    IContentType iContentType;
                    IFile iFile;
                    String string2 = null;
                    iStatus = null;
                    Object object = objectArray[n2];
                    if (object instanceof PHPCodeData) {
                        object = PHPModelUtil.getResource((Object)object);
                    }
                    if (object instanceof IFile) {
                        iFile = (IFile)object;
                        iStatus = iFile.getProject();
                        iContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
                        if (iContentType.isAssociatedWith(iFile.getName())) {
                            string2 = iFile.getFullPath().toString();
                        }
                    }
                    if (string2 == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, PHPDebugUIMessages.launch_failure_no_target, null));
                    }
                    iFile = ServersManager.getDefaultServer();
                    if (iFile == null) {
                        PHPDebugPlugin.createDefaultPHPServer();
                        iFile = ServersManager.getDefaultServer();
                        if (iFile == null) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, "Could not create a defualt server for the launch.", null));
                        }
                    }
                    if ((iContentType = PHPServerLaunchShortcut.findLaunchConfiguration((IProject)iStatus, string2, (Server)iFile, string, iLaunchConfigurationType)) != null) {
                        DebugUITools.launch((ILaunchConfiguration)iContentType, (String)string);
                        break block10;
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, PHPDebugUIMessages.launch_failure_no_config, null));
                }
                catch (CoreException coreException) {
                    iStatus = coreException.getStatus();
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            ErrorDialog.openError((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)PHPDebugUIMessages.launch_failure_msg_title, (String)PHPDebugUIMessages.launch_failure_server_msg_text, (IStatus)iStatus);
                        }
                    });
                }
            }
            ++n2;
        }
    }

    static ILaunchConfiguration findLaunchConfiguration(IProject iProject, String string, Server server, String string2, ILaunchConfigurationType iLaunchConfigurationType) {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
            int n = iLaunchConfigurationArray == null ? 0 : iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string3 = iLaunchConfigurationArray[n2].getAttribute("name", null);
                String string4 = iLaunchConfigurationArray[n2].getAttribute("file_name", null);
                if (string4.equals(string) && server.getName().equals(string3)) {
                    iLaunchConfiguration = iLaunchConfigurationArray[n2].getWorkingCopy();
                    break;
                }
                ++n2;
            }
            if (iLaunchConfiguration == null) {
                iLaunchConfiguration = PHPServerLaunchShortcut.createConfiguration(iProject, string, server, iLaunchConfigurationType);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return iLaunchConfiguration;
    }

    static ILaunchConfiguration createConfiguration(IProject iProject, String string, Server server, ILaunchConfigurationType iLaunchConfigurationType) throws CoreException {
        ILaunchConfiguration iLaunchConfiguration = null;
        if (!FileUtils.fileExists((String)string)) {
            return null;
        }
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom("New_configuration"));
        iLaunchConfigurationWorkingCopy.setAttribute("name", server.getName());
        iLaunchConfigurationWorkingCopy.setAttribute("file_name", string);
        iLaunchConfigurationWorkingCopy.setAttribute("context_root", iProject.getName());
        iLaunchConfigurationWorkingCopy.setAttribute("base_url", String.valueOf(server.getBaseURL()) + '/' + iProject.getName() + '/' + new Path(string).lastSegment());
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", PHPDebugPlugin.getDebugInfoOption());
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.OpenInBrowser", PHPDebugPlugin.getOpenInBrowserOption());
        if (server.canPublish()) {
            iLaunchConfigurationWorkingCopy.setAttribute("publish", true);
        }
        iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
        return iLaunchConfiguration;
    }
}

