/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.debug.ui.preferences.IPHPDebugPreferencesPageAddon;

public class PHPDebugPreferencesAddonRegistry {
    private static final String EXTENSION_POINT_NAME = "phpDebugPreferencesAddon";
    private static final String DEBUG_PREFERENCES_ADDON_TAG = "debugPreferencesAddon";
    private static final String ID_ATTRIBUTE = "id";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String PREFERENCES_PAGE_ID_ATTRIBUTE = "preferencesPageId";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String WORKSPACE_TYPE = "Workspace";
    private static final String PROJECT_SPECIFIC_TYPE = "Project Specific";
    private Dictionary workspaceTypeAddons = new Hashtable();
    private Dictionary projectTypeAddons = new Hashtable();
    private static PHPDebugPreferencesAddonRegistry instance = null;
    private static Comparator pageAddonComparator = new PageAddonComparator();

    private PHPDebugPreferencesAddonRegistry() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(PHPDebugUIPlugin.getID(), EXTENSION_POINT_NAME);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (DEBUG_PREFERENCES_ADDON_TAG.equals(iConfigurationElement.getName())) {
                String string = iConfigurationElement.getAttribute(PREFERENCES_PAGE_ID_ATTRIBUTE);
                if (PROJECT_SPECIFIC_TYPE.equalsIgnoreCase(iConfigurationElement.getAttribute(TYPE_ATTRIBUTE))) {
                    this.addAddon(this.projectTypeAddons, string, iConfigurationElement);
                } else {
                    this.addAddon(this.workspaceTypeAddons, string, iConfigurationElement);
                }
            }
            ++n;
        }
    }

    private void addAddon(Dictionary dictionary, String string, IConfigurationElement iConfigurationElement) {
        ArrayList<PHPDebugPreferencesAddonFactory> arrayList = (ArrayList<PHPDebugPreferencesAddonFactory>)dictionary.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<PHPDebugPreferencesAddonFactory>(5);
        }
        arrayList.add(new PHPDebugPreferencesAddonFactory(iConfigurationElement));
        dictionary.put(string, arrayList);
    }

    private Dictionary getWorkspaceAddons() {
        return this.workspaceTypeAddons;
    }

    private Dictionary getProjectSpecificAddons() {
        return this.projectTypeAddons;
    }

    private static PHPDebugPreferencesAddonRegistry getInstance() {
        if (instance == null) {
            instance = new PHPDebugPreferencesAddonRegistry();
        }
        return instance;
    }

    public static IPHPDebugPreferencesPageAddon[] getDebugPreferencesWorkspaceAddon(String string) throws Exception {
        List list = (List)PHPDebugPreferencesAddonRegistry.getInstance().getWorkspaceAddons().get(string);
        IPHPDebugPreferencesPageAddon[] iPHPDebugPreferencesPageAddonArray = PHPDebugPreferencesAddonRegistry.getAddons(list);
        Arrays.sort(iPHPDebugPreferencesPageAddonArray, pageAddonComparator);
        return iPHPDebugPreferencesPageAddonArray;
    }

    public static IPHPDebugPreferencesPageAddon[] getDebugPreferencesProjectAddon(String string) throws Exception {
        List list = (List)PHPDebugPreferencesAddonRegistry.getInstance().getProjectSpecificAddons().get(string);
        IPHPDebugPreferencesPageAddon[] iPHPDebugPreferencesPageAddonArray = PHPDebugPreferencesAddonRegistry.getAddons(list);
        Arrays.sort(iPHPDebugPreferencesPageAddonArray, pageAddonComparator);
        return iPHPDebugPreferencesPageAddonArray;
    }

    private static IPHPDebugPreferencesPageAddon[] getAddons(List list) {
        if (list == null) {
            return new IPHPDebugPreferencesPageAddon[0];
        }
        IPHPDebugPreferencesPageAddon[] iPHPDebugPreferencesPageAddonArray = new IPHPDebugPreferencesPageAddon[list.size()];
        int n = 0;
        while (n < iPHPDebugPreferencesPageAddonArray.length) {
            iPHPDebugPreferencesPageAddonArray[n] = ((PHPDebugPreferencesAddonFactory)list.get(n)).createDebugPreferencesAddon();
            ++n;
        }
        return iPHPDebugPreferencesPageAddonArray;
    }

    class PHPDebugPreferencesAddonFactory {
        private IConfigurationElement element;
        private IPHPDebugPreferencesPageAddon preferencesPageAddon;

        public PHPDebugPreferencesAddonFactory(IConfigurationElement iConfigurationElement) {
            this.element = iConfigurationElement;
        }

        public IPHPDebugPreferencesPageAddon createDebugPreferencesAddon() {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(this, "Error creation extension for extension-point org.eclipse.php.debug.ui.phpDebugPreferencesAddon"){
                final /* synthetic */ PHPDebugPreferencesAddonFactory this$1;
                {
                    this.this$1 = pHPDebugPreferencesAddonFactory;
                    super(string);
                }

                public void run() throws Exception {
                    PHPDebugPreferencesAddonFactory.access$1(this.this$1, (IPHPDebugPreferencesPageAddon)PHPDebugPreferencesAddonFactory.access$0(this.this$1).createExecutableExtension("class"));
                    PHPDebugPreferencesAddonFactory.access$2(this.this$1).setComparableName(PHPDebugPreferencesAddonFactory.access$0(this.this$1).getAttribute("name"));
                }
            });
            return this.preferencesPageAddon;
        }

        static /* synthetic */ IConfigurationElement access$0(PHPDebugPreferencesAddonFactory pHPDebugPreferencesAddonFactory) {
            return pHPDebugPreferencesAddonFactory.element;
        }

        static /* synthetic */ void access$1(PHPDebugPreferencesAddonFactory pHPDebugPreferencesAddonFactory, IPHPDebugPreferencesPageAddon iPHPDebugPreferencesPageAddon) {
            pHPDebugPreferencesAddonFactory.preferencesPageAddon = iPHPDebugPreferencesPageAddon;
        }

        static /* synthetic */ IPHPDebugPreferencesPageAddon access$2(PHPDebugPreferencesAddonFactory pHPDebugPreferencesAddonFactory) {
            return pHPDebugPreferencesAddonFactory.preferencesPageAddon;
        }
    }

    static class PageAddonComparator
    implements Comparator {
        PageAddonComparator() {
        }

        public int compare(Object object, Object object2) {
            IPHPDebugPreferencesPageAddon iPHPDebugPreferencesPageAddon = (IPHPDebugPreferencesPageAddon)object;
            IPHPDebugPreferencesPageAddon iPHPDebugPreferencesPageAddon2 = (IPHPDebugPreferencesPageAddon)object2;
            if (iPHPDebugPreferencesPageAddon != null && iPHPDebugPreferencesPageAddon2 != null) {
                return iPHPDebugPreferencesPageAddon.getComparableName().compareTo(iPHPDebugPreferencesPageAddon2.getComparableName());
            }
            if (iPHPDebugPreferencesPageAddon == null) {
                return iPHPDebugPreferencesPageAddon2 == null ? 0 : -1;
            }
            return 1;
        }
    }
}

