/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.xhtml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.help.internal.HelpPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class UATransformManager {
    private static Transformer createTransformer(Document document) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DocumentType docType = document.getDoctype();
            if (docType != null) {
                String value = docType.getSystemId();
                transformer.setOutputProperty("doctype-system", value);
                value = document.getDoctype().getPublicId();
                transformer.setOutputProperty("doctype-public", value);
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            return transformer;
        }
        catch (TransformerConfigurationException tce) {
            HelpPlugin.logError("Transformer Config error: " + tce.getMessage(), null);
            Throwable x = tce;
            if (tce.getException() != null) {
                x = tce.getException();
            }
            HelpPlugin.logError("Transformer Stack trace: ", x);
            return null;
        }
    }

    public static String convertToString(Document document) {
        try {
            Transformer transformer = UATransformManager.createTransformer(document);
            DOMSource source = new DOMSource(document);
            StringWriter stringBuffer = new StringWriter();
            StreamResult result = new StreamResult(stringBuffer);
            transformer.transform(source, result);
            return stringBuffer.toString();
        }
        catch (TransformerException te) {
            HelpPlugin.logError("Transformer error: " + te.getMessage(), te);
            Throwable x = te;
            if (te.getException() != null) {
                x = te.getException();
            }
            HelpPlugin.logError("Transformer Stack trace: ", x);
            return null;
        }
    }

    public static InputStream getAsInputStream(Document document) {
        byte[] ba = null;
        String xhtml = UATransformManager.convertToString(document);
        try {
            ba = xhtml.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        ByteArrayInputStream is = new ByteArrayInputStream(ba);
        return is;
    }
}

