/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.navigator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class JavaNavigatorContentProvider
extends PackageExplorerContentProvider
implements IPipelinedTreeContentProvider {
    public static final String JDT_EXTENSION_ID = "org.eclipse.jdt.ui.javaContent";
    private IExtensionStateModel fStateModel;
    private Object fRealInput;

    public JavaNavigatorContentProvider() {
        super(false);
    }

    public JavaNavigatorContentProvider(boolean provideMembers) {
        super(provideMembers);
    }

    public void init(ICommonContentExtensionSite commonContentExtensionSite) {
        IExtensionStateModel stateModel = commonContentExtensionSite.getExtensionStateModel();
        IMemento memento = commonContentExtensionSite.getMemento();
        this.fStateModel = stateModel;
        this.restoreState(memento);
        this.fStateModel.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("isLayoutFlat".equals(event.getProperty()) && event.getNewValue() != null) {
                    boolean newValue = (Boolean)event.getNewValue() != false;
                    JavaNavigatorContentProvider.this.setIsFlatLayout(newValue);
                }
            }
        });
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        boolean showCUChildren = store.getBoolean("org.eclipse.jdt.ui.packages.cuchildren");
        this.setProvideMembers(showCUChildren);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fRealInput = newInput;
        super.inputChanged(viewer, oldInput, this.findInputElement(newInput));
    }

    public Object getParent(Object element) {
        Object parent = super.getParent(element);
        if (parent instanceof IJavaModel) {
            return this.getViewerInput() != null ? this.fRealInput : parent;
        }
        return parent;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkspaceRoot) {
            return super.getElements(JavaCore.create((IWorkspaceRoot)((IWorkspaceRoot)inputElement)));
        }
        return super.getElements(inputElement);
    }

    private Object findInputElement(Object newInput) {
        if (newInput instanceof IWorkspaceRoot) {
            return JavaCore.create((IWorkspaceRoot)((IWorkspaceRoot)newInput));
        }
        return newInput;
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void getPipelinedChildren(Object parent, Set currentChildren) {
        Object[] children = this.getChildren(parent);
        Iterator iter = currentChildren.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof IResource)) continue;
            iter.remove();
        }
        currentChildren.addAll(Arrays.asList(children));
    }

    public void getPipelinedElements(Object input, Set currentElements) {
        Object[] children = this.getElements(input);
        Iterator iter = currentElements.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof IResource)) continue;
            iter.remove();
        }
        currentElements.addAll(Arrays.asList(children));
    }

    public Object getPipelinedParent(Object object, Object suggestedParent) {
        return this.getParent(object);
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification addModification) {
        this.convertToJavaElements(addModification);
        return addModification;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification removeModification) {
        this.convertToJavaElements(removeModification.getChildren());
        return removeModification;
    }

    private boolean convertToJavaElements(PipelinedShapeModification modification) {
        IJavaElement element;
        Object parent = modification.getParent();
        if (parent instanceof IContainer && (element = JavaCore.create((IResource)((IContainer)parent))) != null && element.exists()) {
            if (!(element instanceof IJavaModel)) {
                modification.setParent((Object)element);
            }
            return this.convertToJavaElements(modification.getChildren());
        }
        return false;
    }

    private boolean convertToJavaElements(Set currentChildren) {
        LinkedHashSet<IJavaElement> convertedChildren = new LinkedHashSet<IJavaElement>();
        Iterator childrenItr = currentChildren.iterator();
        while (childrenItr.hasNext()) {
            IJavaElement newChild;
            Object child = childrenItr.next();
            if (!(child instanceof IResource) || (newChild = JavaCore.create((IResource)((IResource)child))) == null || !newChild.exists()) continue;
            childrenItr.remove();
            convertedChildren.add(newChild);
        }
        if (!convertedChildren.isEmpty()) {
            currentChildren.addAll(convertedChildren);
            return true;
        }
        return false;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate refreshSynchronization) {
        return this.convertToJavaElements(refreshSynchronization.getRefreshTargets());
    }

    public boolean interceptUpdate(PipelinedViewerUpdate updateSynchronization) {
        return this.convertToJavaElements(updateSynchronization.getRefreshTargets());
    }

    protected void postAdd(Object parent, Object element) {
        if (parent instanceof IJavaModel) {
            super.postAdd(((IJavaModel)parent).getWorkspace(), element);
        } else {
            super.postAdd(parent, element);
        }
    }

    protected void postRefresh(List toRefresh, boolean updateLabels) {
        Iterator iter = toRefresh.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IJavaModel)) continue;
            iter.remove();
            toRefresh.add(this.fRealInput);
            super.postRefresh(toRefresh, updateLabels);
            return;
        }
        super.postRefresh(toRefresh, updateLabels);
    }
}

