/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.net.URL;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.widgets.ScrolledFormText;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.DiscoveryFolder;
import org.eclipse.update.internal.ui.model.SiteBookmark;
import org.eclipse.update.internal.ui.model.SiteCategory;
import org.eclipse.update.internal.ui.model.UpdateModel;
import org.eclipse.update.internal.ui.parts.SWTUtil;
import org.eclipse.update.internal.ui.wizards.BannerPage;
import org.eclipse.update.internal.ui.wizards.EditSiteDialog;
import org.eclipse.update.internal.ui.wizards.ISearchProvider;
import org.eclipse.update.internal.ui.wizards.LocalSiteSelector;
import org.eclipse.update.internal.ui.wizards.NewUpdateSiteDialog;
import org.eclipse.update.internal.ui.wizards.SitesImportExport;
import org.eclipse.update.operations.IUpdateModelChangedListener;
import org.eclipse.update.search.EnvironmentFilter;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;

public class SitePage
extends BannerPage
implements ISearchProvider {
    private static DiscoveryFolder discoveryFolder = new DiscoveryFolder();
    private CheckboxTableViewer viewer;
    private ScrolledFormText descLabel;
    private Button addSiteButton;
    private Button addLocalButton;
    private Button addLocalZippedButton;
    private Button editButton;
    private Button removeButton;
    private Button exportButton;
    private Button importButton;
    private Button envFilterCheck;
    private EnvironmentFilter envFilter;
    private UpdateSearchRequest searchRequest;
    private ModelListener modelListener;

    public SitePage(UpdateSearchRequest searchRequest) {
        super("SitePage");
        this.searchRequest = searchRequest;
        this.setTitle(UpdateUIMessages.SitePage_title);
        this.setDescription(UpdateUIMessages.SitePage_desc);
        UpdateUI.getDefault().getLabelProvider().connect(this);
        this.envFilter = new EnvironmentFilter();
        this.modelListener = new ModelListener();
        UpdateUI.getDefault().getUpdateModel().addUpdateModelChangedListener(this.modelListener);
    }

    private void toggleEnvFilter(boolean add) {
        if (add) {
            this.searchRequest.addFilter((IUpdateSearchFilter)this.envFilter);
        } else {
            this.searchRequest.removeFilter((IUpdateSearchFilter)this.envFilter);
        }
    }

    public void dispose() {
        UpdateUI.getDefault().getLabelProvider().disconnect(this);
        UpdateUI.getDefault().getUpdateModel().removeUpdateModelChangedListener(this.modelListener);
        super.dispose();
    }

    protected Control createContents(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        Label label = new Label(client, 0);
        label.setText(UpdateUIMessages.SitePage_label);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.createViewer(client);
        Composite buttonContainer = new Composite(client, 0);
        buttonContainer.setLayoutData((Object)new GridData(1040));
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonContainer.setLayout((Layout)layout);
        this.addSiteButton = new Button(buttonContainer, 8);
        this.addSiteButton.setText(UpdateUIMessages.SitePage_addUpdateSite);
        this.addSiteButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.addSiteButton);
        this.addSiteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SitePage.this.handleAddSite();
            }
        });
        this.addLocalButton = new Button(buttonContainer, 8);
        this.addLocalButton.setText(UpdateUIMessages.SitePage_addLocalSite);
        this.addLocalButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.addLocalButton);
        this.addLocalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SitePage.this.handleAddLocal();
            }
        });
        this.addLocalZippedButton = new Button(buttonContainer, 8);
        this.addLocalZippedButton.setText(UpdateUIMessages.SitePage_addLocalZippedSite);
        this.addLocalZippedButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.addLocalZippedButton);
        this.addLocalZippedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SitePage.this.handleAddLocalZipped();
            }
        });
        new Label(buttonContainer, 0);
        this.editButton = new Button(buttonContainer, 8);
        this.editButton.setText(UpdateUIMessages.SitePage_edit);
        this.editButton.setEnabled(false);
        this.editButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.editButton);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SitePage.this.handleEdit();
            }
        });
        this.removeButton = new Button(buttonContainer, 8);
        this.removeButton.setText(UpdateUIMessages.SitePage_remove);
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.removeButton);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SitePage.this.handleRemove();
            }
        });
        new Label(buttonContainer, 0);
        this.importButton = new Button(buttonContainer, 8);
        this.importButton.setText(UpdateUIMessages.SitePage_import);
        this.importButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.importButton);
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SitePage.this.handleImport();
            }
        });
        this.exportButton = new Button(buttonContainer, 8);
        this.exportButton.setText(UpdateUIMessages.SitePage_export);
        this.exportButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.exportButton);
        this.exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SitePage.this.handleExport();
            }
        });
        this.descLabel = new ScrolledFormText(client, true);
        this.descLabel.setText("");
        this.descLabel.setBackground(parent.getBackground());
        HyperlinkSettings settings = new HyperlinkSettings(parent.getDisplay());
        this.descLabel.getFormText().setHyperlinkSettings(settings);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 1;
        gd.heightHint = 30;
        this.descLabel.setLayoutData((Object)gd);
        this.envFilterCheck = new Button(client, 32);
        this.envFilterCheck.setText(UpdateUIMessages.SitePage_ignore);
        this.envFilterCheck.setSelection(true);
        this.toggleEnvFilter(true);
        this.envFilterCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SitePage.this.toggleEnvFilter(SitePage.this.envFilterCheck.getSelection());
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalAlignment = 1024;
        this.envFilterCheck.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)client, "org.eclipse.update.ui.SitePage");
        return client;
    }

    private void createViewer(Composite parent) {
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2816);
        this.viewer.getTable().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object parent) {
                return SitePage.this.getAllSiteBookmarks();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new SitesLabelProvider());
        this.viewer.setInput((Object)UpdateUI.getDefault().getUpdateModel());
        this.viewer.setSorter(new ViewerSorter());
        this.initializeItems();
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                Object element = e.getElement();
                if (element instanceof SiteBookmark) {
                    SitePage.this.handleSiteChecked((SiteBookmark)element, e.getChecked());
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                SitePage.this.handleSelectionChanged((IStructuredSelection)e.getSelection());
            }
        });
    }

    private void initializeItems() {
        this.checkItems();
        this.updateSearchRequest();
    }

    private void checkItems() {
        TableItem[] items = this.viewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            SiteBookmark bookmark = (SiteBookmark)items[i].getData();
            this.viewer.setChecked((Object)bookmark, bookmark.isSelected());
            ++i;
        }
    }

    private void handleAddSite() {
        NewUpdateSiteDialog dialog = new NewUpdateSiteDialog(this.getShell(), this.getAllSiteBookmarks());
        dialog.create();
        dialog.getShell().setText(UpdateUIMessages.SitePage_new);
        if (dialog.open() == 0) {
            this.updateSearchRequest();
        }
    }

    private void handleAddLocal() {
        SiteBookmark siteBookmark = LocalSiteSelector.getLocaLSite(this.getShell(), this.getAllSiteBookmarks());
        if (siteBookmark != null && this.handleNameEdit(siteBookmark) == 0) {
            siteBookmark.setSelected(true);
            UpdateModel model = UpdateUI.getDefault().getUpdateModel();
            model.addBookmark(siteBookmark);
            model.saveBookmarks();
            this.updateSearchRequest();
        }
    }

    private void handleAddLocalZipped() {
        SiteBookmark siteBookmark = LocalSiteSelector.getLocaLZippedSite(this.getShell(), this.getAllSiteBookmarks());
        if (siteBookmark != null && this.handleNameEdit(siteBookmark) == 0) {
            siteBookmark.setSelected(true);
            UpdateModel model = UpdateUI.getDefault().getUpdateModel();
            model.addBookmark(siteBookmark);
            model.saveBookmarks();
            this.updateSearchRequest();
        }
    }

    private void handleRemove() {
        BusyIndicator.showWhile((Display)this.viewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                UpdateModel updateModel = UpdateUI.getDefault().getUpdateModel();
                IStructuredSelection ssel = (IStructuredSelection)SitePage.this.viewer.getSelection();
                SiteBookmark bookmark = (SiteBookmark)ssel.getFirstElement();
                String selName = bookmark.getLabel();
                boolean answer = MessageDialog.openQuestion((Shell)SitePage.this.getShell(), (String)UpdateUIMessages.SitePage_remove_location_conf_title, (String)(String.valueOf(UpdateUIMessages.SitePage_remove_location_conf) + " " + selName));
                if (answer && !bookmark.isReadOnly()) {
                    updateModel.removeBookmark(bookmark);
                    SitePage.this.updateSearchRequest();
                }
            }
        });
    }

    private void handleEdit() {
        URL newURL;
        IStructuredSelection ssel = (IStructuredSelection)this.viewer.getSelection();
        SiteBookmark bookmark = (SiteBookmark)ssel.getFirstElement();
        URL oldURL = bookmark.getURL();
        EditSiteDialog dialog = new EditSiteDialog(this.getShell(), bookmark, this.getAllSiteBookmarks());
        dialog.create();
        String title = bookmark.isLocal() ? UpdateUIMessages.SitePage_dialogEditLocal : UpdateUIMessages.SitePage_dialogEditUpdateSite;
        dialog.getShell().setText(title);
        if (dialog.open() == 0 && !UpdateManagerUtils.sameURL((URL)oldURL, (URL)(newURL = bookmark.getURL()))) {
            UpdateModel model = UpdateUI.getDefault().getUpdateModel();
            model.fireObjectChanged(bookmark, null);
            this.updateSearchRequest();
        }
    }

    private void handleImport() {
        SiteBookmark[] siteBookmarks = SitesImportExport.getImportedBookmarks(this.getShell());
        if (siteBookmarks != null && siteBookmarks.length > 0) {
            UpdateModel model = UpdateUI.getDefault().getUpdateModel();
            SiteBookmark[] currentBookmarks = this.getAllSiteBookmarks();
            int i = 0;
            while (i < siteBookmarks.length) {
                boolean siteExists = false;
                int j = 0;
                while (!siteExists && j < currentBookmarks.length) {
                    if (currentBookmarks[j].getURL().equals(siteBookmarks[i].getURL())) {
                        siteExists = true;
                    }
                    ++j;
                }
                if (!siteExists) {
                    model.addBookmark(siteBookmarks[i]);
                }
                ++i;
            }
            model.saveBookmarks();
            this.updateSearchRequest();
        }
    }

    private void handleExport() {
        SitesImportExport.exportBookmarks(this.getShell(), this.getAllSiteBookmarks());
    }

    private int handleNameEdit(SiteBookmark bookmark) {
        EditSiteDialog dialog = new EditSiteDialog(this.getShell(), bookmark, this.getAllSiteBookmarks(), true);
        dialog.create();
        String title = bookmark.isLocal() ? UpdateUIMessages.SitePage_dialogEditLocal : UpdateUIMessages.SitePage_dialogEditUpdateSite;
        dialog.getShell().setText(title);
        int rc = dialog.open();
        return rc;
    }

    private void handleSiteChecked(SiteBookmark bookmark, boolean checked) {
        if (bookmark.isUnavailable()) {
            bookmark.setSelected(false);
            this.viewer.setChecked((Object)bookmark, false);
            return;
        }
        bookmark.setSelected(checked);
        this.updateSearchRequest();
    }

    private void handleSelectionChanged(IStructuredSelection ssel) {
        boolean enable = false;
        Object item = ssel.getFirstElement();
        String description = null;
        if (item instanceof SiteBookmark) {
            enable = !((SiteBookmark)item).isReadOnly();
            description = ((SiteBookmark)item).getDescription();
        } else {
            boolean cfr_ignored_0 = item instanceof SiteCategory;
        }
        this.editButton.setEnabled(enable);
        this.removeButton.setEnabled(enable);
        if (description == null) {
            description = "";
        }
        this.descLabel.setText(UpdateManagerUtils.getWritableXMLString((String)description));
    }

    private void updateSearchRequest() {
        Object[] checked = this.viewer.getCheckedElements();
        UpdateSearchScope scope = new UpdateSearchScope();
        int nsites = 0;
        int i = 0;
        while (i < checked.length) {
            if (checked[i] instanceof SiteBookmark) {
                SiteBookmark bookmark = (SiteBookmark)checked[i];
                scope.addSearchSite(bookmark.getLabel(), bookmark.getURL(), bookmark.getIgnoredCategories());
                ++nsites;
            }
            ++i;
        }
        this.searchRequest.setScope(scope);
        this.setPageComplete(nsites > 0);
    }

    public UpdateSearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public void setVisible(boolean value) {
        super.setVisible(value);
        if (value) {
            SiteBookmark[] bookmarks = this.getAllSiteBookmarks();
            int i = 0;
            while (i < bookmarks.length) {
                if (bookmarks[i].isUnavailable()) {
                    bookmarks[i].setUnavailable(false);
                }
                ++i;
            }
        }
    }

    private SiteBookmark[] getAllSiteBookmarks() {
        UpdateModel model = UpdateUI.getDefault().getUpdateModel();
        SiteBookmark[] bookmarks = model.getBookmarkLeafs();
        Object[] sitesToVisit = discoveryFolder.getChildren(discoveryFolder);
        SiteBookmark[] all = new SiteBookmark[bookmarks.length + sitesToVisit.length];
        System.arraycopy(bookmarks, 0, all, 0, bookmarks.length);
        System.arraycopy(sitesToVisit, 0, all, bookmarks.length, sitesToVisit.length);
        return all;
    }

    public boolean isPageComplete() {
        return this.viewer.getCheckedElements().length != 0;
    }

    class ModelListener
    implements IUpdateModelChangedListener {
        ModelListener() {
        }

        public void objectChanged(Object object, String property) {
            SitePage.this.viewer.refresh();
            SitePage.this.checkItems();
        }

        public void objectsAdded(Object parent, Object[] children) {
            SitePage.this.viewer.refresh();
            SitePage.this.checkItems();
        }

        public void objectsRemoved(Object parent, Object[] children) {
            SitePage.this.viewer.refresh();
            SitePage.this.checkItems();
        }
    }

    class SitesLabelProvider
    extends LabelProvider {
        SitesLabelProvider() {
        }

        public Image getImage(Object obj) {
            if (obj instanceof SiteBookmark) {
                return UpdateUI.getDefault().getLabelProvider().get(UpdateUIImages.DESC_SITE_OBJ);
            }
            return super.getImage(obj);
        }

        public String getText(Object obj) {
            if (obj instanceof SiteBookmark) {
                return ((SiteBookmark)obj).getLabel();
            }
            return super.getText(obj);
        }
    }
}

