/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.contentassist;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.debug.ui.contentassist.IJavaDebugContentAssistContext;
import org.eclipse.jdt.internal.debug.ui.contentassist.JavaDebugCompletionProposalCollector;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.JavaParameterListValidator;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.TemplateContextType;

public class JavaDebugContentAssistProcessor
implements IContentAssistProcessor {
    private JavaDebugCompletionProposalCollector fCollector;
    private IContextInformationValidator fValidator;
    private TemplateEngine fTemplateEngine;
    private String fErrorMessage = null;
    private char[] fProposalAutoActivationSet;
    private CompletionProposalComparator fComparator;
    private IJavaDebugContentAssistContext fContext;

    public JavaDebugContentAssistProcessor(IJavaDebugContentAssistContext context) {
        this.fContext = context;
        TemplateContextType contextType = JavaPlugin.getDefault().getTemplateContextRegistry().getContextType("java");
        if (contextType != null) {
            this.fTemplateEngine = new TemplateEngine(contextType);
        }
        this.fComparator = new CompletionProposalComparator();
    }

    public String getErrorMessage() {
        if (this.fErrorMessage != null) {
            return this.fErrorMessage;
        }
        if (this.fCollector != null) {
            return this.fCollector.getErrorMessage();
        }
        return null;
    }

    private void setErrorMessage(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.fErrorMessage = string;
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new JavaParameterListValidator();
        }
        return this.fValidator;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        this.setErrorMessage(null);
        try {
            try {
                IType type = this.fContext.getType();
                IJavaProject project = type.getJavaProject();
                String[][] locals = this.fContext.getLocalVariables();
                int numLocals = 0;
                if (locals.length > 0) {
                    numLocals = locals[0].length;
                }
                char[][] localVariableNames = new char[numLocals][];
                char[][] localVariableTypeNames = new char[numLocals][];
                int i = 0;
                while (true) {
                    if (i >= numLocals) {
                        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
                        this.configureResultCollector(project, selection);
                        int[] localModifiers = new int[localVariableNames.length];
                        Arrays.fill(localModifiers, 0);
                        String snippet = viewer.getDocument().get();
                        char[] charSnippet = this.fContext.getSnippet(snippet).toCharArray();
                        type.codeComplete(charSnippet, this.fContext.getInsertionPosition(), documentOffset, localVariableTypeNames, localVariableNames, localModifiers, this.fContext.isStatic(), (CompletionRequestor)this.fCollector);
                        IJavaCompletionProposal[] results = this.fCollector.getJavaCompletionProposals();
                        if (this.fTemplateEngine != null) {
                            this.fTemplateEngine.reset();
                            this.fTemplateEngine.complete(viewer, documentOffset, null);
                            TemplateProposal[] templateResults = this.fTemplateEngine.getResults();
                            IJavaCompletionProposal[] total = new IJavaCompletionProposal[results.length + templateResults.length];
                            System.arraycopy(templateResults, 0, total, 0, templateResults.length);
                            System.arraycopy(results, 0, total, templateResults.length, results.length);
                            results = total;
                        }
                        IJavaCompletionProposal[] iJavaCompletionProposalArray = this.order(results);
                        Object var16_19 = null;
                        this.releaseCollector();
                        return iJavaCompletionProposalArray;
                    }
                    localVariableNames[i] = locals[0][i].toCharArray();
                    localVariableTypeNames[i] = locals[1][i].toCharArray();
                    ++i;
                }
            }
            catch (CoreException x) {
                this.setErrorMessage(x.getStatus().getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            this.releaseCollector();
            throw throwable;
        }
        {
            Object var16_21 = null;
            this.releaseCollector();
            return null;
        }
    }

    private IJavaCompletionProposal[] order(IJavaCompletionProposal[] proposals) {
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    private void configureResultCollector(IJavaProject project, ITextSelection selection) {
        this.fCollector = new JavaDebugCompletionProposalCollector(project);
        if (selection.getLength() != 0) {
            this.fCollector.setReplacementLength(selection.getLength());
        }
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator.setOrderAlphabetically(order);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    private void releaseCollector() {
        if (this.fCollector != null && this.fCollector.getErrorMessage().length() > 0 && this.fErrorMessage != null) {
            this.setErrorMessage(this.fCollector.getErrorMessage());
        }
        this.fCollector = null;
    }
}

