/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.debugger;

public class DebugError
implements Cloneable {
    public static final int DEFAULT_ID = -1;
    private int id = -1;
    private int code = 1;
    private String fileName = "";
    private int lineNumber = -1;
    private String text = "";
    private static String[] codeToName = new String[]{"Debug Error", "Debug Warning", "Parsing Error", "Notice", "Fatal Error", "Core Warning", "Compile Error", "Compile Warning", "User Error", "User Warning", "User Notice", "Debug Strict (PHP 5)"};

    public static boolean isNotice(DebugError debugError) {
        int n = DebugError.getErrorIndex(debugError.getCode());
        return n == 3 || n == 10;
    }

    public static boolean isWarning(DebugError debugError) {
        int n = DebugError.getErrorIndex(debugError.getCode());
        return n == 1 || n == 5 || n == 7 || n == 9;
    }

    public static boolean isError(DebugError debugError) {
        int n = DebugError.getErrorIndex(debugError.getCode());
        return n == 0 || n == 2 || n == 4 || n == 6 || n == 8;
    }

    public static boolean isStrict(DebugError debugError) {
        int n = DebugError.getErrorIndex(debugError.getCode());
        return n == 11;
    }

    private static int getErrorIndex(int n) {
        int n2 = (int)(Math.log(n) / Math.log(2.0));
        return n2;
    }

    private static String getErrorName(int n) {
        int n2 = DebugError.getErrorIndex(n);
        return codeToName[n2];
    }

    public DebugError() {
    }

    public DebugError(int n, String string, int n2, String string2) {
        this();
        this.code = n;
        this.fileName = string;
        this.lineNumber = n2;
        this.text = string2;
    }

    public void setID(int n) {
        this.id = n;
    }

    public int getID() {
        return this.id;
    }

    public void setCode(int n) {
        this.code = n;
    }

    public int getCode() {
        return this.code;
    }

    public String getCodeName() {
        return DebugError.getErrorName(this.code);
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setErrorText(String string) {
        this.text = string;
    }

    public String getErrorText() {
        return this.text;
    }

    public Object clone() throws CloneNotSupportedException {
        return (DebugError)super.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getCodeName());
        if (this.lineNumber >= 0) {
            stringBuffer.append(": ");
            stringBuffer.append(this.getFileName());
            stringBuffer.append(" line ");
            stringBuffer.append(this.lineNumber);
        }
        stringBuffer.append(" - " + this.getErrorText());
        return stringBuffer.toString();
    }

    public int getErrorTextLength() {
        return (" - " + this.getErrorText()).length();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof DebugError) {
            DebugError debugError = (DebugError)object;
            bl = this.code == debugError.code && this.fileName.equals(debugError.fileName) && this.lineNumber == debugError.lineNumber && this.text.equals(debugError.text);
        }
        return bl;
    }
}

