/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.phpModel.parser.management;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.php.core.phpModel.parser.IParserClientFactory;
import org.eclipse.php.core.phpModel.parser.PHPLanguageManager;
import org.eclipse.php.core.phpModel.parser.PHPLanguageManagerProvider;
import org.eclipse.php.core.phpModel.parser.PHPUserModelManager;
import org.eclipse.php.core.phpModel.parser.ParserClient;
import org.eclipse.php.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.core.project.properties.handlers.PhpVersionChangedHandler;
import org.eclipse.php.core.project.properties.handlers.PhpVersionProjectPropertyHandler;
import org.eclipse.php.core.util.project.observer.IProjectClosedObserver;
import org.eclipse.php.core.util.project.observer.ProjectRemovedObserversAttacher;

public class UserModelParserClientFactoryVersionDependent
implements IParserClientFactory {
    private String phpVersion;
    private PhpVersionListener phpVersionListener;
    private Map version2ParserClientMap = new HashMap();
    private PHPUserModelManager userModelManager;
    private IProjectClosedObserver projectChangeObserver;

    public UserModelParserClientFactoryVersionDependent(PHPUserModelManager pHPUserModelManager) {
        this.userModelManager = pHPUserModelManager;
        this.phpVersion = PhpVersionProjectPropertyHandler.getVersion(pHPUserModelManager.getProject());
        this.initVersionChangeListener();
    }

    private void initVersionChangeListener() {
        this.phpVersionListener = new PhpVersionListener();
        PhpVersionChangedHandler.getInstance().addPhpVersionChangedListener(this.phpVersionListener);
        this.projectChangeObserver = new IProjectClosedObserver(){

            public void closed() {
                PhpVersionChangedHandler.getInstance().removePhpVersionChangedListener(UserModelParserClientFactoryVersionDependent.this.phpVersionListener);
            }
        };
        ProjectRemovedObserversAttacher.getInstance().addProjectClosedObserver(this.userModelManager.getProject(), this.projectChangeObserver);
    }

    public ParserClient create() {
        Object v = this.version2ParserClientMap.get(this.phpVersion);
        if (v == null) {
            PHPLanguageManager pHPLanguageManager = PHPLanguageManagerProvider.instance().getPHPLanguageManager(this.phpVersion);
            ParserClient parserClient = pHPLanguageManager.createParserClient(this.userModelManager.getUserModel());
            this.version2ParserClientMap.put(this.phpVersion, parserClient);
            return parserClient;
        }
        return (ParserClient)v;
    }

    public boolean isParsable(String string, int n) {
        return (n & 1) == 0 || this.userModelManager.shouldParse(string);
    }

    private class PhpVersionListener
    implements IPreferencesPropagatorListener {
        private PhpVersionListener() {
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent preferencesPropagatorEvent) {
            UserModelParserClientFactoryVersionDependent.this.phpVersion = (String)preferencesPropagatorEvent.getNewValue();
        }

        public IProject getProject() {
            return UserModelParserClientFactoryVersionDependent.this.userModelManager.getProject();
        }
    }
}

