/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit4.runner;

import org.eclipse.jdt.internal.junit.runner.IListensToTestExecutions;
import org.eclipse.jdt.internal.junit.runner.ITestIdentifier;
import org.eclipse.jdt.internal.junit.runner.TestReferenceFailure;
import org.eclipse.jdt.internal.junit4.runner.FailureException;
import org.eclipse.jdt.internal.junit4.runner.JUnit4Identifier;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnit4TestListener
extends RunListener {
    private final IListensToTestExecutions fNotified;

    public JUnit4TestListener(IListensToTestExecutions notified) {
        this.fNotified = notified;
    }

    public void testStarted(Description plan) throws Exception {
        this.fNotified.notifyTestStarted(this.getIdentifier(plan));
    }

    public void testFailure(Failure failure) throws Exception {
        String status = new FailureException(failure.getException()).getStatus();
        this.fNotified.notifyTestFailed(new TestReferenceFailure(this.getIdentifier(failure.getDescription()), status, failure.getTrace()));
    }

    public void testIgnored(Description plan) throws Exception {
        IgnoredTestIdentifier identifier = new IgnoredTestIdentifier(plan);
        this.fNotified.notifyTestStarted((ITestIdentifier)identifier);
        this.fNotified.notifyTestEnded((ITestIdentifier)identifier);
    }

    public void testFinished(Description plan) throws Exception {
        this.fNotified.notifyTestEnded(this.getIdentifier(plan));
    }

    private ITestIdentifier getIdentifier(Description plan) {
        return new JUnit4Identifier(plan);
    }

    private static class IgnoredTestIdentifier
    extends JUnit4Identifier {
        public IgnoredTestIdentifier(Description description) {
            super(description);
        }

        public String getName() {
            String name = super.getName();
            if (name != null) {
                return "@Ignore: " + name;
            }
            return null;
        }
    }
}

