/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.util;

import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.phpModel.phpElementData.BasicPHPDocTag;
import org.eclipse.php.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.core.phpModel.phpElementData.PHPDocBlockImp;
import org.eclipse.php.core.phpModel.phpElementData.PHPDocTag;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.core.phpModel.phpElementData.PHPIncludeFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPVariableData;

public class PHPDocTool {
    public static PHPDocBlock createPhpDoc(CodeData codeData, IDocument iDocument) {
        return PHPDocTool.createPhpDoc(codeData, null, iDocument);
    }

    public static PHPDocBlock createPhpDoc(CodeData codeData, String string, IDocument iDocument) {
        PHPDocBlock pHPDocBlock = PHPDocTool.createDocBlock(codeData);
        if (string != null) {
            pHPDocBlock.setShortDescription(string);
        }
        return pHPDocBlock;
    }

    private static PHPDocBlock createDocBlock(CodeData codeData) {
        if (codeData instanceof PHPFunctionData) {
            return PHPDocTool.createFunctionDocBlock((PHPFunctionData)codeData);
        }
        if (codeData instanceof PHPClassData) {
            return PHPDocTool.createClassDocBlock();
        }
        if (codeData instanceof PHPFileData) {
            return PHPDocTool.createFileDocBlock();
        }
        if (codeData instanceof PHPClassVarData) {
            return PHPDocTool.createClassVarDocBlock();
        }
        if (codeData instanceof PHPVariableData) {
            return PHPDocTool.createVarDocBlock((PHPVariableData)codeData);
        }
        if (codeData instanceof PHPConstantData) {
            return PHPDocTool.createConstantDocBlock();
        }
        if (codeData instanceof PHPIncludeFileData) {
            return PHPDocTool.createIncludeDocBlock();
        }
        if (codeData instanceof PHPClassConstData) {
            return PHPDocTool.createClassConstantDocBlock();
        }
        return null;
    }

    private static PHPDocBlock createFunctionDocBlock(PHPFunctionData pHPFunctionData) {
        Object object;
        PHPFunctionData.PHPFunctionParameter[] pHPFunctionParameterArray = pHPFunctionData.getParameters();
        ArrayList<BasicPHPDocTag> arrayList = new ArrayList<BasicPHPDocTag>(pHPFunctionParameterArray.length + 1);
        int n = 0;
        while (n < pHPFunctionParameterArray.length) {
            object = String.valueOf('$') + pHPFunctionParameterArray[n].getName();
            object = pHPFunctionParameterArray[n].getClassType() != null ? String.valueOf(pHPFunctionParameterArray[n].getClassType()) + ' ' + (String)object : "unknown_type " + (String)object;
            BasicPHPDocTag basicPHPDocTag = new BasicPHPDocTag(7, (String)object);
            arrayList.add(basicPHPDocTag);
            ++n;
        }
        String string = pHPFunctionData.getReturnType();
        if (string == null) {
            string = "unknown";
        } else if (!string.equals("void")) {
            object = new BasicPHPDocTag(6, string);
            arrayList.add((BasicPHPDocTag)object);
        }
        object = new PHPDocTag[arrayList.size()];
        arrayList.toArray((T[])object);
        return new PHPDocBlockImp(null, null, (PHPDocTag[])object, 2);
    }

    private static PHPDocBlock createClassDocBlock() {
        return new PHPDocBlockImp(null, null, null, 1);
    }

    private static PHPDocBlock createFileDocBlock() {
        BasicPHPDocTag basicPHPDocTag = new BasicPHPDocTag(13, "defaultPackage");
        BasicPHPDocTag basicPHPDocTag2 = new BasicPHPDocTag(1, System.getProperty("user.name"));
        PHPDocTag[] pHPDocTagArray = new PHPDocTag[]{basicPHPDocTag2, basicPHPDocTag};
        return new PHPDocBlockImp(null, null, pHPDocTagArray, 0);
    }

    private static PHPDocBlock createClassVarDocBlock() {
        int n = 9;
        BasicPHPDocTag basicPHPDocTag = new BasicPHPDocTag(12, "unknown_type");
        PHPDocTag[] pHPDocTagArray = new PHPDocTag[]{basicPHPDocTag};
        return new PHPDocBlockImp(null, null, pHPDocTagArray, n);
    }

    private static PHPDocBlock createVarDocBlock(PHPVariableData pHPVariableData) {
        BasicPHPDocTag basicPHPDocTag = null;
        int n = 3;
        if (pHPVariableData.isGlobal()) {
            basicPHPDocTag = new BasicPHPDocTag(4, pHPVariableData.getName());
            n = 4;
        }
        PHPDocTag[] pHPDocTagArray = null;
        if (basicPHPDocTag != null) {
            pHPDocTagArray = new PHPDocTag[]{basicPHPDocTag};
        }
        return new PHPDocBlockImp(null, null, pHPDocTagArray, n);
    }

    private static PHPDocBlock createConstantDocBlock() {
        return new PHPDocBlockImp(null, null, null, 5);
    }

    private static PHPDocBlock createIncludeDocBlock() {
        return new PHPDocBlockImp(null, null, null, 7);
    }

    private static PHPDocBlock createClassConstantDocBlock() {
        return new PHPDocBlockImp(null, null, null, 5);
    }
}

