/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.text.Assert;
import org.eclipse.php.internal.ui.folding.EmptyPHPFoldingPreferenceBlock;
import org.eclipse.php.ui.folding.IPHPFoldingPreferenceBlock;
import org.eclipse.wst.sse.ui.internal.projection.IStructuredTextFoldingProvider;

public final class PHPFoldingStructureProviderDescriptor {
    private static final String PREFERENCES_CLASS = "preferencesClass";
    private static final String CLASS = "class";
    private static final String NAME = "name";
    private static final String ID = "id";
    private String fId;
    private String fName;
    private String fClass;
    private boolean fHasPreferences;
    private IConfigurationElement fElement;

    PHPFoldingStructureProviderDescriptor(IConfigurationElement iConfigurationElement) {
        this.fElement = iConfigurationElement;
        this.fId = iConfigurationElement.getAttributeAsIs(ID);
        Assert.isLegal((this.fId != null ? 1 : 0) != 0);
        this.fName = iConfigurationElement.getAttribute(NAME);
        if (this.fName == null) {
            this.fName = this.fId;
        }
        this.fClass = iConfigurationElement.getAttributeAsIs(CLASS);
        Assert.isLegal((this.fClass != null ? 1 : 0) != 0);
        this.fHasPreferences = iConfigurationElement.getAttributeAsIs(PREFERENCES_CLASS) != null;
    }

    public IStructuredTextFoldingProvider createProvider() throws CoreException {
        IStructuredTextFoldingProvider iStructuredTextFoldingProvider = (IStructuredTextFoldingProvider)this.fElement.createExecutableExtension(CLASS);
        return iStructuredTextFoldingProvider;
    }

    public IPHPFoldingPreferenceBlock createPreferences() throws CoreException {
        if (this.fHasPreferences) {
            IPHPFoldingPreferenceBlock iPHPFoldingPreferenceBlock = (IPHPFoldingPreferenceBlock)this.fElement.createExecutableExtension(PREFERENCES_CLASS);
            return iPHPFoldingPreferenceBlock;
        }
        return new EmptyPHPFoldingPreferenceBlock();
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }
}

