/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.editor.hover;

import java.io.Reader;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.php.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.ui.editor.highlighter.PHPLineStyleProvider;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class PHPSourceViewerInformationControl
implements IInformationControl,
IInformationControlExtension,
DisposeListener {
    private static final int BORDER = 1;
    private Shell fShell;
    private StyledText fText;
    private SourceViewer fViewer;
    private Label fStatusField;
    private Label fSeparator;
    private Font fStatusTextFont;
    private int fMaxWidth = -1;
    private int fMaxHeight = -1;
    private Dictionary fContextStyleMap = null;
    private IStructuredDocumentRegion fNodes = null;
    private RegionParser fParser = null;
    private PHPLineStyleProvider styleProvider;
    private String fInput = "";

    public void setParser(RegionParser regionParser) {
        this.fParser = regionParser;
    }

    public void setContextStyleMap(Dictionary dictionary) {
        this.fContextStyleMap = dictionary;
    }

    public Dictionary getContextStyleMap() {
        return this.fContextStyleMap;
    }

    public RegionParser getParser() {
        return this.fParser;
    }

    public TextAttribute getAttribute(String string) {
        TextAttribute textAttribute = new TextAttribute(this.fText.getBackground(), this.fText.getForeground(), 0);
        if (string != null && this.styleProvider != null) {
            textAttribute = this.styleProvider.getTextAttributeForColor(string);
        }
        return textAttribute;
    }

    public void applyStyles() {
        if (this.fText == null || this.fText.isDisposed() || this.fInput == null || this.fInput.length() == 0) {
            return;
        }
        IStructuredDocumentRegion iStructuredDocumentRegion = this.fNodes;
        while (iStructuredDocumentRegion != null) {
            ITextRegionList iTextRegionList = iStructuredDocumentRegion.getRegions();
            int n = 0;
            while (n < iTextRegionList.size()) {
                TextAttribute textAttribute;
                ITextRegion iTextRegion = iTextRegionList.get(n);
                String string = (String)this.getContextStyleMap().get(iTextRegion.getType());
                if (string != null && (textAttribute = this.getAttribute(string)) != null) {
                    StyleRange styleRange = new StyleRange(iStructuredDocumentRegion.getStartOffset(iTextRegion), iTextRegion.getLength(), textAttribute.getForeground(), textAttribute.getBackground(), textAttribute.getStyle());
                    if ((textAttribute.getStyle() & 0x40000000) != 0) {
                        styleRange.underline = true;
                        styleRange.fontStyle &= 0xBFFFFFFF;
                    }
                    this.fText.setStyleRange(styleRange);
                }
                ++n;
            }
            iStructuredDocumentRegion = iStructuredDocumentRegion.getNext();
        }
    }

    public void initColorsMap() {
        IModelManager iModelManager = StructuredModelManager.getModelManager();
        this.setParser(iModelManager.createStructuredDocumentFor(ContentTypeIdForPHP.ContentTypeID_PHP).getParser());
        this.styleProvider = new PHPLineStyleProvider();
        Hashtable hashtable = new Hashtable(this.styleProvider.getColorTypesMap());
        this.setContextStyleMap(hashtable);
    }

    public PHPSourceViewerInformationControl(Shell shell, int n, int n2) {
        this(shell, n, n2, null);
    }

    public PHPSourceViewerInformationControl(Shell shell, int n, int n2, String string) {
        int n3;
        this.fShell = new Shell(shell, 0x84000 | n);
        Display display = this.fShell.getDisplay();
        this.fShell.setBackground(display.getSystemColor(2));
        Shell shell2 = this.fShell;
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = n3 = (n & 8) == 0 ? 0 : 1;
        gridLayout.marginWidth = n3;
        shell2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        shell2.setLayoutData((Object)gridData);
        if (string != null) {
            shell2 = new Composite((Composite)shell2, 0);
            gridLayout = new GridLayout(1, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            shell2.setLayout((Layout)gridLayout);
            gridData = new GridData(1808);
            shell2.setLayoutData((Object)gridData);
            shell2.setForeground(display.getSystemColor(28));
            shell2.setBackground(display.getSystemColor(29));
        }
        this.fViewer = new ProjectionViewer((Composite)shell2, null, null, false, n2);
        this.fViewer.setEditable(false);
        this.fText = this.fViewer.getTextWidget();
        gridData = new GridData(1809);
        this.fText.setLayoutData((Object)gridData);
        this.fText.setForeground(shell.getDisplay().getSystemColor(28));
        this.fText.setBackground(shell.getDisplay().getSystemColor(29));
        this.initializeFont();
        this.fText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\u001b') {
                    PHPSourceViewerInformationControl.this.fShell.dispose();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        if (string != null) {
            this.fSeparator = new Label((Composite)shell2, 259);
            this.fSeparator.setLayoutData((Object)new GridData(768));
            this.fStatusField = new Label((Composite)shell2, 131072);
            this.fStatusField.setText(string);
            Font font = this.fStatusField.getFont();
            FontData[] fontDataArray = font.getFontData();
            int n4 = 0;
            while (n4 < fontDataArray.length) {
                fontDataArray[n4].setHeight(fontDataArray[n4].getHeight() * 9 / 10);
                ++n4;
            }
            this.fStatusTextFont = new Font((Device)this.fStatusField.getDisplay(), fontDataArray);
            this.fStatusField.setFont(this.fStatusTextFont);
            GridData gridData2 = new GridData(1842);
            this.fStatusField.setLayoutData((Object)gridData2);
            this.fStatusField.setForeground(display.getSystemColor(17));
            this.fStatusField.setBackground(display.getSystemColor(29));
        }
        this.initColorsMap();
        this.addDisposeListener(this);
    }

    public PHPSourceViewerInformationControl(Shell shell, int n) {
        this(shell, 12, n);
    }

    public PHPSourceViewerInformationControl(Shell shell, int n, String string) {
        this(shell, 12, n, string);
    }

    public PHPSourceViewerInformationControl(Shell shell) {
        this(shell, 0);
    }

    public PHPSourceViewerInformationControl(Shell shell, String string) {
        this(shell, 0, string);
    }

    private void initializeFont() {
        Font font = JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont");
        StyledText styledText = this.getViewer().getTextWidget();
        styledText.setFont(font);
    }

    public void setInput(Object object) {
        if (object instanceof String) {
            this.setInformation((String)object);
        } else {
            this.setInformation(null);
        }
    }

    public void setInformation(String string) {
        if (string == null) {
            this.fViewer.setInput(null);
            return;
        }
        this.fInput = string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?");
        stringBuffer.append(string);
        stringBuffer.append("?>");
        Document document = new Document(stringBuffer.toString());
        DocumentReader documentReader = new DocumentReader((IDocument)document);
        this.getParser().reset((Reader)documentReader);
        IStructuredDocumentRegion iStructuredDocumentRegion = this.getParser().getDocumentRegions();
        iStructuredDocumentRegion = iStructuredDocumentRegion.getNext();
        if (iStructuredDocumentRegion.getNext() != null) {
            this.fNodes = iStructuredDocumentRegion;
            do {
                iStructuredDocumentRegion.adjustStart(-2);
            } while ((iStructuredDocumentRegion = iStructuredDocumentRegion.getNext()).getNext() != null);
            iStructuredDocumentRegion.getPrevious().setNext(null);
        }
        document = new Document(this.fInput);
        document.setDocumentPartitioner((IDocumentPartitioner)new PHPStructuredTextPartitioner());
        this.fViewer.setInput((Object)document);
        this.applyStyles();
    }

    public void setVisible(boolean bl) {
        this.fShell.setVisible(bl);
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        if (this.fStatusTextFont != null && !this.fStatusTextFont.isDisposed()) {
            this.fStatusTextFont.dispose();
        }
        this.fStatusTextFont = null;
        this.fShell = null;
        this.fText = null;
    }

    public final void dispose() {
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        } else {
            this.widgetDisposed(null);
        }
    }

    public void setSize(int n, int n2) {
        if (this.fStatusField != null) {
            GridData gridData = (GridData)this.fViewer.getTextWidget().getLayoutData();
            Point point = this.fStatusField.computeSize(-1, -1, true);
            Point point2 = this.fSeparator.computeSize(-1, -1, true);
            gridData.heightHint = n2 - point.y - point2.y;
        }
        this.fShell.setSize(n, n2);
        if (this.fStatusField != null) {
            this.fShell.pack(true);
        }
    }

    public void setLocation(Point point) {
        this.fShell.setLocation(point);
    }

    public void setSizeConstraints(int n, int n2) {
        this.fMaxWidth = n;
        this.fMaxHeight = n2;
    }

    public Point computeSizeHint() {
        int n = -1;
        int n2 = -1;
        Point point = this.fShell.computeSize(n, n2);
        if (point.x > this.fMaxWidth) {
            n = this.fMaxWidth;
        }
        if (point.y > this.fMaxHeight) {
            n2 = this.fMaxHeight;
        }
        if (n != -1 || n2 != -1) {
            point = this.fShell.computeSize(n, n2, false);
        }
        return point;
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.fShell.addDisposeListener(disposeListener);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.fShell.removeDisposeListener(disposeListener);
    }

    public void setForegroundColor(Color color) {
        this.fText.setForeground(color);
    }

    public void setBackgroundColor(Color color) {
        this.fText.setBackground(color);
    }

    public boolean isFocusControl() {
        return this.fText.isFocusControl();
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fText.setFocus();
    }

    public void addFocusListener(FocusListener focusListener) {
        this.fText.addFocusListener(focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.fText.removeFocusListener(focusListener);
    }

    public boolean hasContents() {
        return this.fText.getCharCount() > 0;
    }

    protected ISourceViewer getViewer() {
        return this.fViewer;
    }
}

