/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/
/* The following code was generated by JFlex 1.2.2 on 5/14/06 2:39 PM */
/*nlsXXX*/
package org.eclipse.php.core.documentModel.parser;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.core.resources.IProject;
import org.eclipse.php.core.PHPCoreConstants;
import org.eclipse.php.core.documentModel.parser.Scanner.LexerState;
import org.eclipse.php.core.documentModel.parser.regions.PHPContentRegion;
import org.eclipse.php.core.documentModel.parser.regions.PHPRegionFactory;
import org.eclipse.php.core.documentModel.parser.regions.PHPRegionTypes;
import org.eclipse.php.core.preferences.TaskPatternsProvider;
import org.eclipse.php.core.project.properties.handlers.PhpVersionProjectPropertyHandler;
import org.eclipse.php.core.project.properties.handlers.UseAspTagsHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockTokenizer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.util.Debug;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.parser.IntStack;
import org.eclipse.wst.xml.core.internal.regions.DOMRegionContext;


/**
 * This class is a scanner generated by 
 * <a href="http://www.informatik.tu-muenchen.de/~kleing/jflex/">JFlex</a> 1.2.2
 * on 5/14/06 2:39 PM from the specification file
 * <tt>file:/C:/development/Parsers/parserUtils/highlighting/PHPTokenizer.jflex</tt>
 */
public class PHPTokenizer implements BlockTokenizer, PHPRegionContext, DOMRegionContext {

  /** this character denotes the end of file */
  final public static int YYEOF = -1;

  /** lexical states */
  final public static int ST_XML_DOCTYPE_EXTERNAL_ID = 12;
  final public static int ST_XML_ELEMENT_DECLARATION_CONTENT = 16;
  final public static int ST_XML_DECLARATION_CLOSE = 10;
  final public static int ST_XML_TAG_NAME = 5;
  final public static int ST_XML_ATTRIBUTE_VALUE = 8;
  final public static int ST_XML_DOCTYPE_ID_SYSTEM = 14;
  final public static int ST_XML_ATTRIBUTE_NAME = 6;
  final public static int ST_XML_DOCTYPE_DECLARATION = 11;
  final public static int ST_XML_ELEMENT_DECLARATION = 15;
  final public static int ST_XML_ATTLIST_DECLARATION = 17;
  final public static int ST_XML_COMMENT_END = 4;
  final public static int ST_CDATA_TEXT = 1;
  final public static int ST_XML_COMMENT = 3;
  final public static int ST_CDATA_END = 2;
  final public static int ST_XML_ATTLIST_DECLARATION_CONTENT = 18;
  final public static int ST_BLOCK_TAG_SCAN = 19;
  final public static int ST_XML_DECLARATION = 9;
  final public static int YYINITIAL = 0;
  final public static int ST_XML_EQUALS = 7;
  final public static int ST_XML_DOCTYPE_ID_PUBLIC = 13;

  /** 
   * Translates characters to character classes
   */
  final private static String yycmap_packed = 
    "\11\0\1\4\1\21\2\0\1\13\22\0\1\13\1\20\1\10\1\50"+
    "\1\15\1\16\1\11\1\12\1\15\1\15\1\15\1\15\1\15\1\6"+
    "\1\5\1\3\12\14\1\7\1\53\1\1\1\41\1\2\1\27\1\15"+
    "\1\25\1\54\1\23\1\24\1\34\1\51\1\33\1\60\1\36\1\33"+
    "\1\33\1\32\1\31\1\40\1\37\1\43\1\33\1\33\1\35\1\26"+
    "\1\52\2\33\1\33\1\42\1\33\1\22\1\0\1\17\1\0\1\7"+
    "\1\0\1\45\1\54\1\55\1\46\1\34\1\51\1\33\1\60\1\36"+
    "\2\33\1\32\1\31\1\40\1\37\1\43\1\33\1\33\1\35\1\44"+
    "\1\52\1\33\1\33\1\30\1\42\1\33\1\0\1\47\72\0\1\57"+
    "\10\0\27\56\1\0\37\56\1\0\72\56\2\0\13\56\2\0\10\56"+
    "\1\0\65\56\1\0\104\56\11\0\44\56\3\0\2\56\4\0\36\56"+
    "\70\0\131\56\22\0\7\56\16\0\2\57\56\0\106\57\32\0\2\57"+
    "\44\0\1\56\1\57\3\56\1\0\1\56\1\0\24\56\1\0\54\56"+
    "\1\0\7\56\3\0\1\56\1\0\1\56\1\0\1\56\1\0\1\56"+
    "\1\0\22\56\15\0\14\56\1\0\102\56\1\0\14\56\1\0\44\56"+
    "\1\0\4\57\11\0\65\56\2\0\2\56\2\0\2\56\3\0\34\56"+
    "\2\0\10\56\2\0\2\56\67\0\46\56\2\0\1\56\7\0\46\56"+
    "\12\0\21\57\1\0\27\57\1\0\3\57\1\0\1\57\1\0\2\57"+
    "\1\0\1\57\13\0\33\56\5\0\3\56\56\0\32\56\5\0\1\57"+
    "\12\56\10\57\15\0\12\57\6\0\1\57\107\56\2\0\5\56\1\0"+
    "\17\56\1\0\4\56\1\0\1\56\17\57\2\56\2\57\1\0\4\57"+
    "\2\0\12\57\u0207\0\3\57\1\0\65\56\2\0\1\57\1\56\20\57"+
    "\3\0\4\57\3\0\12\56\2\57\2\0\12\57\21\0\3\57\1\0"+
    "\10\56\2\0\2\56\2\0\26\56\1\0\7\56\1\0\1\56\3\0"+
    "\4\56\2\0\1\57\1\0\7\57\2\0\2\57\2\0\3\57\11\0"+
    "\1\57\4\0\2\56\1\0\3\56\2\57\2\0\12\57\2\56\20\0"+
    "\1\57\2\0\6\56\4\0\2\56\2\0\26\56\1\0\7\56\1\0"+
    "\2\56\1\0\2\56\1\0\2\56\2\0\1\57\1\0\5\57\4\0"+
    "\2\57\2\0\3\57\13\0\4\56\1\0\1\56\7\0\12\57\2\57"+
    "\3\56\14\0\3\57\1\0\7\56\1\0\1\56\1\0\3\56\1\0"+
    "\26\56\1\0\7\56\1\0\2\56\1\0\5\56\2\0\1\57\1\56"+
    "\10\57\1\0\3\57\1\0\3\57\22\0\1\56\5\0\12\57\21\0"+
    "\3\57\1\0\10\56\2\0\2\56\2\0\26\56\1\0\7\56\1\0"+
    "\2\56\2\0\4\56\2\0\1\57\1\56\6\57\3\0\2\57\2\0"+
    "\3\57\10\0\2\57\4\0\2\56\1\0\3\56\4\0\12\57\22\0"+
    "\2\57\1\0\6\56\3\0\3\56\1\0\4\56\3\0\2\56\1\0"+
    "\1\56\1\0\2\56\3\0\2\56\3\0\3\56\3\0\10\56\1\0"+
    "\3\56\4\0\5\57\3\0\3\57\1\0\4\57\11\0\1\57\17\0"+
    "\11\57\21\0\3\57\1\0\10\56\1\0\3\56\1\0\27\56\1\0"+
    "\12\56\1\0\5\56\4\0\7\57\1\0\3\57\1\0\4\57\7\0"+
    "\2\57\11\0\2\56\4\0\12\57\22\0\2\57\1\0\10\56\1\0"+
    "\3\56\1\0\27\56\1\0\12\56\1\0\5\56\4\0\7\57\1\0"+
    "\3\57\1\0\4\57\7\0\2\57\7\0\1\56\1\0\2\56\4\0"+
    "\12\57\22\0\2\57\1\0\10\56\1\0\3\56\1\0\27\56\1\0"+
    "\20\56\4\0\6\57\2\0\3\57\1\0\4\57\11\0\1\57\10\0"+
    "\2\56\4\0\12\57\221\0\56\56\1\0\1\56\1\57\2\56\7\57"+
    "\5\0\6\56\1\57\10\57\1\0\12\57\47\0\2\56\1\0\1\56"+
    "\2\0\2\56\1\0\1\56\2\0\1\56\6\0\4\56\1\0\7\56"+
    "\1\0\3\56\1\0\1\56\1\0\1\56\2\0\2\56\1\0\2\56"+
    "\1\0\1\56\1\57\2\56\6\57\1\0\2\57\1\56\2\0\5\56"+
    "\1\0\1\57\1\0\6\57\2\0\12\57\76\0\2\57\6\0\12\57"+
    "\13\0\1\57\1\0\1\57\1\0\1\57\4\0\2\57\10\56\1\0"+
    "\41\56\7\0\24\57\1\0\6\57\4\0\6\57\1\0\1\57\1\0"+
    "\25\57\3\0\7\57\1\0\1\57\346\0\46\56\12\0\47\56\11\0"+
    "\1\56\1\0\2\56\1\0\3\56\1\0\1\56\1\0\2\56\1\0"+
    "\5\56\51\0\1\56\1\0\1\56\1\0\1\56\13\0\1\56\1\0"+
    "\1\56\1\0\1\56\3\0\2\56\3\0\1\56\5\0\3\56\1\0"+
    "\1\56\1\0\1\56\1\0\1\56\1\0\1\56\3\0\2\56\3\0"+
    "\2\56\1\0\1\56\50\0\1\56\11\0\1\56\2\0\1\56\2\0"+
    "\2\56\7\0\2\56\1\0\1\56\1\0\7\56\50\0\1\56\4\0"+
    "\1\56\10\0\1\56\u0c06\0\234\56\4\0\132\56\6\0\26\56\2\0"+
    "\6\56\2\0\46\56\2\0\6\56\2\0\10\56\1\0\1\56\1\0"+
    "\1\56\1\0\1\56\1\0\37\56\2\0\65\56\1\0\7\56\1\0"+
    "\1\56\3\0\3\56\1\0\7\56\3\0\4\56\2\0\6\56\4\0"+
    "\15\56\5\0\3\56\1\0\7\56\323\0\15\57\4\0\1\57\104\0"+
    "\1\56\3\0\2\56\2\0\1\56\121\0\3\56\u0e82\0\1\57\1\0"+
    "\1\56\31\0\11\56\6\57\1\0\5\57\13\0\124\56\4\0\2\57"+
    "\2\0\2\57\2\0\132\56\1\0\3\57\6\0\50\56\u1cd3\0\u51a6\56"+
    "\u0c5a\0\u2ba4\56\134\0\u0800\0\u1ffe\0\2\0";

  /** 
   * Translates characters to character classes
   */
  final private static char [] yycmap = yy_unpack_cmap(yycmap_packed);

  /** 
   * Translates a state to a row index in the transition table
   */
  final private static int yy_rowMap [] = { 
        0,    49,    98,   147,   196,   245,   294,   343,   392,   441, 
      490,   539,   588,   637,   686,   735,   784,   833,   882,   931, 
      980,  1029,  1078,  1127,  1176,  1225,  1176,  1225,  1274,  1176, 
     1176,  1225,  1323,  1372,  1176,  1421,  1470,  1519,  1568,  1617, 
     1176,  1666,  1715,  1764,  1813,  1862,  1176,  1911,  1960,  2009, 
     2058,  2107,  2156,  2205,  2254,  2303,  2303,  2352,  2401,  2450, 
     2499,  2499,  2548,  2597,  2646,  2695,  2695,  2744,  2793,  2842, 
     2891,  1176,  2940,  2940,  2989,  3038,  3087,  3136,  1176,  1176, 
     1225,  1176,  1176,  3185,  3234,  3283,  3332,  3381,  3430,  3479, 
     3528,  3577,  1176,  1666,  3626,  1764,  1176,  3675,  1813,  3185, 
     3724,  3773,  3822,  2107,  1176,  3871,  3920,  2303,  3969,  2352, 
     1176,  4018,  4067,  4116,  4116,  4165,  4214,  2450,  2303,  2499, 
     4263,  2548,  1176,  4312,  2597,  2646,  2499,  2695,  4361,  2744, 
     1176,  4410,  4459,  4508,  4508,  4557,  4606,  4655,  2940,  4704, 
     2989,  1176,  4753,  4802,  4851,  4851,  4900,  4949,  4998,  5047, 
     5096,  5145,  5194,  5243,  5292,  1176,  5341,  5390,  1176,  1176, 
     1176,  5439,  5488,  5537,  5586,  5635,  4018,  5684,  5684,  4410, 
     5733,  5733,  5782,  4753,  5831,  5831,  5880,  1176,  5929,  5978, 
     6027,  1176,  6076,  6125,  6174,  6223,  6272,  6321,  4165,  4557, 
     6370,  4900,  6419,  6468,  5145,  6517,  6566,  6615,  6664,  6713, 
     6762,  6811,  6860,  6909,  6958,  7007,  1176,  1176,  7056,  7105, 
     7154,  1176,  1176,  1176,  7203,  7252,  7301,  7350,  7399,  1176, 
     2842,  3087
  };

  /** 
   * The packed transition table of the DFA
   */
  final private static String yy_packed = 
    "\1\25\1\26\7\25\1\27\4\25\1\30\42\25\1\31"+
    "\1\32\57\31\1\33\1\34\15\33\1\35\1\33\1\36"+
    "\37\33\1\37\1\40\57\37\1\33\1\34\4\33\1\41"+
    "\12\33\1\36\37\33\1\42\1\26\1\43\1\44\3\42"+
    "\1\45\13\42\4\46\1\42\11\46\1\42\5\46\2\42"+
    "\2\46\1\42\3\46\1\42\1\46\1\33\1\26\1\43"+
    "\1\44\1\47\2\33\1\50\3\33\1\47\5\33\1\47"+
    "\1\33\4\50\1\33\11\50\1\33\5\50\2\33\2\50"+
    "\1\33\3\50\1\33\1\50\1\33\1\26\1\43\1\44"+
    "\1\47\2\33\1\50\3\33\1\47\5\33\1\47\1\33"+
    "\4\50\1\33\11\50\1\51\5\50\2\33\2\50\1\33"+
    "\3\50\1\33\1\50\1\52\1\26\1\43\1\53\1\47"+
    "\3\52\1\54\1\52\1\55\1\47\5\52\1\47\37\52"+
    "\1\33\1\56\1\57\1\33\1\47\6\33\1\47\5\33"+
    "\1\47\2\33\1\60\1\61\6\33\1\62\10\33\1\61"+
    "\1\60\13\33\1\63\1\57\1\33\1\47\6\33\1\47"+
    "\5\33\1\47\1\64\37\33\1\63\1\57\1\33\1\47"+
    "\2\33\1\65\3\33\1\47\5\33\1\47\1\64\4\65"+
    "\1\33\11\65\1\33\5\65\2\33\2\65\1\33\3\65"+
    "\1\33\1\65\1\33\1\63\1\57\1\33\1\47\6\33"+
    "\1\47\5\33\1\47\1\64\12\33\1\66\5\33\1\67"+
    "\15\33\1\70\1\63\1\57\1\71\1\47\3\70\1\72"+
    "\1\70\1\73\1\47\5\70\1\47\1\74\36\70\1\75"+
    "\1\63\1\57\1\76\1\47\3\75\1\77\1\75\1\100"+
    "\1\47\5\75\1\47\1\101\36\75\1\102\1\63\1\57"+
    "\1\103\1\47\3\102\1\104\1\102\1\105\1\47\5\102"+
    "\1\47\37\102\1\106\1\107\1\110\56\106\1\111\1\63"+
    "\1\57\1\112\1\47\3\111\1\113\1\111\1\114\1\47"+
    "\5\111\1\47\37\111\1\115\1\116\1\117\56\115\1\120"+
    "\1\121\57\120\1\25\1\0\7\25\1\0\4\25\1\0"+
    "\42\25\3\0\1\122\12\0\1\123\1\0\1\124\6\0"+
    "\1\125\35\0\1\126\2\0\1\127\3\0\1\126\5\0"+
    "\1\126\1\0\4\127\1\0\11\127\1\0\5\127\1\0"+
    "\1\130\2\127\1\0\3\127\1\0\1\127\4\0\1\126"+
    "\2\0\1\131\3\0\1\126\5\0\1\126\1\0\4\131"+
    "\1\0\11\131\1\0\5\131\2\0\2\131\1\0\3\131"+
    "\1\0\1\131\101\0\1\132\57\0\1\133\47\0\1\134"+
    "\52\0\1\42\3\0\17\42\4\0\1\42\11\0\1\42"+
    "\5\0\2\42\2\0\1\42\3\0\1\42\3\0\1\135"+
    "\56\0\1\42\3\0\1\42\3\45\4\42\1\45\6\42"+
    "\4\46\1\42\11\46\1\42\5\46\2\42\2\46\1\42"+
    "\3\46\1\45\1\46\5\0\3\46\4\0\1\46\6\0"+
    "\4\46\1\0\11\46\1\0\5\46\2\0\2\46\1\0"+
    "\5\46\4\0\1\47\6\0\1\47\5\0\1\47\44\0"+
    "\3\50\4\0\1\50\6\0\4\50\1\0\11\50\1\0"+
    "\5\50\2\0\2\50\1\0\5\50\1\52\2\0\1\136"+
    "\1\0\3\52\1\0\1\52\2\0\5\52\1\0\40\52"+
    "\1\0\1\135\1\136\1\0\3\52\1\0\1\52\2\0"+
    "\5\52\1\0\37\52\1\54\1\0\1\137\1\140\1\137"+
    "\3\54\1\141\1\54\2\137\5\54\1\137\37\54\1\55"+
    "\1\0\1\142\1\143\1\142\3\55\1\142\1\55\1\141"+
    "\1\142\5\55\1\142\37\55\3\0\1\122\12\0\1\123"+
    "\1\0\1\144\6\0\1\125\70\0\1\145\47\0\1\146"+
    "\15\0\1\146\46\0\1\147\44\0\1\123\1\0\1\132"+
    "\6\0\1\125\31\0\17\150\1\151\41\150\5\0\3\65"+
    "\4\0\1\65\6\0\4\65\1\0\11\65\1\0\5\65"+
    "\2\0\2\65\1\0\5\65\42\0\1\152\70\0\1\153"+
    "\6\0\1\70\2\0\1\154\1\0\3\70\1\0\1\70"+
    "\2\0\5\70\1\0\37\70\1\72\1\0\1\155\1\156"+
    "\1\155\3\72\1\157\1\72\2\155\5\72\1\155\37\72"+
    "\1\160\1\0\1\161\1\162\1\161\3\163\1\161\1\160"+
    "\1\164\1\165\3\163\1\160\1\163\1\165\1\160\24\163"+
    "\1\160\6\163\2\160\1\163\1\74\2\150\1\166\1\150"+
    "\3\74\1\150\1\74\2\150\3\74\1\167\1\74\1\150"+
    "\37\74\1\75\2\0\1\170\1\0\3\75\1\0\1\75"+
    "\2\0\5\75\1\0\37\75\1\77\2\171\1\172\1\171"+
    "\3\77\1\173\1\77\2\171\5\77\1\171\37\77\1\100"+
    "\2\174\1\175\1\174\3\100\1\174\1\100\1\173\1\174"+
    "\5\100\1\174\37\100\1\101\2\150\1\176\1\150\3\101"+
    "\1\150\1\101\2\150\3\101\1\177\1\101\1\150\37\101"+
    "\1\102\2\0\1\200\1\0\3\102\1\0\1\102\2\0"+
    "\5\102\1\0\37\102\1\104\1\0\1\201\1\202\1\201"+
    "\3\104\1\203\1\104\2\201\5\104\1\201\37\104\1\204"+
    "\1\0\1\205\1\206\1\205\3\207\1\205\1\204\1\210"+
    "\1\211\3\207\1\204\1\207\1\211\1\204\24\207\1\204"+
    "\6\207\2\204\1\207\2\106\1\0\60\106\1\0\15\106"+
    "\1\212\40\106\1\111\2\0\1\213\1\0\3\111\1\0"+
    "\1\111\2\0\5\111\1\0\37\111\1\113\1\0\1\214"+
    "\1\215\1\214\3\113\1\216\1\113\2\214\5\113\1\214"+
    "\37\113\1\217\1\0\1\220\1\221\1\220\3\222\1\220"+
    "\1\217\1\223\1\224\3\222\1\217\1\222\1\224\1\217"+
    "\24\222\1\217\6\222\2\217\1\222\2\115\1\0\60\115"+
    "\1\0\15\115\1\225\40\115\6\0\1\226\13\0\1\227"+
    "\42\0\1\230\6\0\1\230\5\0\1\230\21\0\1\231"+
    "\21\0\1\126\2\0\1\25\3\0\1\126\5\0\1\126"+
    "\1\0\4\25\1\0\11\25\1\0\5\25\2\0\2\25"+
    "\1\0\3\25\1\0\1\25\1\232\1\0\2\232\1\233"+
    "\3\127\1\232\1\0\1\232\1\233\1\127\1\232\1\0"+
    "\2\232\1\233\1\232\4\127\1\232\11\127\1\232\5\127"+
    "\2\232\2\127\1\234\5\127\14\0\1\235\13\0\1\236"+
    "\30\0\1\232\1\0\2\232\1\233\3\131\1\232\1\0"+
    "\1\232\1\233\1\131\1\232\1\0\2\232\1\233\1\232"+
    "\4\131\1\232\11\131\1\232\5\131\2\232\2\131\1\237"+
    "\5\131\22\0\1\227\40\0\1\240\60\0\1\241\56\0"+
    "\1\137\1\0\6\137\1\141\50\137\1\142\1\0\10\142"+
    "\1\141\46\142\23\0\1\242\31\0\1\242\31\0\1\243"+
    "\15\0\1\243\50\0\1\244\61\0\1\245\77\0\1\246"+
    "\4\0\1\155\1\0\6\155\1\157\50\155\1\160\1\0"+
    "\1\161\1\247\1\161\3\160\1\161\1\160\1\157\1\161"+
    "\5\160\1\161\37\160\1\161\1\0\10\161\1\157\46\161"+
    "\1\160\1\0\1\161\1\247\1\161\3\160\1\161\1\160"+
    "\1\250\1\161\5\160\1\161\37\160\12\0\1\251\46\0"+
    "\1\161\1\0\10\161\1\250\46\161\10\171\1\173\50\171"+
    "\12\174\1\173\46\174\1\201\1\0\6\201\1\203\50\201"+
    "\1\204\1\0\1\205\1\252\1\205\3\204\1\205\1\204"+
    "\1\203\1\205\5\204\1\205\37\204\1\205\1\0\10\205"+
    "\1\203\46\205\1\204\1\0\1\205\1\252\1\205\3\204"+
    "\1\205\1\204\1\253\1\205\5\204\1\205\37\204\12\0"+
    "\1\254\46\0\1\205\1\0\10\205\1\253\46\205\2\106"+
    "\1\0\17\106\1\255\36\106\1\214\1\0\6\214\1\216"+
    "\50\214\1\217\1\0\1\220\1\256\1\220\3\217\1\220"+
    "\1\217\1\216\1\220\5\217\1\220\37\217\1\220\1\0"+
    "\10\220\1\216\46\220\1\217\1\0\1\220\1\256\1\220"+
    "\3\217\1\220\1\217\1\257\1\220\5\217\1\220\37\217"+
    "\12\0\1\260\46\0\1\220\1\0\10\220\1\257\46\220"+
    "\2\115\1\0\17\115\1\261\36\115\6\0\1\262\75\0"+
    "\1\263\41\0\1\230\6\0\1\230\5\0\1\230\117\0"+
    "\1\264\1\232\1\0\7\232\1\0\4\232\1\0\34\232"+
    "\1\0\6\232\1\0\2\232\1\233\4\232\1\0\1\232"+
    "\1\233\2\232\1\0\2\232\1\233\31\232\1\265\5\232"+
    "\14\0\1\235\36\0\1\266\21\0\1\267\6\0\3\267"+
    "\6\0\1\267\10\0\2\267\2\0\1\267\2\0\2\267"+
    "\31\0\1\270\15\0\1\270\46\0\1\271\57\0\1\272"+
    "\55\0\1\273\15\0\1\273\46\0\1\274\31\0\1\275"+
    "\1\0\3\275\2\0\1\164\4\275\1\0\2\275\1\0"+
    "\24\275\1\0\6\275\2\0\1\275\3\0\1\276\1\0"+
    "\3\276\2\0\1\210\4\276\1\0\2\276\1\0\24\276"+
    "\1\0\6\276\2\0\1\276\2\106\1\0\20\106\1\277"+
    "\35\106\3\0\1\300\1\0\3\300\2\0\1\223\4\300"+
    "\1\0\2\300\1\0\24\300\1\0\6\300\2\0\1\300"+
    "\2\115\1\0\20\115\1\301\35\115\24\0\1\302\77\0"+
    "\1\303\3\0\1\303\64\0\1\265\21\0\1\267\6\0"+
    "\3\267\6\0\1\267\10\0\2\267\2\0\1\267\1\0"+
    "\1\266\2\267\45\0\1\304\54\0\1\305\56\0\1\306"+
    "\60\0\1\307\62\0\1\310\22\0\2\106\1\0\21\106"+
    "\1\311\34\106\2\115\1\0\21\115\1\312\34\115\25\0"+
    "\1\313\76\0\1\314\52\0\1\315\63\0\1\316\51\0"+
    "\1\317\52\0\1\320\31\0\1\320\3\0\2\106\1\0"+
    "\22\106\1\321\33\106\2\115\1\0\22\115\1\322\33\115"+
    "\26\0\1\323\66\0\1\324\52\0\1\325\15\0\1\325"+
    "\42\0\1\326\15\0\1\326\14\0\2\106\1\0\23\106"+
    "\1\327\32\106\2\115\1\0\23\115\1\330\32\115\25\0"+
    "\1\331\33\0\2\106\1\0\22\106\1\332\33\106\2\115"+
    "\1\0\22\115\1\333\33\115\22\0\1\334\36\0\2\106"+
    "\1\0\17\106\1\335\36\106\2\115\1\0\17\115\1\336"+
    "\36\115";

  /** 
   * The transition table of the DFA
   */
  final private static int yytrans [] = yy_unpack(yy_packed);


  /* error codes */
  final private static int YY_UNKNOWN_ERROR = 0;
  // final private static int YY_ILLEGAL_STATE = 1;
  final private static int YY_NO_MATCH = 2;
  final private static int YY_PUSHBACK_2BIG = 3;

  /* error messages for the codes above */
  final private static String YY_ERROR_MSG[] = {
    "Unkown internal scanner error",		//$NON-NLS-1$
    "Internal error: unknown state",		//$NON-NLS-1$
    "Error: could not match input",		//$NON-NLS-1$
    "Error: pushback value was too large"	//$NON-NLS-1$
  };

  /**
   * YY_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private final static byte YY_ATTRIBUTE[] = {
     1,  0,  0,  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  0,  1,  1,  1,  1,  9,  1,  9,  1,  1,  9,  9,  1, 
     1,  1,  9,  1,  1,  1,  1,  1,  9,  1,  1,  1,  1,  1,  9,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  9,  1,  1,  1,  1,  1,  1,  9,  9, 
     1,  9,  9,  1,  1,  0,  1,  0,  1,  0,  0,  0,  9,  0,  0,  0, 
     9,  0,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  0,  0,  9,  1, 
     0,  0,  1,  1,  0,  0,  1,  0,  0,  0,  9,  0,  0,  0,  1,  0, 
     0,  0,  9,  1,  0,  0,  1,  1,  0,  1,  0,  0,  0,  9,  1,  0, 
     0,  1,  1,  0,  1,  0,  0,  1,  0,  1,  1,  9,  0,  0,  9,  9, 
     9,  0,  0,  0,  0,  0,  0,  1,  0,  0,  1,  0,  1,  0,  1,  0, 
     1,  9,  0,  0,  1,  9,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0, 
     1,  0,  0,  0,  0,  0,  0,  0,  1,  1,  0,  0,  0,  0,  9,  9, 
     1,  1,  0,  9,  9,  9,  1,  1,  0,  1,  1,  9,  1,  1
  };

  /** the input device */
  private java.io.Reader yy_reader;

  /** the current state of the DFA */
  private int yy_state;

  /** the current lexical state */
  private int yy_lexical_state = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char yy_buffer[] = new char[16384];

  /** the textposition at the last accepting state */
  private int yy_markedPos;

  /** the textposition at the last state to be included in yytext */
  private int yy_pushbackPos;

  /** the current text position in the buffer */
  private int yy_currentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int yy_startRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int yy_endRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  // private int yycolumn; 

  /** 
   * yy_atBOL == true <=> the scanner is currently at the beginning of a line
   */
  // private boolean yy_atBOL;

  /** yy_atEOF == true <=> the scanner has returned a value for EOF */
  private boolean yy_atEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean yy_eof_done;

  /* user code: */
	private int fTokenCount = 0;
 
	// required holders for white-space compacting
	private boolean fShouldLoadBuffered = false;
	private String fBufferedContext = null;
	private String fBufferedText = null;
	private int fBufferedStart = 1;
	private int fBufferedLength = 0;

	// state stack for handling embedded regions
	private IntStack fStateStack = new IntStack();

	private String context = null;
	private String text = null;
	private int start = 0;
	private int textLength = 0;
	private int length = 0;

	// offset for tracking position specific block tags
	private int fOffset = 0;
	
	// the name of the current tag being opened
	private String fCurrentTagName = null;

	// the list of tag name BlockMarkers
	private List fBlockMarkers = new ArrayList();

	// required to not seek text blocks on an end tag
	private boolean fIsBlockingEnabled = false;
	private boolean fIsCaseSensitiveBlocking = true;

/**
 * user method 
 */
public final void addBlockMarker(BlockMarker marker) {
	if(containsTagName(marker.getTagName()))
		return;
	fBlockMarkers.add(marker);
}
/**
 * user method 
 */
public final void removeBlockMarker(BlockMarker marker) {
	fBlockMarkers.remove(marker);
}
/**
 * user method 
 */
public final void removeBlockMarker(String tagname) {
	if (fBlockMarkers != null) {
		Iterator blocks = fBlockMarkers.iterator();
		while (blocks.hasNext()) {
			if (((BlockMarker) blocks.next()).getTagName().equals(tagname))
				blocks.remove();
		}
	}
}
/* user method */
public final boolean isCaseSensitiveBlocking() {
	return fIsCaseSensitiveBlocking;
}
/* user method */
public final void setCaseSensitiveBlocking(boolean newValue) {
	fIsCaseSensitiveBlocking = newValue;
}
/* user method */
public boolean getBlockMarkerCaseSensitivity() {
        return getBlockMarkerCaseSensitivity(fCurrentTagName);
}
/* user method */
public boolean getBlockMarkerCaseSensitivity(String name) {
	Iterator iterator = fBlockMarkers.iterator();
	while(iterator.hasNext()) {
		BlockMarker marker = (BlockMarker)iterator.next();
		boolean casesensitive = marker.isCaseSensitive();
		if(casesensitive && marker.getTagName().equals(name))
			return casesensitive;
		else if(!casesensitive && marker.getTagName().equalsIgnoreCase(name))
			return casesensitive;
	}
	return true;
}
/* user method */
public String getBlockMarkerContext() {
	return getBlockMarkerContext(fCurrentTagName);
}
/* user method */
public String getBlockMarkerContext(String name) {
	Iterator iterator = fBlockMarkers.iterator();
	while(iterator.hasNext()) {
		BlockMarker marker = (BlockMarker)iterator.next();
		if(marker.getTagName().equals(name))
			return marker.getContext();
	}
	return BLOCK_TEXT;
}
/* user method */
public List getBlockMarkers() {
	return fBlockMarkers;
}
/* user method */
public final int getOffset() {
	return fOffset + yychar;
}
private final boolean isBlockMarker() {
	return isBlockMarker(fCurrentTagName);
}
private final boolean isBlockMarker(String tagName) {
	if (!fIsBlockingEnabled)
		return false;
	return containsTagName(tagName);
}
/**
 * user method
 */
public final void beginBlockTagScan(String newTagName) {
	beginBlockMarkerScan(newTagName, BLOCK_TEXT);
}
/**
 * user method
 *
 * Special tokenizer setup.  Allows tokenization to be initiated at the
 * start of a text block within a "newTagName" tag.
 *
 * Example: 
 *	Tokenizer toker = new Tokenizer();
 *	toker.setCaseSensitiveBlocking(false);
 *	toker.reset(new java.io.StringReader("afiuhqwkejhtasihgalkwhtq</scripter></scr></script>asgdasga"));
 *	toker.beginBlockMarkerScan("script", BLOCK_TEXT);
 *	toker.getRegions(); 
 *
 * Returns:
 *	BLOCK_TEXT: 0-40
 *	XML_END_TAG_OPEN: 41-42
 *	XML_TAG_NAME: 43-48
 *	XML_TAG_CLOSE: 49-49
 *	XML_CONTENT: 50-57
 *
 */
public final void beginBlockMarkerScan(String newTagName, String blockcontext) {
	yybegin(ST_BLOCK_TAG_SCAN);
	fCurrentTagName = newTagName;
}
/**
 * Method doScan.
 * 
 * Returns a context region for all of the text from the current position upto the end of input or
 * to right *before* the first occurence of searchString
 * 
 * @param searchString - target string to search for ex.: "-->", "</tagname"
 * @param requireTailSeparator - whether the target must be immediately followed by whitespace or '>'
 * @param context - the context of the scanned region if non-zero length
 * @param exitState - the state to go to if the region was of non-zero length
 * @param abortState - the state to go to if the searchString was found immediately
 * @return String - the context found: the desired context on a non-zero length match, the abortContext on immediate success
 * @throws IOException
 */
private final String doScan(String searchString, boolean requireTailSeparator, String searchContext, int exitState, int immediateFallbackState) throws IOException {
	boolean stillSearching = true;
	// Disable further block (probably)
	fIsBlockingEnabled = false;
	int searchStringLength = searchString.length();
	int n = 0;
	char lastCheckChar;
	int i;
	boolean same = false;
	while (stillSearching) {
		n = 0;
		// Ensure that enough data from the input exists to compare against the search String.
		n = yy_advance();
		while(n != YYEOF && yy_currentPos < searchStringLength)
			n = yy_advance();
		// If the input was too short or we've exhausted the input, stop immediately.
		if (n == YYEOF) {
			stillSearching = false;
		}
		else {
			same = true;
			// Ensure that we've not encountered a complete block (<%%>) that was *shorter* than the closeTagString and
			// thus found twice at current-targetLength [since the first scan would have come out this far anyway].
			// Check the characters in the target versus the last targetLength characters read from the buffer
			// and see if it matches
			
			// safety check for array accesses (yy_currentPos is the *last* character we can check against)
			if(yy_currentPos >= searchStringLength && yy_currentPos <= yy_buffer.length) {
				for(i = 0; i < searchStringLength; i++) {
					if(same && fIsCaseSensitiveBlocking)
						same = yy_buffer[i + yy_currentPos - searchStringLength] == searchString.charAt(i);
					else if(same && !fIsCaseSensitiveBlocking)
						same = Character.toLowerCase(yy_buffer[i + yy_currentPos - searchStringLength]) == Character.toLowerCase(searchString.charAt(i));
				}
			}
			// safety check failed; no match is possible right now
			else {
				same = false;
			}
			if (same && requireTailSeparator && yy_currentPos < yy_buffer.length) {
				// Additional check for close tags to ensure that targetString="</script" doesn't match
				// "</scriptS"
				lastCheckChar = yy_buffer[yy_currentPos];
				// Succeed on "</script>" and "</script "
				if(lastCheckChar == '>' || Character.isWhitespace(lastCheckChar))
					stillSearching = false;
			}
			else {
				stillSearching = !same || (yy_currentPos < yy_startRead + searchStringLength);
			}
		}
	}
	if (n != YYEOF || same) {
		// We've stopped short of the end or definitely found a match
		yy_markedPos = yy_currentPos - searchStringLength;
		yy_currentPos = yy_markedPos + 1;
		// If the searchString occurs at the very beginning of what would have
		// been a Block, resume scanning normally immediately
		if (yy_markedPos == yy_startRead) {
			yybegin(immediateFallbackState);
			return primGetNextToken();
		}
	}
	else {
		// We ran through the rest of the input
		yy_markedPos = yy_currentPos;
		yy_currentPos++;
	}
	yybegin(exitState);
	// If the ending occurs at the very beginning of what would have
	// been a Block, resume scanning normally immediately
	if(yy_markedPos == yy_startRead)
		return primGetNextToken();
	return searchContext;
}
/**
 * user method
 *
 * A generic lookahead-like operation
 */
private final String doBlockScan(String target, String targetContext, int immediateFallbackState) throws IOException {
	return doScan(target, false, targetContext, immediateFallbackState, immediateFallbackState);
}
/**
 * user method 
 * does a lookahead for the current tag name
 */
private final String doBlockTagScan() throws IOException {
        fIsCaseSensitiveBlocking = getBlockMarkerCaseSensitivity();
	return doScan("</" + fCurrentTagName, true, getBlockMarkerContext(fCurrentTagName), YYINITIAL, YYINITIAL);
}

private IProject project;

public void setProject(IProject project){
	this.project = project;
}

private PhpSourceParser source;

public void setSourceParser(PhpSourceParser source) {
	this.source = source;
}

	private PhpLexer fPhpLexer = null;
	private boolean fInPhpState = false;

	public boolean getInPhpMode() {
		return fInPhpState;
	}

	public void setInPhpMode(boolean newState) {
		fInPhpState = newState;
	}
	
	public LexerState getPhpLexerState() {
		// if the php lexer is not created yet, we don't have a lex state
		// hence, return null
		if (fPhpLexer == null) 
			return null;
		
		// else return the 
		final Object lexicalState = fPhpLexer.createLexicalStateMemento();
		assert (lexicalState instanceof LexerState);

		return (LexerState) lexicalState;
	}
	
	public void setPhpLexerState(LexerState newState) {
		assert newState != null;
		
		final PhpLexer phpLexer = getPhpLexer();
		newState.restoreState(phpLexer);
	}
	
	private PhpLexer getPhpLexer() {
		if (fPhpLexer == null) {
			String phpVersion = PhpVersionProjectPropertyHandler.getVersion(project);
			int[] parameters = getParamenters();
			if (phpVersion.equals(PHPCoreConstants.PHP5)) {
				fPhpLexer = new PhpLexer5(yy_reader);
				parameters[6] = PhpLexer5.ST_PHP_IN_SCRIPTING;
				fPhpLexer.reset(yy_reader, yy_buffer, parameters);
			} else {
				fPhpLexer = new PhpLexer4(yy_reader);
				parameters[6] = PhpLexer4.ST_PHP_IN_SCRIPTING;
				fPhpLexer.reset(yy_reader, yy_buffer, parameters);
			}
			fPhpLexer.setAspTags(UseAspTagsHandler.useAspTagsAsPhp(project));
		}

		return fPhpLexer;
	}

	private void resetPhpLexer() {
		fPhpLexer = null;
	}

	private ArrayList storedPhpTokens = new ArrayList();

	private ITextRegion getNextPhpToken() throws IOException {

		if (!storedPhpTokens.isEmpty()) {
			return (ITextRegion) storedPhpTokens.remove(0);
		}
		PhpLexer phpLexer = getPhpLexer();

		// load the starting non-whitespace token (assume that it is so)
		if (fShouldLoadBuffered) {
			context = fBufferedContext;
			start = fBufferedStart;
			textLength = length = fBufferedLength;
			fShouldLoadBuffered = false;
		} else {
			context = phpLexer.yylex();
			start = phpLexer.getTokenStart();
			textLength = length = phpLexer.yylength();
			if (yy_atEOF) {
				fTokenCount++;
				return null;
			}
		}

		if (PHPRegionTypes.PHP_CLOSETAG == context) {
			char[] tmpBuffer = phpLexer.getYy_buffer();
			int[] tmpParameters = phpLexer.getParamenters();
			reset(yy_reader, tmpBuffer, tmpParameters);
			yypushback(length - 2); // we want only the "?>" to get into the PHP region and the whiteSpace to be in the HTML
			fInPhpState = false;
			resetPhpLexer();
			// the 2 stands for "?>" length
			return PHPRegionFactory.getInstance().createToken(PHPRegionContext.PHP_CLOSE, start, 2, 2, null, null, null);
		}

		if (PhpLexer.isPHPCommentState(context)) {
			handlePhpComment();
			return (ITextRegion) storedPhpTokens.remove(0);
		}
		// store the next token
		fBufferedContext = phpLexer.yylex();
		fBufferedStart = phpLexer.getTokenStart();
		fBufferedLength = phpLexer.yylength();
		if (fBufferedContext == PHPRegionTypes.WHITESPACE && context != PHPRegionTypes.PHP_CONSTANT_ENCAPSED_STRING) {
			fShouldLoadBuffered = false;
			length += fBufferedLength;
		} else {
			fShouldLoadBuffered = true;
		}
		if (context == null) {
			fInPhpState = false;
			resetPhpLexer();
			// EOF
			if (Debug.debugTokenizer) {
				System.out.println(getClass().getName() + " discovered " + fTokenCount + " tokens."); //$NON-NLS-2$//$NON-NLS-1$
			}
			return null;
		}
		fTokenCount++;

		return new PHPContentRegion(start, textLength, length, context);
	}

	private void handlePhpComment() throws IOException {
		int commentStart = 0;
		int commentLegth = 0;
		String commentType = "";

		PhpLexer phpLexer = getPhpLexer();
		if (context == PHPRegionTypes.PHP_COMMENT_START || context == PHPRegionTypes.PHPDOC_COMMENT_START) {
			commentType = context == PHPRegionTypes.PHP_COMMENT_START ? PHPRegionTypes.PHP_COMMENT : PHPRegionTypes.PHPDOC_COMMENT;  
			ITextRegion tRegion = new PHPContentRegion(start, textLength, length, context);
			storedPhpTokens.add(tRegion);
			commentStart = phpLexer.getTokenStart() + phpLexer.yylength();
			commentLegth = 0;
		} else {
			commentType = context;
			commentStart = phpLexer.getTokenStart();
			commentLegth = phpLexer.yylength();
		}

		for (context = phpLexer.yylex(); context != null; context = phpLexer.yylex()) {
			if (context == PHPRegionTypes.PHP_CLOSETAG) {
				checkForTodo(commentType, commentStart, commentLegth, source.getText(commentStart, commentLegth));
				fBufferedContext = context;
				fBufferedStart = phpLexer.getTokenStart();
				fBufferedLength = phpLexer.yylength();
				fShouldLoadBuffered = true;
				return;
			}
			if (isPHPCommentState(context)) {
				commentLegth += phpLexer.yylength();
				continue;
			}
			checkForTodo(commentType, commentStart, commentLegth, source.getText(commentStart, commentLegth));
			if (context.startsWith("PHPDOC") && context != PHPRegionTypes.PHPDOC_COMMENT_END) { //if its phpdoc tags
				ITextRegion tRegion = new PHPContentRegion(phpLexer.getTokenStart(), phpLexer.yylength(), phpLexer.yylength(), context);
				storedPhpTokens.add(tRegion);
				commentStart = phpLexer.getTokenStart() + phpLexer.yylength();
				commentLegth = 0;
			} else {
				fBufferedContext = context;
				fBufferedStart = phpLexer.getTokenStart();
				fBufferedLength = phpLexer.yylength();
				fShouldLoadBuffered = true;
				return;
			}

		}
		checkForTodo(commentType, commentStart, commentLegth, source.getText(commentStart, commentLegth));
	}

	private boolean isPHPCommentState(String token) {
		return PhpLexer.isPHPLineCommentState(token) || token == PHPRegionTypes.PHP_COMMENT || token == PHPRegionTypes.PHP_HEREDOC_TAG || token == PHPRegionTypes.PHPDOC_COMMENT;
	}

	private void checkForTodo(String token, int commentStart, int commentLength, String comment) {
		ArrayList matchers = createMatcherList(comment);
		int startPosition = 0;

		Matcher matcher = getMinimalMatcher(matchers, startPosition);
		ITextRegion tRegion = null;
		while (matcher != null) {
			int startIndex = matcher.start();
			int endIndex = matcher.end();
			if (startIndex != startPosition) {
				tRegion = new PHPContentRegion(commentStart + startPosition, startIndex - startPosition, startIndex - startPosition, token);
				storedPhpTokens.add(tRegion);
			}
			tRegion = new PHPContentRegion(commentStart + startIndex, endIndex - startIndex, endIndex - startIndex, PHPRegionTypes.TASK);
			storedPhpTokens.add(tRegion);
			startPosition = endIndex;
			matcher = getMinimalMatcher(matchers, startPosition);
		}
		tRegion = new PHPContentRegion(commentStart + startPosition, commentLength - startPosition, commentLength - startPosition, token);
		storedPhpTokens.add(tRegion);
	}
	
private ArrayList createMatcherList(String content) {
	Pattern[] todos = null;
	if (project != null) {
		todos = TaskPatternsProvider.getInstance().getPatternsForProject(project);
	} else {
		todos = TaskPatternsProvider.getInstance().getPetternsForWorkspace();
	}
	ArrayList list = new ArrayList(todos.length);
	for (int i = 0; i < todos.length; i++) {
		list.add(i, todos[i].matcher(content));
	}
	return list;
}

private Matcher getMinimalMatcher(ArrayList matchers, int startPosition) {
	Matcher minimal = null;
	int size = matchers.size();
	for (int i = 0; i < size;) {
		Matcher tmp = (Matcher) matchers.get(i);
		if (tmp.find(startPosition)) {
			if (minimal == null || tmp.start() < minimal.start()) {
				minimal = tmp;
			}
			i++;
		} else {
			matchers.remove(i);
			size--;
		}
	}
	return minimal;
}

public void reset(java.io.Reader  reader, char[] buffer, int[] parameters){
	this.yy_reader = reader;
	this.yy_buffer = buffer;
	this.yy_markedPos = parameters[0];
	this.yy_pushbackPos = parameters[1];
	this.yy_currentPos = parameters[2];
	this.yy_startRead = parameters[3];
	this.yy_endRead = parameters[4];
	this.yyline = parameters[5];  
	this.yychar = this.yy_startRead - this.yy_pushbackPos;
	fShouldLoadBuffered = false;
	fInPhpState = false;
}

public int[] getParamenters(){
	return new int[]{yy_markedPos, yy_pushbackPos, yy_currentPos, yy_startRead, yy_endRead, yyline, yy_lexical_state};
}

/**
 * user method
 *
 * Converts the raw context String returned by the primGetNextToken()
 * method into a full ITextRegion by pulling in values for the
 * current offset within the scanning text.
 *
 * Returns null when EOF is encountered and attaches intermittently
 * discovered whitespace onto the end of useful regions.
 *
 * Note that this algorithm caches the token following the one being returned
 * so that whitespace can be collapsed.
 */
public final ITextRegion getNextToken() throws IOException {
	if(fInPhpState){
		return getNextPhpToken();
	}
	// load the starting non-whitespace token (assume that it is so)
	if (fShouldLoadBuffered) {
		context = fBufferedContext;
		text = fBufferedText;
		start = fBufferedStart;
		textLength = length = fBufferedLength;
		fShouldLoadBuffered = false;
	}
	else {
		context = primGetNextToken();
		text = yytext();
		if (context == XML_TAG_NAME) {
			if(containsTagName(yy_buffer, yy_startRead, yy_markedPos-yy_startRead))
				fCurrentTagName = text;
			else
				fCurrentTagName = null;
		}
		else if (context == XML_TAG_OPEN) {
			fIsBlockingEnabled = true;
		}
		else if (context == XML_END_TAG_OPEN) {
			fIsBlockingEnabled = false;
		}
		start = yychar;
		textLength = length = yylength();
		if (yy_atEOF) {
			fTokenCount++;
			return null;
		}
	}
	if(context == PHP_OPEN){
    	fInPhpState = true;
		return PHPRegionFactory.getInstance().createToken(context, start, textLength, length, null, null, text);
	}
	// store the next token
	fBufferedContext = primGetNextToken();
	fBufferedText = yytext();
	if (fBufferedContext == XML_TAG_NAME) {
		if(containsTagName(yy_buffer, yy_startRead, yy_markedPos-yy_startRead))
			fCurrentTagName = fBufferedText;
		else
			fCurrentTagName = null;
	}
	else if (fBufferedContext == XML_TAG_OPEN) {
		fIsBlockingEnabled = true;
	}
	else if (fBufferedContext == XML_END_TAG_OPEN) {
		fIsBlockingEnabled = false;
	}
	fBufferedStart = yychar;
	fBufferedLength = yylength();
	if (fBufferedContext == WHITE_SPACE) {
		fShouldLoadBuffered = false;
		length += fBufferedLength;
	}else {
		fShouldLoadBuffered = true;
	}
	if (context == null) {
		// EOF
		if (Debug.debugTokenizer) {
			System.out.println(getClass().getName() + " discovered " + fTokenCount + " tokens."); //$NON-NLS-2$//$NON-NLS-1$
		}
		return null;
	}
	fTokenCount++;
	return PHPRegionFactory.getInstance().createToken(context, start, textLength, length, null, fCurrentTagName, text);
}
/* user method */
public PHPTokenizer(){
	super();
}
/* user method */
public PHPTokenizer(char[] charArray){
		this(new CharArrayReader(charArray));
}
/* user method */
public void reset(char[] charArray) {
	reset(new CharArrayReader(charArray), 0);
}
/* user method */
public void reset(char[] charArray, int newOffset) {
	reset(new CharArrayReader(charArray), newOffset);
}
/* user method */
public void reset(java.io.InputStream in) {
	reset(new java.io.InputStreamReader(in), 0);
}
/* user method */
public void reset(java.io.InputStream in, int newOffset) {
	reset(new java.io.InputStreamReader(in), newOffset);
}
/* user method */
public void reset(java.io.Reader in) {
	reset(in, 0);
}
/**
 * user method *
 *
 * Reset internal counters and vars to "newly created" values, in the hopes
 * that resetting a pre-existing tokenizer is faster than creating a new one.
 *
 * This method contains code blocks that were essentially duplicated from the
 * <em>generated</em> output of this specification before this method was
 * added.  Those code blocks were under the above copyright.
 */
public void reset(java.io.Reader in, int newOffset) {
	if (Debug.debugTokenizer) {
		System.out.println("resetting tokenizer");//$NON-NLS-1$
	}
	fOffset = newOffset;

	/* the input device */
	yy_reader = in;

	/* the current state of the DFA */
	yy_state = 0;

	/* the current lexical state */
	yy_lexical_state = YYINITIAL;

	/* this buffer contains the current text to be matched and is
	the source of the yytext() string */
	java.util.Arrays.fill(yy_buffer, (char)0);

	/* the textposition at the last accepting state */
	yy_markedPos = 0;

	/* the textposition at the last state to be included in yytext */
	yy_pushbackPos = 0;

	/* the current text position in the buffer */
	yy_currentPos = 0;

	/* startRead marks the beginning of the yytext() string in the buffer */
	yy_startRead = 0;

	/** 
	 * endRead marks the last character in the buffer, that has been read
	 * from input 
	 */
	yy_endRead = 0;

	/* number of newlines encountered up to the start of the matched text */
	yyline = 0;

	/* the number of characters up to the start of the matched text */
	yychar = 0;

	/* yy_atEOF == true <=> the scanner has returned a value for EOF */
	yy_atEOF = false;

	/* denotes if the user-EOF-code has already been executed */
	yy_eof_done = false;


	/* user vars: */
	fTokenCount = 0;
 
	fShouldLoadBuffered = false;
	fBufferedContext = null;
	fBufferedText = null;
	fBufferedStart = 1;
	fBufferedLength = 0;
	fStateStack = new IntStack();

	context = null;
	text = null;
	start = 0;
	textLength = 0;
	length = 0;
}

	/**
	 * user method
	 *
	 */
	public BlockTokenizer newInstance() {
		PHPTokenizer newInstance = new PHPTokenizer();
		// global tagmarkers can be shared; they have no state and 
		// are never destroyed (e.g. 'release')
		for(int i = 0; i < fBlockMarkers.size(); i++) {
			BlockMarker blockMarker = (BlockMarker) fBlockMarkers.get(i);
			if(blockMarker.isGlobal())
				newInstance.addBlockMarker(blockMarker);
		}
		return newInstance;
	}
/* user method */
private final String scanXMLCommentText() throws IOException {
	// Scan for '-->' and return the text up to that point as
	//   XML_COMMENT_TEXT unless the string occurs IMMEDIATELY, in which
	//  case change to the ST_XML_COMMENT_END state and return the next
	//  context as usual.
	return doScan("-->", false, XML_COMMENT_TEXT, ST_XML_COMMENT_END, ST_XML_COMMENT_END);
}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PHPTokenizer(java.io.Reader in) {
    this.yy_reader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public PHPTokenizer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed DFA transition table.
   *
   * @param packed   the packed transition table
   * @return         the unpacked transition table
   */
  private static int [] yy_unpack(String packed) {
    int [] trans = new int[7448];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2322) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do trans[j++] = value; while (--count > 0);
    }
    return trans;
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] yy_unpack_cmap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1372) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Gets the next input character.
   *
   * @return      the next character of the input stream, EOF if the
   *              end of the stream is reached.
   * @exception   IOException  if any I/O-Error occurs
   */
  private int yy_advance() throws java.io.IOException {

    /* standard case */
    if (yy_currentPos < yy_endRead) return yy_buffer[yy_currentPos++];

    /* if the eof is reached, we don't need to work hard */ 
    if (yy_atEOF) return YYEOF;

    /* otherwise: need to refill the buffer */

    /* first: make room (if you can) */
    if (yy_startRead > 0) {
      System.arraycopy(yy_buffer, yy_startRead, 
                       yy_buffer, 0, 
                       yy_endRead-yy_startRead);

      /* translate stored positions */
      yy_endRead-= yy_startRead;
      yy_currentPos-= yy_startRead;
      yy_markedPos-= yy_startRead;
      yy_pushbackPos-= yy_startRead;
      yy_startRead = 0;
    }

    /* is the buffer big enough? */
    if (yy_currentPos >= yy_buffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[yy_currentPos*2];
      System.arraycopy(yy_buffer, 0, newBuffer, 0, yy_buffer.length);
      yy_buffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = yy_reader.read(yy_buffer, yy_endRead, 
                                            yy_buffer.length-yy_endRead);

    if ( numRead == -1 ) return YYEOF;

    yy_endRead+= numRead;

    return yy_buffer[yy_currentPos++];
  }

    
  /**
   * Closes the input stream.
   */
  final public void yyclose() throws java.io.IOException {
    yy_atEOF = true;            /* indicate end of file */
    yy_endRead = yy_startRead;  /* invalidate buffer    */
    yy_reader.close();
  }


  /**
   * Returns the current lexical state.
   */
  final public int yystate() {
    return yy_lexical_state;
  }

  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  final public void yybegin(int newState) {
    yy_lexical_state = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  final public String yytext() {
    return new String( yy_buffer, yy_startRead, yy_markedPos-yy_startRead );
  }

  /**
   * Returns the length of the matched text region.
   */
  final public int yylength() {
    return yy_markedPos-yy_startRead;
  }


  /**
   * Reports an error that occured while scanning - from the SED JFlex skeleton
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void yy_ScanError(int errorCode) {
    try {
      Logger.log(Logger.ERROR, YY_ERROR_MSG[errorCode]);
    }
    catch (ArrayIndexOutOfBoundsException e) {
      Logger.log(Logger.ERROR, YY_ERROR_MSG[YY_UNKNOWN_ERROR]);
    }
    // DO NOT EXIT the VM on an error
    // System.exit(1);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  void yypushback(int number) {
    if ( number > yylength() )
      yy_ScanError(YY_PUSHBACK_2BIG);

    yy_markedPos -= number;
  }

	/**
	 * user method - skeleton.sed
	 */
	protected final boolean containsTagName(char[] markerTagName, int offset, int tagnameLength) {
		for(int j = 0; j < fBlockMarkers.size(); j++) {
			BlockMarker marker = (BlockMarker)fBlockMarkers.get(j);
			if(marker.getTagName().length() == tagnameLength) {
				boolean matchesSoFar = true;
				for(int i = 0; i < tagnameLength && matchesSoFar; i++) {
					if(marker.isCaseSensitive()) {
						if(marker.getTagName().charAt(i) != markerTagName[i + offset])
							matchesSoFar = false;
					}
					else {
						if(Character.toLowerCase(marker.getTagName().charAt(i)) != Character.toLowerCase(markerTagName[i + offset]))
							matchesSoFar = false;
					}
				}
				if(matchesSoFar)
					return true;
			}
		}
		return false;
	}

	/**
	 * user method - skeleton.sed
	 *
	 * Return ALL of the regions scannable within the remaining text
	 * Note: for verification use
	 */
	public final List getRegions() {
		List tokens = new ArrayList();
		ITextRegion region = null;
		try {
			region = getNextToken();
			while(region != null) {
				if (region != null) {
					tokens.add(region);
				}
				region = getNextToken();
			}
		}
		catch (StackOverflowError e) {
			Logger.logException(getClass().getName()+": input could not be tokenized correctly at position " + getOffset(), e);//$NON-NLS-1$
			throw e;
		}
		catch (Exception e) {
			// Since this is convenience method and NOT the recommended 
			// way of getting tokens, many errors are simply hidden
			Logger.logException("Exception not handled retrieving regions: " + e.getLocalizedMessage(), e);//$NON-NLS-1$
		}
		return tokens;
	}
	/**
	 * user method - skeleton.sed
	 */
	private final void dump(String s) {
		if (Debug.debugTokenizer) {
			System.out.println(s + " (" + yychar + "-" + //$NON-NLS-2$//$NON-NLS-1$
				(yylength() + yychar) + "):\'" +//$NON-NLS-1$
					StringUtils.escape(yytext()) + "\'");//$NON-NLS-1$
		}
	}
	/* user method  - skeleton.sed */
	public final boolean isEOF() {
		return yy_atEOF;
	}
/* user method - skeleton.sed */
protected final boolean containsTagName(String markerTagName) {
	Iterator blocks = fBlockMarkers.iterator();
	while(blocks.hasNext()) {
		BlockMarker marker = (BlockMarker)blocks.next();
		if(marker.isCaseSensitive()) {
			if(marker.getTagName().equals(markerTagName))
				return true;
		}
		else {
			if(marker.getTagName().equalsIgnoreCase(markerTagName))
				return true;
		}
	}
	return false;
}

  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void yy_do_eof() {
    if (!yy_eof_done) {
      yy_eof_done = true;
    // do nothing, this is the downstream parser's job

    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   IOException  if any I/O-Error occurs
   */
  public String primGetNextToken() throws java.io.IOException {
    int yy_input;
    int yy_action;


    while (true) {

      yychar+= yylength();

      boolean yy_counted = false;
      for (yy_currentPos = yy_startRead; yy_currentPos < yy_markedPos;
                                                      yy_currentPos++) {
        switch (yy_buffer[yy_currentPos]) {
        case '\r':
          yyline++;
          yy_counted = true;
          break;
        case '\n':
          if (yy_counted)
            yy_counted = false;
          else {
            yyline++;
          }
          break;
        default:
          yy_counted = false;
        }
      }

      if (yy_counted) {
        if ( yy_advance() == '\n' ) yyline--;
        if ( !yy_atEOF ) yy_currentPos--;
      }

      yy_action = -1;

      yy_currentPos = yy_startRead = yy_markedPos;

      yy_state = yy_lexical_state;


      yy_forAction: {
        while (true) {
    
          yy_input = yy_advance();

          if ( yy_input == YYEOF ) break yy_forAction;

          int yy_next = yytrans[ yy_rowMap[yy_state] + yycmap[yy_input] ];
          if (yy_next == -1) break yy_forAction;
          yy_state = yy_next;

          int yy_attributes = YY_ATTRIBUTE[yy_state];
          if ( (yy_attributes & 1) > 0 ) {
            yy_action = yy_state; 
            yy_markedPos = yy_currentPos; 
            if ( (yy_attributes & 8) > 0 ) break yy_forAction;
          }

        }
      }


      switch (yy_action) {    

        case 219: 
        case 220: 
        case 221: 
          { 
	if(Debug.debugTokenizer)
		dump("\nCDATA start");//$NON-NLS-1$
	fStateStack.push(yystate());
	yybegin(ST_CDATA_TEXT);
	return XML_CDATA_OPEN;
 }
        case 223: break;
        case 213: 
          { 
	if(Debug.debugTokenizer)
		dump("element");//$NON-NLS-1$
	yybegin(ST_XML_ELEMENT_DECLARATION);
	return XML_ELEMENT_DECLARATION;
 }
        case 224: break;
        case 212: 
          { 
	if(Debug.debugTokenizer)
		dump("attlist");//$NON-NLS-1$
	yybegin(ST_XML_ATTLIST_DECLARATION);
	return XML_ATTLIST_DECLARATION;
 }
        case 225: break;
        case 211: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_DECLARATION);
	return XML_DOCTYPE_DECLARATION;
 }
        case 226: break;
        case 207: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype external id");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_ID_PUBLIC);
	return XML_DOCTYPE_EXTERNAL_ID_PUBLIC;
 }
        case 227: break;
        case 206: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype external id");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_ID_SYSTEM);
	return XML_DOCTYPE_EXTERNAL_ID_SYSTEM;
 }
        case 228: break;
        case 52: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype type");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_EXTERNAL_ID);
	return XML_DOCTYPE_NAME;
 }
        case 229: break;
        case 46: 
          { 
	if(Debug.debugTokenizer)
		dump("declaration end");//$NON-NLS-1$
	if (Debug.debugTokenizer) {
		if(fStateStack.peek()!=YYINITIAL)
			System.out.println("end embedded region");//$NON-NLS-1$
	}
	yybegin(fStateStack.pop());
	return XML_DECLARATION_CLOSE;
 }
        case 230: break;
        case 41: 
        case 43: 
        case 44: 
        case 96: 
          { 
	if(Debug.debugTokenizer)
		dump("attr value");//$NON-NLS-1$
        yybegin(ST_XML_ATTRIBUTE_NAME);
        return XML_TAG_ATTRIBUTE_VALUE;
 }
        case 231: break;
        case 40: 
          { 
	if(Debug.debugTokenizer)
		dump("equals");//$NON-NLS-1$
        yybegin(ST_XML_ATTRIBUTE_VALUE);
        return XML_TAG_ATTRIBUTE_EQUALS;
 }
        case 232: break;
        case 39: 
          { 
	if(Debug.debugTokenizer)
		dump("attr name");//$NON-NLS-1$
        yybegin(ST_XML_EQUALS);
        return XML_TAG_ATTRIBUTE_NAME;
 }
        case 233: break;
        case 36: 
        case 37: 
          { 
	if(Debug.debugTokenizer)
		dump("tag name");//$NON-NLS-1$
        yybegin(ST_XML_ATTRIBUTE_NAME);
        return XML_TAG_NAME;
 }
        case 234: break;
        case 34: 
          { 
	if(Debug.debugTokenizer)
		dump("tag close");//$NON-NLS-1$
	if(isBlockMarker()) {
        	yybegin(ST_BLOCK_TAG_SCAN);
	}
	else
        	yybegin(YYINITIAL);
        return XML_TAG_CLOSE;
 }
        case 235: break;
        case 30: 
        case 31: 
          { 
	if(Debug.debugTokenizer)
		dump("comment content");//$NON-NLS-1$
	return scanXMLCommentText();
 }
        case 236: break;
        case 29: 
          { 
	if(Debug.debugTokenizer)
		dump("LINE FEED");//$NON-NLS-1$
	return WHITE_SPACE;
 }
        case 237: break;
        case 0: 
        case 20: 
        case 86: 
        case 88: 
        case 153: 
        case 154: 
        case 180: 
          { 
	if(Debug.debugTokenizer)
		dump("\nXML content");//$NON-NLS-1$
	return XML_CONTENT;
 }
        case 238: break;
        case 5: 
        case 33: 
          { 
	if(Debug.debugTokenizer)
		dump("inappropriate tag name");//$NON-NLS-1$
	yybegin(YYINITIAL);
        return XML_CONTENT;
 }
        case 239: break;
        case 6: 
        case 7: 
        case 8: 
        case 9: 
        case 10: 
        case 11: 
        case 12: 
        case 13: 
        case 14: 
        case 15: 
        case 17: 
        case 38: 
          { 
	if(Debug.debugTokenizer)
		dump("white space");//$NON-NLS-1$
        return WHITE_SPACE;
 }
        case 240: break;
        case 16: 
        case 69: 
        case 70: 
        case 137: 
        case 172: 
        case 190: 
        case 200: 
        case 208: 
        case 214: 
        case 217: 
          { 
	if(Debug.debugTokenizer)
		dump("elementdecl contentspec");//$NON-NLS-1$
	return XML_ELEMENT_DECL_CONTENT;
 }
        case 241: break;
        case 18: 
        case 76: 
        case 77: 
        case 148: 
        case 176: 
        case 192: 
        case 201: 
        case 209: 
        case 215: 
        case 218: 
          { 
	if(Debug.debugTokenizer)
		dump("attlist contentspec");//$NON-NLS-1$
	return XML_ATTLIST_DECL_CONTENT;
 }
        case 242: break;
        case 21: 
        case 45: 
          { 
	if(Debug.debugTokenizer)
		dump("\nstart tag open");//$NON-NLS-1$
        yybegin(ST_XML_TAG_NAME);
        return XML_TAG_OPEN;
 }
        case 243: break;
        case 22: 
        case 23: 
        case 26: 
        case 27: 
        case 28: 
        case 32: 
        case 35: 
        case 42: 
        case 47: 
        case 48: 
        case 49: 
        case 50: 
        case 51: 
        case 53: 
        case 54: 
        case 56: 
        case 61: 
        case 66: 
        case 73: 
          { 
	if (Debug.debugTokenizer)
		System.out.println("!!!unexpected!!!: \"" + yytext() + "\":" + //$NON-NLS-2$//$NON-NLS-1$
			yychar + "-" + (yychar + yylength()));//$NON-NLS-1$
	return UNDEFINED;
 }
        case 244: break;
        case 24: 
        case 25: 
          { 
	if(Debug.debugTokenizer)
		dump("CDATA text");//$NON-NLS-1$
	String blockContext = doBlockScan("]]>", XML_CDATA_TEXT, ST_CDATA_END);//$NON-NLS-1$
	if(blockContext == XML_CDATA_TEXT)
		yybegin(ST_CDATA_END);
	return blockContext;
 }
        case 245: break;
        case 55: 
        case 57: 
        case 58: 
        case 59: 
        case 110: 
        case 111: 
        case 114: 
        case 115: 
        case 167: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype public reference");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_ID_SYSTEM);
	return XML_DOCTYPE_EXTERNAL_ID_PUBREF;
 }
        case 246: break;
        case 60: 
        case 62: 
        case 63: 
        case 64: 
        case 122: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype system reference");//$NON-NLS-1$
	yybegin(ST_XML_DECLARATION_CLOSE);
	return XML_DOCTYPE_EXTERNAL_ID_SYSREF;
 }
        case 247: break;
        case 65: 
        case 67: 
        case 68: 
        case 130: 
        case 131: 
        case 134: 
        case 135: 
        case 170: 
          { 
	if(Debug.debugTokenizer)
		dump("elementdecl name");//$NON-NLS-1$
	yybegin(ST_XML_ELEMENT_DECLARATION_CONTENT);
	return XML_ELEMENT_DECL_NAME;
 }
        case 248: break;
        case 71: 
          { 
	if(Debug.debugTokenizer)
		dump("elementdecl close");//$NON-NLS-1$
	if (Debug.debugTokenizer) {
		if(fStateStack.peek()!=YYINITIAL)
			System.out.println("end embedded region");//$NON-NLS-1$
	}
	yybegin(fStateStack.pop());
	return XML_DECLARATION_CLOSE;
 }
        case 249: break;
        case 72: 
        case 74: 
        case 75: 
        case 141: 
        case 142: 
        case 145: 
        case 146: 
        case 174: 
          { 
	if(Debug.debugTokenizer)
		dump("attlist name");//$NON-NLS-1$
	yybegin(ST_XML_ATTLIST_DECLARATION_CONTENT);
	return XML_ATTLIST_DECL_NAME;
 }
        case 250: break;
        case 78: 
          { 
	if(Debug.debugTokenizer)
		dump("attlist close");//$NON-NLS-1$
	if (Debug.debugTokenizer) {
		if(fStateStack.peek()!=YYINITIAL)
			System.out.println("end embedded region");//$NON-NLS-1$
	}
	yybegin(fStateStack.pop());
	return XML_DECLARATION_CLOSE;
 }
        case 251: break;
        case 81: 
          { 
	if(Debug.debugTokenizer)
		dump("\nend tag open");//$NON-NLS-1$
        yybegin(ST_XML_TAG_NAME);
        return XML_END_TAG_OPEN;
 }
        case 252: break;
        case 82: 
        case 84: 
        case 151: 
          { 
    if (UseAspTagsHandler.useAspTagsAsPhp(project) ||yytext().charAt(1) != '%') {
    	return PHP_OPEN;
    }
    yypushback(1);
	yybegin(ST_XML_TAG_NAME);
	return XML_TAG_OPEN;
 }
        case 253: break;
        case 83: 
          { 
	fStateStack.push(yystate());
	if(Debug.debugTokenizer)
		dump("\ndeclaration start");//$NON-NLS-1$
        yybegin(ST_XML_DECLARATION);
	return XML_DECLARATION_OPEN;
 }
        case 254: break;
        case 92: 
          { 
        yybegin(YYINITIAL);
	if(Debug.debugTokenizer)
		dump("empty tag close");//$NON-NLS-1$
        return XML_EMPTY_TAG_CLOSE;
 }
        case 255: break;
        case 104: 
        case 118: 
        case 126: 
          { 
	return XML_DOCTYPE_INTERNAL_SUBSET;
 }
        case 256: break;
        case 155: 
          { 
	if(Debug.debugTokenizer)
		dump("\nEntityRef");//$NON-NLS-1$
	return XML_ENTITY_REFERENCE;
 }
        case 257: break;
        case 158: 
          { 
	if(Debug.debugTokenizer)
		dump("\nPEReference");//$NON-NLS-1$
	return XML_PE_REFERENCE;
 }
        case 258: break;
        case 159: 
          { 
	if(Debug.debugTokenizer)
		dump("CDATA end");//$NON-NLS-1$
	yybegin(fStateStack.pop());
	return XML_CDATA_CLOSE;
 }
        case 259: break;
        case 160: 
          { 
	if(Debug.debugTokenizer)
		dump("comment end");//$NON-NLS-1$
	yybegin(YYINITIAL);
	return XML_COMMENT_CLOSE;
 }
        case 260: break;
        case 177: 
          { 
	if(Debug.debugTokenizer)
		dump("\ncomment start");//$NON-NLS-1$
	yybegin(ST_XML_COMMENT);
	return XML_COMMENT_OPEN;
 }
        case 261: break;
        case 181: 
          { 
	if(Debug.debugTokenizer)
		dump("\nCharRef");//$NON-NLS-1$
	return XML_CHAR_REFERENCE;
 }
        case 262: break;
        case 79: 
        case 80: 
          { 
		return doBlockTagScan();
	 }
        case 263: break;
        default: 
          if (yy_input == YYEOF && yy_startRead == yy_currentPos) {
            yy_atEOF = true;
            yy_do_eof();
              return null;
          } 
          else {
            yy_ScanError(YY_NO_MATCH);
          }
      }
    }
  }    


}
