/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.PHPUIMessages;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.ui.treecontent.PHPTreeNode;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ConfigureIncludePathAction
extends SelectionDispatchAction {
    public static final String ID_INCLUDES_NODE = "org.eclipse.php.ui.treecontent.IncludesNode";
    private static final String INCLUDEPATH_PREFERENCES_PAGE_ID = "org.eclipse.php.ui.propertyPages.IncludePathPropertyPage";
    private IProject project;

    public ConfigureIncludePathAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(PHPUIMessages.ConfigureIncludePathAction_label);
        this.setToolTipText(PHPUIMessages.ConfigureIncludePathAction_tooltip);
        this.setDescription(PHPUIMessages.ConfigureIncludePathAction_description);
    }

    public void selectionChanged(ITextSelection iTextSelection) {
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(this.checkEnabled(iStructuredSelection));
    }

    private boolean checkEnabled(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty()) {
            return false;
        }
        Object object = iStructuredSelection.getFirstElement();
        this.project = this.getProjectFromSelectedElement(object);
        return this.project != null;
    }

    private IProject getProjectFromSelectedElement(Object object) {
        if (object instanceof IProject) {
            return (IProject)object;
        }
        if (object instanceof PHPCodeData) {
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            String string = ((PHPCodeData)object).getUserData().getFileName();
            IFile iFile = iWorkspaceRoot.getFile((IPath)new Path(string));
            return iFile.getProject();
        }
        if (object instanceof PHPTreeNode && ID_INCLUDES_NODE.equals(((PHPTreeNode)object).getId())) {
            PHPTreeNode pHPTreeNode = (PHPTreeNode)object;
            return (IProject)pHPTreeNode.getData();
        }
        return null;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        if (this.project != null) {
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)this.project, (String)INCLUDEPATH_PREFERENCES_PAGE_ID, null, null).open();
        }
    }

    public Object getElementToOpen(Object object) {
        return object;
    }
}

