/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.core.phpModel.PHPModelUtil;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.ui.explorer.ExplorerPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.views.navigator.ResourceNavigatorRenameAction;

public class RenameResourceAction
extends SelectionDispatchAction {
    TreeViewer treeViewer;

    public RenameResourceAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        ViewSite viewSite;
        IWorkbenchPart iWorkbenchPart;
        if (iWorkbenchSite instanceof ViewSite && (iWorkbenchPart = (viewSite = (ViewSite)iWorkbenchSite).getPart()) instanceof ExplorerPart) {
            ExplorerPart explorerPart = (ExplorerPart)iWorkbenchPart;
            this.treeViewer = explorerPart.getViewer();
        }
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        IResource iResource = RenameResourceAction.getResource(iStructuredSelection);
        if (iResource == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(ActionUtils.isRenameAvailable(iResource));
        }
    }

    public void run(IStructuredSelection iStructuredSelection) {
        IResource iResource = RenameResourceAction.getResource(iStructuredSelection);
        if (!ActionUtils.isProcessable(this.getShell(), iResource)) {
            return;
        }
        if (!ActionUtils.isRenameAvailable(iResource)) {
            return;
        }
        this.createWorkbenchAction(iStructuredSelection).run();
    }

    private ResourceNavigatorRenameAction createWorkbenchAction(IStructuredSelection iStructuredSelection) {
        ResourceNavigatorRenameAction resourceNavigatorRenameAction = new ResourceNavigatorRenameAction(this.getShell(), this.treeViewer);
        resourceNavigatorRenameAction.selectionChanged(iStructuredSelection);
        return resourceNavigatorRenameAction;
    }

    private static IResource getResource(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return null;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof PHPCodeData && !(object instanceof PHPFileData)) {
            return null;
        }
        if (!((object = PHPModelUtil.getResource((Object)object)) instanceof IResource)) {
            return null;
        }
        return (IResource)object;
    }
}

