/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.NewPHPManualSiteDialog;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.preferences.ui.IPreferenceConfigurationBlock;
import org.eclipse.php.ui.preferences.ui.ScrolledCompositeImpl;
import org.eclipse.php.ui.util.PHPManualSiteDescriptor;
import org.eclipse.php.ui.util.PixelConverter;
import org.eclipse.php.ui.util.StatusInfo;
import org.eclipse.php.ui.util.StatusUtil;
import org.eclipse.php.ui.wizards.fields.DialogField;
import org.eclipse.php.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.ui.wizards.fields.IListAdapter;
import org.eclipse.php.ui.wizards.fields.ListDialogField;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;

public class PHPManualConfigurationBlock
implements IPreferenceConfigurationBlock {
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private static final int IDX_DEFAULT = 4;
    public static final String PREFERENCES_DELIMITER = new String(new char[]{'\u0005'});
    private IStatus fPHPManualStatus;
    private ListDialogField fPHPManualButtonsList;
    private PreferencePage fMainPreferencePage;
    private OverlayPreferenceStore fStore;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            Button button = (Button)selectionEvent.widget;
            PHPManualConfigurationBlock.this.fStore.setValue((String)PHPManualConfigurationBlock.this.fCheckBoxes.get(button), button.getSelection());
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Button button = (Button)selectionEvent.widget;
            PHPManualConfigurationBlock.this.fStore.setValue((String)PHPManualConfigurationBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };

    protected boolean isDefault(PHPManualConfig pHPManualConfig) {
        return this.fPHPManualButtonsList.getIndexOfElement(pHPManualConfig) == 0;
    }

    protected void setToDefault(PHPManualConfig pHPManualConfig) {
        List list = this.fPHPManualButtonsList.getElements();
        list.remove(pHPManualConfig);
        list.add(0, pHPManualConfig);
        this.fPHPManualButtonsList.setElements(list);
        this.fPHPManualButtonsList.enableButton(4, false);
    }

    public PHPManualConfigurationBlock(PreferencePage preferencePage, OverlayPreferenceStore overlayPreferenceStore) {
        Assert.isNotNull((Object)preferencePage);
        Assert.isNotNull((Object)overlayPreferenceStore);
        this.fMainPreferencePage = preferencePage;
        this.fStore = overlayPreferenceStore;
        this.fStore.addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "phpManualSite"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "phpManualSites"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "phpManualOpenInNewBrowser"));
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return overlayKeyArray;
    }

    public Control createControl(Composite composite) {
        PHPManualAdapter pHPManualAdapter = new PHPManualAdapter();
        String[] stringArray = new String[5];
        stringArray[0] = PHPUIMessages.PHPManualConfigurationBlock_new;
        stringArray[1] = PHPUIMessages.PHPManualConfigurationBlock_edit;
        stringArray[2] = PHPUIMessages.PHPManualConfigurationBlock_remove;
        stringArray[4] = PHPUIMessages.PHPManualConfigurationBlock_default;
        String[] stringArray2 = stringArray;
        this.fPHPManualButtonsList = new ListDialogField(pHPManualAdapter, stringArray2, (ILabelProvider)new PHPManualLabelProvider());
        this.fPHPManualButtonsList.setDialogFieldListener(pHPManualAdapter);
        this.fPHPManualButtonsList.setRemoveButtonIndex(2);
        String[] stringArray3 = new String[]{PHPUIMessages.PHPManualConfigurationBlock_siteName, PHPUIMessages.PHPManualConfigurationBlock_url, PHPUIMessages.PHPManualConfigurationBlock_fileExtension};
        this.fPHPManualButtonsList.setTableColumns(new ListDialogField.ColumnsDescription(stringArray3, true));
        this.fPHPManualButtonsList.setViewerSorter(new PHPManualSorter());
        if (this.fPHPManualButtonsList.getSize() > 0) {
            this.fPHPManualButtonsList.selectFirstElement();
        } else {
            this.fPHPManualButtonsList.enableButton(1, false);
            this.fPHPManualButtonsList.enableButton(4, false);
        }
        this.fPHPManualStatus = new StatusInfo();
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl(composite, 768);
        Composite composite2 = new Composite((Composite)scrolledCompositeImpl, 0);
        composite2.setLayout((Layout)gridLayout);
        scrolledCompositeImpl.setContent((Control)composite2);
        scrolledCompositeImpl.setLayout((Layout)gridLayout);
        scrolledCompositeImpl.setFont(composite.getFont());
        GridData gridData = new GridData(1808);
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        Control control = this.fPHPManualButtonsList.getListControl(composite2);
        control.setLayoutData((Object)gridData);
        Composite composite3 = this.fPHPManualButtonsList.getButtonBox(composite2);
        composite3.setLayoutData((Object)new GridData(258));
        this.addCheckBox(composite2, PHPUIMessages.PHPManualConfigurationBlock_openInNewBrowser, "phpManualOpenInNewBrowser", 0);
        this.addFiller(composite2);
        Point point = composite2.computeSize(-1, -1);
        scrolledCompositeImpl.setMinSize(point.x, point.y);
        return scrolledCompositeImpl;
    }

    private Button addCheckBox(Composite composite, String string, String string2, int n) {
        Button button = new Button(composite, 32);
        button.setText(string);
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n;
        gridData.horizontalSpan = 2;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(button, string2);
        button.setSelection(this.fStore.getBoolean(string2));
        return button;
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label label = new Label(composite, 16384);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gridData);
    }

    protected void sideButtonPressed(int n) {
        if (n == 0) {
            NewPHPManualSiteDialog newPHPManualSiteDialog = new NewPHPManualSiteDialog(this.fMainPreferencePage.getShell(), null, this.fPHPManualButtonsList.getElements());
            if (newPHPManualSiteDialog.open() == 0) {
                this.fPHPManualButtonsList.addElement(newPHPManualSiteDialog.getResult());
            }
        } else if (n == 1) {
            PHPManualConfig pHPManualConfig = (PHPManualConfig)this.fPHPManualButtonsList.getSelectedElements().get(0);
            NewPHPManualSiteDialog newPHPManualSiteDialog = new NewPHPManualSiteDialog(this.fMainPreferencePage.getShell(), pHPManualConfig, this.fPHPManualButtonsList.getElements());
            if (newPHPManualSiteDialog.open() == 0 && newPHPManualSiteDialog.getResult() != null) {
                this.fPHPManualButtonsList.replaceElement(pHPManualConfig, newPHPManualSiteDialog.getResult());
            }
        } else if (n == 4) {
            this.setToDefault((PHPManualConfig)this.fPHPManualButtonsList.getSelectedElements().get(0));
        }
    }

    protected void updateStatus() {
        this.fMainPreferencePage.setValid(this.fPHPManualStatus.isOK());
        StatusUtil.applyToStatusLine((DialogPage)this.fMainPreferencePage, this.fPHPManualStatus);
    }

    public void initialize() {
        ArrayList arrayList = new ArrayList();
        PHPManualConfigurationBlock.initFromExtensions(arrayList);
        PHPManualConfigurationBlock.initFromPreferences((IPreferenceStore)this.fStore, arrayList);
        this.fPHPManualButtonsList.setElements(arrayList);
        PHPManualConfig pHPManualConfig = PHPManualConfigurationBlock.getActiveManualSite((IPreferenceStore)this.fStore, arrayList);
        if (pHPManualConfig != null) {
            this.setToDefault(pHPManualConfig);
        }
    }

    public static void initFromExtensions(List list) {
        PHPManualSiteDescriptor[] pHPManualSiteDescriptorArray = PHPUiPlugin.getDefault().getPHPManualSiteDescriptors();
        int n = 0;
        while (n < pHPManualSiteDescriptorArray.length) {
            list.add(new PHPManualConfig(pHPManualSiteDescriptorArray[n].getLabel(), pHPManualSiteDescriptorArray[n].getURL(), pHPManualSiteDescriptorArray[n].getExtension(), true));
            ++n;
        }
    }

    public static void initFromPreferences(IPreferenceStore iPreferenceStore, List list) {
        String string = iPreferenceStore.getString("phpManualSites");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, PREFERENCES_DELIMITER);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) continue;
                String string3 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) continue;
                String string4 = stringTokenizer.nextToken();
                PHPManualConfig pHPManualConfig = new PHPManualConfig(string2, string3, string4, false);
                boolean bl = false;
                int n = 0;
                while (n < list.size()) {
                    PHPManualConfig pHPManualConfig2 = (PHPManualConfig)list.get(n);
                    if (pHPManualConfig2.label.equals(pHPManualConfig.label) || pHPManualConfig2.url.equals(pHPManualConfig.url)) {
                        bl = true;
                    }
                    ++n;
                }
                if (bl) continue;
                list.add(pHPManualConfig);
            }
        }
    }

    public static PHPManualConfig getActiveManualSite(IPreferenceStore iPreferenceStore, List list) {
        String string = iPreferenceStore.getString("phpManualSite");
        int n = 0;
        while (n < list.size()) {
            PHPManualConfig pHPManualConfig = (PHPManualConfig)list.get(n);
            if (pHPManualConfig.url.equals(string)) {
                return pHPManualConfig;
            }
            ++n;
        }
        return null;
    }

    public void dispose() {
    }

    public void performDefaults() {
        this.initialize();
        this.updateStatus();
    }

    public void performOk() {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = this.fPHPManualButtonsList.getElements().toArray();
        if (objectArray != null && objectArray.length > 0) {
            int n = 0;
            while (n < objectArray.length) {
                PHPManualConfig pHPManualConfig = (PHPManualConfig)objectArray[n];
                if (!pHPManualConfig.isContributed) {
                    if (stringBuffer.length() != 0) {
                        stringBuffer.append(PREFERENCES_DELIMITER);
                    }
                    stringBuffer.append(pHPManualConfig.label);
                    stringBuffer.append(PREFERENCES_DELIMITER);
                    stringBuffer.append(pHPManualConfig.url);
                    stringBuffer.append(PREFERENCES_DELIMITER);
                    stringBuffer.append(pHPManualConfig.extension);
                }
                ++n;
            }
            this.fStore.setValue("phpManualSites", stringBuffer.toString());
            this.fStore.setValue("phpManualSite", ((PHPManualConfig)objectArray[0]).url);
        }
    }

    private class PHPManualAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private PHPManualAdapter() {
        }

        private boolean canEdit(List list) {
            return list.size() == 1 && !((PHPManualConfig)list.get(0)).isContributed;
        }

        private boolean canRemove(List list) {
            Object[] objectArray = list.toArray();
            int n = 0;
            while (n < objectArray.length) {
                if (((PHPManualConfig)objectArray[n]).isContributed) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private boolean canSetToDefault(List list) {
            return list.size() == 1 && !PHPManualConfigurationBlock.this.isDefault((PHPManualConfig)list.get(0));
        }

        public void dialogFieldChanged(DialogField dialogField) {
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            PHPManualConfigurationBlock.this.sideButtonPressed(n);
        }

        public void doubleClicked(ListDialogField listDialogField) {
            if (this.canEdit(listDialogField.getSelectedElements())) {
                PHPManualConfigurationBlock.this.sideButtonPressed(1);
            }
        }

        public void selectionChanged(ListDialogField listDialogField) {
            List list = listDialogField.getSelectedElements();
            listDialogField.enableButton(1, this.canEdit(list));
            listDialogField.enableButton(4, this.canSetToDefault(list));
            listDialogField.enableButton(2, this.canRemove(list));
        }
    }

    public static class PHPManualConfig {
        private String label;
        private String url;
        private String extension;
        private boolean isContributed;

        public PHPManualConfig(String string, String string2, String string3, boolean bl) {
            this.label = string;
            this.url = string2;
            this.isContributed = bl;
            this.extension = string3;
        }

        public boolean isContributed() {
            return this.isContributed;
        }

        public String getLabel() {
            return this.label;
        }

        public String getUrl() {
            return this.url;
        }

        public String getExtension() {
            return this.extension;
        }
    }

    private class PHPManualLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        private PHPManualLabelProvider() {
        }

        public Font getFont(Object object) {
            if (PHPManualConfigurationBlock.this.isDefault((PHPManualConfig)object)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (n == 0) {
                return ((PHPManualConfig)object).label;
            }
            if (n == 1) {
                return ((PHPManualConfig)object).url;
            }
            if (n == 2) {
                return ((PHPManualConfig)object).extension;
            }
            return null;
        }
    }

    private class PHPManualSorter
    extends ViewerSorter {
        private PHPManualSorter() {
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            return this.collator.compare(((PHPManualConfig)object).label, ((PHPManualConfig)object2).label);
        }
    }
}

