/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.dnd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.ui.util.SWTUtil;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ResourceTransfer;

public class ResourceTransferDragAdapter
extends DragSourceAdapter
implements TransferDragSourceListener {
    private ISelectionProvider fProvider;
    private static final List EMPTY_LIST = new ArrayList(0);
    static /* synthetic */ Class class$0;

    public ResourceTransferDragAdapter(ISelectionProvider iSelectionProvider) {
        this.fProvider = iSelectionProvider;
        Assert.isNotNull((Object)this.fProvider);
    }

    public Transfer getTransfer() {
        return ResourceTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.doit = this.convertSelection().size() > 0;
    }

    public void dragSetData(DragSourceEvent dragSourceEvent) {
        List list = this.convertSelection();
        dragSourceEvent.data = list.toArray(new IResource[list.size()]);
    }

    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (!dragSourceEvent.doit) {
            return;
        }
        if (dragSourceEvent.detail == 2) {
            this.handleFinishedDropMove(dragSourceEvent);
        }
    }

    private List convertSelection() {
        ISelection iSelection = this.fProvider.getSelection();
        if (!(iSelection instanceof IStructuredSelection)) {
            return EMPTY_LIST;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        ArrayList<IResource> arrayList = new ArrayList<IResource>(iStructuredSelection.size());
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            IResource iResource;
            Object e = iterator.next();
            if (!(e instanceof IAdaptable)) continue;
            IAdaptable iAdaptable = (IAdaptable)e;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) continue;
            arrayList.add(iResource);
        }
        return arrayList;
    }

    private void handleFinishedDropMove(DragSourceEvent dragSourceEvent) {
        IResource iResource;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.php.ui", 10001, "Cannot delete resources", null);
        List list = this.convertSelection();
        Shell shell = list.iterator();
        while (shell.hasNext()) {
            iResource = (IResource)shell.next();
            try {
                iResource.delete(true, null);
            }
            catch (CoreException coreException) {
                multiStatus.add(coreException.getStatus());
            }
        }
        if (multiStatus.getChildren().length > 0) {
            shell = SWTUtil.getShell(dragSourceEvent.widget);
            iResource = new ErrorDialog(shell, "Moving Resources with Drag and Drop", "Cannot delete the following file(s)", (IStatus)multiStatus, 4);
            iResource.open();
        }
    }
}

