/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.preferences.includepath;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.PHPUIMessages;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.preferences.includepath.IPVariableElement;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class IPVariableElementLabelProvider
extends LabelProvider
implements IColorProvider {
    private Image fZIPImage;
    private Image fFolderImage;
    private boolean fShowResolvedVariables;
    private Color fResolvedBackground;

    public IPVariableElementLabelProvider(boolean bl) {
        ImageRegistry imageRegistry = PHPUiPlugin.getDefault().getImageRegistry();
        this.fZIPImage = imageRegistry.get("org.eclipse.php.ui.zip_l_obj.gif");
        this.fFolderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        this.fShowResolvedVariables = bl;
        this.fResolvedBackground = null;
    }

    public Image getImage(Object object) {
        if (object instanceof IPVariableElement) {
            IPVariableElement iPVariableElement = (IPVariableElement)object;
            IPath iPath = iPVariableElement.getPath();
            if (iPath.toFile().isFile()) {
                return this.fZIPImage;
            }
            return this.fFolderImage;
        }
        return super.getImage(object);
    }

    public String getText(Object object) {
        if (object instanceof IPVariableElement) {
            IPVariableElement iPVariableElement = (IPVariableElement)object;
            String string = iPVariableElement.getName();
            IPath iPath = iPVariableElement.getPath();
            StringBuffer stringBuffer = new StringBuffer(string);
            if (iPVariableElement.isReserved()) {
                stringBuffer.append(' ');
                stringBuffer.append(PHPUIMessages.CPVariableElementLabelProvider_reserved);
            }
            if (iPath != null) {
                stringBuffer.append(" - ");
                if (!iPath.isEmpty()) {
                    stringBuffer.append(iPath.toOSString());
                } else {
                    stringBuffer.append(PHPUIMessages.CPVariableElementLabelProvider_empty);
                }
            }
            return stringBuffer.toString();
        }
        return super.getText(object);
    }

    public Color getForeground(Object object) {
        return null;
    }

    public Color getBackground(Object object) {
        if (object instanceof IPVariableElement) {
            IPVariableElement iPVariableElement = (IPVariableElement)object;
            if (!this.fShowResolvedVariables && iPVariableElement.isReserved()) {
                if (this.fResolvedBackground == null) {
                    Display display = Display.getCurrent();
                    this.fResolvedBackground = display.getSystemColor(29);
                }
                return this.fResolvedBackground;
            }
        }
        return null;
    }

    public void dispose() {
        super.dispose();
    }
}

