/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.platform.internal.Messages;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.intro.config.IIntroContentProvider;
import org.eclipse.ui.intro.config.IIntroContentProviderSite;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EclipseRSSViewer
implements IIntroContentProvider {
    private static final String NEWS_URL = "http://www.eclipse.org/home/eclipsenews.rss";
    private static final String INTRO_SHOW_IN_BROWSER = "http://org.eclipse.ui.intro/openBrowser?url=";
    private static final int MAX_NEWS_ITEMS = 5;
    private static final String HREF_BULLET = "bullet";
    private IIntroContentProviderSite site;
    private boolean disposed;
    private String id;
    private FormToolkit toolkit;
    private Composite parent;
    private Image bulletImage;
    private List items;
    private FormText formText;

    public void init(IIntroContentProviderSite site) {
        this.site = site;
        Thread newsWorker = new Thread(new NewsFeed());
        newsWorker.start();
    }

    public void createContent(String id, PrintWriter out) {
        if (this.disposed) {
            return;
        }
        this.id = id;
        if (this.items == null) {
            out.print("<p class=\"status-text\">");
            out.print(Messages.getString("EclipseRSSViewer_loading"));
            out.println("</p>");
        } else {
            if (this.items.size() > 0) {
                out.println("<ul id=\"eclipse-news\">");
                int i = 0;
                while (i < this.items.size()) {
                    NewsItem item = (NewsItem)this.items.get(i);
                    out.print("<li>");
                    out.print("<a class=\"topicList\" href=\"");
                    out.print(this.createExternalURL(item.url));
                    out.print("\">");
                    out.print(item.label);
                    out.print("</a>");
                    out.println("</li>");
                    ++i;
                }
            } else {
                out.print("<p class=\"status-text\">");
                out.print(Messages.getString("EclipseRSSViewer_noNews"));
                out.println("</p>");
            }
            out.println("</ul>");
        }
    }

    public void createContent(String id, Composite parent, FormToolkit toolkit) {
        if (this.disposed) {
            return;
        }
        if (this.formText == null) {
            this.formText = toolkit.createFormText(parent, true);
            this.formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    EclipseRSSViewer.this.doNavigate((String)e.getHref());
                }
            });
            this.bulletImage = this.createImage((IPath)new Path("intro/css/graphics/arrow.gif"));
            if (this.bulletImage != null) {
                this.formText.setImage(HREF_BULLET, this.bulletImage);
            }
            this.parent = parent;
            this.toolkit = toolkit;
            this.id = id;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<form>");
        if (this.items == null) {
            buffer.append("<p>");
            buffer.append(Messages.getString("EclipseRSSViewer_loading"));
            buffer.append("</p>");
        } else if (this.items.size() > 0) {
            int i = 0;
            while (i < this.items.size()) {
                NewsItem item = (NewsItem)this.items.get(i);
                buffer.append("<li style=\"image\" value=\"");
                buffer.append(HREF_BULLET);
                buffer.append("\">");
                buffer.append("<a href=\"");
                buffer.append(item.url);
                buffer.append("\">");
                buffer.append(item.label);
                buffer.append("</a>");
                buffer.append("</li>");
                ++i;
            }
        } else {
            buffer.append("<p>");
            buffer.append(Messages.getString("EclipseRSSViewer_noNews"));
            buffer.append("</p>");
        }
        buffer.append("</form>");
        this.formText.setText(buffer.toString(), true, false);
    }

    private String createExternalURL(String url) {
        return INTRO_SHOW_IN_BROWSER + URLEncoder.encode(url);
    }

    private Image createImage(IPath path) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.platform");
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        try {
            url = FileLocator.toFileURL((URL)url);
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            return desc.createImage();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void doNavigate(final String url) {
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IIntroURL introUrl = IntroURLFactory.createIntroURL((String)url);
                if (introUrl != null) {
                    introUrl.execute();
                    return;
                }
                EclipseRSSViewer.this.openBrowser(url);
            }
        });
    }

    private void openBrowser(String href) {
        try {
            URL url = new URL(href);
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            support.getExternalBrowser().openURL(url);
        }
        catch (PartInitException partInitException) {
        }
        catch (MalformedURLException malformedURLException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createNewsItems() {
        this.items = Collections.synchronizedList(new ArrayList());
        InputStream in = null;
        try {
            try {
                URL url = new URL(NEWS_URL);
                in = url.openStream();
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                parser.parse(in, (DefaultHandler)new RSSHandler());
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (in == null) return;
        in.close();
    }

    private void reflow(Control initiator) {
        Control c = initiator;
        while (c != null) {
            c.setRedraw(false);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
        c = initiator;
        while (c != null) {
            if (c instanceof Composite) {
                ((Composite)c).layout(true);
            }
            if (!((c = c.getParent()) instanceof ScrolledForm)) continue;
            ((ScrolledForm)c).reflow(true);
            break;
        }
        c = initiator;
        while (c != null) {
            c.setRedraw(true);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
    }

    public void dispose() {
        if (this.bulletImage != null) {
            this.bulletImage.dispose();
            this.bulletImage = null;
        }
        this.disposed = true;
    }

    static /* synthetic */ Composite access$2(EclipseRSSViewer eclipseRSSViewer) {
        return eclipseRSSViewer.parent;
    }

    static /* synthetic */ String access$3(EclipseRSSViewer eclipseRSSViewer) {
        return eclipseRSSViewer.id;
    }

    static /* synthetic */ FormToolkit access$4(EclipseRSSViewer eclipseRSSViewer) {
        return eclipseRSSViewer.toolkit;
    }

    static /* synthetic */ FormText access$5(EclipseRSSViewer eclipseRSSViewer) {
        return eclipseRSSViewer.formText;
    }

    static /* synthetic */ void access$6(EclipseRSSViewer eclipseRSSViewer, Control control) {
        eclipseRSSViewer.reflow(control);
    }

    static /* synthetic */ IIntroContentProviderSite access$7(EclipseRSSViewer eclipseRSSViewer) {
        return eclipseRSSViewer.site;
    }

    class NewsFeed
    implements Runnable {
        NewsFeed() {
        }

        public void run() {
            if (EclipseRSSViewer.this.disposed) {
                return;
            }
            EclipseRSSViewer.this.createNewsItems();
            if (EclipseRSSViewer.this.disposed) {
                return;
            }
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(this){
                final /* synthetic */ NewsFeed this$1;
                {
                    this.this$1 = newsFeed;
                }

                public void run() {
                    if (EclipseRSSViewer.access$2(NewsFeed.access$0(this.this$1)) != null) {
                        NewsFeed.access$0(this.this$1).createContent(EclipseRSSViewer.access$3(NewsFeed.access$0(this.this$1)), EclipseRSSViewer.access$2(NewsFeed.access$0(this.this$1)), EclipseRSSViewer.access$4(NewsFeed.access$0(this.this$1)));
                        EclipseRSSViewer.access$6(NewsFeed.access$0(this.this$1), (Control)EclipseRSSViewer.access$5(NewsFeed.access$0(this.this$1)));
                    }
                    EclipseRSSViewer.access$7(NewsFeed.access$0(this.this$1)).reflow((IIntroContentProvider)NewsFeed.access$0(this.this$1), true);
                }
            });
        }

        static /* synthetic */ EclipseRSSViewer access$0(NewsFeed newsFeed) {
            return newsFeed.EclipseRSSViewer.this;
        }
    }

    static class NewsItem {
        String label;
        String url;

        NewsItem() {
        }

        void setLabel(String label) {
            this.label = label;
        }

        void setUrl(String url) {
            this.url = url;
        }
    }

    private class RSSHandler
    extends DefaultHandler {
        private static final String ELEMENT_RSS = "rss";
        private static final String ELEMENT_CHANNEL = "channel";
        private static final String ELEMENT_ITEM = "item";
        private static final String ELEMENT_TITLE = "title";
        private static final String ELEMENT_LINK = "link";
        private Stack stack = new Stack();
        private StringBuffer buf;
        private NewsItem item;

        private RSSHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.stack.push(qName);
            if ((ELEMENT_TITLE.equals(qName) || ELEMENT_LINK.equals(qName)) && this.item != null) {
                this.buf = new StringBuffer();
            } else if (ELEMENT_ITEM.equals(qName) && ELEMENT_CHANNEL.equals(this.stack.get(1)) && ELEMENT_RSS.equals(this.stack.get(0)) && this.stack.size() == 3 && EclipseRSSViewer.this.items.size() < 5) {
                this.item = new NewsItem();
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.stack.pop();
            if (this.item != null) {
                if (this.buf != null) {
                    if (ELEMENT_TITLE.equals(qName)) {
                        this.item.setLabel(this.buf.toString().trim());
                        this.buf = null;
                    } else if (ELEMENT_LINK.equals(qName)) {
                        this.item.setUrl(this.buf.toString().trim());
                        this.buf = null;
                    }
                } else if (ELEMENT_ITEM.equals(qName)) {
                    if (this.item.label != null && this.item.label.length() > 0 && this.item.url != null && this.item.url.length() > 0) {
                        EclipseRSSViewer.this.items.add(this.item);
                    }
                    this.item = null;
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buf != null) {
                this.buf.append(new String(ch, start, length));
            }
        }
    }
}

