/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.wsdl.traversal;

import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLVisitor;
import org.w3c.dom.Element;

public class WSDLTraversal {
    private WSDLVisitor visitor;
    private boolean traverseBinding2BindingOperation = true;
    private boolean traverseBinding2Element = true;
    private boolean traverseBinding2ExtensibilityElement = true;
    private boolean traverseBinding2PortType = true;
    private boolean traverseBindingFault2Element = true;
    private boolean traverseBindingFault2ExtensibilityElement = true;
    private boolean traverseBindingInput2Element = true;
    private boolean traverseBindingInput2ExtensibilityElement = true;
    private boolean traverseBindingOperation2BindingFault = true;
    private boolean traverseBindingOperation2BindingInput = true;
    private boolean traverseBindingOperation2BindingOutput = true;
    private boolean traverseBindingOperation2Element = true;
    private boolean traverseBindingOperation2ExtensibilityElement = true;
    private boolean traverseBindingOperation2Operation = true;
    private boolean traverseBindingOutput2Element = true;
    private boolean traverseBindingOutput2ExtensibilityElement = true;
    private boolean traverseDefinition2Binding = true;
    private boolean traverseDefinition2Element = true;
    private boolean traverseDefinition2ExtensibilityElement = true;
    private boolean traverseDefinition2Import = true;
    private boolean traverseDefinition2Message = true;
    private boolean traverseDefinition2PortType = true;
    private boolean traverseDefinition2Service = true;
    private boolean traverseDefinition2Types = true;
    private boolean traverseFault2Element = true;
    private boolean traverseFault2Message = true;
    private boolean traverseImport2Definition = true;
    private boolean traverseImport2Element = true;
    private boolean traverseInput2Element = true;
    private boolean traverseInput2Message = true;
    private boolean traverseMessage2Element = true;
    private boolean traverseMessage2Part = true;
    private boolean traverseOperation2Element = true;
    private boolean traverseOperation2Fault = true;
    private boolean traverseOperation2Input = true;
    private boolean traverseOperation2Output = true;
    private boolean traverseOutput2Element = true;
    private boolean traverseOutput2Message = true;
    private boolean traversePart2Element = true;
    private boolean traversePort2Binding = true;
    private boolean traversePort2Element = true;
    private boolean traversePort2ExtensibilityElement = true;
    private boolean traversePortType2Element = true;
    private boolean traversePortType2Operation = true;
    private boolean traverseService2Element = true;
    private boolean traverseService2ExtensibilityElement = true;
    private boolean traverseService2Port = true;
    private boolean traverseTypes2Element = true;
    private boolean traverseTypes2ExtensibilityElement = true;
    private boolean traverseSOAPHeader2SOAPHeaderFault = true;
    private boolean traverseBinding2SOAPBinding = true;
    private boolean traverseBindingOperation2SOAPOperation = true;
    private boolean traverseBindingInput2SOAPHeader = true;
    private boolean traverseBindingInput2SOAPBody = true;
    private boolean traverseBindingOutput2SOAPHeader = true;
    private boolean traverseBindingOutput2SOAPBody = true;
    private boolean traverseBindingFault2SOAPFault = true;
    private boolean visitBinding = false;
    private boolean visitBindingFault = false;
    private boolean visitBindingInput = false;
    private boolean visitBindingOperation = false;
    private boolean visitBindingOutput = false;
    private boolean visitDefinition = false;
    private boolean visitElement = false;
    private boolean visitExtensibilityElement = false;
    private boolean visitFault = false;
    private boolean visitImport = false;
    private boolean visitInput = false;
    private boolean visitMessage = false;
    private boolean visitOperation = false;
    private boolean visitOutput = false;
    private boolean visitPart = false;
    private boolean visitPort = false;
    private boolean visitPortType = false;
    private boolean visitService = false;
    private boolean visitTypes = false;
    private boolean visitSOAPBinding = false;
    private boolean visitSOAPBody = false;
    private boolean visitSOAPFault = false;
    private boolean visitSOAPHeader = false;
    private boolean visitSOAPHeaderFault = false;
    private boolean visitSOAPOperation = false;

    public void ignoreReferences() {
        this.ignoreBinding2PortType();
        this.ignoreBindingOperation2Operation();
        this.ignoreFault2Message();
        this.ignoreInput2Message();
        this.ignoreOutput2Message();
        this.ignorePort2Binding();
    }

    public void setVisitor(WSDLVisitor visitor) {
        this.visitor = visitor;
    }

    public WSDLTraversal ignoreBinding2SOAPBinding() {
        this.traverseBinding2SOAPBinding = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOperation2SOAPOperation() {
        this.traverseBindingOperation2SOAPOperation = false;
        return this;
    }

    public WSDLTraversal ignoreBindingInput2SOAPHeader() {
        this.traverseBindingInput2SOAPHeader = false;
        return this;
    }

    public WSDLTraversal ignoreBindingInput2SOAPBody() {
        this.traverseBindingInput2SOAPBody = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOutput2SOAPHeader() {
        this.traverseBindingOutput2SOAPHeader = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOutput2SOAPBody() {
        this.traverseBindingOutput2SOAPBody = false;
        return this;
    }

    public WSDLTraversal ignoreBindingFault2SOAPFault() {
        this.traverseBindingFault2SOAPFault = false;
        return this;
    }

    public WSDLTraversal ignoreSOAPHeader2SOAPHeaderFault() {
        this.traverseSOAPHeader2SOAPHeaderFault = false;
        return this;
    }

    public WSDLTraversal ignoreBinding2BindingOperation() {
        this.traverseBinding2BindingOperation = false;
        return this;
    }

    public WSDLTraversal ignoreBinding2Element() {
        this.traverseBinding2Element = false;
        return this;
    }

    public WSDLTraversal ignoreBinding2ExtensibilityElement() {
        this.traverseBinding2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal ignoreBinding2PortType() {
        this.traverseBinding2PortType = false;
        return this;
    }

    public WSDLTraversal ignoreBindingFault2Element() {
        this.traverseBindingFault2Element = false;
        return this;
    }

    public WSDLTraversal ignoreBindingFault2ExtensibilityElement() {
        this.traverseBindingFault2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal ignoreBindingInput2Element() {
        this.traverseBindingInput2Element = false;
        return this;
    }

    public WSDLTraversal ignoreBindingInput2ExtensibilityElement() {
        this.traverseBindingInput2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOperation2BindingFault() {
        this.traverseBindingOperation2BindingFault = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOperation2BindingInput() {
        this.traverseBindingOperation2BindingInput = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOperation2BindingOutput() {
        this.traverseBindingOperation2BindingOutput = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOperation2Element() {
        this.traverseBindingOperation2Element = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOperation2ExtensibilityElement() {
        this.traverseBindingOperation2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOperation2Operation() {
        this.traverseBindingOperation2Operation = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOutput2Element() {
        this.traverseBindingOutput2Element = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOutput2ExtensibilityElement() {
        this.traverseBindingOutput2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal ignoreDefinition2Binding() {
        this.traverseDefinition2Binding = false;
        return this;
    }

    public WSDLTraversal ignoreDefinition2Element() {
        this.traverseDefinition2Element = false;
        return this;
    }

    public WSDLTraversal ignoreDefinition2ExtensibilityElement() {
        this.traverseDefinition2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal ignoreDefinition2Import() {
        this.traverseDefinition2Import = false;
        return this;
    }

    public WSDLTraversal ignoreDefinition2Message() {
        this.traverseDefinition2Message = false;
        return this;
    }

    public WSDLTraversal ignoreDefinition2PortType() {
        this.traverseDefinition2PortType = false;
        return this;
    }

    public WSDLTraversal ignoreDefinition2Service() {
        this.traverseDefinition2Service = false;
        return this;
    }

    public WSDLTraversal ignoreDefinition2Types() {
        this.traverseDefinition2Types = false;
        return this;
    }

    public WSDLTraversal ignoreFault2Element() {
        this.traverseFault2Element = false;
        return this;
    }

    public WSDLTraversal ignoreFault2Message() {
        this.traverseFault2Message = false;
        return this;
    }

    public WSDLTraversal ignoreImport2Definition() {
        this.traverseImport2Definition = false;
        return this;
    }

    public WSDLTraversal ignoreImport2Element() {
        this.traverseImport2Element = false;
        return this;
    }

    public WSDLTraversal ignoreInput2Element() {
        this.traverseInput2Element = false;
        return this;
    }

    public WSDLTraversal ignoreInput2Message() {
        this.traverseInput2Message = false;
        return this;
    }

    public WSDLTraversal ignoreMessage2Element() {
        this.traverseMessage2Element = false;
        return this;
    }

    public WSDLTraversal ignoreMessage2Part() {
        this.traverseMessage2Part = false;
        return this;
    }

    public WSDLTraversal ignoreOperation2Element() {
        this.traverseOperation2Element = false;
        return this;
    }

    public WSDLTraversal ignoreOperation2Fault() {
        this.traverseOperation2Fault = false;
        return this;
    }

    public WSDLTraversal ignoreOperation2Input() {
        this.traverseOperation2Input = false;
        return this;
    }

    public WSDLTraversal ignoreOperation2Output() {
        this.traverseOperation2Output = false;
        return this;
    }

    public WSDLTraversal ignoreOutput2Element() {
        this.traverseOutput2Element = false;
        return this;
    }

    public WSDLTraversal ignoreOutput2Message() {
        this.traverseOutput2Message = false;
        return this;
    }

    public WSDLTraversal ignorePart2Element() {
        this.traversePart2Element = false;
        return this;
    }

    public WSDLTraversal ignorePort2Binding() {
        this.traversePort2Binding = false;
        return this;
    }

    public WSDLTraversal ignorePort2Element() {
        this.traversePort2Element = false;
        return this;
    }

    public WSDLTraversal ignorePort2ExtensibilityElement() {
        this.traversePort2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal ignorePortType2Element() {
        this.traversePortType2Element = false;
        return this;
    }

    public WSDLTraversal ignorePortType2Operation() {
        this.traversePortType2Operation = false;
        return this;
    }

    public WSDLTraversal ignoreService2Element() {
        this.traverseService2Element = false;
        return this;
    }

    public WSDLTraversal ignoreService2ExtensibilityElement() {
        this.traverseService2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal ignoreService2Port() {
        this.traverseService2Port = false;
        return this;
    }

    public WSDLTraversal ignoreTypes2Element() {
        this.traverseTypes2Element = false;
        return this;
    }

    public WSDLTraversal ignoreTypes2ExtensibilityElement() {
        this.traverseTypes2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal visitSOAPBinding(boolean value) {
        this.visitSOAPBinding = value;
        return this;
    }

    public WSDLTraversal visitSOAPBody(boolean value) {
        this.visitSOAPBody = value;
        return this;
    }

    public WSDLTraversal visitSOAPFault(boolean value) {
        this.visitSOAPFault = value;
        return this;
    }

    public WSDLTraversal visitSOAPHeader(boolean value) {
        this.visitSOAPHeader = value;
        return this;
    }

    public WSDLTraversal visitSOAPHeaderFault(boolean value) {
        this.visitSOAPHeaderFault = value;
        return this;
    }

    public WSDLTraversal visitSOAPOperation(boolean value) {
        this.visitSOAPOperation = value;
        return this;
    }

    public WSDLTraversal visitBinding(boolean value) {
        this.visitBinding = value;
        return this;
    }

    public WSDLTraversal visitBindingFault(boolean value) {
        this.visitBindingFault = value;
        return this;
    }

    public WSDLTraversal visitBindingInput(boolean value) {
        this.visitBindingInput = value;
        return this;
    }

    public WSDLTraversal visitBindingOperation(boolean value) {
        this.visitBindingOperation = value;
        return this;
    }

    public WSDLTraversal visitBindingOutput(boolean value) {
        this.visitBindingOutput = value;
        return this;
    }

    public WSDLTraversal visitDefinition(boolean value) {
        this.visitDefinition = value;
        return this;
    }

    public WSDLTraversal visitElement(boolean value) {
        this.visitElement = value;
        return this;
    }

    public WSDLTraversal visitExtensibilityElement(boolean value) {
        this.visitExtensibilityElement = value;
        return this;
    }

    public WSDLTraversal visitFault(boolean value) {
        this.visitFault = value;
        return this;
    }

    public WSDLTraversal visitImport(boolean value) {
        this.visitImport = value;
        return this;
    }

    public WSDLTraversal visitInput(boolean value) {
        this.visitInput = value;
        return this;
    }

    public WSDLTraversal visitMessage(boolean value) {
        this.visitMessage = value;
        return this;
    }

    public WSDLTraversal visitOperation(boolean value) {
        this.visitOperation = value;
        return this;
    }

    public WSDLTraversal visitOutput(boolean value) {
        this.visitOutput = value;
        return this;
    }

    public WSDLTraversal visitPart(boolean value) {
        this.visitPart = value;
        return this;
    }

    public WSDLTraversal visitPort(boolean value) {
        this.visitPort = value;
        return this;
    }

    public WSDLTraversal visitPortType(boolean value) {
        this.visitPortType = value;
        return this;
    }

    public WSDLTraversal visitService(boolean value) {
        this.visitService = value;
        return this;
    }

    public WSDLTraversal visitTypes(boolean value) {
        this.visitTypes = value;
        return this;
    }

    public WSDLTraversal ignoreBinding() {
        this.traverseDefinition2Binding = false;
        this.traversePort2Binding = false;
        return this;
    }

    public WSDLTraversal ignoreBindingFault() {
        this.traverseBindingOperation2BindingFault = false;
        return this;
    }

    public WSDLTraversal ignoreBindingInput() {
        this.traverseBindingOperation2BindingInput = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOperation() {
        this.traverseBinding2BindingOperation = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOutput() {
        this.traverseBindingOperation2BindingOutput = false;
        return this;
    }

    public WSDLTraversal ignoreDefinition() {
        this.traverseImport2Definition = false;
        return this;
    }

    public WSDLTraversal ignoreElement() {
        this.traverseBinding2Element = false;
        this.traverseBindingFault2Element = false;
        this.traverseBindingInput2Element = false;
        this.traverseBindingOperation2Element = false;
        this.traverseBindingOutput2Element = false;
        this.traverseDefinition2Element = false;
        this.traversePort2Element = false;
        this.traverseService2Element = false;
        this.traverseFault2Element = false;
        this.traverseOutput2Element = false;
        this.traverseImport2Element = false;
        this.traverseInput2Element = false;
        this.traverseOperation2Element = false;
        this.traverseMessage2Element = false;
        this.traversePart2Element = false;
        this.traversePortType2Element = false;
        this.traverseTypes2Element = false;
        return this;
    }

    public WSDLTraversal ignoreExtensibilityElement() {
        this.traverseService2ExtensibilityElement = false;
        this.traversePort2ExtensibilityElement = false;
        this.traverseDefinition2ExtensibilityElement = false;
        this.traverseBindingOutput2ExtensibilityElement = false;
        this.traverseBinding2ExtensibilityElement = false;
        this.traverseBindingFault2ExtensibilityElement = false;
        this.traverseBindingInput2ExtensibilityElement = false;
        this.traverseBindingOperation2ExtensibilityElement = false;
        this.traverseTypes2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal ignoreSOAPBinding() {
        this.traverseBinding2SOAPBinding = false;
        return this;
    }

    public WSDLTraversal ignoreSOAPOperation() {
        this.traverseBindingOperation2SOAPOperation = false;
        return this;
    }

    public WSDLTraversal ignoreSOAPBody() {
        this.traverseBindingInput2SOAPBody = false;
        this.traverseBindingOutput2SOAPBody = false;
        return this;
    }

    public WSDLTraversal ignoreSOAPHeader() {
        this.traverseBindingInput2SOAPHeader = false;
        this.traverseBindingOutput2SOAPHeader = false;
        return this;
    }

    public WSDLTraversal ignoreSOAPHeaderFault() {
        this.traverseSOAPHeader2SOAPHeaderFault = false;
        return this;
    }

    public WSDLTraversal ignoreSOAPFault() {
        this.traverseBindingFault2SOAPFault = false;
        return this;
    }

    public WSDLTraversal ignoreFault() {
        this.traverseOperation2Fault = false;
        return this;
    }

    public WSDLTraversal ignoreImport() {
        this.traverseImport2Definition = false;
        return this;
    }

    public WSDLTraversal ignoreInput() {
        this.traverseOperation2Input = false;
        return this;
    }

    public WSDLTraversal ignoreMessage() {
        this.traverseFault2Message = false;
        this.traverseDefinition2Message = false;
        this.traverseInput2Message = false;
        this.traverseOutput2Message = false;
        return this;
    }

    public WSDLTraversal ignoreOperation() {
        this.traverseBindingOperation2Operation = false;
        this.traversePortType2Operation = false;
        return this;
    }

    public WSDLTraversal ignoreOutput() {
        this.traverseOperation2Output = false;
        return this;
    }

    public WSDLTraversal ignorePart() {
        this.traverseMessage2Part = false;
        return this;
    }

    public WSDLTraversal ignorePort() {
        this.traverseService2Port = false;
        return this;
    }

    public WSDLTraversal ignorePortType() {
        this.traverseBinding2PortType = false;
        this.traverseDefinition2PortType = false;
        return this;
    }

    public WSDLTraversal ignoreService() {
        this.traverseDefinition2Service = false;
        return this;
    }

    public WSDLTraversal ignoreTypes() {
        this.traverseDefinition2Types = false;
        return this;
    }

    private void adjust() {
        this.adjustPart();
        this.adjustService();
        this.adjustTypes();
        this.adjustOperation();
        this.adjustInput();
        this.adjustOutput();
        this.adjustFault();
        this.adjustBinding();
        this.adjustBindingOperation();
        this.adjustBindingInput();
        this.adjustBindingOutput();
        this.adjustBindingFault();
        this.adjustImport();
        this.adjustElement();
        this.adjustMessage();
        this.adjustPort();
        this.adjustPortType();
        this.adjustDefinition();
        this.adjustExtensibilityElement();
        this.adjustSOAPBinding();
        this.adjustSOAPBody();
        this.adjustSOAPHeader();
        this.adjustSOAPHeaderFault();
        this.adjustSOAPFault();
        this.adjustSOAPOperation();
    }

    private boolean adjustExtensibilityElement() {
        boolean value = this.visitExtensibilityElement;
        if (!value) {
            this.ignoreExtensibilityElement();
        }
        return value;
    }

    private boolean adjustPart() {
        boolean value;
        boolean bl = value = this.visitPart || this.traversePart2Element && this.adjustElement();
        if (!value) {
            this.ignorePart();
        }
        return value;
    }

    private boolean adjustSOAPHeader() {
        boolean value;
        boolean bl = value = this.visitSOAPHeader || this.traverseSOAPHeader2SOAPHeaderFault && this.adjustSOAPHeaderFault();
        if (!value) {
            this.ignoreSOAPHeader();
        }
        return value;
    }

    private boolean adjustBindingOutput() {
        boolean value;
        boolean bl = value = this.visitBindingOutput || this.traverseBindingOutput2Element && this.adjustElement() || this.traverseBindingOutput2ExtensibilityElement && this.adjustExtensibilityElement() || this.traverseBindingOutput2SOAPBody && this.adjustSOAPBody() || this.traverseBindingOutput2SOAPHeader && this.adjustSOAPHeader();
        if (!value) {
            this.ignoreBindingOutput();
        }
        return value;
    }

    private boolean adjustElement() {
        boolean value = this.visitElement;
        if (!value) {
            this.ignoreElement();
        }
        return value;
    }

    private boolean adjustTypes() {
        boolean value;
        boolean bl = value = this.visitTypes || this.traverseTypes2Element && this.adjustElement() || this.traverseTypes2ExtensibilityElement && this.adjustExtensibilityElement();
        if (!value) {
            this.ignoreTypes();
        }
        return value;
    }

    private boolean adjustSOAPBinding() {
        boolean value = this.visitSOAPBinding;
        if (!value) {
            this.ignoreSOAPBinding();
        }
        return value;
    }

    private boolean adjustPort() {
        boolean value;
        boolean bl = value = this.visitPort || this.traversePort2Element && this.adjustElement() || this.traversePort2ExtensibilityElement && this.adjustExtensibilityElement() || this.traversePort2Binding && this.adjustBinding();
        if (!value) {
            this.ignorePort();
        }
        return value;
    }

    private boolean adjustOperation() {
        boolean value;
        boolean bl = value = this.visitOperation || this.traverseOperation2Element && this.adjustElement() || this.traverseOperation2Input && this.adjustInput() || this.traverseOperation2Output && this.adjustOutput() || this.traverseOperation2Fault && this.adjustFault();
        if (!value) {
            this.ignoreOperation();
        }
        return value;
    }

    private boolean adjustBindingOperation() {
        boolean value;
        boolean bl = value = this.visitBindingOperation || this.traverseBindingOperation2Element && this.adjustElement() || this.traverseBindingOperation2BindingFault && this.adjustBindingFault() || this.traverseBindingOperation2BindingOutput && this.adjustBindingOutput() || this.traverseBindingOperation2Operation && this.adjustOperation() || this.traverseBindingOperation2BindingInput && this.adjustBindingInput() || this.traverseBindingOperation2ExtensibilityElement && this.adjustExtensibilityElement() || this.traverseBindingOperation2SOAPOperation && this.adjustSOAPOperation();
        if (!value) {
            this.ignoreBindingOperation();
        }
        return value;
    }

    private boolean adjustInput() {
        boolean value;
        boolean bl = value = this.visitInput || this.traverseInput2Element && this.adjustElement() || this.traverseInput2Message && this.adjustMessage();
        if (!value) {
            this.ignoreInput();
        }
        return value;
    }

    private boolean adjustBinding() {
        boolean value;
        boolean bl = value = this.visitBinding || this.traverseBinding2Element && this.adjustElement() || this.traverseBinding2BindingOperation && this.adjustBindingOperation() || this.traverseBinding2ExtensibilityElement && this.adjustExtensibilityElement() || this.traverseBinding2PortType && this.adjustPortType() || this.traverseBinding2SOAPBinding && this.adjustSOAPBinding();
        if (!value) {
            this.ignoreBinding();
        }
        return value;
    }

    private boolean adjustSOAPBody() {
        boolean value = this.visitSOAPBody;
        if (!value) {
            this.ignoreSOAPBody();
        }
        return value;
    }

    private boolean adjustSOAPHeaderFault() {
        boolean value = this.visitSOAPHeaderFault;
        if (!value) {
            this.ignoreSOAPHeaderFault();
        }
        return value;
    }

    private boolean adjustBindingInput() {
        boolean value;
        boolean bl = value = this.visitBindingInput || this.traverseBindingInput2Element && this.adjustElement() || this.traverseBindingInput2ExtensibilityElement && this.adjustExtensibilityElement() || this.traverseBindingInput2SOAPBody && this.adjustSOAPBody() || this.traverseBindingInput2SOAPHeader && this.adjustSOAPHeader();
        if (!value) {
            this.ignoreBindingInput();
        }
        return value;
    }

    private boolean adjustOutput() {
        boolean value;
        boolean bl = value = this.visitOutput || this.traverseOutput2Element && this.adjustElement() || this.traverseOutput2Message && this.adjustMessage();
        if (!value) {
            this.ignoreOutput();
        }
        return value;
    }

    private boolean adjustBindingFault() {
        boolean value;
        boolean bl = value = this.visitBindingFault || this.traverseBindingFault2Element && this.adjustElement() || this.traverseBindingFault2ExtensibilityElement && this.adjustExtensibilityElement() || this.traverseBindingFault2SOAPFault && this.adjustSOAPFault();
        if (!value) {
            this.ignoreBindingFault();
        }
        return value;
    }

    private boolean adjustSOAPOperation() {
        boolean value = this.visitSOAPOperation;
        if (!value) {
            this.ignoreSOAPOperation();
        }
        return value;
    }

    private boolean adjustDefinition() {
        boolean value;
        boolean bl = value = this.visitDefinition || this.traverseDefinition2Element && this.adjustElement() || this.traverseDefinition2Import && this.adjustImport() || this.traverseDefinition2Types && this.adjustTypes() || this.traverseDefinition2Message && this.adjustMessage() || this.traverseDefinition2ExtensibilityElement && this.adjustExtensibilityElement() || this.traverseDefinition2PortType && this.adjustPortType() || this.traverseDefinition2Binding && this.adjustBinding() || this.traverseDefinition2Service && this.adjustService();
        if (!value) {
            this.ignoreDefinition();
        }
        return value;
    }

    private boolean adjustSOAPFault() {
        boolean value = this.visitSOAPFault;
        if (!value) {
            this.ignoreSOAPFault();
        }
        return value;
    }

    private boolean adjustImport() {
        boolean value;
        boolean bl = value = this.visitImport || this.traverseImport2Definition || this.traverseImport2Element && this.adjustElement();
        if (!value) {
            this.ignoreImport();
        }
        return value;
    }

    private boolean adjustFault() {
        boolean value;
        boolean bl = value = this.visitFault || this.traverseFault2Element && this.adjustElement() || this.traverseFault2Message && this.adjustMessage();
        if (!value) {
            this.ignoreFault();
        }
        return value;
    }

    private boolean adjustPortType() {
        boolean value;
        boolean bl = value = this.visitPortType || this.traversePortType2Element && this.adjustElement() || this.traversePortType2Operation && this.adjustOperation();
        if (!value) {
            this.ignorePortType();
        }
        return value;
    }

    private boolean adjustService() {
        boolean value;
        boolean bl = value = this.visitService || this.traverseService2Element && this.adjustElement() || this.traverseService2ExtensibilityElement && this.adjustExtensibilityElement() || this.traverseService2Port && this.adjustPort();
        if (!value) {
            this.ignoreService();
        }
        return value;
    }

    private boolean adjustMessage() {
        boolean value;
        boolean bl = value = this.visitMessage || this.traverseMessage2Element && this.adjustElement() || this.traverseMessage2Part && this.adjustPart();
        if (!value) {
            this.ignoreMessage();
        }
        return value;
    }

    private void traverse(ExtensibilityElement objExtensibilityElement, Object parent, WSDLTraversalContext ctx) {
        ctx.resumeExtensibilityElementProcessing();
        ctx.setExtensibilityElement(objExtensibilityElement);
        if (this.visitExtensibilityElement) {
            this.visitor.visit(objExtensibilityElement, parent, ctx);
        }
    }

    private void traverse(Part objPart, Object parent, WSDLTraversalContext ctx) {
        ctx.resumePartProcessing();
        ctx.setPart(objPart);
        if (this.visitPart) {
            this.visitor.visit(objPart, parent, ctx);
            if (!ctx.processPart()) {
                return;
            }
        }
        if (objPart == null) {
            return;
        }
        if (this.traversePart2Element) {
            this.traverse(objPart.getDocumentationElement(), (Object)objPart, ctx);
        }
    }

    private void traverse(SOAPHeader objSOAPHeader, Object parent, WSDLTraversalContext ctx) {
        ctx.resumeSOAPHeaderProcessing();
        ctx.setSOAPHeader(objSOAPHeader);
        if (this.visitSOAPHeader) {
            this.visitor.visit(objSOAPHeader, parent, ctx);
            if (!ctx.processSOAPHeader()) {
                return;
            }
        }
        if (objSOAPHeader == null) {
            return;
        }
        if (this.traverseSOAPHeader2SOAPHeaderFault && objSOAPHeader.getSOAPHeaderFaults() != null) {
            Iterator it = objSOAPHeader.getSOAPHeaderFaults().iterator();
            while (it.hasNext()) {
                this.traverse((SOAPHeaderFault)it.next(), (Object)objSOAPHeader, ctx);
                if (ctx.processSOAPHeader()) continue;
                return;
            }
        }
    }

    private void traverse(Element objElement, Object parent, WSDLTraversalContext ctx) {
        ctx.setElement(objElement);
        if (this.visitElement) {
            this.visitor.visit(objElement, parent, ctx);
        }
    }

    private void traverse(Types objTypes, Object parent, WSDLTraversalContext ctx) {
        ctx.resumeTypesProcessing();
        ctx.setTypes(objTypes);
        if (this.visitTypes) {
            this.visitor.visit(objTypes, parent, ctx);
            if (!ctx.processTypes()) {
                return;
            }
        }
        if (objTypes == null) {
            return;
        }
        if (this.traverseTypes2Element) {
            this.traverse(objTypes.getDocumentationElement(), (Object)objTypes, ctx);
            if (!ctx.processTypes()) {
                return;
            }
        }
        if (this.traverseTypes2ExtensibilityElement && objTypes.getExtensibilityElements() != null) {
            Iterator it = objTypes.getExtensibilityElements().iterator();
            while (it.hasNext()) {
                this.traverse((ExtensibilityElement)it.next(), (Object)objTypes, ctx);
                if (ctx.processTypes()) continue;
                return;
            }
        }
    }

    private void traverse(SOAPBinding objSOAPBinding, Object parent, WSDLTraversalContext ctx) {
        ctx.setSOAPBinding(objSOAPBinding);
        if (this.visitSOAPBinding) {
            this.visitor.visit(objSOAPBinding, parent, ctx);
        }
    }

    private void traverse(Definition objDefinition, Object parent, WSDLTraversalContext ctx) {
        Iterator<Object> it;
        ctx.resumeDefinitionProcessing();
        ctx.setDefinition(objDefinition);
        if (this.visitDefinition) {
            this.visitor.visit(objDefinition, parent, ctx);
            if (!ctx.processDefinition()) {
                return;
            }
        }
        if (objDefinition == null) {
            return;
        }
        if (this.traverseDefinition2Import && objDefinition.getImports() != null) {
            it = objDefinition.getImports().values().iterator();
            while (it.hasNext()) {
                Vector v = (Vector)it.next();
                if (v == null) continue;
                Iterator it2 = v.iterator();
                while (it2.hasNext()) {
                    this.traverse((Import)it2.next(), (Object)objDefinition, ctx);
                    if (ctx.processDefinition()) continue;
                    return;
                }
            }
        }
        if (this.traverseDefinition2Element) {
            this.traverse(objDefinition.getDocumentationElement(), (Object)objDefinition, ctx);
            if (!ctx.processDefinition()) {
                return;
            }
        }
        if (this.traverseDefinition2Types) {
            this.traverse(objDefinition.getTypes(), (Object)objDefinition, ctx);
            if (!ctx.processDefinition()) {
                return;
            }
        }
        if (this.traverseDefinition2Message && objDefinition.getMessages() != null) {
            it = objDefinition.getMessages().values().iterator();
            while (it.hasNext()) {
                this.traverse((Message)it.next(), (Object)objDefinition, ctx);
                if (ctx.processDefinition()) continue;
                return;
            }
        }
        if (this.traverseDefinition2PortType && objDefinition.getPortTypes() != null) {
            it = objDefinition.getPortTypes().values().iterator();
            while (it.hasNext()) {
                this.traverse((PortType)it.next(), (Object)objDefinition, ctx);
                if (ctx.processDefinition()) continue;
                return;
            }
        }
        if (this.traverseDefinition2Binding && objDefinition.getBindings() != null) {
            it = objDefinition.getBindings().values().iterator();
            while (it.hasNext()) {
                this.traverse((Binding)it.next(), (Object)objDefinition, ctx);
                if (ctx.processDefinition()) continue;
                return;
            }
        }
        if (this.traverseDefinition2Service && objDefinition.getServices() != null) {
            it = objDefinition.getServices().values().iterator();
            while (it.hasNext()) {
                this.traverse((Service)it.next(), (Object)objDefinition, ctx);
                if (ctx.processDefinition()) continue;
                return;
            }
        }
        if (this.traverseDefinition2ExtensibilityElement && objDefinition.getExtensibilityElements() != null) {
            it = objDefinition.getExtensibilityElements().iterator();
            while (it.hasNext()) {
                this.traverse((ExtensibilityElement)it.next(), (Object)objDefinition, ctx);
                if (ctx.processDefinition()) continue;
                return;
            }
        }
    }

    private void traverse(Port objPort, Object parent, WSDLTraversalContext ctx) {
        ctx.resumePortProcessing();
        ctx.setPort(objPort);
        if (this.visitPort) {
            this.visitor.visit(objPort, parent, ctx);
            if (!ctx.processPort()) {
                return;
            }
        }
        if (objPort == null) {
            return;
        }
        if (this.traversePort2Element) {
            this.traverse(objPort.getDocumentationElement(), (Object)objPort, ctx);
            if (!ctx.processPort()) {
                return;
            }
        }
        if (this.traversePort2Binding) {
            this.traverse(objPort.getBinding(), (Object)objPort, ctx);
            if (!ctx.processPort()) {
                return;
            }
        }
        if (this.traversePort2ExtensibilityElement && objPort.getExtensibilityElements() != null) {
            Iterator it = objPort.getExtensibilityElements().iterator();
            while (it.hasNext()) {
                this.traverse((ExtensibilityElement)it.next(), (Object)objPort, ctx);
                if (ctx.processPort()) continue;
                return;
            }
        }
    }

    private void traverse(Operation objOperation, Object parent, WSDLTraversalContext ctx) {
        ctx.resumeOperationProcessing();
        ctx.setOperation(objOperation);
        if (this.visitOperation) {
            this.visitor.visit(objOperation, parent, ctx);
            if (!ctx.processOperation()) {
                return;
            }
        }
        if (objOperation == null) {
            return;
        }
        if (this.traverseOperation2Element) {
            this.traverse(objOperation.getDocumentationElement(), (Object)objOperation, ctx);
            if (!ctx.processOperation()) {
                return;
            }
        }
        if (this.traverseOperation2Input) {
            this.traverse(objOperation.getInput(), (Object)objOperation, ctx);
            if (!ctx.processOperation()) {
                return;
            }
        }
        if (this.traverseOperation2Output) {
            this.traverse(objOperation.getOutput(), (Object)objOperation, ctx);
            if (!ctx.processOperation()) {
                return;
            }
        }
        if (this.traverseOperation2Fault && objOperation.getFaults() != null) {
            Iterator it = objOperation.getFaults().values().iterator();
            while (it.hasNext()) {
                this.traverse((Fault)it.next(), (Object)objOperation, ctx);
                if (ctx.processOperation()) continue;
                return;
            }
        }
    }

    private void traverse(Input objInput, Object parent, WSDLTraversalContext ctx) {
        ctx.resumeInputProcessing();
        ctx.setInput(objInput);
        if (this.visitInput) {
            this.visitor.visit(objInput, parent, ctx);
            if (!ctx.processInput()) {
                return;
            }
        }
        if (objInput == null) {
            return;
        }
        if (this.traverseInput2Element) {
            this.traverse(objInput.getDocumentationElement(), (Object)objInput, ctx);
            if (!ctx.processInput()) {
                return;
            }
        }
        if (this.traverseInput2Message) {
            this.traverse(objInput.getMessage(), (Object)objInput, ctx);
        }
    }

    private void traverse(SOAPBody objSOAPBody, Object parent, WSDLTraversalContext ctx) {
        ctx.setSOAPBody(objSOAPBody);
        if (this.visitSOAPBody) {
            this.visitor.visit(objSOAPBody, parent, ctx);
        }
    }

    private void traverse(SOAPHeaderFault objSOAPHeaderFault, Object parent, WSDLTraversalContext ctx) {
        ctx.setSOAPHeaderFault(objSOAPHeaderFault);
        if (this.visitSOAPHeaderFault) {
            this.visitor.visit(objSOAPHeaderFault, parent, ctx);
        }
    }

    private void traverse(Output objOutput, Object parent, WSDLTraversalContext ctx) {
        ctx.resumeOutputProcessing();
        ctx.setOutput(objOutput);
        if (this.visitOutput) {
            this.visitor.visit(objOutput, parent, ctx);
            if (!ctx.processOutput()) {
                return;
            }
        }
        if (objOutput == null) {
            return;
        }
        if (this.traverseOutput2Element) {
            this.traverse(objOutput.getDocumentationElement(), (Object)objOutput, ctx);
            if (!ctx.processOutput()) {
                return;
            }
        }
        if (this.traverseOutput2Message) {
            this.traverse(objOutput.getMessage(), (Object)objOutput, ctx);
        }
    }

    private void traverse(BindingFault objBindingFault, Object parent, WSDLTraversalContext ctx) {
        Iterator it;
        ctx.resumeBindingFaultProcessing();
        ctx.setBindingFault(objBindingFault);
        if (this.visitBindingFault) {
            this.visitor.visit(objBindingFault, parent, ctx);
            if (!ctx.processBindingFault()) {
                return;
            }
        }
        if (objBindingFault == null) {
            return;
        }
        if (this.traverseBindingFault2Element) {
            this.traverse(objBindingFault.getDocumentationElement(), (Object)objBindingFault, ctx);
            if (!ctx.processBindingFault()) {
                return;
            }
        }
        if (this.traverseBindingFault2SOAPFault && objBindingFault.getExtensibilityElements() != null) {
            it = objBindingFault.getExtensibilityElements().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (o instanceof SOAPFault) {
                    this.traverse((SOAPFault)o, (Object)objBindingFault, ctx);
                }
                if (ctx.processBindingFault()) continue;
                return;
            }
        }
        if (this.traverseBindingFault2ExtensibilityElement && objBindingFault.getExtensibilityElements() != null) {
            it = objBindingFault.getExtensibilityElements().iterator();
            while (it.hasNext()) {
                this.traverse((ExtensibilityElement)it.next(), (Object)objBindingFault, ctx);
                if (ctx.processBindingFault()) continue;
                return;
            }
        }
    }

    private void traverse(SOAPOperation objSOAPOperation, Object parent, WSDLTraversalContext ctx) {
        ctx.setSOAPOperation(objSOAPOperation);
        if (this.visitSOAPOperation) {
            this.visitor.visit(objSOAPOperation, parent, ctx);
        }
    }

    private void traverse(BindingInput objBindingInput, Object parent, WSDLTraversalContext ctx) {
        Iterator it;
        ctx.resumeBindingInputProcessing();
        ctx.setBindingInput(objBindingInput);
        if (this.visitBindingInput) {
            this.visitor.visit(objBindingInput, parent, ctx);
            if (!ctx.processBindingInput()) {
                return;
            }
        }
        if (objBindingInput == null) {
            return;
        }
        if (this.traverseBindingInput2Element) {
            this.traverse(objBindingInput.getDocumentationElement(), (Object)objBindingInput, ctx);
            if (!ctx.processBindingInput()) {
                return;
            }
        }
        if ((this.traverseBindingInput2SOAPBody || this.traverseBindingInput2SOAPHeader) && objBindingInput.getExtensibilityElements() != null) {
            it = objBindingInput.getExtensibilityElements().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (this.traverseBindingInput2SOAPBody && o instanceof SOAPBody) {
                    this.traverse((SOAPBody)o, (Object)objBindingInput, ctx);
                } else if (this.traverseBindingInput2SOAPHeader && o instanceof SOAPHeader) {
                    this.traverse((SOAPHeader)o, (Object)objBindingInput, ctx);
                }
                if (ctx.processBindingInput()) continue;
                return;
            }
        }
        if (this.traverseBindingInput2ExtensibilityElement && objBindingInput.getExtensibilityElements() != null) {
            it = objBindingInput.getExtensibilityElements().iterator();
            while (it.hasNext()) {
                this.traverse((ExtensibilityElement)it.next(), (Object)objBindingInput, ctx);
                if (ctx.processBindingInput()) continue;
                return;
            }
        }
    }

    private void traverse(BindingOperation objBindingOperation, Object parent, WSDLTraversalContext ctx) {
        Iterator<Object> it;
        ctx.resumeBindingOperationProcessing();
        ctx.setBindingOperation(objBindingOperation);
        if (this.visitBindingOperation) {
            this.visitor.visit(objBindingOperation, parent, ctx);
            if (!ctx.processBindingOperation()) {
                return;
            }
        }
        if (objBindingOperation == null) {
            return;
        }
        if (this.traverseBindingOperation2Element) {
            this.traverse(objBindingOperation.getDocumentationElement(), (Object)objBindingOperation, ctx);
            if (!ctx.processBindingOperation()) {
                return;
            }
        }
        if (this.traverseBindingOperation2SOAPOperation && objBindingOperation.getExtensibilityElements() != null) {
            it = objBindingOperation.getExtensibilityElements().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (o instanceof SOAPOperation) {
                    this.traverse((SOAPOperation)o, (Object)objBindingOperation, ctx);
                }
                if (ctx.processBindingOperation()) continue;
                return;
            }
        }
        if (this.traverseBindingOperation2ExtensibilityElement && objBindingOperation.getExtensibilityElements() != null) {
            it = objBindingOperation.getExtensibilityElements().iterator();
            while (it.hasNext()) {
                this.traverse((ExtensibilityElement)it.next(), (Object)objBindingOperation, ctx);
                if (ctx.processBindingOperation()) continue;
                return;
            }
        }
        if (this.traverseBindingOperation2Operation) {
            this.traverse(objBindingOperation.getOperation(), (Object)objBindingOperation, ctx);
            if (!ctx.processBindingOperation()) {
                return;
            }
        }
        if (this.traverseBindingOperation2BindingInput) {
            this.traverse(objBindingOperation.getBindingInput(), (Object)objBindingOperation, ctx);
            if (!ctx.processBindingOperation()) {
                return;
            }
        }
        if (this.traverseBindingOperation2BindingOutput) {
            this.traverse(objBindingOperation.getBindingOutput(), (Object)objBindingOperation, ctx);
            if (!ctx.processBindingOperation()) {
                return;
            }
        }
        if (this.traverseBindingOperation2BindingFault && objBindingOperation.getBindingFaults() != null) {
            it = objBindingOperation.getBindingFaults().values().iterator();
            while (it.hasNext()) {
                this.traverse((BindingFault)it.next(), (Object)objBindingOperation, ctx);
                if (ctx.processBindingOperation()) continue;
                return;
            }
        }
    }

    private void traverse(SOAPFault objSOAPFault, Object parent, WSDLTraversalContext ctx) {
        ctx.setSOAPFault(objSOAPFault);
        if (this.visitSOAPFault) {
            this.visitor.visit(objSOAPFault, parent, ctx);
        }
    }

    private void traverse(Binding objBinding, Object parent, WSDLTraversalContext ctx) {
        Iterator it;
        ctx.resumeBindingProcessing();
        ctx.setBinding(objBinding);
        if (this.visitBinding) {
            this.visitor.visit(objBinding, parent, ctx);
            if (!ctx.processBinding()) {
                return;
            }
        }
        if (objBinding == null) {
            return;
        }
        if (this.traverseBinding2Element) {
            this.traverse(objBinding.getDocumentationElement(), (Object)objBinding, ctx);
            if (!ctx.processBinding()) {
                return;
            }
        }
        if (this.traverseBinding2SOAPBinding && objBinding.getExtensibilityElements() != null) {
            it = objBinding.getExtensibilityElements().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (o instanceof SOAPBinding) {
                    this.traverse((SOAPBinding)o, (Object)objBinding, ctx);
                }
                if (ctx.processBinding()) continue;
                return;
            }
        }
        if (this.traverseBinding2PortType) {
            this.traverse(objBinding.getPortType(), (Object)objBinding, ctx);
            if (!ctx.processBinding()) {
                return;
            }
        }
        if (this.traverseBinding2BindingOperation && objBinding.getBindingOperations() != null) {
            it = objBinding.getBindingOperations().iterator();
            while (it.hasNext()) {
                this.traverse((BindingOperation)it.next(), (Object)objBinding, ctx);
                if (ctx.processBinding()) continue;
                return;
            }
        }
        if (this.traverseBinding2ExtensibilityElement && objBinding.getExtensibilityElements() != null) {
            it = objBinding.getExtensibilityElements().iterator();
            while (it.hasNext()) {
                this.traverse((ExtensibilityElement)it.next(), (Object)objBinding, ctx);
                if (ctx.processBinding()) continue;
                return;
            }
        }
    }

    private void traverse(Fault objFault, Object parent, WSDLTraversalContext ctx) {
        ctx.resumeFaultProcessing();
        ctx.setFault(objFault);
        if (this.visitFault) {
            this.visitor.visit(objFault, parent, ctx);
            if (!ctx.processFault()) {
                return;
            }
        }
        if (objFault == null) {
            return;
        }
        if (this.traverseFault2Element) {
            this.traverse(objFault.getDocumentationElement(), (Object)objFault, ctx);
            if (!ctx.processFault()) {
                return;
            }
        }
        if (this.traverseFault2Message) {
            this.traverse(objFault.getMessage(), (Object)objFault, ctx);
        }
    }

    private void traverse(Service objService, Object parent, WSDLTraversalContext ctx) {
        Iterator<Object> it;
        ctx.resumeServiceProcessing();
        ctx.setService(objService);
        if (this.visitService) {
            this.visitor.visit(objService, parent, ctx);
            if (!ctx.processService()) {
                return;
            }
        }
        if (objService == null) {
            return;
        }
        if (this.traverseService2Element) {
            this.traverse(objService.getDocumentationElement(), (Object)objService, ctx);
            if (!ctx.processService()) {
                return;
            }
        }
        if (this.traverseService2ExtensibilityElement && objService.getExtensibilityElements() != null) {
            it = objService.getExtensibilityElements().iterator();
            while (it.hasNext()) {
                this.traverse((ExtensibilityElement)it.next(), (Object)objService, ctx);
                if (ctx.processService()) continue;
                return;
            }
        }
        if (this.traverseService2Port && objService.getPorts() != null) {
            it = objService.getPorts().values().iterator();
            while (it.hasNext()) {
                this.traverse((Port)it.next(), (Object)objService, ctx);
                if (ctx.processService()) continue;
                return;
            }
        }
    }

    private void traverse(Import objImport, Object parent, WSDLTraversalContext ctx) {
        ctx.resumeImportProcessing();
        ctx.setImport(objImport);
        if (this.visitImport) {
            this.visitor.visit(objImport, parent, ctx);
            if (!ctx.processImport()) {
                return;
            }
        }
        if (objImport == null) {
            return;
        }
        if (this.traverseImport2Element) {
            this.traverse(objImport.getDocumentationElement(), (Object)objImport, ctx);
            if (!ctx.processImport()) {
                return;
            }
        }
        if (this.traverseImport2Definition) {
            this.traverse(objImport.getDefinition(), (Object)objImport, ctx);
        }
    }

    private void traverse(BindingOutput objBindingOutput, Object parent, WSDLTraversalContext ctx) {
        Iterator it;
        ctx.resumeBindingOutputProcessing();
        ctx.setBindingOutput(objBindingOutput);
        if (this.visitBindingOutput) {
            this.visitor.visit(objBindingOutput, parent, ctx);
            if (!ctx.processBindingOutput()) {
                return;
            }
        }
        if (objBindingOutput == null) {
            return;
        }
        if (this.traverseBindingOutput2Element) {
            this.traverse(objBindingOutput.getDocumentationElement(), (Object)objBindingOutput, ctx);
            if (!ctx.processBindingOutput()) {
                return;
            }
        }
        if ((this.traverseBindingOutput2SOAPBody || this.traverseBindingOutput2SOAPHeader) && objBindingOutput.getExtensibilityElements() != null) {
            it = objBindingOutput.getExtensibilityElements().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (this.traverseBindingOutput2SOAPBody && o instanceof SOAPBody) {
                    this.traverse((SOAPBody)o, (Object)objBindingOutput, ctx);
                } else if (this.traverseBindingOutput2SOAPHeader && o instanceof SOAPHeader) {
                    this.traverse((SOAPHeader)o, (Object)objBindingOutput, ctx);
                }
                if (ctx.processBindingOutput()) continue;
                return;
            }
        }
        if (this.traverseBindingOutput2ExtensibilityElement && objBindingOutput.getExtensibilityElements() != null) {
            it = objBindingOutput.getExtensibilityElements().iterator();
            while (it.hasNext()) {
                this.traverse((ExtensibilityElement)it.next(), (Object)objBindingOutput, ctx);
                if (ctx.processBindingOutput()) continue;
                return;
            }
        }
    }

    private void traverse(PortType objPortType, Object parent, WSDLTraversalContext ctx) {
        ctx.resumePortTypeProcessing();
        ctx.setPortType(objPortType);
        if (this.visitPortType) {
            this.visitor.visit(objPortType, parent, ctx);
            if (!ctx.processPortType()) {
                return;
            }
        }
        if (objPortType == null) {
            return;
        }
        if (this.traversePortType2Element) {
            this.traverse(objPortType.getDocumentationElement(), (Object)objPortType, ctx);
            if (!ctx.processPortType()) {
                return;
            }
        }
        if (this.traversePortType2Operation && objPortType.getOperations() != null) {
            Iterator it = objPortType.getOperations().iterator();
            while (it.hasNext()) {
                this.traverse((Operation)it.next(), (Object)objPortType, ctx);
                if (ctx.processPortType()) continue;
                return;
            }
        }
    }

    private void traverse(Message objMessage, Object parent, WSDLTraversalContext ctx) {
        ctx.resumeMessageProcessing();
        ctx.setMessage(objMessage);
        if (this.visitMessage) {
            this.visitor.visit(objMessage, parent, ctx);
            if (!ctx.processMessage()) {
                return;
            }
        }
        if (objMessage == null) {
            return;
        }
        if (this.traverseMessage2Element) {
            this.traverse(objMessage.getDocumentationElement(), (Object)objMessage, ctx);
            if (!ctx.processMessage()) {
                return;
            }
        }
        if (this.traverseMessage2Part && objMessage.getParts() != null) {
            Iterator it = objMessage.getParts().values().iterator();
            while (it.hasNext()) {
                this.traverse((Part)it.next(), (Object)objMessage, ctx);
                if (ctx.processMessage()) continue;
                return;
            }
        }
    }

    public void traverse(Part a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(Service a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(Types a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(Operation a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(Input a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(Output a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(Fault a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(Binding a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(BindingOperation a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(BindingInput a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(BindingOutput a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(BindingFault a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(Import a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(Element a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(Message a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(Port a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(PortType a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(Definition a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(ExtensibilityElement a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(SOAPBinding a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(SOAPBody a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(SOAPHeader a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(SOAPHeaderFault a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(SOAPFault a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(SOAPOperation a) {
        this.adjust();
        this.traverse(a, null, new WSDLTraversalContext(this));
    }

    public void traverse(Part a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(Service a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(Types a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(Operation a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(Input a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(Output a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(Fault a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(Binding a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(BindingOperation a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(BindingInput a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(BindingOutput a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(BindingFault a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(Import a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(Element a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(Message a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(Port a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(PortType a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(Definition a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(ExtensibilityElement a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(SOAPBinding a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(SOAPBody a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(SOAPHeader a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(SOAPHeaderFault a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(SOAPFault a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }

    public void traverse(SOAPOperation a, Map params) {
        this.adjust();
        WSDLTraversalContext ctx = new WSDLTraversalContext(this);
        if (params != null) {
            ctx.params.putAll(params);
        }
        this.traverse(a, null, ctx);
    }
}

