/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.observable.list;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.internal.databinding.provisional.observable.IChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.IStaleListener;
import org.eclipse.jface.internal.databinding.provisional.observable.ObservableTracker;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IListChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IObservableList;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiff;

public abstract class AbstractObservableList
extends AbstractList
implements IObservableList {
    private Object listChangeListeners;
    private Object changeListeners = null;
    private Object staleListeners = null;

    public boolean isStale() {
        return false;
    }

    public void addListChangeListener(IListChangeListener listener) {
        AbstractCollection listenerList;
        if (this.listChangeListeners == null) {
            boolean hadListeners = this.hasListeners();
            this.listChangeListeners = listener;
            if (!hadListeners) {
                this.firstListenerAdded();
            }
            return;
        }
        if (this.listChangeListeners instanceof Collection) {
            listenerList = (ArrayList<IListChangeListener>)this.listChangeListeners;
        } else {
            IListChangeListener l = (IListChangeListener)this.listChangeListeners;
            listenerList = new ArrayList<IListChangeListener>();
            listenerList.add(l);
            this.listChangeListeners = listenerList;
        }
        if (listenerList.size() > 16) {
            this.listChangeListeners = listenerList = new HashSet(listenerList);
        }
        listenerList.add(listener);
    }

    public void removeListChangeListener(IListChangeListener listener) {
        if (this.listChangeListeners == listener) {
            this.listChangeListeners = null;
            if (!this.hasListeners()) {
                this.lastListenerRemoved();
            }
            return;
        }
        if (this.listChangeListeners instanceof Collection) {
            Collection listenerList = (Collection)this.listChangeListeners;
            listenerList.remove(listener);
            if (listenerList.size() == 0) {
                this.listChangeListeners = null;
                if (!this.hasListeners()) {
                    this.lastListenerRemoved();
                }
            }
        }
    }

    protected void fireListChange(ListDiff diff) {
        this.fireChange();
        if (this.listChangeListeners == null) {
            return;
        }
        if (this.listChangeListeners instanceof IListChangeListener) {
            ((IListChangeListener)this.listChangeListeners).handleListChange(this, diff);
            return;
        }
        Collection changeListenerCollection = (Collection)this.listChangeListeners;
        IListChangeListener[] listeners = changeListenerCollection.toArray(new IListChangeListener[changeListenerCollection.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].handleListChange(this, diff);
            ++i;
        }
    }

    public void addChangeListener(IChangeListener listener) {
        ArrayList<IChangeListener> listenerList;
        if (this.changeListeners == null) {
            boolean hadListeners = this.hasListeners();
            this.changeListeners = listener;
            if (!hadListeners) {
                this.firstListenerAdded();
            }
            return;
        }
        if (this.changeListeners instanceof IChangeListener) {
            IChangeListener l = (IChangeListener)this.changeListeners;
            listenerList = new ArrayList<IChangeListener>();
            listenerList.add(l);
        } else {
            listenerList = (ArrayList<IChangeListener>)this.changeListeners;
        }
        if (listenerList.size() > 16) {
            HashSet<IChangeListener> listenerSet = new HashSet<IChangeListener>();
            listenerSet.addAll(listenerList);
            this.changeListeners = listenerList;
        }
        listenerList.add(listener);
    }

    public void removeChangeListener(IChangeListener listener) {
        if (this.changeListeners == listener) {
            this.changeListeners = null;
            if (!this.hasListeners()) {
                this.lastListenerRemoved();
            }
            return;
        }
        if (this.changeListeners instanceof Collection) {
            Collection listenerList = (Collection)this.changeListeners;
            listenerList.remove(listener);
            if (listenerList.size() == 0) {
                this.changeListeners = null;
                if (!this.hasListeners()) {
                    this.lastListenerRemoved();
                }
            }
        }
    }

    public void addStaleListener(IStaleListener listener) {
        ArrayList<IStaleListener> listenerList;
        if (this.staleListeners == null) {
            boolean hadListeners = this.hasListeners();
            this.staleListeners = listener;
            if (!hadListeners) {
                this.firstListenerAdded();
            }
            return;
        }
        if (this.staleListeners instanceof IStaleListener) {
            IStaleListener l = (IStaleListener)this.staleListeners;
            listenerList = new ArrayList<IStaleListener>();
            listenerList.add(l);
        } else {
            listenerList = (ArrayList<IStaleListener>)this.staleListeners;
        }
        if (listenerList.size() > 16) {
            HashSet<IStaleListener> listenerSet = new HashSet<IStaleListener>();
            listenerSet.addAll(listenerList);
            this.staleListeners = listenerList;
        }
        listenerList.add(listener);
    }

    public void removeStaleListener(IStaleListener listener) {
        if (this.staleListeners == listener) {
            this.staleListeners = null;
            if (!this.hasListeners()) {
                this.lastListenerRemoved();
            }
            return;
        }
        if (this.staleListeners instanceof Collection) {
            Collection listenerList = (Collection)this.staleListeners;
            listenerList.remove(listener);
            if (listenerList.size() == 0) {
                this.staleListeners = null;
                if (!this.hasListeners()) {
                    this.lastListenerRemoved();
                }
            }
        }
    }

    protected void fireChange() {
        if (this.changeListeners == null) {
            return;
        }
        if (this.changeListeners instanceof IChangeListener) {
            ((IChangeListener)this.changeListeners).handleChange(this);
            return;
        }
        Collection changeListenerCollection = (Collection)this.changeListeners;
        IChangeListener[] listeners = changeListenerCollection.toArray(new IChangeListener[changeListenerCollection.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].handleChange(this);
            ++i;
        }
    }

    protected void fireStale() {
        if (this.staleListeners == null) {
            return;
        }
        if (this.staleListeners instanceof IChangeListener) {
            ((IChangeListener)this.staleListeners).handleChange(this);
            return;
        }
        Collection changeListenerCollection = (Collection)this.staleListeners;
        IChangeListener[] listeners = changeListenerCollection.toArray(new IChangeListener[changeListenerCollection.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].handleChange(this);
            ++i;
        }
    }

    protected boolean hasListeners() {
        return this.changeListeners != null || this.staleListeners != null || this.listChangeListeners != null;
    }

    protected void firstListenerAdded() {
    }

    protected void lastListenerRemoved() {
    }

    public void dispose() {
        this.listChangeListeners = null;
        this.changeListeners = null;
        this.staleListeners = null;
        this.lastListenerRemoved();
    }

    public final int size() {
        this.getterCalled();
        return this.doGetSize();
    }

    protected abstract int doGetSize();

    private void getterCalled() {
        ObservableTracker.getterCalled(this);
    }

    public boolean isEmpty() {
        this.getterCalled();
        return super.isEmpty();
    }

    public boolean contains(Object o) {
        this.getterCalled();
        return super.contains(o);
    }

    public Iterator iterator() {
        final Iterator wrappedIterator = super.iterator();
        return new Iterator(){

            public void remove() {
                wrappedIterator.remove();
            }

            public boolean hasNext() {
                AbstractObservableList.this.getterCalled();
                return wrappedIterator.hasNext();
            }

            public Object next() {
                AbstractObservableList.this.getterCalled();
                return wrappedIterator.next();
            }
        };
    }

    public Object[] toArray() {
        this.getterCalled();
        return super.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.getterCalled();
        return super.toArray(a);
    }

    public boolean add(Object o) {
        this.getterCalled();
        return super.add(o);
    }

    public boolean remove(Object o) {
        this.getterCalled();
        return super.remove(o);
    }

    public boolean containsAll(Collection c) {
        this.getterCalled();
        return super.containsAll(c);
    }

    public boolean addAll(Collection c) {
        this.getterCalled();
        return super.addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        this.getterCalled();
        return super.addAll(c);
    }

    public boolean removeAll(Collection c) {
        this.getterCalled();
        return super.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        this.getterCalled();
        return super.retainAll(c);
    }

    public boolean equals(Object o) {
        this.getterCalled();
        return super.equals(o);
    }

    public int hashCode() {
        this.getterCalled();
        return super.hashCode();
    }

    public int indexOf(Object o) {
        this.getterCalled();
        return super.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        this.getterCalled();
        return super.lastIndexOf(o);
    }
}

