/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.ui.internal.search.dialogs;

import org.eclipse.core.resources.IResource;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.wst.common.core.search.scope.ProjectSearchScope;
import org.eclipse.wst.common.core.search.scope.SearchScope;
import org.eclipse.wst.common.core.search.scope.WorkingSetSearchScope;
import org.eclipse.wst.common.core.search.scope.WorkspaceSearchScope;
import org.eclipse.wst.common.ui.internal.UIPlugin;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSearchListDialog;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSearchListDialogConfiguration;

public class ScopedComponentSearchListDialog
extends ComponentSearchListDialog {
    protected static final String DEFAULT_NAME_FIELD_TITLE = UIPlugin.getString("_UI_LABEL_COMPONENT_NAME");
    protected static final String DEFAULT_LIST_TITLE = UIPlugin.getString("_UI_LABEL_MATCHING_COMPONENTS");
    public static final String SCOPE_SPECIFIED_FILE = UIPlugin.getString("_UI_LABEL_SPECIFIED_FILE");
    public static final String SCOPE_ENCLOSING_PROJECT = UIPlugin.getString("_UI_LABEL_ENCLOSING_PROJECT");
    public static final String SCOPE_WORKSPACE = UIPlugin.getString("_UI_LABEL_WORKSPACE");
    public static final String SCOPE_CURRENT_RESOURCE = UIPlugin.getString("_UI_LABEL_CURRENT_RESOURCE");
    public static final String SCOPE_WORKING_SETS = UIPlugin.getString("_UI_LABEL_WORKING_SETS");
    private String currentSearchScope = SCOPE_CURRENT_RESOURCE;
    protected Button chooseButton;
    protected Button[] radioButton = new Button[4];
    protected String filterLabel;
    protected String listTitle;
    protected IResource currentResource;
    protected Composite selectWorkingSetsGroup;
    protected Text workingSetsText;
    protected static String valueForWorkingSetsText;
    private static IWorkingSet[] workingSets;

    public ScopedComponentSearchListDialog(Shell shell, String dialogTitle, ComponentSearchListDialogConfiguration configuration) {
        super(shell, dialogTitle, configuration);
    }

    public void setFilterLabel(String filterLabel) {
        this.filterLabel = filterLabel;
    }

    public void setListTitle(String listTitle) {
        this.listTitle = listTitle;
    }

    protected Control createDialogArea(Composite parent) {
        super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.bottomComposite.setLayout((Layout)layout);
        Group group = new Group(this.bottomComposite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        group.setText(UIPlugin.getString("_UI_LABEL_SEARCH_SCOPE"));
        ScopeChangeListener scopeChangeListener = new ScopeChangeListener();
        this.radioButton[0] = new Button((Composite)group, 16);
        this.radioButton[0].setText(SCOPE_WORKSPACE);
        this.radioButton[1] = new Button((Composite)group, 16);
        this.radioButton[1].setText(SCOPE_ENCLOSING_PROJECT);
        this.radioButton[2] = new Button((Composite)group, 16);
        this.radioButton[2].setText(SCOPE_CURRENT_RESOURCE);
        this.radioButton[3] = new Button((Composite)group, 16);
        this.radioButton[3].setText(SCOPE_WORKING_SETS);
        int i = 0;
        while (i < this.radioButton.length) {
            if (this.radioButton[i].getText().equals(this.currentSearchScope)) {
                this.radioButton[i].setSelection(true);
            }
            this.radioButton[i].addSelectionListener((SelectionListener)scopeChangeListener);
            ++i;
        }
        this.selectWorkingSetsGroup = new Composite((Composite)group, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.selectWorkingSetsGroup.setLayoutData((Object)gd);
        GridLayout workingSetGroupLayout = new GridLayout(2, false);
        workingSetGroupLayout.marginWidth = 0;
        workingSetGroupLayout.marginHeight = 0;
        this.selectWorkingSetsGroup.setLayout((Layout)workingSetGroupLayout);
        this.workingSetsText = new Text(this.selectWorkingSetsGroup, 2056);
        this.workingSetsText.setLayoutData((Object)new GridData(768));
        if (valueForWorkingSetsText != null) {
            this.workingSetsText.setText(valueForWorkingSetsText);
        }
        this.chooseButton = new Button(this.selectWorkingSetsGroup, 0);
        this.chooseButton.setText(UIPlugin.getString("_UI_LABEL_CHOOSE"));
        this.chooseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = ScopedComponentSearchListDialog.this.getShell();
                IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(shell, true);
                if (dialog.open() == 0) {
                    workingSets = dialog.getSelection();
                    valueForWorkingSetsText = "";
                    int i = 0;
                    while (i < workingSets.length) {
                        valueForWorkingSetsText = String.valueOf(valueForWorkingSetsText) + workingSets[i].getLabel();
                        if (i != workingSets.length - 1) {
                            valueForWorkingSetsText = String.valueOf(valueForWorkingSetsText) + ", ";
                        }
                        ++i;
                    }
                    ScopedComponentSearchListDialog.this.workingSetsText.setText(valueForWorkingSetsText);
                }
                ScopedComponentSearchListDialog.this.radioButton[2].setSelection(false);
                ScopedComponentSearchListDialog.this.radioButton[1].setSelection(false);
                ScopedComponentSearchListDialog.this.radioButton[0].setSelection(false);
                ScopedComponentSearchListDialog.this.radioButton[3].setSelection(true);
                ScopedComponentSearchListDialog.this.scopeChangeHandler(ScopedComponentSearchListDialog.this.radioButton[3]);
            }
        });
        return parent;
    }

    public String getSearchScope() {
        return this.currentSearchScope;
    }

    private void scopeChangeHandler(Button b) {
        if ((b.getStyle() & 0x10) != 0) {
            this.currentSearchScope = b.getText();
            WorkspaceSearchScope scope = null;
            if (this.currentSearchScope == SCOPE_ENCLOSING_PROJECT && this.currentResource != null) {
                scope = new ProjectSearchScope(this.currentResource.getFullPath());
            } else if (this.currentSearchScope == SCOPE_WORKSPACE) {
                scope = new WorkspaceSearchScope();
            } else if (this.currentSearchScope == SCOPE_WORKING_SETS) {
                WorkingSetSearchScope workingSetsScope = new WorkingSetSearchScope();
                int i = 0;
                while (i < workingSets.length) {
                    workingSetsScope.addAWorkingSetToScope(workingSets[i].getElements());
                    ++i;
                }
                scope = workingSetsScope;
            }
            this.populateMasterComponentList((SearchScope)scope);
            this.refreshTableViewer(this.getProcessedFilterString());
            Table table = this.componentTableViewer.getTable();
            TableItem[] items = table.getItems();
            if (items.length > 0) {
                TableItem[] select = new TableItem[]{items[0]};
                table.setSelection(select);
            }
            this.updateCanFinish();
        }
    }

    public IResource getCurrentResource() {
        return this.currentResource;
    }

    public void setCurrentResource(IResource currentResource) {
        this.currentResource = currentResource;
    }

    private class ScopeChangeListener
    extends SelectionAdapter {
        private ScopeChangeListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof Button) {
                Button b = (Button)e.widget;
                ScopedComponentSearchListDialog.this.scopeChangeHandler(b);
            }
        }
    }
}

