/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal;

import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.TopLevelNode;
import org.eclipse.wst.dtd.core.internal.text.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public abstract class NamedTopLevelNode
extends TopLevelNode {
    private String tagStartType;

    public NamedTopLevelNode(DTDFile dtdFile, IStructuredDocumentRegion flatNode, String type) {
        super(dtdFile, flatNode);
        this.tagStartType = type;
    }

    public ITextRegion getNameRegion() {
        RegionIterator iter = this.iterator();
        this.getNextRegion(iter, this.tagStartType);
        if (!iter.hasNext()) {
            return null;
        }
        ITextRegion region = iter.next();
        if (!region.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.WHITESPACE")) {
            return null;
        }
        if (!iter.hasNext()) {
            return null;
        }
        region = iter.next();
        if (region.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NAME")) {
            return region;
        }
        if (this.tagStartType == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ENTITY_TAG" && region.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.PERCENT") && iter.hasNext()) {
            region = iter.next();
            if (!region.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.WHITESPACE")) {
                return null;
            }
            if (!iter.hasNext()) {
                return null;
            }
            region = iter.next();
            if (region.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NAME")) {
                return region;
            }
        }
        return null;
    }

    public ITextRegion getStartTag(RegionIterator iter) {
        return this.getNextRegion(iter, this.tagStartType);
    }

    public ITextRegion getWhitespaceAfterName() {
        ITextRegion nameRegion = this.getNameRegion();
        RegionIterator iter = this.iterator();
        this.getNextRegion(iter, this.tagStartType);
        boolean foundName = false;
        while (iter.hasNext()) {
            ITextRegion region = iter.next();
            if (!foundName && nameRegion != null && region == nameRegion) {
                foundName = true;
            }
            if (!region.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.WHITESPACE") || nameRegion != null && !foundName) continue;
            return region;
        }
        return null;
    }

    public void setName(Object requestor, String name) {
        ITextRegion nameRegion = this.getNameRegion();
        if (nameRegion != null) {
            super.setName(requestor, name);
        } else {
            ITextRegion region;
            RegionIterator iter = this.iterator();
            ITextRegion elementTagRegion = this.getNextRegion(iter, this.tagStartType);
            int replaceLength = 0;
            if (iter.hasNext() && (region = iter.next()).getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.WHITESPACE") && region.getLength() >= 2) {
                replaceLength = 1;
            }
            String newText = " " + name;
            this.replaceText(requestor, this.getStructuredDTDDocumentRegion().getEndOffset(elementTagRegion), replaceLength, newText);
        }
    }
}

