/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.php.core.util.FileUtils;
import org.eclipse.php.server.core.Server;
import org.eclipse.php.server.core.manager.ServersManager;
import org.eclipse.php.server.internal.ui.ClosableWizardDialog;
import org.eclipse.php.server.internal.ui.ServerWizard;
import org.eclipse.php.server.ui.ServerEditDialog;
import org.eclipse.php.server.ui.ServerUtilities;
import org.eclipse.php.ui.preferences.ui.ScrolledCompositeImpl;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ServerTab
extends AbstractLaunchConfigurationTab {
    protected IFile selectedFile = null;
    protected Text fFile;
    protected Text fPublishContextRoot;
    protected Text fURL;
    protected Label fContextLabel;
    protected Button projectButton;
    protected Button fileButton;
    protected Button publish;
    protected Button createNewServer;
    protected Button configureServers;
    protected Button autoGeneratedURL;
    protected String[] serverTypeIds;
    protected Combo serverCombo;
    protected Server server;
    protected boolean serverCanPublish = false;
    protected List servers;
    protected boolean init = true;
    private static final String READ_ONLY = "read-only";
    protected static final String AUTO_GENERATED_URL = "auto_generated_url";
    protected WidgetListener fListener = new WidgetListener();
    private boolean saveWorkingCopy;

    public void createControl(Composite composite) {
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl(composite, 512);
        Composite composite2 = new Composite((Composite)scrolledCompositeImpl, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this.createServerControl(composite2);
        this.createFileComponent(composite2);
        this.createURLControl(composite2);
        this.createExtensionControls(composite2);
        Dialog.applyDialogFont((Control)composite2);
        scrolledCompositeImpl.setContent((Control)composite2);
        Point point = composite2.computeSize(-1, -1);
        scrolledCompositeImpl.setMinSize(point.x, point.y);
        this.setControl((Control)scrolledCompositeImpl);
    }

    public void createExtensionControls(Composite composite) {
    }

    public void createURLControl(Composite composite) {
        Group group = new Group(composite, 0);
        String string = "URL";
        group.setText(string);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        this.autoGeneratedURL = new Button((Composite)group, 32);
        this.autoGeneratedURL.setText("Auto Generated URL");
        this.autoGeneratedURL.setSelection(true);
        gridData = new GridData(768);
        this.autoGeneratedURL.setLayoutData((Object)gridData);
        this.autoGeneratedURL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ServerTab.this.autoGeneratedURL.getSelection()) {
                    ServerTab.this.initializeURLControl();
                }
                ServerTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fURL = new Text((Composite)group, 2052);
        gridData = new GridData(768);
        gridData.horizontalIndent = 20;
        this.fURL.setLayoutData((Object)gridData);
        this.fURL.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ServerTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createServerSelectionControl(Composite composite) {
        GridData gridData = new GridData(256);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        Group group = new Group(composite2, 0);
        group.setText("Server");
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 3;
        GridData gridData2 = new GridData(768);
        group.setLayout((Layout)gridLayout2);
        group.setLayoutData((Object)gridData2);
        this.serverCombo = new Combo((Composite)group, 2060);
        this.serverCombo.setLayoutData((Object)new GridData(768));
        this.serverCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ServerTab.this.handleServerSelection();
            }
        });
        this.createNewServer = this.createPushButton((Composite)group, "New", null);
        this.createNewServer.addSelectionListener((SelectionListener)this.fListener);
        this.configureServers = this.createPushButton((Composite)group, "Configure...", null);
        this.configureServers.addSelectionListener((SelectionListener)this.fListener);
        this.servers = new ArrayList();
        this.populateServerList((ArrayList)this.servers);
        if (!this.servers.isEmpty()) {
            int n = 0;
            while (n < this.servers.size()) {
                Server server = (Server)this.servers.get(n);
                this.serverCombo.add(server.getName());
                ++n;
            }
        }
        if (this.serverCombo.getItemCount() > 0) {
            this.serverCombo.select(0);
        }
        this.serverCombo.forceFocus();
    }

    protected void populateServerList(ArrayList arrayList) {
        Server[] serverArray = ServersManager.getServers();
        if (arrayList == null) {
            arrayList = new ArrayList<Server>();
        }
        if (serverArray != null) {
            int n = serverArray.length;
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(serverArray[n2]);
                ++n2;
            }
        }
    }

    public void createServerControl(Composite composite) {
        this.createServerSelectionControl(composite);
        GridData gridData = new GridData(256);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        this.handleServerSelection();
    }

    protected void createFileComponent(Composite composite) {
        Group group = new Group(composite, 0);
        String string = "File / Project";
        group.setText(string);
        GridLayout gridLayout = new GridLayout(3, false);
        GridData gridData = new GridData(768);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        this.fFile = new Text((Composite)group, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fFile.setLayoutData((Object)gridData);
        this.fFile.addModifyListener((ModifyListener)this.fListener);
        this.fileButton = this.createPushButton((Composite)group, "Browse", null);
        gridData = (GridData)this.fileButton.getLayoutData();
        gridData.horizontalSpan = 1;
        this.fileButton.addSelectionListener((SelectionListener)this.fListener);
        this.publish = this.createCheckButton((Composite)group, "Publish to Server");
        gridData = (GridData)this.publish.getLayoutData();
        gridData.horizontalSpan = 3;
        this.fContextLabel = new Label((Composite)group, 0);
        this.fContextLabel.setText("Publish Context Root: ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalIndent = 20;
        this.fContextLabel.setLayoutData((Object)gridData);
        this.fPublishContextRoot = new Text((Composite)group, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fPublishContextRoot.setLayoutData((Object)gridData);
        this.fPublishContextRoot.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ServerTab.this.updateLaunchConfigurationDialog();
                if (ServerTab.this.autoGeneratedURL.getSelection()) {
                    ServerTab.this.initializeURLControl();
                }
            }
        });
        this.publish.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ServerTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.handleServerSelection();
    }

    public String[] getRequiredNatures() {
        return null;
    }

    protected void handleServerButtonSelected() {
        final Server server = this.getServerFromWizard();
        if (server != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ServerTab.this.servers.add(server);
                    ServerTab.this.serverCombo.add(server.getName());
                    ServerTab.this.serverCombo.select(ServerTab.this.serverCombo.indexOf(server.getName()));
                    ServerTab.this.handleServerSelection();
                }
            });
        }
    }

    protected void handleConfigureButtonSelected() {
        int n = this.serverCombo.getSelectionIndex();
        Server server = (Server)this.servers.get(n);
        String string = server.getName();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        ServerEditDialog serverEditDialog = new ServerEditDialog(shell, server);
        if (serverEditDialog.open() == 1) {
            nullProgressMonitor.setCanceled(true);
            return;
        }
        ServersManager.save();
        String string2 = server.getName();
        if (!string2.equals(string)) {
            this.serverCombo.remove(n);
            this.serverCombo.add(string2, n);
            this.serverCombo.select(n);
        }
        this.saveWorkingCopy = true;
        this.handleServerSelection();
    }

    public String[] getFileExtensions() {
        return null;
    }

    private IResource getFileFromDialog(IProject iProject) {
        return ServerUtilities.getFileFromDialog(iProject, this.getShell(), this.getFileExtensions(), this.getRequiredNatures());
    }

    protected void handleFileButtonSelected() {
        IResource iResource = null;
        iResource = this.getFileFromDialog(null);
        if (iResource == null) {
            return;
        }
        String string = iResource.getFullPath().toString();
        this.fFile.setText(string);
        this.fURL.setText(this.computeURL(this.fPublishContextRoot.getText(), string));
    }

    protected IProject getProject(String string) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        if (iProjectArray == null || iProjectArray.length == 0) {
            return null;
        }
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            if (iProject.getName().equals(string)) {
                return iProject;
            }
            ++n;
        }
        return null;
    }

    protected void handleServerSelection() {
        Object e;
        int n = this.serverCombo.getItemCount();
        int n2 = this.serverCombo.getSelectionIndex();
        if (!this.servers.isEmpty() && (e = this.servers.get(this.serverCombo.getSelectionIndex())) != null && e instanceof Server) {
            this.server = (Server)this.servers.get(this.serverCombo.getSelectionIndex());
            boolean bl = false;
            if (this.server != null) {
                bl = this.server.canPublish();
            }
            this.serverCanPublish = bl;
            if (this.publish != null) {
                this.publish.setSelection(bl);
                this.publish.setEnabled(bl);
            }
            if (this.fURL != null && this.autoGeneratedURL.getSelection()) {
                this.initializeURLControl();
            }
        }
        if (this.server == null && n2 + 1 != n) {
            this.setErrorMessage("No server selected");
        } else {
            this.setErrorMessage(null);
        }
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        this.setErrorMessage(null);
        if (this.serverCombo != null) {
            this.serverCombo.setEnabled(true);
            if (this.serverCombo.getItemCount() > 0) {
                this.serverCombo.select(0);
            }
        }
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.serverCombo.setEnabled(true);
        this.setErrorMessage(null);
        try {
            String string = iLaunchConfiguration.getAttribute("file_name", "");
            String string2 = iLaunchConfiguration.getAttribute("context_root", "");
            boolean bl = iLaunchConfiguration.getAttribute("publish", false);
            String string3 = iLaunchConfiguration.getAttribute("base_url", "");
            boolean bl2 = iLaunchConfiguration.getAttribute(AUTO_GENERATED_URL, true);
            this.publish.setSelection(bl);
            this.initializeServerControl(iLaunchConfiguration);
            this.fFile.setText(string);
            this.fPublishContextRoot.setText(string2);
            if (bl2) {
                this.autoGeneratedURL.setSelection(true);
                String string4 = this.computeURL(string2, string);
                this.fURL.setText(string4);
                this.fURL.setEditable(false);
            } else {
                this.autoGeneratedURL.setSelection(false);
                this.fURL.setText(string3);
                this.fURL.setEditable(true);
            }
        }
        catch (CoreException coreException) {}
        this.initializeExtensionControls(iLaunchConfiguration);
        this.isValid(iLaunchConfiguration);
    }

    protected void initializeExtensionControls(ILaunchConfiguration iLaunchConfiguration) {
    }

    protected String computeURL(String string, String string2) {
        if (this.server == null) {
            return "";
        }
        String string3 = this.server.getBaseURL();
        if (string3.equals("")) {
            string3 = "http://localhost";
        }
        StringBuffer stringBuffer = new StringBuffer(string3);
        if (!string.equals("")) {
            stringBuffer.append("/");
            stringBuffer.append(string);
        }
        if (!string2.equals("")) {
            stringBuffer.append(this.formatFileName(string2));
        }
        return stringBuffer.toString();
    }

    private String formatFileName(String string) {
        String string2 = null;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource iResource = iWorkspaceRoot.findMember(string);
        if (iResource == null) {
            return "";
        }
        int n = iResource.getType();
        if (n == 1 || n == 2) {
            string2 = iResource.getProjectRelativePath().toString();
        } else if (iResource.getType() == 4) {
            string2 = "/";
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        return string2;
    }

    protected void initializeURLControl() {
        if (this.fPublishContextRoot == null || this.fFile == null) {
            return;
        }
        this.fURL.setText(this.computeURL(this.fPublishContextRoot.getText(), this.fFile.getText()));
    }

    protected void initializeServerControl(ILaunchConfiguration iLaunchConfiguration) {
        try {
            String string = iLaunchConfiguration.getAttribute("name", "");
            if (string != null && !string.equals("")) {
                this.server = ServersManager.getServer((String)string);
                if (this.server == null) {
                    this.setErrorMessage("Invalid server");
                    this.serverCombo.setEnabled(false);
                    return;
                }
                this.serverCombo.setText(this.server.getName());
                this.publish.setEnabled(this.server.canPublish());
            } else if (this.serverCombo.getItemCount() > 0) {
                Server server = ServersManager.getDefaultServer();
                int n = this.serverCombo.indexOf(server.getName());
                if (n > -1) {
                    this.serverCombo.select(n);
                } else {
                    this.serverCombo.select(0);
                }
                this.server = ServersManager.getServer((String)this.serverCombo.getText());
                this.publish.setEnabled(this.server.canPublish());
            }
            if (iLaunchConfiguration.getAttribute(READ_ONLY, false)) {
                this.serverCombo.setEnabled(false);
            }
        }
        catch (Exception exception) {}
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        if (this.server != null) {
            iLaunchConfigurationWorkingCopy.setAttribute("name", this.server.getName());
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute("name", null);
        }
        String string = this.fFile.getText();
        String string2 = this.fPublishContextRoot.getText();
        String string3 = this.fURL.getText();
        boolean bl = this.publish.getSelection();
        iLaunchConfigurationWorkingCopy.setAttribute("file_name", string);
        iLaunchConfigurationWorkingCopy.setAttribute("context_root", string2);
        iLaunchConfigurationWorkingCopy.setAttribute("publish", bl);
        iLaunchConfigurationWorkingCopy.setAttribute("base_url", string3);
        iLaunchConfigurationWorkingCopy.setAttribute(AUTO_GENERATED_URL, this.autoGeneratedURL.getSelection());
        this.fURL.setEditable(!this.autoGeneratedURL.getSelection());
        boolean bl2 = this.publish.getSelection();
        this.fContextLabel.setEnabled(bl2);
        this.fPublishContextRoot.setEnabled(bl2);
        this.applyExtension(iLaunchConfigurationWorkingCopy);
        if (this.saveWorkingCopy) {
            try {
                iLaunchConfigurationWorkingCopy.doSave();
            }
            catch (CoreException coreException) {}
            this.saveWorkingCopy = false;
        }
    }

    protected void applyExtension(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        Object object;
        block7: {
            this.setMessage(null);
            this.setErrorMessage(null);
            try {
                String string = iLaunchConfiguration.getAttribute("name", "");
                if (string.equals("") || (object = ServersManager.getServer((String)string)) != null) break block7;
                this.deleteLaunchConfiguration(iLaunchConfiguration);
                ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
                int n = 0;
                while (n < iLaunchConfigurationArray.length) {
                    iLaunchConfiguration = iLaunchConfigurationArray[n];
                    string = iLaunchConfiguration.getAttribute("name", "");
                    if (!string.equals("") && ServersManager.getServer((String)string) == null) {
                        this.deleteLaunchConfiguration(iLaunchConfiguration);
                    }
                    ++n;
                }
                return false;
            }
            catch (CoreException coreException) {}
        }
        object = iLaunchConfiguration.getAttribute("file_name", "");
        if (!FileUtils.fileExists((String)object)) {
            this.setErrorMessage("File / Project does not exist");
            return false;
        }
        return this.isValidExtension(iLaunchConfiguration);
    }

    private void deleteLaunchConfiguration(final ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ILaunchConfiguration iLaunchConfiguration2 = iLaunchConfiguration;
                try {
                    if (iLaunchConfiguration2 instanceof ILaunchConfigurationWorkingCopy) {
                        iLaunchConfiguration2 = ((ILaunchConfigurationWorkingCopy)iLaunchConfiguration2).getOriginal();
                    }
                    if (iLaunchConfiguration2 != null) {
                        iLaunchConfiguration2.delete();
                    }
                }
                catch (CoreException coreException) {}
            }
        });
    }

    protected boolean isValidExtension(ILaunchConfiguration iLaunchConfiguration) {
        return true;
    }

    public Image getImage() {
        return null;
    }

    public String getName() {
        return "Server";
    }

    public void addControlAccessibleListener(Control control, String string) {
        String[] stringArray = string.split("&");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stringBuffer.toString()));
    }

    protected Server getServerFromWizard() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        Server server = null;
        ServerWizard serverWizard = new ServerWizard();
        ClosableWizardDialog closableWizardDialog = new ClosableWizardDialog(shell, serverWizard);
        if (closableWizardDialog.open() == 1) {
            nullProgressMonitor.setCanceled(true);
            return null;
        }
        server = (Server)serverWizard.getRootFragment().getWizardModel().getObject("server");
        if (server != null) {
            ServersManager.addServer((Server)server);
            ServersManager.save();
        }
        return server;
    }

    private class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String string) {
            this.controlName = string;
        }

        public void getName(AccessibleEvent accessibleEvent) {
            accessibleEvent.result = this.controlName;
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            ServerTab.this.updateLaunchConfigurationDialog();
            if (ServerTab.this.autoGeneratedURL.getSelection()) {
                ServerTab.this.initializeURLControl();
            }
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            ServerTab.this.setDirty(true);
            Object object = selectionEvent.getSource();
            if (object == ServerTab.this.fileButton) {
                ServerTab.this.handleFileButtonSelected();
            } else if (object == ServerTab.this.createNewServer) {
                ServerTab.this.handleServerButtonSelected();
            } else if (object == ServerTab.this.configureServers) {
                ServerTab.this.handleConfigureButtonSelected();
            }
        }
    }
}

