/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.StringUtils;

public class Commandline
implements Cloneable {
    private Vector arguments = new Vector();
    private String executable = null;
    protected static final String DISCLAIMER = StringUtils.LINE_SEP + "The ' characters around the executable and arguments are" + StringUtils.LINE_SEP + "not part of the command." + StringUtils.LINE_SEP;

    public Commandline(String toProcess) {
        String[] tmp = Commandline.translateCommandline(toProcess);
        if (tmp != null && tmp.length > 0) {
            this.setExecutable(tmp[0]);
            int i = 1;
            while (i < tmp.length) {
                this.createArgument().setValue(tmp[i]);
                ++i;
            }
        }
    }

    public Commandline() {
    }

    public Argument createArgument() {
        return this.createArgument(false);
    }

    public Argument createArgument(boolean insertAtStart) {
        Argument argument = new Argument();
        if (insertAtStart) {
            this.arguments.insertElementAt(argument, 0);
        } else {
            this.arguments.addElement(argument);
        }
        return argument;
    }

    public void setExecutable(String executable) {
        if (executable == null || executable.length() == 0) {
            return;
        }
        this.executable = executable.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public String getExecutable() {
        return this.executable;
    }

    public void addArguments(String[] line) {
        int i = 0;
        while (i < line.length) {
            this.createArgument().setValue(line[i]);
            ++i;
        }
    }

    public String[] getCommandline() {
        LinkedList commands = new LinkedList();
        ListIterator list = commands.listIterator();
        this.addCommandToList(list);
        String[] result = new String[commands.size()];
        return commands.toArray(result);
    }

    public void addCommandToList(ListIterator list) {
        if (this.executable != null) {
            list.add(this.executable);
        }
        this.addArgumentsToList(list);
    }

    public String[] getArguments() {
        ArrayList result = new ArrayList(this.arguments.size() * 2);
        this.addArgumentsToList(result.listIterator());
        String[] res = new String[result.size()];
        return result.toArray(res);
    }

    public void addArgumentsToList(ListIterator list) {
        int i = 0;
        while (i < this.arguments.size()) {
            Argument arg = (Argument)this.arguments.elementAt(i);
            String[] s = arg.getParts();
            if (s != null) {
                int j = 0;
                while (j < s.length) {
                    list.add(s[j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    public String toString() {
        return Commandline.toString(this.getCommandline());
    }

    public static String quoteArgument(String argument) {
        if (argument.indexOf("\"") > -1) {
            if (argument.indexOf("'") > -1) {
                throw new BuildException("Can't handle single and double quotes in same argument");
            }
            return '\'' + argument + '\'';
        }
        if (argument.indexOf("'") > -1 || argument.indexOf(" ") > -1) {
            return '\"' + argument + '\"';
        }
        return argument;
    }

    public static String toString(String[] line) {
        if (line == null || line.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < line.length) {
            if (i > 0) {
                result.append(' ');
            }
            result.append(Commandline.quoteArgument(line[i]));
            ++i;
        }
        return result.toString();
    }

    public static String[] translateCommandline(String toProcess) {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        Vector<String> v = new Vector<String>();
        StringBuffer current = new StringBuffer();
        boolean lastTokenHasBeenQuoted = false;
        while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        break;
                    }
                    current.append(nextTok);
                    break;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        break;
                    }
                    current.append(nextTok);
                    break;
                }
                default: {
                    if ("'".equals(nextTok)) {
                        state = 1;
                    } else if ("\"".equals(nextTok)) {
                        state = 2;
                    } else if (" ".equals(nextTok)) {
                        if (lastTokenHasBeenQuoted || current.length() != 0) {
                            v.addElement(current.toString());
                            current = new StringBuffer();
                        }
                    } else {
                        current.append(nextTok);
                    }
                    lastTokenHasBeenQuoted = false;
                }
            }
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            v.addElement(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new BuildException("unbalanced quotes in " + toProcess);
        }
        Object[] args = new String[v.size()];
        v.copyInto(args);
        return args;
    }

    public int size() {
        return this.getCommandline().length;
    }

    public Object clone() {
        try {
            Commandline c = (Commandline)super.clone();
            c.arguments = (Vector)this.arguments.clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new BuildException(e);
        }
    }

    public void clear() {
        this.executable = null;
        this.arguments.removeAllElements();
    }

    public void clearArgs() {
        this.arguments.removeAllElements();
    }

    public Marker createMarker() {
        return new Marker(this.arguments.size());
    }

    public String describeCommand() {
        return Commandline.describeCommand(this);
    }

    public String describeArguments() {
        return Commandline.describeArguments(this);
    }

    public static String describeCommand(Commandline line) {
        return Commandline.describeCommand(line.getCommandline());
    }

    public static String describeArguments(Commandline line) {
        return Commandline.describeArguments(line.getArguments());
    }

    public static String describeCommand(String[] args) {
        if (args == null || args.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer("Executing '");
        buf.append(args[0]);
        buf.append("'");
        if (args.length > 0) {
            buf.append(" with ");
            buf.append(Commandline.describeArguments(args, 1));
        } else {
            buf.append(DISCLAIMER);
        }
        return buf.toString();
    }

    public static String describeArguments(String[] args) {
        return Commandline.describeArguments(args, 0);
    }

    protected static String describeArguments(String[] args, int offset) {
        if (args == null || args.length <= offset) {
            return "";
        }
        StringBuffer buf = new StringBuffer("argument");
        if (args.length > offset) {
            buf.append("s");
        }
        buf.append(":").append(StringUtils.LINE_SEP);
        int i = offset;
        while (i < args.length) {
            buf.append("'").append(args[i]).append("'").append(StringUtils.LINE_SEP);
            ++i;
        }
        buf.append(DISCLAIMER);
        return buf.toString();
    }

    public static class Argument
    extends ProjectComponent {
        private String[] parts;

        public void setValue(String value) {
            this.parts = new String[]{value};
        }

        public void setLine(String line) {
            if (line == null) {
                return;
            }
            this.parts = Commandline.translateCommandline(line);
        }

        public void setPath(Path value) {
            this.parts = new String[]{value.toString()};
        }

        public void setPathref(Reference value) {
            Path p = new Path(this.getProject());
            p.setRefid(value);
            this.parts = new String[]{p.toString()};
        }

        public void setFile(File value) {
            this.parts = new String[]{value.getAbsolutePath()};
        }

        public String[] getParts() {
            return this.parts;
        }
    }

    public class Marker {
        private int position;
        private int realPos = -1;

        Marker(int position) {
            this.position = position;
        }

        public int getPosition() {
            if (this.realPos == -1) {
                this.realPos = Commandline.this.executable == null ? 0 : 1;
                int i = 0;
                while (i < this.position) {
                    Argument arg = (Argument)Commandline.this.arguments.elementAt(i);
                    this.realPos += arg.getParts().length;
                    ++i;
                }
            }
            return this.realPos;
        }
    }
}

