/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.internal.deployables;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ModuleFile;
import org.eclipse.wst.server.core.internal.ModuleFolder;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ProjectModule;

public abstract class ComponentDeployable
extends ProjectModule {
    protected IVirtualComponent component = null;
    protected List members = new ArrayList();

    public ComponentDeployable(IProject project) {
        super(project);
        this.component = ComponentCore.createComponent((IProject)project);
    }

    public boolean isBinary() {
        return false;
    }

    private void addMembersToModuleFolder(ModuleFolder mf, IModuleResource[] mr) {
        if (mf == null) {
            return;
        }
        HashSet<IModuleResource> membersJoin = new HashSet<IModuleResource>();
        if (mf.members() != null) {
            membersJoin.addAll(Arrays.asList(mf.members()));
        }
        if (mr != null && mr.length > 0) {
            membersJoin.addAll(Arrays.asList(mr));
        }
        mf.setMembers(membersJoin.toArray(new IModuleResource[membersJoin.size()]));
    }

    public IModule[] getChildModules() {
        return this.getModules();
    }

    public IModule[] getModules() {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        if (this.component != null) {
            IVirtualReference[] components = this.component.getReferences();
            int i = 0;
            while (i < components.length) {
                IModule module;
                IVirtualComponent virtualComp;
                IVirtualReference reference = components[i];
                if (reference != null && reference.getDependencyType() == 0 && (virtualComp = reference.getReferencedComponent()) != null && virtualComp.getProject() != this.component.getProject() && (module = ServerUtil.getModule((IProject)virtualComp.getProject())) != null && !modules.contains(module)) {
                    modules.add(module);
                }
                ++i;
            }
        }
        return modules.toArray(new IModule[modules.size()]);
    }

    protected IModuleResource[] getMembers(IContainer cont, IPath path, IPath javaPath, IContainer[] javaCont) throws CoreException {
        IResource[] res = cont.members();
        int size2 = res.length;
        ArrayList<ModuleFile> list = new ArrayList<ModuleFile>(size2);
        int j = 0;
        while (j < size2) {
            if (res[j] instanceof IContainer) {
                IContainer cc = (IContainer)res[j];
                IPath newPath = path.append(cc.getName()).makeRelative();
                ModuleFolder mf = (ModuleFolder)this.getExistingModuleResource(this.members, newPath);
                if (mf == null) {
                    mf = new ModuleFolder(cc, cc.getName(), path);
                    ModuleFolder parent = (ModuleFolder)this.getExistingModuleResource(this.members, path);
                    if (path.isEmpty()) {
                        this.members.add(mf);
                    } else {
                        if (parent == null) {
                            parent = this.ensureParentExists(path, cc);
                        }
                        this.addMembersToModuleFolder(parent, new IModuleResource[]{mf});
                    }
                }
                IModuleResource[] mr = this.getMembers(cc, newPath, javaPath, javaCont);
                if (javaPath != null && newPath.isPrefixOf(javaPath)) {
                    mr = this.handleJavaPath(path, javaPath, newPath, javaCont, mr, cc);
                }
                this.addMembersToModuleFolder(mf, mr);
            } else {
                IFile f = (IFile)res[j];
                if (path.equals((Object)javaPath)) {
                    ModuleFolder mFolder = (ModuleFolder)this.getExistingModuleResource(this.members, javaPath);
                    ModuleFile mFile = new ModuleFile(f, f.getName(), javaPath, f.getModificationStamp() + f.getLocalTimeStamp());
                    if (mFolder != null) {
                        this.addMembersToModuleFolder(mFolder, new IModuleResource[]{mFile});
                    } else {
                        list.add(mFile);
                    }
                } else {
                    ModuleFile mf = new ModuleFile(f, f.getName(), path, f.getModificationStamp() + f.getLocalTimeStamp());
                    list.add(mf);
                }
            }
            ++j;
        }
        IModuleResource[] mr = new IModuleResource[list.size()];
        list.toArray(mr);
        return mr;
    }

    protected IModuleResource[] getMembers(IVirtualContainer cont, IPath path) throws CoreException {
        IVirtualResource[] res = cont.members();
        int size2 = res.length;
        ArrayList<ModuleFolder> list = new ArrayList<ModuleFolder>(size2);
        int j = 0;
        while (j < size2) {
            ModuleFolder mf;
            if (res[j] instanceof IVirtualContainer) {
                IVirtualContainer cc = (IVirtualContainer)res[j];
                mf = (ModuleFolder)this.getExistingModuleResource(this.members, path.append(new Path(cc.getName()).makeRelative()));
                if (mf == null) {
                    mf = new ModuleFolder((IContainer)cc.getUnderlyingResource(), cc.getName(), path);
                    ModuleFolder parent = (ModuleFolder)this.getExistingModuleResource(this.members, path);
                    if (path.isEmpty()) {
                        this.members.add(mf);
                    } else {
                        if (parent == null) {
                            parent = this.ensureParentExists(path, (IContainer)cc.getUnderlyingResource());
                        }
                        this.addMembersToModuleFolder(parent, new IModuleResource[]{mf});
                    }
                }
                IModuleResource[] mr = this.getMembers(cc, path.append(cc.getName()));
                this.addMembersToModuleFolder(mf, mr);
            } else {
                IFile f = (IFile)res[j].getUnderlyingResource();
                if (!this.isFileInSourceContainer(f)) {
                    mf = new ModuleFile(f, f.getName(), path, f.getModificationStamp() + f.getLocalTimeStamp());
                    list.add(mf);
                }
            }
            ++j;
        }
        IModuleResource[] mr = new IModuleResource[list.size()];
        list.toArray(mr);
        return mr;
    }

    protected ModuleFolder ensureParentExists(IPath path, IContainer cc) {
        ModuleFolder parent = (ModuleFolder)this.getExistingModuleResource(this.members, path);
        if (parent == null) {
            String folderName = path.lastSegment();
            Path folderPath = Path.EMPTY;
            if (path.segmentCount() > 1) {
                folderPath = path.removeLastSegments(1);
            }
            parent = new ModuleFolder(cc, folderName, (IPath)folderPath);
            if (path.segmentCount() > 1) {
                this.addMembersToModuleFolder(this.ensureParentExists(path.removeLastSegments(1), cc), new IModuleResource[]{parent});
            } else {
                this.members.add(parent);
            }
        }
        return parent;
    }

    protected boolean isFileInSourceContainer(IFile file) {
        return false;
    }

    protected IModuleResource getExistingModuleResource(List aList, IPath path) {
        if (aList == null || aList.isEmpty() || path == null) {
            return null;
        }
        String[] pathSegments = path.segments();
        IModuleResource moduleResource = null;
        if (pathSegments.length == 0) {
            return null;
        }
        Iterator iter = aList.iterator();
        while (iter.hasNext()) {
            moduleResource = (IModuleResource)iter.next();
            String[] moduleSegments = moduleResource.getModuleRelativePath().segments();
            if (pathSegments[pathSegments.length - 1].equals(moduleResource.getName()) && moduleSegments.length + 1 == pathSegments.length && this.startsWith(moduleSegments, pathSegments)) {
                return moduleResource;
            }
            if (!(moduleResource instanceof IModuleFolder) || !this.startsWith(moduleSegments, pathSegments) || pathSegments.length <= moduleSegments.length || !moduleResource.getName().equals(pathSegments[moduleSegments.length > 0 ? moduleSegments.length : 0]) || ((IModuleFolder)moduleResource).members() == null) continue;
            return this.getExistingModuleResource(Arrays.asList(((IModuleFolder)moduleResource).members()), path);
        }
        return null;
    }

    private boolean startsWith(String[] beginningSegments, String[] testSegments) {
        int i = 0;
        while (i < beginningSegments.length) {
            if (!beginningSegments[i].equals(testSegments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected IModuleResource[] handleJavaPath(IPath path, IPath javaPath, IPath curPath, IContainer[] javaCont, IModuleResource[] mr, IContainer cc) throws CoreException {
        return new IModuleResource[0];
    }

    public IModuleResource[] members() throws CoreException {
        this.members.clear();
        IVirtualComponent vc = ComponentCore.createComponent((IProject)this.getProject());
        if (vc != null) {
            IVirtualFolder vFolder = vc.getRootFolder();
            IModuleResource[] mr = this.getMembers((IVirtualContainer)vFolder, (IPath)Path.EMPTY);
            int size = mr.length;
            int j = 0;
            while (j < size) {
                if (!this.members.contains(mr[j])) {
                    this.members.add(mr[j]);
                }
                ++j;
            }
            List utilMembers = this.getUtilMembers(vc);
            if (!utilMembers.isEmpty()) {
                this.members.addAll(utilMembers);
            }
        }
        IModuleResource[] mr = new IModuleResource[this.members.size()];
        this.members.toArray(mr);
        return mr;
    }

    protected List getUtilMembers(IVirtualComponent vc) {
        ArrayList utilMembers = new ArrayList();
        IVirtualReference[] components = vc.getReferences();
        int i = 0;
        while (i < components.length) {
            IVirtualReference reference = components[i];
            IVirtualComponent virtualComp = reference.getReferencedComponent();
            if (virtualComp != null && virtualComp.isBinary()) {
                IPath archivePath = ((VirtualArchiveComponent)virtualComp).getWorkspaceRelativePath();
                ModuleFile mf = null;
                if (archivePath != null) {
                    IFile utilFile = ResourcesPlugin.getWorkspace().getRoot().getFile(archivePath);
                    mf = new ModuleFile(utilFile, utilFile.getName(), reference.getRuntimePath().makeRelative());
                } else {
                    File extFile = ((VirtualArchiveComponent)virtualComp).getUnderlyingDiskFile();
                    mf = new ModuleFile(extFile, extFile.getName(), reference.getRuntimePath().makeRelative());
                }
                if (mf != null) {
                    IModuleResource moduleParent = this.getExistingModuleResource(this.members, mf.getModuleRelativePath());
                    if (moduleParent != null && moduleParent instanceof ModuleFolder) {
                        this.addMembersToModuleFolder((ModuleFolder)moduleParent, new IModuleResource[]{mf});
                    } else if (mf.getModuleRelativePath().isEmpty()) {
                        this.members.add(mf);
                    } else {
                        if (moduleParent == null) {
                            moduleParent = this.ensureParentExists(mf.getModuleRelativePath(), (IContainer)vc.getRootFolder().getUnderlyingResource());
                        }
                        this.addMembersToModuleFolder((ModuleFolder)moduleParent, new IModuleResource[]{mf});
                    }
                }
            }
            ++i;
        }
        return utilMembers;
    }

    protected static boolean isProjectOfType(IProject project, String typeID) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return false;
        }
        if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)typeID)) {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
            return projectFacet != null && facetedProject.hasProjectFacet(projectFacet);
        }
        return false;
    }

    public IContainer[] getResourceFolders() {
        IVirtualFolder vFolder;
        IVirtualComponent vc = ComponentCore.createComponent((IProject)this.getProject());
        if (vc != null && (vFolder = vc.getRootFolder()) != null) {
            return vFolder.getUnderlyingFolders();
        }
        return new IContainer[0];
    }
}

